<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T04:17:37+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "uk"
}
-->
# Перекладайте свій проєкт за допомогою Co-op Translator

**Co-op Translator** — це інструмент командного рядка (CLI), який допомагає перекладати markdown-файли та зображення у вашому проєкті на різні мови. У цьому розділі пояснюється, як користуватися інструментом, описані різні опції CLI та наведені приклади для різних сценаріїв використання.

> [!NOTE]
> Повний перелік команд та їх детальні описи дивіться у [Довіднику команд](./command-reference.md).

---

## Приклади сценаріїв та команд

Ось кілька поширених варіантів використання **Co-op Translator** з відповідними командами.

### 1. Базовий переклад (одна мова)

Щоб перекласти весь ваш проєкт (markdown-файли та зображення) на одну мову, наприклад, корейську, використовуйте таку команду:

```bash
translate -l "ko"
```

Ця команда перекладе всі markdown-файли та зображення на корейську, додаючи нові переклади, не видаляючи вже існуючі.

> [!TIP]
>
> Хочете дізнатися, які мовні коди доступні у **Co-op Translator**? Перейдіть до розділу [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) у репозиторії для деталей.

#### Приклад на Phi-3 CookBook

У **Phi-3 CookBook** я використав наступний спосіб, щоб додати корейський переклад для існуючих markdown-файлів та зображень.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. Переклад на кілька мов

Щоб перекласти ваш проєкт на кілька мов (наприклад, іспанську, французьку та німецьку), використовуйте цю команду:

```bash
translate -l "es fr de"
```

Ця команда перекладе проєкт на іспанську, французьку та німецьку, додаючи нові переклади, не перезаписуючи вже існуючі.

#### Приклад на Phi-3 CookBook

У **Phi-3 CookBook**, після отримання останніх змін для відображення нових комітів, я використав наступний спосіб для перекладу нових markdown-файлів та зображень.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> Зазвичай рекомендується перекладати одну мову за раз, але у випадках, коли потрібно додати конкретні зміни, переклад кількох мов одночасно може бути ефективним.

### 3. Оновлення перекладів (видаляє існуючі переклади)

Щоб оновити існуючі переклади (тобто видалити поточні переклади та замінити їх новими), використовуйте опцію `-u`. Вона видалить всі існуючі переклади для зазначених мов і перекладе їх заново.

```bash
translate -l "ko" -u
```

Увага: Перед видаленням існуючих перекладів команда попросить підтвердження.

#### Приклад на Phi-3 CookBook

У **Phi-3 CookBook** я використав наступний спосіб для оновлення всіх перекладених файлів іспанською. Рекомендую використовувати цей метод, коли є значні зміни в оригінальному контенті у багатьох markdown-документах. Якщо потрібно оновити лише кілька перекладених markdown-файлів, ефективніше вручну видалити ці файли та потім скористатися методом `-a` для додавання оновлених перекладів.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. Переклад лише зображень

Щоб перекласти лише зображення у вашому проєкті, використовуйте опцію `-img`:

```bash
translate -l "ko" -img
```

Ця команда перекладе лише зображення на корейську, не зачіпаючи markdown-файли.

### 6. Переклад лише markdown-файлів

Щоб перекласти лише markdown-файли у вашому проєкті, використовуйте опцію `-md`:

```bash
translate -l "ko" -md
```

#### Приклад на Phi-3 CookBook

У **Phi-3 CookBook** я використав наступний спосіб для перевірки помилок перекладу у корейських файлах та автоматичного повторного перекладу для файлів з виявленими проблемами.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

Ця опція перевіряє наявність помилок перекладу. Зараз, якщо різниця у кількості переносів рядків між оригіналом і перекладом перевищує шість, файл позначається як такий, що має помилку перекладу. Я планую вдосконалити цей критерій для більшої гнучкості у майбутньому.

Наприклад, цей метод корисний для виявлення пропущених фрагментів або пошкоджених перекладів, і він автоматично повторно перекладає ці файли.

Однак, якщо ви вже знаєте, які файли проблемні, ефективніше вручну видалити ці файли та скористатися опцією `-a` для повторного перекладу.

### 8. Режим налагодження

Щоб увімкнути детальне логування для пошуку проблем, використовуйте опцію `-d`:

```bash
translate -l "ko" -d
```

Ця команда запустить переклад у режимі налагодження, надаючи додаткову інформацію про процес, що допоможе знайти причини проблем під час перекладу.

#### Приклад на Phi-3 CookBook

У **Phi-3 CookBook** я зіткнувся з проблемою, коли переклади з багатьма посиланнями у markdown-файлах спричиняли помилки форматування, наприклад, зламані переклади та ігнорування переносів рядків. Щоб діагностувати цю проблему, я використав опцію `-d`, щоб побачити, як працює процес перекладу.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. Переклад на всі мови

Якщо ви хочете перекласти проєкт на всі підтримувані мови, використовуйте ключове слово all.

> [!WARNING]
> Переклад на всі мови одночасно може зайняти багато часу залежно від розміру проєкту. Наприклад, переклад **Phi-3 CookBook** на іспанську зайняв близько 2 годин. Зважаючи на масштаб, одному користувачу не практично обробляти 20 мов. Рекомендується розподілити роботу між кількома учасниками, кожен з яких перекладає одну-дві мови, і поступово оновлювати переклади.

```bash
translate -l "all"
```

Ця команда перекладе проєкт на всі доступні мови. Якщо продовжите, переклад може зайняти багато часу залежно від розміру проєкту.

> [!TIP]
>
> ### Вручну видаляти перекладені файли (опціонально)
> Тепер перекладені файли автоматично визначаються та очищаються, коли оновлюється вихідний файл.
>
> Однак, якщо ви хочете вручну оновити переклад — наприклад, щоб переробити конкретний файл або змінити поведінку системи — можете скористатися наступною командою для видалення всіх версій файлу у мовних папках.
>
> ### На Windows:
> 1. **Через Command Prompt**:
>    - Відкрийте Command Prompt.
>    - Перейдіть у потрібну папку за допомогою команди `cd`.
>    - Використайте цю команду для видалення файлів:
>      ```
>      del /s *filename*
>      ```
>      Замініть `filename` на частину імені файлу, яку шукаєте. Опція `/s` шукає у підпапках.
>
> 2. **Через PowerShell**:
>    - Відкрийте PowerShell.
>    - Виконайте цю команду:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      Замініть `"C:\YourPath"` на шлях до папки, а `filename` — на потрібне ім’я.
>
> ### На macOS/Linux:
> 1. **Через Terminal**:
>   - Відкрийте Terminal.
>   - Перейдіть у потрібну директорію через `cd`.
>   - Використайте команду `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     Замініть `filename` на потрібне ім’я.
>
> Завжди перевіряйте файли перед видаленням, щоб уникнути випадкової втрати.
>
> Після видалення файлів, які потрібно замінити, просто повторно запустіть вашу команду `translate -l`, щоб оновити останні зміни у файлі.

---

**Відмова від відповідальності**:
Цей документ було перекладено за допомогою сервісу автоматичного перекладу [Co-op Translator](https://github.com/Azure/co-op-translator). Хоча ми прагнемо до точності, звертаємо вашу увагу, що автоматичний переклад може містити помилки або неточності. Оригінальний документ мовою оригіналу слід вважати авторитетним джерелом. Для критично важливої інформації рекомендується професійний людський переклад. Ми не несемо відповідальності за будь-які непорозуміння або неправильне тлумачення, що виникли внаслідок використання цього перекладу.