<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T04:17:29+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "uk"
}
-->
# Встановлення пакета Co-op translator

**Co-op Translator** — це інструмент командного рядка (CLI), створений для перекладу всіх markdown-файлів та зображень у вашому проєкті на різні мови. У цьому посібнику ви дізнаєтеся, як налаштувати перекладач і запускати його для різних сценаріїв використання.

### Створіть віртуальне середовище

Ви можете створити віртуальне середовище за допомогою `pip` або `Poetry`. Введіть одну з наступних команд у вашому терміналі.

#### За допомогою pip

```bash
python -m venv .venv
```

#### За допомогою Poetry

```bash
poetry init
```

### Активуйте віртуальне середовище

Після створення віртуального середовища його потрібно активувати. Кроки залежать від вашої операційної системи. Введіть наступну команду у вашому терміналі.

#### Для pip і Poetry

- Windows:

    ```bash
    .venv\Scripts\activate
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### За допомогою Poetry

1. Якщо ви створили середовище за допомогою Poetry, введіть цю команду у вашому терміналі для активації.

    ```bash
    poetry shell
    ```

### Встановлення пакета та необхідних залежностей

Після налаштування та активації віртуального середовища наступним кроком буде встановлення необхідних залежностей.

### Швидке встановлення

Встановіть Co-Op Translator через pip

```
pip install co-op-translator
```
Або

Встановіть через poetry
```
poetry add co-op-translator
```

#### За допомогою pip (з requirements.txt), якщо ви клонували цей репозиторій

> [!NOTE]
> Будь ласка, НЕ робіть цього, якщо ви встановлюєте co-op translator через швидке встановлення.

1. Якщо ви використовуєте pip, введіть цю команду у вашому терміналі. Вона автоматично встановить необхідні пакети, вказані у файлі `requirements.txt`:

    ```bash
    pip install -r requirements.txt
    ```

#### За допомогою Poetry (з pyproject.toml)

1. Якщо ви використовуєте Poetry, введіть цю команду у вашому терміналі. Вона автоматично встановить необхідні пакети, вказані у файлі `pyproject.toml`:

    ```bash
    poetry install
    ```

---

**Застереження**:
Цей документ було перекладено за допомогою сервісу автоматичного перекладу [Co-op Translator](https://github.com/Azure/co-op-translator). Хоча ми прагнемо до точності, звертаємо вашу увагу, що автоматичний переклад може містити помилки або неточності. Оригінальний документ мовою оригіналу слід вважати авторитетним джерелом. Для критично важливої інформації рекомендується професійний людський переклад. Ми не несемо відповідальності за будь-які непорозуміння або неправильне тлумачення, що виникли внаслідок використання цього перекладу.