<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T12:46:37+00:00",
  "source_file": "README.md",
  "language_code": "uk"
}
-->
# Co-op Translator

_Легко автоматизуйте переклад вашого освітнього контенту на GitHub кількома мовами, щоб охопити глобальну аудиторію._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 Підтримка кількох мов

#### Підтримується [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[Арабська](../ar/README.md) | [Бенгальська](../bn/README.md) | [Болгарська](../bg/README.md) | [Бирманська (М’янма)](../my/README.md) | [Китайська (спрощена)](../zh/README.md) | [Китайська (традиційна, Гонконг)](../hk/README.md) | [Китайська (традиційна, Макао)](../mo/README.md) | [Китайська (традиційна, Тайвань)](../tw/README.md) | [Хорватська](../hr/README.md) | [Чеська](../cs/README.md) | [Данська](../da/README.md) | [Голландська](../nl/README.md) | [Естонська](../et/README.md) | [Фінська](../fi/README.md) | [Французька](../fr/README.md) | [Німецька](../de/README.md) | [Грецька](../el/README.md) | [Іврит](../he/README.md) | [Гінді](../hi/README.md) | [Угорська](../hu/README.md) | [Індонезійська](../id/README.md) | [Італійська](../it/README.md) | [Японська](../ja/README.md) | [Каннада](../kn/README.md) | [Корейська](../ko/README.md) | [Литовська](../lt/README.md) | [Малайська](../ms/README.md) | [Малаялам](../ml/README.md) | [Маратхі](../mr/README.md) | [Непальська](../ne/README.md) | [Нігерійський пиджин](../pcm/README.md) | [Норвезька](../no/README.md) | [Перська (фарсі)](../fa/README.md) | [Польська](../pl/README.md) | [Португальська (Бразилія)](../br/README.md) | [Португальська (Португалія)](../pt/README.md) | [Пенджабі (гурмухі)](../pa/README.md) | [Румунська](../ro/README.md) | [Російська](../ru/README.md) | [Сербська (кирилиця)](../sr/README.md) | [Словацька](../sk/README.md) | [Словенська](../sl/README.md) | [Іспанська](../es/README.md) | [Свахілі](../sw/README.md) | [Шведська](../sv/README.md) | [Тагальська (філіппінська)](../tl/README.md) | [Тамільська](../ta/README.md) | [Телугу](../te/README.md) | [Тайська](../th/README.md) | [Турецька](../tr/README.md) | [Українська](./README.md) | [Урду](../ur/README.md) | [В’єтнамська](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## Огляд

**Co-op Translator** допомагає легко локалізувати ваш освітній контент на GitHub кількома мовами.
Коли ви оновлюєте свої Markdown-файли, зображення або ноутбуки, переклади автоматично синхронізуються, забезпечуючи точність і актуальність контенту для учнів у всьому світі.

Приклад організації перекладеного контенту:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.uk.png)

## Швидкий старт

```bash
# Створіть і активуйте віртуальне середовище (рекомендовано)
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Встановіть пакет
pip install co-op-translator
# Перекласти
translate -l "ko ja fr" -md
```

Docker:

```bash
# Завантажте публічний образ з GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# Запустіть з підключеною поточною папкою та наданим файлом .env (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## Мінімальна налаштування

1. Створіть файл `.env` за шаблоном: [.env.template](../../.env.template)
2. Налаштуйте одного провайдера LLM (Azure OpenAI або OpenAI)
3. (Опційно) Для перекладу зображень (`-img`) налаштуйте Azure AI Vision
4. (Рекомендовано) Очистіть попередні переклади, щоб уникнути конфліктів (наприклад, `translations/`)
5. (Рекомендовано) Додайте розділ перекладу у ваш README за допомогою [шаблону мов README](./getting_started/README_languages_template.md)
6. Дивіться: [Налаштування Azure AI](./getting_started/set-up-azure-ai.md)

## Використання

Перекласти всі підтримувані типи:

```bash
translate -l "ko ja"
```

Тільки Markdown:

```bash
translate -l "de" -md
```

Markdown + зображення:

```bash
translate -l "pt" -md -img
```

Тільки ноутбуки:

```bash
translate -l "zh" -nb
```

Більше прапорців: [Довідник команд](./getting_started/command-reference.md)

## Особливості

- Автоматичний переклад Markdown, ноутбуків і зображень
- Підтримка синхронізації перекладів зі змінами у джерелі
- Працює локально (CLI) або в CI (GitHub Actions)
- Використовує Azure OpenAI або OpenAI; опційно Azure AI Vision для зображень
- Зберігає форматування та структуру Markdown

## Документація

- [Посібник командного рядка](./getting_started/command-line-guide/command-line-guide.md)
- [Посібник GitHub Actions (публічні репозиторії та стандартні секрети)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [Посібник GitHub Actions (репозиторії організації Microsoft та налаштування на рівні організації)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [Шаблон мов README](./getting_started/README_languages_template.md)
- [Підтримувані мови](./getting_started/supported-languages.md)
- [Внесок у проект](./CONTRIBUTING.md)
- [Вирішення проблем](./getting_started/troubleshooting.md)

### Специфічний посібник Microsoft
> [!NOTE]
> Для підтримувачів репозиторіїв Microsoft “Для початківців” лише.

- [Оновлення списку “інших курсів” (тільки для репозиторіїв MS Beginners)](./getting_started/update-other-courses.md)

## Підтримайте нас і сприяйте глобальному навчанню

Приєднуйтесь до нас у революції поширення освітнього контенту у світі! Поставте ⭐ [Co-op Translator](https://github.com/azure/co-op-translator) на GitHub і підтримайте нашу місію подолання мовних бар’єрів у навчанні та технологіях. Ваша зацікавленість і внески мають велике значення! Внески коду та пропозиції щодо функцій завжди вітаються.

### Вивчайте освітній контент Microsoft вашою мовою

- [AZD для початківців](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI для початківців](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) для початківців](https://github.com/microsoft/mcp-for-beginners)
- [AI Agents для початківців](https://github.com/microsoft/ai-agents-for-beginners)
- [Generative AI для початківців з .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI для початківців](https://github.com/microsoft/generative-ai-for-beginners)
- [Generative AI для початківців з Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML для початківців](https://aka.ms/ml-beginners)
- [Data Science для початківців](https://aka.ms/datascience-beginners)
- [AI для початківців](https://aka.ms/ai-beginners)
- [Кібербезпека для початківців](https://github.com/microsoft/Security-101)
- [Веб-розробка для початківців](https://aka.ms/webdev-beginners)
- [IoT для початківців](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## Відеопрезентації

👉 Натисніть на зображення нижче, щоб переглянути на YouTube.

- **Open at Microsoft**: Коротке 18-хвилинне введення та швидкий посібник з використання Co-op Translator.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.uk.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## Внесок у проект

Цей проєкт вітає внески та пропозиції. Бажаєте допомогти розвитку Azure Co-op Translator? Будь ласка, ознайомтеся з нашим [CONTRIBUTING.md](./CONTRIBUTING.md) для інструкцій, як зробити Co-op Translator більш доступним.

## Учасники

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## Кодекс поведінки

Цей проєкт прийняв [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
Для додаткової інформації дивіться [FAQ Кодексу поведінки](https://opensource.microsoft.com/codeofconduct/faq/) або
зв’яжіться з [opencode@microsoft.com](mailto:opencode@microsoft.com) з будь-якими питаннями чи коментарями.

## Відповідальний Штучний Інтелект

Microsoft прагне допомагати клієнтам відповідально використовувати наші AI-продукти, ділитися досвідом і будувати партнерства на основі довіри за допомогою інструментів, таких як Transparency Notes та Impact Assessments. Багато з цих ресурсів доступні за адресою [https://aka.ms/RAI](https://aka.ms/RAI).
Підхід Microsoft до відповідального AI базується на принципах справедливості, надійності та безпеки, конфіденційності та захисту, інклюзивності, прозорості та підзвітності.

Великі моделі природної мови, зображень і мови — як ті, що використовуються у цьому прикладі — можуть іноді поводитися несправедливо, ненадійно або образливо, що може призводити до шкоди. Будь ласка, ознайомтеся з [Transparency note сервісу Azure OpenAI](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text), щоб бути поінформованими про ризики та обмеження.
Рекомендований підхід до зменшення цих ризиків — включити в архітектуру систему безпеки, яка може виявляти та запобігати шкідливій поведінці. [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) забезпечує незалежний рівень захисту, здатний виявляти шкідливий контент, створений користувачами та ШІ, у додатках і сервісах. Azure AI Content Safety включає API для тексту та зображень, які дозволяють виявляти шкідливий матеріал. Також у нас є інтерактивна Content Safety Studio, яка дозволяє переглядати, досліджувати та випробовувати приклади коду для виявлення шкідливого контенту в різних модальностях. Наступна [документація швидкого старту](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) проведе вас через процес надсилання запитів до сервісу.

Ще один аспект, який слід враховувати, — загальна продуктивність додатка. У багатомодальних і багатомодельних додатках продуктивність означає, що система працює так, як ви та ваші користувачі очікують, включно з тим, що вона не генерує шкідливі результати. Важливо оцінювати продуктивність вашого додатка загалом, використовуючи [метрики якості генерації, ризиків і безпеки](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in).

Ви можете оцінити свій AI-додаток у середовищі розробки за допомогою [prompt flow SDK](https://microsoft.github.io/promptflow/index.html). За наявності тестового набору даних або цілі, генерації вашого генеративного AI-додатка кількісно вимірюються за допомогою вбудованих або власних оцінювачів на ваш вибір. Щоб почати роботу з prompt flow SDK для оцінки вашої системи, ви можете скористатися [керівництвом швидкого старту](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk). Після виконання оцінювання ви можете [візуалізувати результати в Azure AI Studio](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## Торгові марки

Цей проєкт може містити торгові марки або логотипи проєктів, продуктів чи сервісів. Авторизоване використання торгових марок або логотипів Microsoft підпорядковується і має відповідати [Правилам використання торгових марок і брендів Microsoft](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general). Використання торгових марок або логотипів Microsoft у змінених версіях цього проєкту не повинно викликати плутанину або створювати враження спонсорства Microsoft. Будь-яке використання торгових марок або логотипів третіх сторін підпорядковується політикам цих третіх сторін.

## Отримання допомоги

Якщо ви застрягли або маєте питання щодо створення AI-додатків, приєднуйтесь до:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

Якщо у вас є відгуки про продукт або ви зіткнулися з помилками під час розробки, відвідайте:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Відмова від відповідальності**:
Цей документ було перекладено за допомогою сервісу автоматичного перекладу [Co-op Translator](https://github.com/Azure/co-op-translator). Хоча ми прагнемо до точності, будь ласка, майте на увазі, що автоматичні переклади можуть містити помилки або неточності. Оригінальний документ рідною мовою слід вважати авторитетним джерелом. Для критично важливої інформації рекомендується звертатися до професійного людського перекладу. Ми не несемо відповідальності за будь-які непорозуміння або неправильні тлумачення, що виникли внаслідок використання цього перекладу.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->