<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T12:45:46+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "uk"
}
-->
# Внесок у Co-op Translator

Цей проєкт вітає внески та пропозиції. Більшість внесків вимагають вашої згоди з Угодою про ліцензію для контрибуторів (CLA), яка підтверджує, що ви маєте право і фактично надаєте нам права на використання вашого внеску. Деталі можна знайти за адресою https://cla.opensource.microsoft.com.

Коли ви надсилаєте pull request, бот CLA автоматично визначить, чи потрібно вам надати CLA, і відповідно позначить PR (наприклад, перевірка статусу, коментар). Просто дотримуйтесь інструкцій бота. Вам потрібно зробити це лише один раз для всіх репозиторіїв, що використовують нашу CLA.

## Налаштування середовища розробки

Для налаштування середовища розробки цього проєкту рекомендуємо використовувати Poetry для керування залежностями. Ми використовуємо `pyproject.toml` для керування залежностями проєкту, тому для встановлення залежностей слід використовувати Poetry.

### Створення віртуального середовища

#### За допомогою pip

```bash
python -m venv .venv
```

#### За допомогою Poetry

```bash
poetry init
```

### Активування віртуального середовища

#### Для pip і Poetry

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### За допомогою Poetry

```bash
poetry shell
```

### Встановлення пакету та необхідних залежностей

#### За допомогою Poetry (з pyproject.toml)

```bash
poetry install
```

### Ручне тестування

Перед подачею PR важливо протестувати функціонал перекладу на реальній документації:

1. Створіть тестову папку в кореневому каталозі:
    ```bash
    mkdir test_docs
    ```

2. Скопіюйте деякі markdown-документи та зображення, які хочете перекласти, у тестову папку. Наприклад:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. Встановіть пакет локально:
    ```bash
    pip install -e .
    ```

4. Запустіть Co-op Translator на ваших тестових документах:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. Перевірте перекладені файли в `test_docs/translations` та `test_docs/translated_images`, щоб упевнитися, що:
   - Якість перекладу відповідає очікуванням
   - Метадані у коментарях правильні
   - Оригінальна структура markdown збережена
   - Посилання та зображення працюють коректно

Таке ручне тестування допомагає переконатися, що ваші зміни добре працюють у реальних умовах.

### Змінні середовища

1. Створіть файл `.env` у кореневому каталозі, скопіювавши наявний `.env.template`.
2. Заповніть змінні середовища згідно з інструкціями.

> [!TIP]
>
> ### Додаткові варіанти налаштування середовища розробки
>
> Окрім запуску проєкту локально, ви можете використовувати GitHub Codespaces або VS Code Dev Containers як альтернативні варіанти середовища розробки.
>
> #### GitHub Codespaces
>
> Ви можете запускати цей проєкт віртуально за допомогою GitHub Codespaces без додаткових налаштувань.
>
> Кнопка відкриє веб-версію VS Code у вашому браузері:
>
> 1. Відкрийте шаблон (це може зайняти кілька хвилин):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### Локальний запуск за допомогою VS Code Dev Containers
>
> ⚠️ Цей варіант працюватиме лише, якщо Docker Desktop має виділено щонайменше 16 ГБ оперативної пам’яті. Якщо у вас менше 16 ГБ, спробуйте [GitHub Codespaces](../..) або [налаштуйте локально](../..).
>
> Альтернативою є VS Code Dev Containers, який відкриває проєкт у вашому локальному VS Code за допомогою [розширення Dev Containers](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers):
>
> 1. Запустіть Docker Desktop (встановіть, якщо ще не встановлено)
> 2. Відкрийте проєкт:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### Стиль коду

Ми використовуємо [Black](https://github.com/psf/black) як форматувач коду Python для підтримки єдиного стилю коду в проєкті. Black — це безкомпромісний форматувач, який автоматично переформатовує Python-код відповідно до стилю Black.

#### Конфігурація

Конфігурація Black вказана у нашому `pyproject.toml`:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Встановлення Black

Ви можете встановити Black за допомогою Poetry (рекомендовано) або pip:

##### За допомогою Poetry

Black автоматично встановлюється під час налаштування середовища розробки:
```bash
poetry install
```

##### За допомогою pip

Якщо ви використовуєте pip, можете встановити Black напряму:
```bash
pip install black
```

#### Використання Black

##### З Poetry

1. Відформатуйте всі Python-файли в проєкті:
    ```bash
    poetry run black .
    ```

2. Відформатуйте конкретний файл або директорію:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### З pip

1. Відформатуйте всі Python-файли в проєкті:
    ```bash
    black .
    ```

2. Відформатуйте конкретний файл або директорію:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> Рекомендуємо налаштувати ваш редактор так, щоб він автоматично форматував код за допомогою Black при збереженні. Більшість сучасних редакторів підтримують це через розширення або плагіни.

## Запуск Co-op Translator

Щоб запустити Co-op Translator за допомогою Poetry у вашому середовищі, виконайте наступні кроки:

1. Перейдіть у каталог, де хочете виконати тестування перекладу, або створіть тимчасову папку для тестів.

2. Виконайте команду нижче. Змініть `-l ko` на код мови, на яку хочете перекладати. Прапорець `-d` означає режим налагодження.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> Переконайтеся, що ваше середовище Poetry активоване (poetry shell) перед запуском команди.

## Додати нову мову

Ми вітаємо внески, які додають підтримку нових мов. Перед відкриттям PR виконайте наведені нижче кроки для полегшення перевірки.

1. Додайте мову до мапінгу шрифтів
   - Відредагуйте `src/co_op_translator/fonts/font_language_mappings.yml`
   - Додайте запис з:
     - `code`: код мови у форматі ISO-подібному (наприклад, `vi`)
     - `name`: зручна для користувача назва
     - `font`: шрифт, що постачається у `src/co_op_translator/fonts/` і підтримує цей скрипт
     - `rtl`: `true`, якщо мова з написанням справа наліво, інакше `false`

2. Додайте необхідні файли шрифтів (за потреби)
   - Якщо потрібен новий шрифт, перевірте сумісність ліцензії для відкритого розповсюдження
   - Додайте файл шрифту у `src/co_op_translator/fonts/`

3. Локальна перевірка
   - Запустіть переклади для невеликого зразка (Markdown, зображення та ноутбуки за потреби)
   - Переконайтеся, що вивід відображається коректно, включно зі шрифтами та RTL-розміткою, якщо застосовно

4. Оновіть документацію
   - Переконайтеся, що мова додана у `getting_started/supported-languages.md`
   - Змінювати `getting_started/README_languages_template.md` не потрібно; він генерується зі списку підтримуваних мов

5. Відкрийте PR
   - Опишіть додану мову та будь-які питання ліцензування шрифтів
   - За можливості додайте скріншоти відображення

Приклад запису YAML:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### Тестування нової мови

Ви можете протестувати нову мову, виконавши таку команду:

```bash
# Створіть і активуйте віртуальне середовище
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Встановіть пакет для розробки
pip install -e .
# Запустіть переклад
translate -l "new_lang"
```

## Куратори

### Формат повідомлення коміту та стратегія злиття

Для забезпечення послідовності та зрозумілості історії комітів у проєкті ми використовуємо певний формат повідомлень комітів **для фінального повідомлення коміту** при використанні стратегії **Squash and Merge**.

Коли pull request (PR) зливається, окремі коміти об’єднуються в один. Фінальне повідомлення коміту має відповідати наведеному нижче формату для підтримки чистої та послідовної історії.

#### Формат повідомлення коміту (для squash and merge)

Ми використовуємо такий формат повідомлень комітів:

```bash
<type>: <description> (#<номер PR>)
```

- **type**: Категорія коміту. Використовуємо такі типи:
  - `Docs`: Оновлення документації.
  - `Build`: Зміни, пов’язані з системою збірки або залежностями, включно з оновленнями конфігураційних файлів, CI-воркфлоу або Dockerfile.
  - `Core`: Зміни в основній функціональності проєкту, особливо у файлах у директорії `src/co_op_translator/core`.

- **description**: Короткий опис змін.
- **PR number**: Номер pull request, пов’язаного з комітом.

**Приклади**:

- `Docs: Оновлення інструкцій з встановлення для кращої зрозумілості (#50)`
- `Core: Покращення обробки перекладу зображень (#60)`

> [!NOTE]
> Наразі префікси **`Docs`**, **`Core`** та **`Build`** автоматично додаються до назв PR на основі застосованих міток до зміненого коду. Якщо правильна мітка застосована, зазвичай не потрібно вручну редагувати назву PR. Просто перевірте, що все вірно і префікс згенеровано коректно.

#### Стратегія злиття

Ми використовуємо **Squash and Merge** як стандартну стратегію для pull request. Ця стратегія гарантує, що повідомлення комітів відповідають нашому формату, навіть якщо окремі коміти — ні.

**Переваги**:

- Чиста, лінійна історія проєкту.
- Послідовність у повідомленнях комітів.
- Менше шуму від дрібних комітів (наприклад, "виправлення опечатки").

При злитті переконайтеся, що фінальне повідомлення коміту відповідає описаному формату.

**Приклад Squash and Merge**
Якщо PR містить такі коміти:

- `fix typo`
- `update README`
- `adjust formatting`

Їх слід об’єднати в:
`Docs: Покращення зрозумілості та форматування документації (#65)`

### Процес релізу

Цей розділ описує найпростіший спосіб для кураторів опублікувати новий реліз Co-op Translator.

#### 1. Збільшення версії у `pyproject.toml`

1. Визначте наступний номер версії (ми дотримуємося семантичного версіонування: `MAJOR.MINOR.PATCH`).
2. Відредагуйте `pyproject.toml` і оновіть поле `version` у секції `[tool.poetry]`.
3. Відкрийте окремий pull request, який змінює лише версію (та будь-які автоматично оновлені lock/метадані, якщо є).
4. Після перевірки використайте **Squash and Merge** і переконайтеся, що фінальне повідомлення коміту відповідає описаному формату.

#### 2. Створення релізу на GitHub

1. Перейдіть на сторінку репозиторію GitHub і відкрийте **Releases** → **Draft a new release**.
2. Створіть новий тег (наприклад, `v0.13.0`) з гілки `main`.
3. Встановіть заголовок релізу таким самим, як версія (наприклад, `v0.13.0`).
4. Натисніть **Generate release notes** для автоматичного заповнення журналу змін.
5. За бажанням відредагуйте текст (наприклад, щоб виділити нові підтримувані мови або важливі зміни).
6. Опублікуйте реліз.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Відмова від відповідальності**:  
Цей документ було перекладено за допомогою сервісу автоматичного перекладу [Co-op Translator](https://github.com/Azure/co-op-translator). Хоча ми прагнемо до точності, будь ласка, майте на увазі, що автоматичні переклади можуть містити помилки або неточності. Оригінальний документ рідною мовою слід вважати авторитетним джерелом. Для критично важливої інформації рекомендується звертатися до професійного людського перекладу. Ми не несемо відповідальності за будь-які непорозуміння або неправильні тлумачення, що виникли внаслідок використання цього перекладу.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->