<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T11:06:42+00:00",
  "source_file": "README.md",
  "language_code": "tr"
}
-->
# Co-op Çevirmen

_Eğitim amaçlı GitHub içeriğinizi birden çok dile kolayca otomatik olarak çevirin ve küresel bir kitleye ulaşın._

[![Python paketi](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![Lisans: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![İndirmeler](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![İndirmeler](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Konteyner: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Kod stili: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub katkıda bulunanlar](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub sorunlar](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub çekme istekleri](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PR'ler Hoşgeldiniz](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 Çok Dilli Destek

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) tarafından desteklenmektedir

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[Arapça](../ar/README.md) | [Bengalce](../bn/README.md) | [Bulgarca](../bg/README.md) | [Birmanca (Myanmar)](../my/README.md) | [Çince (Basitleştirilmiş)](../zh/README.md) | [Çince (Geleneksel, Hong Kong)](../hk/README.md) | [Çince (Geleneksel, Makao)](../mo/README.md) | [Çince (Geleneksel, Tayvan)](../tw/README.md) | [Hırvatça](../hr/README.md) | [Çekçe](../cs/README.md) | [Danca](../da/README.md) | [Flemenkçe](../nl/README.md) | [Estonca](../et/README.md) | [Fince](../fi/README.md) | [Fransızca](../fr/README.md) | [Almanca](../de/README.md) | [Yunanca](../el/README.md) | [İbranice](../he/README.md) | [Hintçe](../hi/README.md) | [Macarca](../hu/README.md) | [Endonezce](../id/README.md) | [İtalyanca](../it/README.md) | [Japonca](../ja/README.md) | [Kannada](../kn/README.md) | [Korece](../ko/README.md) | [Litvanca](../lt/README.md) | [Malayca](../ms/README.md) | [Malayalamca](../ml/README.md) | [Marathi](../mr/README.md) | [Nepalce](../ne/README.md) | [Nijerya Pidgin](../pcm/README.md) | [Norveççe](../no/README.md) | [Farsça (Persian)](../fa/README.md) | [Lehçe](../pl/README.md) | [Portekizce (Brezilya)](../br/README.md) | [Portekizce (Portekiz)](../pt/README.md) | [Pencapça (Gurmukhi)](../pa/README.md) | [Rumence](../ro/README.md) | [Rusça](../ru/README.md) | [Sırpça (Kiril)](../sr/README.md) | [Slovakça](../sk/README.md) | [Slovence](../sl/README.md) | [İspanyolca](../es/README.md) | [Svahili](../sw/README.md) | [İsveççe](../sv/README.md) | [Tagalogca (Filipince)](../tl/README.md) | [Tamilce](../ta/README.md) | [Telugu](../te/README.md) | [Tayca](../th/README.md) | [Türkçe](./README.md) | [Ukraynaca](../uk/README.md) | [Urduca](../ur/README.md) | [Vietnamca](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub izleyiciler](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Takip)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub çatallar](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Çatalla)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub yıldızlar](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Yıldız)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![GitHub Codespaces'ta Aç](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Aç&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## Genel Bakış

**Co-op Translator**, eğitim amaçlı GitHub içeriğinizi birden çok dile zahmetsizce yerelleştirmenize yardımcı olur. Markdown dosyalarınızı, resimlerinizi veya not defterlerinizi güncellediğinizde, çeviriler otomatik olarak senkronize kalır ve içeriğinizin dünya çapındaki öğrenenler için doğru ve güncel olmasını sağlar.

Çevrilmiş içeriğin nasıl düzenlendiğine dair örnek:

![Örnek](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.tr.png)

## Hızlı Başlangıç

```bash
# Sanal bir ortam oluşturun ve etkinleştirin (önerilir)
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Paketi yükleyin
pip install co-op-translator
# Çevir
translate -l "ko ja fr" -md
```

Docker:

```bash
# GHCR'den genel imajı çek
docker pull ghcr.io/azure/co-op-translator:latest
# Mevcut klasör monte edilerek ve .env sağlanarak çalıştır (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## Minimal kurulum

1. Şablon kullanarak bir `.env` dosyası oluşturun: [.env.template](../../.env.template)
2. Bir LLM sağlayıcısı yapılandırın (Azure OpenAI veya OpenAI)
3. (İsteğe bağlı) Görsel çeviri için (`-img`) Azure AI Vision yapılandırın
4. (Önerilen) Çakışmaları önlemek için önceki çevirileri temizleyin (örneğin, `translations/`)
5. (Önerilen) README dosyanıza bir çeviri bölümü ekleyin: [README dilleri şablonu](./getting_started/README_languages_template.md)
6. Bakınız: [Azure AI Kurulumu](./getting_started/set-up-azure-ai.md)

## Kullanım

Desteklenen tüm türleri çevirin:

```bash
translate -l "ko ja"
```

Sadece Markdown:

```bash
translate -l "de" -md
```

Markdown + resimler:

```bash
translate -l "pt" -md -img
```

Sadece not defterleri:

```bash
translate -l "zh" -nb
```

Daha fazla bayrak: [Komut referansı](./getting_started/command-reference.md)

## Özellikler

- Markdown, not defterleri ve resimler için otomatik çeviri
- Çevirileri kaynak değişiklikleriyle senkron tutar
- Yerel (CLI) veya CI (GitHub Actions) ortamında çalışır
- Azure OpenAI veya OpenAI kullanır; resimler için isteğe bağlı Azure AI Vision
- Markdown biçimlendirmesini ve yapısını korur

## Dokümanlar

- [Komut satırı rehberi](./getting_started/command-line-guide/command-line-guide.md)
- [GitHub Actions rehberi (Açık kaynak depolar ve standart gizli anahtarlar)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [GitHub Actions rehberi (Microsoft organizasyon depoları ve organizasyon düzeyi ayarlar)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [README dilleri şablonu](./getting_started/README_languages_template.md)
- [Desteklenen diller](./getting_started/supported-languages.md)
- [Katkıda bulunma](./CONTRIBUTING.md)
- [Sorun giderme](./getting_started/troubleshooting.md)

### Microsoft’a özel rehber
> [!NOTE]
> Sadece Microsoft “Yeni Başlayanlar” depolarının bakımcıları için.

- [“Diğer kurslar” listesini güncelleme (sadece MS Yeni Başlayanlar depoları için)](./getting_started/update-other-courses.md)

## Bize destek olun ve küresel öğrenmeyi teşvik edin

Eğitim içeriğinin dünya çapında paylaşım şeklini birlikte dönüştürelim! [Co-op Translator](https://github.com/azure/co-op-translator) projesine GitHub’da bir ⭐ verin ve öğrenme ile teknolojide dil engellerini kaldırma misyonumuzu destekleyin. İlginiz ve katkılarınız büyük fark yaratır! Kod katkıları ve özellik önerileri her zaman memnuniyetle karşılanır.

### Microsoft eğitim içeriklerini kendi dilinizde keşfedin

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)
- [.NET ile Generative AI for Beginners](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)
- [Java ile Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML for Beginners](https://aka.ms/ml-beginners)
- [Data Science for Beginners](https://aka.ms/datascience-beginners)
- [AI for Beginners](https://aka.ms/ai-beginners)
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)
- [IoT for Beginners](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## Video sunumları

👉 Aşağıdaki görsele tıklayarak YouTube’da izleyin.

- **Microsoft’ta Açık**: Co-op Translator’ın nasıl kullanılacağına dair kısa 18 dakikalık tanıtım ve hızlı rehber.

  [![Microsoft’ta Açık](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.tr.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## Katkıda Bulunma

Bu proje katkı ve önerilere açıktır. Azure Co-op Translator’a katkıda bulunmak ister misiniz? Lütfen Co-op Translator’ı daha erişilebilir kılmak için nasıl yardımcı olabileceğinize dair rehberimizi inceleyin: [CONTRIBUTING.md](./CONTRIBUTING.md).

## Katkıda Bulunanlar

[![co-op-translator katkıda bulunanlar](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## Davranış Kuralları

Bu proje [Microsoft Açık Kaynak Davranış Kuralları](https://opensource.microsoft.com/codeofconduct/)’nu benimsemiştir. Daha fazla bilgi için [Davranış Kuralları SSS](https://opensource.microsoft.com/codeofconduct/faq/) sayfasını ziyaret edebilir veya ek sorularınız için [opencode@microsoft.com](mailto:opencode@microsoft.com) adresiyle iletişime geçebilirsiniz.

## Sorumlu Yapay Zeka

Microsoft, müşterilerimizin yapay zeka ürünlerimizi sorumlu şekilde kullanmalarına yardımcı olmaya, öğrendiklerimizi paylaşmaya ve Şeffaflık Notları ile Etki Değerlendirmeleri gibi araçlarla güvene dayalı ortaklıklar kurmaya kararlıdır. Bu kaynakların çoğu [https://aka.ms/RAI](https://aka.ms/RAI) adresinde bulunabilir.  
Microsoft’un sorumlu yapay zeka yaklaşımı, adalet, güvenilirlik ve güvenlik, gizlilik ve güvenlik, kapsayıcılık, şeffaflık ve hesap verebilirlik gibi yapay zeka ilkelerine dayanmaktadır.

Bu örnekte kullanılanlar gibi büyük ölçekli doğal dil, görsel ve konuşma modelleri, haksız, güvenilmez veya rahatsız edici davranışlar sergileyebilir ve bu da zararlara yol açabilir. Riskler ve sınırlamalar hakkında bilgi edinmek için lütfen [Azure OpenAI hizmeti Şeffaflık notu](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) sayfasını inceleyin.
Bu riskleri azaltmak için önerilen yaklaşım, mimarinizde zararlı davranışı tespit edip önleyebilen bir güvenlik sistemi bulundurmaktır. [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview), uygulamalarda ve hizmetlerde kullanıcı tarafından oluşturulan ve yapay zeka tarafından oluşturulan zararlı içeriği tespit edebilen bağımsız bir koruma katmanı sağlar. Azure AI Content Safety, zararlı materyalleri tespit etmenize olanak tanıyan metin ve görüntü API'lerini içerir. Ayrıca, farklı modalitelerde zararlı içeriği tespit etmek için örnek kodları görüntüleyip keşfedebileceğiniz ve deneyebileceğiniz etkileşimli bir Content Safety Studio'ya sahibiz. Aşağıdaki [hızlı başlangıç dokümantasyonu](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) servise istek yapma sürecinde size rehberlik eder.

Dikkate alınması gereken bir diğer husus ise genel uygulama performansıdır. Çok modlu ve çok modeller içeren uygulamalarda, performansın sizin ve kullanıcılarınızın beklentilerine uygun şekilde sistemin çalışması, zararlı çıktı üretmemesi anlamına geldiğini düşünüyoruz. Genel uygulamanızın performansını değerlendirmek için [üretim kalitesi ve risk ile güvenlik metriklerini](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) kullanmanız önemlidir.

Yapay zeka uygulamanızı geliştirme ortamınızda [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) ile değerlendirebilirsiniz. Test veri seti veya hedef verildiğinde, üretken yapay zeka uygulamanızın çıktıları, yerleşik değerlendiriciler veya tercih ettiğiniz özel değerlendiricilerle niceliksel olarak ölçülür. Sisteminizin değerlendirmesine başlamak için prompt flow sdk ile ilgili [hızlı başlangıç kılavuzunu](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) takip edebilirsiniz. Bir değerlendirme çalıştırması gerçekleştirdikten sonra, sonuçları [Azure AI Studio'da görselleştirebilirsiniz](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## Ticari Markalar

Bu proje, projeler, ürünler veya hizmetler için ticari markalar veya logolar içerebilir. Microsoft ticari markalarının veya logolarının yetkili kullanımı, [Microsoft'un Ticari Marka ve Marka Kılavuzları](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) kurallarına tabidir ve bu kurallara uyulmalıdır. Bu projenin değiştirilmiş sürümlerinde Microsoft ticari markalarının veya logolarının kullanımı, karışıklığa yol açmamalı veya Microsoft sponsorluğunu ima etmemelidir. Üçüncü taraf ticari markalarının veya logolarının kullanımı ise ilgili üçüncü tarafların politikalarına tabidir.

## Yardım Alma

Yapay zeka uygulamaları geliştirirken takılırsanız veya sorularınız olursa, katılın:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

Ürün geri bildirimi vermek veya geliştirme sırasında hatalarla karşılaşmak için ziyaret edin:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Feragatname**:  
Bu belge, AI çeviri servisi [Co-op Translator](https://github.com/Azure/co-op-translator) kullanılarak çevrilmiştir. Doğruluk için çaba gösterilse de, otomatik çevirilerin hatalar veya yanlışlıklar içerebileceğini lütfen unutmayınız. Orijinal belge, kendi dilinde yetkili kaynak olarak kabul edilmelidir. Kritik bilgiler için profesyonel insan çevirisi önerilir. Bu çevirinin kullanımı sonucu oluşabilecek yanlış anlamalar veya yorum hatalarından sorumlu değiliz.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->