<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "cc205495d4eace1fabcdee963024069f",
  "translation_date": "2025-06-12T11:11:17+00:00",
  "source_file": "SECURITY.md",
  "language_code": "tl"
}
-->
## Security

Seryoso ang Microsoft sa seguridad ng aming mga software products at serbisyo, kabilang na ang lahat ng source code repositories na pinamamahalaan sa pamamagitan ng aming mga GitHub organizations tulad ng [Microsoft](https://github.com/Microsoft), [Azure](https://github.com/Azure), [DotNet](https://github.com/dotnet), [AspNet](https://github.com/aspnet) at [Xamarin](https://github.com/xamarin).

Kung naniniwala kang nakakita ka ng security vulnerability sa anumang Microsoft-owned repository na tumutugma sa [Microsoft's definition of a security vulnerability](https://aka.ms/security.md/definition), mangyaring i-report ito sa amin ayon sa mga tagubiling nasa ibaba.

## Reporting Security Issues

**Huwag mag-report ng security vulnerabilities sa pamamagitan ng public GitHub issues.**

Sa halip, i-report ito sa Microsoft Security Response Center (MSRC) sa [https://msrc.microsoft.com/create-report](https://aka.ms/security.md/msrc/create-report).

Kung mas gusto mong mag-submit nang hindi nagla-login, magpadala ng email sa [secure@microsoft.com](mailto:secure@microsoft.com). Kung maaari, i-encrypt ang iyong mensahe gamit ang aming PGP key; i-download ito mula sa [Microsoft Security Response Center PGP Key page](https://aka.ms/security.md/msrc/pgp).

Dapat kang makatanggap ng tugon sa loob ng 24 na oras. Kung sa anumang dahilan ay hindi mo ito natanggap, mangyaring mag-follow up sa pamamagitan ng email upang matiyak na natanggap namin ang iyong orihinal na mensahe. Karagdagang impormasyon ay makikita sa [microsoft.com/msrc](https://www.microsoft.com/msrc).

Mangyaring isama ang mga hinihiling na impormasyon sa ibaba (hangga't maaari) upang matulungan kaming mas maintindihan ang kalikasan at lawak ng posibleng isyu:

  * Uri ng isyu (hal. buffer overflow, SQL injection, cross-site scripting, atbp.)
  * Buong path ng mga source file na may kaugnayan sa paglitaw ng isyu
  * Lokasyon ng apektadong source code (tag/branch/commit o direktang URL)
  * Anumang espesyal na configuration na kailangan para maulit ang isyu
  * Hakbang-hakbang na mga tagubilin para maulit ang isyu
  * Proof-of-concept o exploit code (kung maaari)
  * Epekto ng isyu, kasama kung paano maaaring samantalahin ng attacker ang isyu

Makakatulong ang impormasyong ito para mas mabilis naming ma-triage ang iyong report.

Kung nagrereport ka para sa bug bounty, mas kumpletong mga ulat ay maaaring makatulong para sa mas mataas na gantimpala. Bisitahin ang aming [Microsoft Bug Bounty Program](https://aka.ms/security.md/msrc/bounty) page para sa karagdagang detalye tungkol sa aming mga aktibong programa.

## Preferred Languages

Mas gusto namin na ang lahat ng komunikasyon ay nasa English.

## Policy

Sinusunod ng Microsoft ang prinsipyo ng [Coordinated Vulnerability Disclosure](https://aka.ms/security.md/cvd).

**Pagtatapat**:  
Ang dokumentong ito ay isinalin gamit ang AI translation service na [Co-op Translator](https://github.com/Azure/co-op-translator). Bagamat nagsusumikap kami para sa katumpakan, pakatandaan na ang mga awtomatikong pagsasalin ay maaaring maglaman ng mga pagkakamali o di-tumpak na impormasyon. Ang orihinal na dokumento sa orihinal nitong wika ang dapat ituring na pangunahing sanggunian. Para sa mahahalagang impormasyon, inirerekomenda ang propesyonal na pagsasalin ng tao. Hindi kami mananagot sa anumang hindi pagkakaunawaan o maling interpretasyon na maaaring magmula sa paggamit ng pagsasaling ito.