<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T03:17:17+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "th"
}
-->
# แปลโปรเจกต์ของคุณด้วย Co-op Translator

**Co-op Translator** เป็นเครื่องมือแบบบรรทัดคำสั่ง (CLI) ที่ช่วยให้คุณแปลไฟล์ markdown และไฟล์ภาพในโปรเจกต์ของคุณเป็นหลายภาษาได้ ส่วนนี้จะอธิบายวิธีใช้งานเครื่องมือ ตัวเลือก CLI ต่าง ๆ และยกตัวอย่างการใช้งานในแต่ละกรณี

> [!NOTE]
> สำหรับรายการคำสั่งทั้งหมดและรายละเอียดเพิ่มเติม กรุณาดูที่ [Command reference](./command-reference.md)

---

## ตัวอย่างสถานการณ์และคำสั่ง

นี่คือตัวอย่างการใช้งาน **Co-op Translator** ที่พบได้บ่อย พร้อมคำสั่งที่เหมาะสมสำหรับแต่ละกรณี

### 1. แปลพื้นฐาน (ภาษาเดียว)

หากต้องการแปลโปรเจกต์ทั้งหมด (ไฟล์ markdown และภาพ) เป็นภาษาเดียว เช่น ภาษาเกาหลี ให้ใช้คำสั่งนี้

```bash
translate -l "ko"
```

คำสั่งนี้จะช่วยแปลไฟล์ markdown และภาพทั้งหมดเป็นภาษาเกาหลี โดยจะเพิ่มไฟล์แปลใหม่โดยไม่ลบไฟล์แปลเดิมที่มีอยู่

> [!TIP]
>
> อยากรู้ว่ามีรหัสภาษาอะไรบ้างใน **Co-op Translator**? ดูรายละเอียดเพิ่มเติมได้ที่ [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) ใน repository

#### ตัวอย่างใน Phi-3 CookBook

ใน **Phi-3 CookBook** ฉันใช้วิธีนี้เพื่อเพิ่มไฟล์แปลภาษาเกาหลีสำหรับไฟล์ markdown และภาพที่มีอยู่

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. แปลหลายภาษา

หากต้องการแปลโปรเจกต์เป็นหลายภาษา (เช่น สเปน ฝรั่งเศส และเยอรมัน) ให้ใช้คำสั่งนี้

```bash
translate -l "es fr de"
```

คำสั่งนี้จะช่วยแปลโปรเจกต์เป็นภาษาสเปน ฝรั่งเศส และเยอรมัน โดยจะเพิ่มไฟล์แปลใหม่โดยไม่ทับไฟล์แปลเดิม

#### ตัวอย่างใน Phi-3 CookBook

ใน **Phi-3 CookBook** หลังจากดึงการเปลี่ยนแปลงล่าสุดเพื่อให้ตรงกับ commit ล่าสุด ฉันใช้วิธีนี้เพื่อแปลไฟล์ markdown และภาพที่เพิ่มใหม่

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> โดยทั่วไปแนะนำให้แปลทีละภาษา แต่ในกรณีที่ต้องการเพิ่มการเปลี่ยนแปลงเฉพาะ การแปลหลายภาษาพร้อมกันก็ช่วยประหยัดเวลาได้

### 3. อัปเดตไฟล์แปล (ลบไฟล์แปลเดิม)

หากต้องการอัปเดตไฟล์แปลเดิม (เช่น ลบไฟล์แปลปัจจุบันแล้วแปลใหม่) ให้ใช้ตัวเลือก `-u` คำสั่งนี้จะลบไฟล์แปลทั้งหมดของภาษาที่ระบุและแปลใหม่

```bash
translate -l "ko" -u
```

คำเตือน: คำสั่งนี้จะถามยืนยันก่อนดำเนินการลบไฟล์แปลเดิม

#### ตัวอย่างใน Phi-3 CookBook

ใน **Phi-3 CookBook** ฉันใช้วิธีนี้เพื่ออัปเดตไฟล์แปลภาษาสเปนทั้งหมด แนะนำให้ใช้วิธีนี้เมื่อมีการเปลี่ยนแปลงเนื้อหาต้นฉบับจำนวนมากในหลายไฟล์ markdown หากมีไฟล์ markdown ที่ต้องอัปเดตเพียงไม่กี่ไฟล์ จะสะดวกกว่าหากลบไฟล์เหล่านั้นเองแล้วใช้วิธี `-a` เพื่อเพิ่มไฟล์แปลใหม่

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. แปลเฉพาะไฟล์ภาพ

หากต้องการแปลเฉพาะไฟล์ภาพในโปรเจกต์ ให้ใช้ตัวเลือก `-img`

```bash
translate -l "ko" -img
```

คำสั่งนี้จะช่วยแปลเฉพาะไฟล์ภาพเป็นภาษาเกาหลี โดยไม่กระทบไฟล์ markdown

### 6. แปลเฉพาะไฟล์ Markdown

หากต้องการแปลเฉพาะไฟล์ markdown ในโปรเจกต์ ให้ใช้ตัวเลือก `-md`

```bash
translate -l "ko" -md
```

#### ตัวอย่างใน Phi-3 CookBook

ใน **Phi-3 CookBook** ฉันใช้วิธีนี้เพื่อตรวจสอบข้อผิดพลาดในการแปลไฟล์ภาษาเกาหลี และให้ระบบลองแปลใหม่อัตโนมัติสำหรับไฟล์ที่พบปัญหา

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

ตัวเลือกนี้จะช่วยตรวจสอบข้อผิดพลาดในการแปล ปัจจุบันหากจำนวนบรรทัดที่แตกต่างกันระหว่างไฟล์ต้นฉบับกับไฟล์แปลเกินหกบรรทัด ไฟล์นั้นจะถูกระบุว่ามีข้อผิดพลาดในการแปล วางแผนจะปรับเกณฑ์นี้ให้ยืดหยุ่นมากขึ้นในอนาคต

ตัวอย่างเช่น วิธีนี้เหมาะสำหรับตรวจสอบส่วนที่ขาดหายหรือไฟล์แปลที่เสีย และจะลองแปลใหม่ให้อัตโนมัติ

แต่ถ้าคุณรู้แล้วว่าไฟล์ไหนมีปัญหา จะสะดวกกว่าหากลบไฟล์เหล่านั้นเองแล้วใช้ตัวเลือก `-a` เพื่อแปลใหม่

### 8. โหมดดีบัก

หากต้องการเปิดบันทึกแบบละเอียดเพื่อแก้ไขปัญหา ให้ใช้ตัวเลือก `-d`

```bash
translate -l "ko" -d
```

คำสั่งนี้จะรันการแปลในโหมดดีบัก พร้อมบันทึกข้อมูลเพิ่มเติมเพื่อช่วยวิเคราะห์ปัญหาระหว่างการแปล

#### ตัวอย่างใน Phi-3 CookBook

ใน **Phi-3 CookBook** ฉันเจอปัญหาเมื่อแปลไฟล์ markdown ที่มีลิงก์จำนวนมาก ทำให้เกิดข้อผิดพลาด เช่น แปลผิดหรือข้ามบรรทัด เพื่อวิเคราะห์ปัญหานี้ ฉันใช้ตัวเลือก `-d` เพื่อดูรายละเอียดการทำงานของระบบแปล

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. แปลทุกภาษา

หากต้องการแปลโปรเจกต์เป็นทุกภาษาที่รองรับ ให้ใช้คำว่า all

> [!WARNING]
> การแปลทุกภาษาพร้อมกันอาจใช้เวลานานมากขึ้นอยู่กับขนาดโปรเจกต์ เช่น การแปล **Phi-3 CookBook** เป็นภาษาสเปนใช้เวลาประมาณ 2 ชั่วโมง ด้วยขนาดงานที่ใหญ่ ไม่เหมาะให้คนเดียวรับผิดชอบ 20 ภาษา แนะนำให้แบ่งงานกันหลายคน โดยแต่ละคนดูแล 1-2 ภาษา และค่อย ๆ อัปเดตไฟล์แปล

```bash
translate -l "all"
```

คำสั่งนี้จะช่วยแปลโปรเจกต์เป็นทุกภาษาที่รองรับ หากดำเนินการ การแปลอาจใช้เวลานานมากขึ้นอยู่กับขนาดโปรเจกต์

> [!TIP]
>
> ### ลบไฟล์แปลด้วยตัวเอง (ทางเลือก)
> ตอนนี้ระบบจะตรวจสอบและลบไฟล์แปลอัตโนมัติเมื่อไฟล์ต้นฉบับมีการอัปเดต
>
> แต่ถ้าคุณต้องการอัปเดตไฟล์แปลเอง เช่น ต้องการแปลไฟล์ใหม่หรือแทนที่ไฟล์เดิม สามารถใช้คำสั่งนี้เพื่อลบไฟล์ทุกเวอร์ชันในโฟลเดอร์แต่ละภาษา
>
> ### บน Windows:
> 1. **ใช้ Command Prompt**:
>    - เปิด Command Prompt
>    - ไปยังโฟลเดอร์ที่เก็บไฟล์ด้วยคำสั่ง `cd`
>    - ใช้คำสั่งนี้เพื่อลบไฟล์:
>      ```
>      del /s *filename*
>      ```
>      แทนที่ `filename` ด้วยชื่อไฟล์ที่ต้องการค้นหา `/s` จะค้นหาในโฟลเดอร์ย่อยด้วย
>
> 2. **ใช้ PowerShell**:
>    - เปิด PowerShell
>    - รันคำสั่งนี้:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      แทนที่ `"C:\YourPath"` ด้วยเส้นทางโฟลเดอร์ และ `filename` ด้วยชื่อไฟล์ที่ต้องการ
>
> ### บน macOS/Linux:
> 1. **ใช้ Terminal**:
>   - เปิด Terminal
>   - ไปยังโฟลเดอร์ด้วย `cd`
>   - ใช้คำสั่ง `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     แทนที่ `filename` ด้วยชื่อไฟล์ที่ต้องการ
>
> ตรวจสอบไฟล์ให้แน่ใจก่อนลบเพื่อป้องกันการสูญหายโดยไม่ตั้งใจ
>
> เมื่อคุณลบไฟล์ที่ต้องการแทนที่แล้ว ให้รันคำสั่ง `translate -l` อีกครั้งเพื่ออัปเดตไฟล์แปลล่าสุด

---

**ข้อจำกัดความรับผิดชอบ**:
เอกสารฉบับนี้ได้รับการแปลโดยใช้บริการแปลภาษา AI [Co-op Translator](https://github.com/Azure/co-op-translator) แม้เราจะพยายามให้การแปลมีความถูกต้อง แต่โปรดทราบว่าการแปลโดยอัตโนมัติอาจมีข้อผิดพลาดหรือความไม่ถูกต้อง เอกสารต้นฉบับในภาษาต้นทางควรถือเป็นแหล่งข้อมูลที่เชื่อถือได้ สำหรับข้อมูลสำคัญ แนะนำให้ใช้บริการแปลโดยนักแปลมืออาชีพ ทางเราจะไม่รับผิดชอบต่อความเข้าใจผิดหรือการตีความที่เกิดขึ้นจากการใช้การแปลนี้