<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T11:16:46+00:00",
  "source_file": "README.md",
  "language_code": "th"
}
-->
# Co-op Translator

_ช่วยให้คุณแปลเนื้อหาการศึกษาบน GitHub เป็นหลายภาษาได้อย่างง่ายดาย เพื่อเข้าถึงผู้ชมทั่วโลก_

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 รองรับหลายภาษา

#### สนับสนุนโดย [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[อาหรับ](../ar/README.md) | [เบงกาลี](../bn/README.md) | [บัลแกเรีย](../bg/README.md) | [พม่า (เมียนมา)](../my/README.md) | [จีน (ตัวย่อ)](../zh/README.md) | [จีน (ตัวเต็ม, ฮ่องกง)](../hk/README.md) | [จีน (ตัวเต็ม, มาเก๊า)](../mo/README.md) | [จีน (ตัวเต็ม, ไต้หวัน)](../tw/README.md) | [โครเอเชีย](../hr/README.md) | [เช็ก](../cs/README.md) | [เดนมาร์ก](../da/README.md) | [ดัตช์](../nl/README.md) | [เอสโตเนีย](../et/README.md) | [ฟินแลนด์](../fi/README.md) | [ฝรั่งเศส](../fr/README.md) | [เยอรมัน](../de/README.md) | [กรีก](../el/README.md) | [ฮีบรู](../he/README.md) | [ฮินดี](../hi/README.md) | [ฮังการี](../hu/README.md) | [อินโดนีเซีย](../id/README.md) | [อิตาลี](../it/README.md) | [ญี่ปุ่น](../ja/README.md) | [กันนาดา](../kn/README.md) | [เกาหลี](../ko/README.md) | [ลิทัวเนีย](../lt/README.md) | [มาเลย์](../ms/README.md) | [มาลายาลัม](../ml/README.md) | [มราฐี](../mr/README.md) | [เนปาล](../ne/README.md) | [ไนจีเรีย พิดจิน](../pcm/README.md) | [นอร์เวย์](../no/README.md) | [เปอร์เซีย (ฟาร์ซี)](../fa/README.md) | [โปแลนด์](../pl/README.md) | [โปรตุเกส (บราซิล)](../br/README.md) | [โปรตุเกส (โปรตุเกส)](../pt/README.md) | [ปัญจาบี (กูรมุขี)](../pa/README.md) | [โรมาเนีย](../ro/README.md) | [รัสเซีย](../ru/README.md) | [เซอร์เบีย (ซีริลลิก)](../sr/README.md) | [สโลวัก](../sk/README.md) | [สโลวีเนีย](../sl/README.md) | [สเปน](../es/README.md) | [สวาฮิลี](../sw/README.md) | [สวีเดน](../sv/README.md) | [ตากาล็อก (ฟิลิปปินส์)](../tl/README.md) | [ทมิฬ](../ta/README.md) | [เทลูกู](../te/README.md) | [ไทย](./README.md) | [ตุรกี](../tr/README.md) | [ยูเครน](../uk/README.md) | [อูรดู](../ur/README.md) | [เวียดนาม](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## ภาพรวม

**Co-op Translator** ช่วยให้คุณแปลเนื้อหาการศึกษาบน GitHub เป็นหลายภาษาได้อย่างง่ายดาย
เมื่อคุณอัปเดตไฟล์ Markdown รูปภาพ หรือโน้ตบุ๊ก การแปลจะถูกซิงค์โดยอัตโนมัติ เพื่อให้เนื้อหาของคุณถูกต้องและทันสมัยสำหรับผู้เรียนทั่วโลก

ตัวอย่างการจัดระเบียบเนื้อหาที่แปลแล้ว:

![ตัวอย่าง](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.th.png)

## เริ่มต้นอย่างรวดเร็ว

```bash
# สร้างและเปิดใช้งานสภาพแวดล้อมเสมือน (แนะนำ)
python -m venv .venv
# วินโดวส์
.venv\Scripts\activate
# แมคโอเอส/ลินุกซ์
source .venv/bin/activate
# ติดตั้งแพ็กเกจ
pip install co-op-translator
# แปล
translate -l "ko ja fr" -md
```

Docker:

```bash
# ดึงภาพสาธารณะจาก GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# รันโดยเมานต์โฟลเดอร์ปัจจุบันและให้ .env (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## การตั้งค่าขั้นต่ำ

1. สร้างไฟล์ `.env` โดยใช้เทมเพลต: [.env.template](../../.env.template)
2. ตั้งค่าผู้ให้บริการ LLM หนึ่งราย (Azure OpenAI หรือ OpenAI)
3. (ไม่บังคับ) สำหรับการแปลรูปภาพ (`-img`) ตั้งค่า Azure AI Vision
4. (แนะนำ) ลบการแปลเดิมออกเพื่อป้องกันความขัดแย้ง (เช่น โฟลเดอร์ `translations/`)
5. (แนะนำ) เพิ่มส่วนการแปลใน README ของคุณโดยใช้ [เทมเพลตภาษา README](./getting_started/README_languages_template.md)
6. ดูเพิ่มเติม: [ตั้งค่า Azure AI](./getting_started/set-up-azure-ai.md)

## การใช้งาน

แปลทุกประเภทที่รองรับ:

```bash
translate -l "ko ja"
```

แค่ Markdown:

```bash
translate -l "de" -md
```

Markdown + รูปภาพ:

```bash
translate -l "pt" -md -img
```

แค่โน้ตบุ๊ก:

```bash
translate -l "zh" -nb
```

ตัวเลือกเพิ่มเติม: [คำสั่งอ้างอิง](./getting_started/command-reference.md)

## คุณสมบัติ

- แปลอัตโนมัติสำหรับ Markdown, โน้ตบุ๊ก และรูปภาพ
- รักษาการแปลให้ตรงกับการเปลี่ยนแปลงต้นฉบับ
- ใช้งานได้ทั้งในเครื่อง (CLI) หรือใน CI (GitHub Actions)
- ใช้ Azure OpenAI หรือ OpenAI; มีตัวเลือก Azure AI Vision สำหรับรูปภาพ
- รักษารูปแบบและโครงสร้าง Markdown ไว้

## เอกสาร

- [คู่มือบรรทัดคำสั่ง](./getting_started/command-line-guide/command-line-guide.md)
- [คู่มือ GitHub Actions (Public repositories & standard secrets)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [คู่มือ GitHub Actions (Microsoft organization repositories & org-level setups)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [เทมเพลตภาษา README](./getting_started/README_languages_template.md)
- [ภาษาที่รองรับ](./getting_started/supported-languages.md)
- [การมีส่วนร่วม](./CONTRIBUTING.md)
- [แก้ไขปัญหา](./getting_started/troubleshooting.md)

### คู่มือเฉพาะ Microsoft
> [!NOTE]
> สำหรับผู้ดูแล repository “For Beginners” ของ Microsoft เท่านั้น

- [อัปเดตรายการ “หลักสูตรอื่น ๆ” (สำหรับ repository MS Beginners เท่านั้น)](./getting_started/update-other-courses.md)

## สนับสนุนเราและส่งเสริมการเรียนรู้ทั่วโลก

มาร่วมกันปฏิวัติการแบ่งปันเนื้อหาการศึกษาทั่วโลก! ให้ ⭐ กับ [Co-op Translator](https://github.com/azure/co-op-translator) บน GitHub และสนับสนุนภารกิจของเราในการทำลายอุปสรรคด้านภาษาในการเรียนรู้และเทคโนโลยี ความสนใจและการมีส่วนร่วมของคุณมีผลกระทบอย่างมาก! ยินดีรับการมีส่วนร่วมด้านโค้ดและข้อเสนอแนะฟีเจอร์เสมอ

### สำรวจเนื้อหาการศึกษาของ Microsoft ในภาษาของคุณ

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)
- [Generative AI for Beginners using .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)
- [Generative AI for Beginners using Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML for Beginners](https://aka.ms/ml-beginners)
- [Data Science for Beginners](https://aka.ms/datascience-beginners)
- [AI for Beginners](https://aka.ms/ai-beginners)
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)
- [IoT for Beginners](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## วิดีโอนำเสนอ

👉 คลิกที่ภาพด้านล่างเพื่อชมบน YouTube

- **Open at Microsoft**: แนะนำสั้น ๆ 18 นาที พร้อมคู่มือการใช้งาน Co-op Translator อย่างรวดเร็ว

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.th.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## การมีส่วนร่วม

โครงการนี้ยินดีรับการมีส่วนร่วมและข้อเสนอแนะ หากคุณสนใจร่วมพัฒนา Azure Co-op Translator โปรดดูที่ [CONTRIBUTING.md](./CONTRIBUTING.md) เพื่อดูแนวทางการช่วยทำให้ Co-op Translator เข้าถึงได้ง่ายขึ้น

## ผู้ร่วมพัฒนา

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## จรรยาบรรณ

โครงการนี้ได้นำ [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) มาใช้
สำหรับข้อมูลเพิ่มเติมดูที่ [คำถามที่พบบ่อยเกี่ยวกับจรรยาบรรณ](https://opensource.microsoft.com/codeofconduct/faq/) หรือ
ติดต่อ [opencode@microsoft.com](mailto:opencode@microsoft.com) หากมีคำถามหรือข้อเสนอแนะเพิ่มเติม

## AI ที่รับผิดชอบ

Microsoft มุ่งมั่นช่วยลูกค้าใช้ผลิตภัณฑ์ AI อย่างรับผิดชอบ แบ่งปันความรู้ และสร้างความไว้วางใจผ่านเครื่องมือต่าง ๆ เช่น Transparency Notes และ Impact Assessments ทรัพยากรเหล่านี้สามารถดูได้ที่ [https://aka.ms/RAI](https://aka.ms/RAI)
แนวทางของ Microsoft ใน AI ที่รับผิดชอบยึดหลักการ AI ของเรา ได้แก่ ความเป็นธรรม ความน่าเชื่อถือและความปลอดภัย ความเป็นส่วนตัวและความมั่นคง ความครอบคลุม ความโปร่งใส และความรับผิดชอบ

โมเดลภาษาธรรมชาติ รูปภาพ และเสียงขนาดใหญ่ — เช่นที่ใช้ในตัวอย่างนี้ — อาจแสดงพฤติกรรมที่ไม่เป็นธรรม ไม่น่าเชื่อถือ หรือไม่เหมาะสม ซึ่งอาจก่อให้เกิดความเสียหาย โปรดศึกษาข้อมูลใน [Azure OpenAI service Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) เพื่อรับทราบความเสี่ยงและข้อจำกัดต่าง ๆ
แนวทางที่แนะนำในการลดความเสี่ยงเหล่านี้คือการรวมระบบความปลอดภัยในสถาปัตยกรรมของคุณที่สามารถตรวจจับและป้องกันพฤติกรรมที่เป็นอันตรายได้ [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) ให้ชั้นการป้องกันอิสระที่สามารถตรวจจับเนื้อหาที่เป็นอันตรายซึ่งสร้างโดยผู้ใช้และ AI ในแอปพลิเคชันและบริการ Azure AI Content Safety ประกอบด้วย API สำหรับข้อความและภาพที่ช่วยให้คุณตรวจจับเนื้อหาที่เป็นอันตรายได้ นอกจากนี้ เรายังมี Content Safety Studio แบบโต้ตอบที่ช่วยให้คุณดู สำรวจ และทดลองใช้ตัวอย่างโค้ดสำหรับการตรวจจับเนื้อหาที่เป็นอันตรายในรูปแบบต่างๆ เอกสาร [quickstart documentation](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) ต่อไปนี้จะแนะนำวิธีการส่งคำขอไปยังบริการนี้

อีกประเด็นที่ต้องพิจารณาคือประสิทธิภาพโดยรวมของแอปพลิเคชัน สำหรับแอปพลิเคชันที่มีหลายโหมดและหลายโมเดล เราถือว่าประสิทธิภาพหมายถึงระบบทำงานตามที่คุณและผู้ใช้ของคุณคาดหวัง รวมถึงไม่สร้างผลลัพธ์ที่เป็นอันตรายด้วย การประเมินประสิทธิภาพของแอปพลิเคชันโดยรวมของคุณจึงเป็นสิ่งสำคัญโดยใช้ [generation quality and risk and safety metrics](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in)

คุณสามารถประเมินแอปพลิเคชัน AI ของคุณในสภาพแวดล้อมการพัฒนาด้วยการใช้ [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) โดยเมื่อมีชุดข้อมูลทดสอบหรือเป้าหมาย การสร้างของแอปพลิเคชัน generative AI ของคุณจะถูกวัดเชิงปริมาณด้วยตัวประเมินในตัวหรือผู้ประเมินที่คุณกำหนดเอง เพื่อเริ่มต้นใช้งาน prompt flow sdk ในการประเมินระบบของคุณ คุณสามารถทำตาม [quickstart guide](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) เมื่อคุณดำเนินการรันการประเมินแล้ว คุณสามารถ [แสดงผลลัพธ์ใน Azure AI Studio](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results) ได้

## เครื่องหมายการค้า

โครงการนี้อาจมีเครื่องหมายการค้าหรือโลโก้สำหรับโครงการ ผลิตภัณฑ์ หรือบริการ การใช้เครื่องหมายการค้าหรือโลโก้ของ Microsoft อย่างถูกต้องต้องเป็นไปตามและปฏิบัติตาม [Microsoft's Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) การใช้เครื่องหมายการค้าหรือโลโก้ของ Microsoft ในเวอร์ชันที่แก้ไขของโครงการนี้ต้องไม่ก่อให้เกิดความสับสนหรือบ่งชี้ว่ามีการสนับสนุนจาก Microsoft การใช้เครื่องหมายการค้าหรือโลโก้ของบุคคลที่สามใดๆ ต้องเป็นไปตามนโยบายของบุคคลที่สามนั้นๆ

## ขอความช่วยเหลือ

หากคุณติดขัดหรือต้องการคำถามเกี่ยวกับการสร้างแอป AI เข้าร่วมได้ที่:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

หากคุณมีข้อเสนอแนะเกี่ยวกับผลิตภัณฑ์หรือพบข้อผิดพลาดขณะพัฒนา โปรดเยี่ยมชม:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**ข้อจำกัดความรับผิดชอบ**:  
เอกสารนี้ได้รับการแปลโดยใช้บริการแปลภาษาอัตโนมัติ [Co-op Translator](https://github.com/Azure/co-op-translator) แม้เราจะพยายามให้ความถูกต้องสูงสุด แต่โปรดทราบว่าการแปลอัตโนมัติอาจมีข้อผิดพลาดหรือความไม่ถูกต้อง เอกสารต้นฉบับในภาษาต้นทางถือเป็นแหล่งข้อมูลที่เชื่อถือได้ สำหรับข้อมูลที่สำคัญ ขอแนะนำให้ใช้บริการแปลโดยผู้เชี่ยวชาญมนุษย์ เราไม่รับผิดชอบต่อความเข้าใจผิดหรือการตีความผิดใด ๆ ที่เกิดจากการใช้การแปลนี้
<!-- CO-OP TRANSLATOR DISCLAIMER END -->