<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-11-22T05:58:20+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "te"
}
-->
# Microsoft Co-op Translator సమస్యల పరిష్కార గైడ్

## అవలోకనం
Microsoft Co-Op Translator అనేది Markdown డాక్యుమెంట్లను సులభంగా అనువదించడానికి శక్తివంతమైన సాధనం. ఈ గైడ్ సాధనాన్ని ఉపయోగించేటప్పుడు ఎదురయ్యే సాధారణ సమస్యలను పరిష్కరించడంలో మీకు సహాయపడుతుంది.

## సాధారణ సమస్యలు మరియు పరిష్కారాలు

### 1. Markdown ట్యాగ్ సమస్య
**సమస్య:** అనువదించిన Markdown డాక్యుమెంట్ పైభాగంలో `markdown` ట్యాగ్ కలిగి ఉంటుంది, ఇది రెండరింగ్ సమస్యలకు కారణమవుతుంది.

**పరిష్కారం:** దీన్ని పరిష్కరించడానికి, డాక్యుమెంట్ పైభాగంలో ఉన్న `markdown` ట్యాగ్‌ను తొలగించండి. ఇది Markdown ఫైల్ సరిగ్గా రెండర్ అవ్వడానికి అనుమతిస్తుంది.

**దశలు:**
1. అనువదించిన Markdown (`.md`) ఫైల్‌ను తెరవండి.
2. డాక్యుమెంట్ పైభాగంలో `markdown` ట్యాగ్‌ను గుర్తించండి.
3. `markdown` ట్యాగ్‌ను తొలగించండి.
4. ఫైల్‌లో మార్పులను సేవ్ చేయండి.
5. ఫైల్‌ను తిరిగి తెరిచి సరిగ్గా రెండర్ అవుతుందో లేదో నిర్ధారించండి.

### 2. ఎంబెడెడ్ ఇమేజ్ URL సమస్య
**సమస్య:** ఎంబెడెడ్ ఇమేజ్‌ల URL‌లు భాషా స్థానికతకు సరిపోకపోవడం వల్ల తప్పు లేదా గైర్హాజరు ఇమేజ్‌లు కనిపిస్తాయి.

**పరిష్కారం:** ఎంబెడెడ్ ఇమేజ్‌ల URLలను తనిఖీ చేసి, అవి భాషా స్థానికతకు సరిపోతున్నాయో లేదో నిర్ధారించండి. అన్ని ఇమేజ్‌లు `translated_images` ఫోల్డర్‌లో ఉంటాయి, ప్రతి ఇమేజ్ ఫైల్ పేరులో భాషా స్థానికత ట్యాగ్ ఉంటుంది.

**దశలు:**
1. అనువదించిన Markdown డాక్యుమెంట్‌ను తెరవండి.
2. ఎంబెడెడ్ ఇమేజ్‌లు మరియు వాటి URLలను గుర్తించండి.
3. ఇమేజ్ ఫైల్ పేరులో భాషా స్థానికత డాక్యుమెంట్ భాషకు సరిపోతుందో లేదో నిర్ధారించండి.
4. అవసరమైతే URLలను నవీకరించండి.
5. మార్పులను సేవ్ చేసి, డాక్యుమెంట్‌ను తిరిగి తెరిచి ఇమేజ్‌లు సరిగ్గా రెండర్ అవుతున్నాయో లేదో నిర్ధారించండి.

### 3. అనువాద ఖచ్చితత్వం
**సమస్య:** అనువదించిన కంటెంట్ ఖచ్చితంగా లేదు లేదా మరింత ఎడిటింగ్ అవసరం.

**పరిష్కారం:** అనువదించిన డాక్యుమెంట్‌ను సమీక్షించి, ఖచ్చితత్వం మరియు చదవగలిగే విధానాన్ని మెరుగుపరచడానికి అవసరమైన ఎడిటింగ్ చేయండి.

**దశలు:**
1. అనువదించిన డాక్యుమెంట్‌ను తెరవండి.
2. కంటెంట్‌ను జాగ్రత్తగా సమీక్షించండి.
3. అనువాద ఖచ్చితత్వాన్ని మెరుగుపరచడానికి అవసరమైన ఎడిటింగ్ చేయండి.
4. మార్పులను సేవ్ చేయండి.

## 4. అనుమతి లోపం లేదా 404

ఇమేజ్‌లు లేదా టెక్స్ట్ సరైన భాషకు అనువదించబడడం లేదు మరియు -d డీబగ్ మోడ్‌లో నడుపుతున్నప్పుడు 401 లోపం ఎదురవుతుంది. ఇది క్లాసిక్ ఆథెంటికేషన్ వైఫల్యం—కీ చెల్లదు, గడువు ముగిసింది లేదా ఎండ్‌పాయింట్ ప్రాంతానికి అనుసంధానించబడలేదు.

కో-ఆప్ ట్రాన్స్‌లేటర్‌ను [-d డీబగ్ స్విచ్](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md)తో నడపండి, మూల కారణాన్ని మరింత అర్థం చేసుకోవడానికి.

- **లోప సందేశం**: `Access denied due to invalid subscription key or wrong API endpoint.`
- **సంభవించే కారణాలు**:
  - సబ్‌స్క్రిప్షన్ కీ అభ్యర్థనలో తప్పుగా ఉంది లేదా తొలగించబడింది.
  - AI Services Key లేదా Subscription Key వేరే Azure వనరుకు చెందినది (ఉదా: Translator లేదా OpenAI) కానీ **Azure AI Vision** వనరుకు చెందినది కాదు.

 **వనరుల రకం**
  - [Azure Portal](https://portal.azure.com) లేదా [Azure AI Foundry](https://ai.azure.com)కి వెళ్లి వనరు రకం `Azure AI services` → `Vision`గా ఉందో లేదో నిర్ధారించండి.
  - కీలు చెల్లుబాటు అవుతున్నాయో మరియు సరైన కీ ఉపయోగించబడుతున్నదో నిర్ధారించండి.

## 5. కాన్ఫిగరేషన్ లోపాలు (కొత్త లోపాల నిర్వహణ)

కొత్త ఎంపిక అనువాద వ్యవస్థతో ప్రారంభించి, Co-op Translator అవసరమైన సేవలు కాన్ఫిగర్ చేయబడనిప్పుడు స్పష్టమైన లోప సందేశాలను అందిస్తుంది.

### 5.1. ఇమేజ్ అనువాదానికి Azure AI Service కాన్ఫిగర్ చేయబడలేదు

**సమస్య:** మీరు ఇమేజ్ అనువాదాన్ని (`-img` ఫ్లాగ్) అభ్యర్థించారు కానీ Azure AI Service సరిగ్గా కాన్ఫిగర్ చేయబడలేదు.

**లోప సందేశం:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**పరిష్కారం:**
1. **ఆప్షన్ 1**: Azure AI Serviceని కాన్ఫిగర్ చేయండి
   - మీ `.env` ఫైల్‌లో `AZURE_AI_SERVICE_API_KEY`ను జోడించండి
   - మీ `.env` ఫైల్‌లో `AZURE_AI_SERVICE_ENDPOINT`ను జోడించండి
   - సేవ అందుబాటులో ఉందో లేదో నిర్ధారించండి

2. **ఆప్షన్ 2**: ఇమేజ్ అనువాద అభ్యర్థనను తొలగించండి
   ```bash
   # బదులుగా: translate -l "ko" -img
   # ఉపయోగించండి: translate -l "ko" -md
   ```

### 5.2. అవసరమైన కాన్ఫిగరేషన్ లేకపోవడం

**సమస్య:** అవసరమైన LLM కాన్ఫిగరేషన్ లేదు.

**లోప సందేశం:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**పరిష్కారం:**
1. మీ `.env` ఫైల్‌లో కనీసం ఈ LLM కాన్ఫిగరేషన్లలో ఒకటి ఉందో లేదో నిర్ధారించండి:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` మరియు `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   మీకు Azure OpenAI లేదా OpenAI కాన్ఫిగర్ చేయడం అవసరం, రెండూ కాదు.

### 5.3. ఎంపిక అనువాద గందరగోళం

**సమస్య:** ఆదేశం విజయవంతమైనప్పటికీ ఎటువంటి ఫైళ్లను అనువదించలేదు.

**సంభవించే కారణాలు:**
- తప్పు ఫైల్ రకం ఫ్లాగ్‌లు (`-md`, `-img`, `-nb`)
- ప్రాజెక్ట్‌లో సరిపోని ఫైళ్లు
- తప్పు డైరెక్టరీ నిర్మాణం

**పరిష్కారం:**
1. **డీబగ్ మోడ్ ఉపయోగించండి**: ఏమి జరుగుతుందో చూడటానికి:
   ```bash
   translate -l "ko" -md -d
   ```

2. **ఫైల్ రకాలను తనిఖీ చేయండి** మీ ప్రాజెక్ట్‌లో:
   ```bash
   # మార్క్‌డౌన్ ఫైళ్ల కోసం
   find . -name "*.md" -not -path "./translations/*"
   
   # నోట్‌బుక్‌ల కోసం
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # చిత్రాల కోసం
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **ఫ్లాగ్ కాంబినేషన్లను నిర్ధారించండి**:
   ```bash
   # అన్ని అనువదించండి (డిఫాల్ట్)
   translate -l "ko"
   
   # నిర్దిష్ట రకాలను అనువదించండి
   translate -l "ko" -md -img
   ```

## 6. పాత వ్యవస్థ నుండి మైగ్రేషన్

### 6.1. Markdown-మాత్రమే మోడ్ రద్దు చేయబడింది

**సమస్య:** ఆటోమేటిక్ Markdown-మాత్రమే fallbackపై ఆధారపడిన ఆదేశాలు ఇకపై ఆశించిన విధంగా పనిచేయవు.

**పాత ప్రవర్తన:**
```bash
# ఇది స్వయంచాలకంగా markdown-మాత్రం మోడ్‌కు మారుతుంది
translate -l "ko"  # (Azure AI Vision కాన్ఫిగర్ చేయబడనిప్పుడు)
```

**కొత్త ప్రవర్తన:**
```bash
# ఇది ఇప్పుడు చిత్ర అనువాదం అభ్యర్థించబడినప్పుడు కాని ఆకృతీకరించబడనిప్పుడు లోపాన్ని ఉత్పత్తి చేస్తుంది
translate -l "ko" -img
```

**పరిష్కారం:**
- **మీరు అనువదించాలనుకుంటున్నదాన్ని స్పష్టంగా చెప్పండి**:
  ```bash
  translate -l "ko" -md        # కేవలం మార్క్‌డౌన్
  translate -l "ko" -md -img   # మార్క్‌డౌన్ మరియు చిత్రాలు
  translate -l "ko"            # అన్ని సేవలు కాన్ఫిగర్ చేయబడితే అన్ని విషయాలు
  ```

### 6.2. అనూహ్యమైన లింక్ ప్రవర్తన

**సమస్య:** అనువదించిన ఫైళ్లలో లింక్‌లు అనూహ్యమైన ప్రదేశాలను సూచిస్తాయి.

**కారణం:** ఎంపిక చేసిన ఫైల్ రకాల ఆధారంగా డైనమిక్ లింక్ ప్రాసెసింగ్ మార్పులు.

**పరిష్కారం:**
1. **కొత్త లింక్ ప్రవర్తనను అర్థం చేసుకోండి**:
   - `-nb` చేర్చబడింది: నోట్‌బుక్ లింక్‌లు అనువదించిన వెర్షన్లను సూచిస్తాయి
   - `-nb` మినహాయించబడింది: నోట్‌బుక్ లింక్‌లు అసలు ఫైళ్లను సూచిస్తాయి
   - `-img` చేర్చబడింది: ఇమేజ్ లింక్‌లు అనువదించిన వెర్షన్లను సూచిస్తాయి
   - `-img` మినహాయించబడింది: ఇమేజ్ లింక్‌లు అసలు ఫైళ్లను సూచిస్తాయి

2. **మీ అవసరానికి సరైన కాంబినేషన్‌ను ఎంచుకోండి**:
   ```bash
   # అన్ని అంతర్గత లింకులు అనువాదిత వెర్షన్లను సూచిస్తాయి
   translate -l "ko" -md -img -nb
   
   # కేవలం మార్క్‌డౌన్ అనువదించబడింది, ఇతర లింకులు అసలైన వాటిని సూచిస్తాయి
   translate -l "ko" -md
   ```

## 7. GitHub Action నడిచింది కానీ Pull Request (PR) సృష్టించబడలేదు

**లక్షణం:** `peter-evans/create-pull-request` కోసం వర్క్‌ఫ్లో లాగ్‌లు చూపిస్తాయి:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**సంభవించే కారణాలు:**
- **మార్పులు గుర్తించబడలేదు:** అనువాద దశ ఎటువంటి మార్పులను ఉత్పత్తి చేయలేదు (రిపో ఇప్పటికే నవీకరించబడింది).
- **ఉత్పత్తులను నిర్లక్ష్యం చేయడం:** `.gitignore` మీరు కమిట్ చేయాలని భావించిన ఫైళ్లను మినహాయిస్తుంది (ఉదా: `*.ipynb`, `translations/`, `translated_images/`).
- **add-paths అసమతుల్యత:** ఆక్షన్‌కు అందించిన మార్గాలు వాస్తవ ఉత్పత్తి ప్రదేశాలకు సరిపోవు.
- **వర్క్‌ఫ్లో లాజిక్/షరతులు:** అనువాద దశ ముందుగానే ముగిసింది లేదా అనూహ్యమైన డైరెక్టరీలకు రాసింది.

**ఎలా పరిష్కరించాలి / నిర్ధారించాలి:**
1. **ఉత్పత్తులు ఉన్నాయో నిర్ధారించండి:** అనువాదం తర్వాత, `translations/` మరియు/లేదా `translated_images/`లో కొత్త/మార్చబడిన ఫైళ్లు ఉన్నాయో workspaceలో తనిఖీ చేయండి.
   - నోట్‌బుక్‌లను అనువదిస్తే, `.ipynb` ఫైళ్లు నిజంగా `translations/<lang>/...` కింద రాయబడినాయో నిర్ధారించండి.
2. **`.gitignore` సమీక్షించండి:** ఉత్పత్తి ఫైళ్లను నిర్లక్ష్యం చేయవద్దు. మీరు ఈ ఫైళ్లను నిర్లక్ష్యం చేయడం లేదు అని నిర్ధారించండి:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (నోట్‌బుక్‌లను అనువదిస్తే)
3. **add-paths ఉత్పత్తులకు సరిపోతుందో నిర్ధారించండి:** బహుళ-లైన్ విలువను ఉపయోగించి, అవసరమైతే రెండు ఫోల్డర్లను చేర్చండి:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **డీబగ్ కోసం PRను బలవంతంగా చేయండి:** వైరింగ్ సరిగ్గా ఉందని నిర్ధారించడానికి తాత్కాలికంగా ఖాళీ కమిట్‌లను అనుమతించండి:
   ```yaml
   with:
     commit-empty: true
   ```
5. **డీబగ్‌తో నడపండి:** ఏ ఫైళ్లు కనుగొనబడ్డాయి మరియు రాయబడ్డాయో ముద్రించడానికి అనువాద ఆదేశానికి `-d` జోడించండి.
6. **అనుమతులు (GITHUB_TOKEN):** కమిట్‌లు మరియు PRలను సృష్టించడానికి వర్క్‌ఫ్లోకు రైట్ అనుమతులు ఉన్నాయో నిర్ధారించండి:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```

## త్వరిత డీబగ్ చెక్లిస్ట్

అనువాద సమస్యలను పరిష్కరించేటప్పుడు:

1. **డీబగ్ మోడ్ ఉపయోగించండి**: వివరమైన లాగ్‌లను చూడటానికి `-d` ఫ్లాగ్ జోడించండి
2. **మీ ఫ్లాగ్‌లను తనిఖీ చేయండి**: `-md`, `-img`, `-nb` మీ ఉద్దేశానికి సరిపోతున్నాయో నిర్ధారించండి
3. **కాన్ఫిగరేషన్‌ను నిర్ధారించండి**: మీ `.env` ఫైల్‌లో అవసరమైన కీలు ఉన్నాయో చూడండి
4. **దశలవారీగా పరీక్షించండి**: మొదట `-md`తో ప్రారంభించి, తర్వాత ఇతర రకాలను జోడించండి
5. **ఫైల్ నిర్మాణాన్ని తనిఖీ చేయండి**: మూల ఫైళ్లు ఉన్నాయో మరియు అందుబాటులో ఉన్నాయో నిర్ధారించండి

అందుబాటులో ఉన్న ఆదేశాలు మరియు ఫ్లాగ్‌ల గురించి మరింత వివరమైన సమాచారం కోసం, [Command Reference](./command-reference.md) చూడండి.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**అస్వీకరణ**:  
ఈ పత్రం AI అనువాద సేవ [Co-op Translator](https://github.com/Azure/co-op-translator) ఉపయోగించి అనువదించబడింది. మేము ఖచ్చితత్వానికి ప్రయత్నిస్తున్నప్పటికీ, ఆటోమేటెడ్ అనువాదాలు తప్పులు లేదా అసమగ్రతలను కలిగి ఉండవచ్చు. దాని స్వదేశ భాషలో ఉన్న అసలు పత్రాన్ని అధికారం కలిగిన మూలంగా పరిగణించాలి. కీలకమైన సమాచారం కోసం, ప్రొఫెషనల్ మానవ అనువాదాన్ని సిఫారసు చేస్తాము. ఈ అనువాదాన్ని ఉపయోగించడం వల్ల కలిగే ఏవైనా అపార్థాలు లేదా తప్పుదారులు కోసం మేము బాధ్యత వహించము.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->