<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-11-22T06:00:19+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "te"
}
-->
# మీ ప్రాజెక్ట్‌ను Co-op Translator ఉపయోగించి అనువదించండి

**Co-op Translator** అనేది కమాండ్-లైన్ ఇంటర్‌ఫేస్ (CLI) సాధనం, ఇది మీ ప్రాజెక్ట్‌లోని మార్క్‌డౌన్ మరియు చిత్ర ఫైళ్లను అనేక భాషలలోకి అనువదించడంలో సహాయపడుతుంది. ఈ విభాగం సాధనాన్ని ఎలా ఉపయోగించాలో, వివిధ CLI ఎంపికలను, మరియు వివిధ ఉపయోగ సందర్భాలకు ఉదాహరణలను వివరిస్తుంది.

> [!NOTE]
> కమాండ్ల పూర్తి జాబితా మరియు వాటి వివరణల కోసం, దయచేసి [Command reference](./command-reference.md) చూడండి.

---

## ఉదాహరణలు మరియు కమాండ్లు

**Co-op Translator** కోసం కొన్ని సాధారణ ఉపయోగ సందర్భాలు మరియు వాటికి సరిపడే కమాండ్లు ఇక్కడ ఉన్నాయి.

### 1. ప్రాథమిక అనువాదం (ఒకే భాష)

మీ మొత్తం ప్రాజెక్ట్‌ను (మార్క్‌డౌన్ ఫైళ్లు మరియు చిత్రాలు) ఒకే భాషలోకి, ఉదాహరణకు కొరియన్‌లోకి అనువదించడానికి, ఈ కమాండ్‌ను ఉపయోగించండి:

```bash
translate -l "ko"
```

ఈ కమాండ్ అన్ని మార్క్‌డౌన్ మరియు చిత్ర ఫైళ్లను కొరియన్‌లోకి అనువదిస్తుంది, కొత్త అనువాదాలను జోడించి, ఇప్పటికే ఉన్న వాటిని తొలగించకుండా.

> [!TIP]
>
> **Co-op Translator** లో ఏ భాష కోడ్లు అందుబాటులో ఉన్నాయో తెలుసుకోవాలనుకుంటున్నారా? వివరాల కోసం రిపోజిటరీలోని [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) విభాగాన్ని సందర్శించండి.

#### Phi-3 CookBook పై ఉదాహరణ

**Phi-3 CookBook** లో, ఇప్పటికే ఉన్న మార్క్‌డౌన్ ఫైళ్లు మరియు చిత్రాలకు కొరియన్ అనువాదాన్ని జోడించడానికి నేను ఈ విధానాన్ని ఉపయోగించాను.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. బహుభాషలలో అనువదించడం

మీ ప్రాజెక్ట్‌ను బహుభాషలలో (ఉదాహరణకు, స్పానిష్, ఫ్రెంచ్, మరియు జర్మన్) అనువదించడానికి ఈ కమాండ్‌ను ఉపయోగించండి:

```bash
translate -l "es fr de"
```

ఈ కమాండ్ ప్రాజెక్ట్‌ను స్పానిష్, ఫ్రెంచ్, మరియు జర్మన్‌లోకి అనువదిస్తుంది, ఇప్పటికే ఉన్న అనువాదాలను తొలగించకుండా కొత్త అనువాదాలను జోడిస్తుంది.

#### Phi-3 CookBook పై ఉదాహరణ

**Phi-3 CookBook** లో, తాజా మార్పులను ప్రతిబింబించడానికి తాజా కమిట్లను పుల్ చేసిన తర్వాత, కొత్తగా జోడించిన మార్క్‌డౌన్ ఫైళ్లు మరియు చిత్రాలను అనువదించడానికి నేను ఈ విధానాన్ని ఉపయోగించాను.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> సాధారణంగా ఒక భాషను ఒకేసారి అనువదించడం సిఫార్సు చేయబడుతుంది, కానీ ఈ విధంగా ప్రత్యేక మార్పులను జోడించాల్సిన పరిస్థితుల్లో, బహుభాషలలో ఒకేసారి అనువదించడం సమర్థవంతంగా ఉంటుంది.

### 3. అనువాదాలను నవీకరించడం (ఇప్పటికే ఉన్న అనువాదాలను తొలగిస్తుంది)

ఇప్పటికే ఉన్న అనువాదాలను నవీకరించడానికి (అంటే, ప్రస్తుత అనువాదాలను తొలగించి కొత్త వాటితో భర్తీ చేయడానికి), `-u` ఎంపికను ఉపయోగించండి. ఇది నిర్దేశించిన భాషల కోసం అన్ని ప్రస్తుత అనువాదాలను తొలగించి వాటిని మళ్లీ అనువదిస్తుంది.

```bash
translate -l "ko" -u
```

హెచ్చరిక: ఈ కమాండ్ కొనసాగించే ముందు ప్రస్తుత అనువాదాలను తొలగించడానికి మీకు నిర్ధారణ కోరుతుంది.

#### Phi-3 CookBook పై ఉదాహరణ

**Phi-3 CookBook** లో, స్పానిష్‌లోని అన్ని అనువదించిన ఫైళ్లను నవీకరించడానికి నేను ఈ విధానాన్ని ఉపయోగించాను. అనేక మార్క్‌డౌన్ డాక్యుమెంట్లలో అసలు కంటెంట్‌లో ముఖ్యమైన మార్పులు ఉన్నప్పుడు ఈ విధానాన్ని ఉపయోగించడం సిఫార్సు చేయబడుతుంది. కానీ, కొన్ని అనువదించిన మార్క్‌డౌన్ ఫైళ్లను మాత్రమే నవీకరించాల్సిన అవసరం ఉంటే, ఆ ప్రత్యేక ఫైళ్లను మానవీయంగా తొలగించి, `-a` విధానాన్ని ఉపయోగించి నవీకరించిన అనువాదాలను జోడించడం మరింత సమర్థవంతంగా ఉంటుంది.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. కేవలం చిత్రాలను అనువదించడం

మీ ప్రాజెక్ట్‌లో కేవలం చిత్ర ఫైళ్లను అనువదించడానికి, `-img` ఎంపికను ఉపయోగించండి:

```bash
translate -l "ko" -img
```

ఈ కమాండ్ కేవలం చిత్రాలను కొరియన్‌లోకి అనువదిస్తుంది, మార్క్‌డౌన్ ఫైళ్లను ప్రభావితం చేయకుండా.

### 6. కేవలం మార్క్‌డౌన్ ఫైళ్లను అనువదించడం

మీ ప్రాజెక్ట్‌లో కేవలం మార్క్‌డౌన్ ఫైళ్లను అనువదించడానికి, `-md` ఎంపికను ఉపయోగించండి:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook పై ఉదాహరణ

**Phi-3 CookBook** లో, కొరియన్ ఫైళ్లలో అనువాద పొరపాట్లను తనిఖీ చేయడానికి మరియు గుర్తించిన సమస్యల కోసం స్వయంచాలకంగా అనువాదాన్ని మళ్లీ ప్రయత్నించడానికి నేను ఈ విధానాన్ని ఉపయోగించాను.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

ఈ ఎంపిక అనువాద పొరపాట్లను తనిఖీ చేస్తుంది. ప్రస్తుతం, అసలు మరియు అనువదించిన ఫైళ్ల మధ్య లైన్ బ్రేక్‌లలో వ్యత్యాసం ఆరు కంటే ఎక్కువ ఉంటే, ఆ ఫైల్‌ను అనువాద పొరపాటు కలిగినదిగా గుర్తిస్తారు. భవిష్యత్తులో ఈ ప్రమాణాన్ని మరింత అనువుగా మార్చడానికి నేను ప్రణాళిక చేస్తున్నాను.

ఉదాహరణకు, ఈ విధానం కోల్పోయిన భాగాలు లేదా చెడిపోయిన అనువాదాలను గుర్తించడానికి ఉపయోగకరంగా ఉంటుంది, మరియు ఆ ఫైళ్ల కోసం స్వయంచాలకంగా అనువాదాన్ని మళ్లీ ప్రయత్నిస్తుంది.

అయితే, మీకు ఇప్పటికే ఏ ఫైళ్లు సమస్యాత్మకమైనవో తెలుసు అయితే, ఆ ఫైళ్లను మానవీయంగా తొలగించి, `-a` ఎంపికను ఉపయోగించి వాటిని మళ్లీ అనువదించడం మరింత సమర్థవంతంగా ఉంటుంది.

### 8. డీబగ్ మోడ్

ట్రబుల్‌షూటింగ్ కోసం వివరమైన లాగింగ్‌ను ప్రారంభించడానికి, `-d` ఎంపికను ఉపయోగించండి:

```bash
translate -l "ko" -d
```

ఈ కమాండ్ అనువాదాన్ని డీబగ్ మోడ్‌లో నడుపుతుంది, అనువాద ప్రక్రియలో సమస్యలను గుర్తించడంలో మీకు సహాయపడే అదనపు లాగింగ్ సమాచారాన్ని అందిస్తుంది.

#### Phi-3 CookBook పై ఉదాహరణ

**Phi-3 CookBook** లో, మార్క్‌డౌన్ ఫైళ్లలో అనేక లింక్‌లతో అనువాదాలు ఫార్మాటింగ్ పొరపాట్లు, చెడిపోయిన అనువాదాలు మరియు లైన్ బ్రేక్‌లను నిర్లక్ష్యం చేయడం వంటి సమస్యలను కలిగించాయి. ఈ సమస్యను నిర్ధారించడానికి, అనువాద ప్రక్రియ ఎలా పనిచేస్తుందో చూడటానికి నేను `-d` ఎంపికను ఉపయోగించాను.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. అన్ని భాషలలో అనువదించడం

ప్రాజెక్ట్‌ను అందుబాటులో ఉన్న అన్ని భాషలలోకి అనువదించాలనుకుంటే, all కీవర్డ్‌ను ఉపయోగించండి.

> [!WARNING]
> అన్ని భాషలలో ఒకేసారి అనువదించడం ప్రాజెక్ట్ పరిమాణంపై ఆధారపడి చాలా సమయం పడుతుంది. ఉదాహరణకు, **Phi-3 CookBook** ను స్పానిష్‌లోకి అనువదించడానికి సుమారు 2 గంటలు పట్టింది. ఈ స్థాయిలో, 20 భాషల కోసం ఒక వ్యక్తి నిర్వహించడం సాధ్యంకాదు. అనువాదాలను క్రమంగా నవీకరించడానికి, ప్రతి ఒక్కరు ఒకటి లేదా రెండు భాషలను నిర్వహిస్తూ, అనేక సహకారదారుల మధ్య పని విభజించడం సిఫార్సు చేయబడుతుంది.

```bash
translate -l "all"
```

ఈ కమాండ్ ప్రాజెక్ట్‌ను అందుబాటులో ఉన్న అన్ని భాషలలోకి అనువదిస్తుంది. మీరు కొనసాగితే, ప్రాజెక్ట్ పరిమాణంపై ఆధారపడి అనువాదానికి చాలా సమయం పట్టవచ్చు.

> [!TIP]
>
> ### అనువదించిన ఫైళ్లను మానవీయంగా తొలగించడం (ఐచ్ఛికం)
> అనువదించిన ఫైళ్లు ఇప్పుడు స్వయంచాలకంగా గుర్తించబడతాయి మరియు మూల ఫైల్ నవీకరించబడినప్పుడు శుభ్రం చేయబడతాయి.
>
> అయితే, మీరు ఒక అనువాదాన్ని మానవీయంగా నవీకరించాలనుకుంటే - ఉదాహరణకు, ఒక ప్రత్యేక ఫైల్‌ను మళ్లీ చేయడానికి లేదా సిస్టమ్ ప్రవర్తనను ఓవర్‌రైడ్ చేయడానికి - మీరు భాష ఫోల్డర్లలో ఫైల్ యొక్క అన్ని వెర్షన్లను తొలగించడానికి ఈ కమాండ్‌ను ఉపయోగించవచ్చు.
>
> ### Windows లో:
> 1. **కమాండ్ ప్రాంప్ట్ ఉపయోగించి**:
>    - కమాండ్ ప్రాంప్ట్ ఓపెన్ చేయండి.
>    - `cd` కమాండ్ ఉపయోగించి ఫైళ్లు ఉన్న ఫోల్డర్‌కు వెళ్లండి.
>    - ఫైళ్లను తొలగించడానికి ఈ కమాండ్‌ను ఉపయోగించండి:
>      ```
>      del /s *filename*
>      ```
>      `filename` ను మీరు వెతుకుతున్న ఫైల్ పేరు యొక్క ప్రత్యేక భాగంతో భర్తీ చేయండి. `/s` ఎంపిక ఉపడిరెక్టరీలను వెతుకుతుంది.
>
> 2. **PowerShell ఉపయోగించి**:
>    - PowerShell ఓపెన్ చేయండి.
>    - ఈ కమాండ్‌ను నడపండి:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` ను ఫోల్డర్ మార్గంతో మరియు `filename` ను ప్రత్యేక పేరుతో భర్తీ చేయండి.
>
> ### macOS/Linux లో:
> 1. **టెర్మినల్ ఉపయోగించి**:
>   - టెర్మినల్ ఓపెన్ చేయండి.
>   - `cd` ఉపయోగించి డైరెక్టరీకి వెళ్లండి.
>   - `find` కమాండ్ ఉపయోగించండి:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` ను ప్రత్యేక పేరుతో భర్తీ చేయండి.
>
> ఫైళ్లను తొలగించే ముందు తప్పనిసరిగా డబుల్-చెక్ చేయండి, అనుకోకుండా నష్టాన్ని నివారించడానికి. 
>
> మీరు భర్తీ చేయాల్సిన ఫైళ్లను తొలగించిన తర్వాత, మీ `translate -l` కమాండ్‌ను మళ్లీ నడపండి, తాజా ఫైల్ మార్పులను నవీకరించడానికి.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**అస్వీకరణ**:  
ఈ పత్రం AI అనువాద సేవ [Co-op Translator](https://github.com/Azure/co-op-translator) ఉపయోగించి అనువదించబడింది. మేము ఖచ్చితత్వానికి ప్రయత్నిస్తున్నప్పటికీ, ఆటోమేటెడ్ అనువాదాలు తప్పులు లేదా అసమగ్రతలను కలిగి ఉండవచ్చు. దాని స్వదేశ భాషలో ఉన్న అసలు పత్రాన్ని అధికారం కలిగిన మూలంగా పరిగణించాలి. కీలకమైన సమాచారం కోసం, ప్రొఫెషనల్ మానవ అనువాదాన్ని సిఫారసు చేస్తాము. ఈ అనువాదాన్ని ఉపయోగించడం వల్ల కలిగే ఏవైనా అపార్థాలు లేదా తప్పుదారులు కోసం మేము బాధ్యత వహించము.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->