<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T13:09:36+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "te"
}
-->
# కో-ఆప్ అనువాదకుడికి సహకరించడం

ఈ ప్రాజెక్ట్ సహకారాలు మరియు సూచనలను స్వాగతిస్తుంది. చాలా సహకారాలకు మీరు ఒక
కాంట్రిబ్యూటర్ లైసెన్స్ అగ్రిమెంట్ (CLA) కు అంగీకరించాలి, ఇది మీరు మీ సహకారాన్ని ఉపయోగించడానికి హక్కు కలిగి ఉన్నారని మరియు నిజంగా హక్కులు మాకు ఇస్తున్నారని ప్రకటిస్తుంది. వివరాలకు, https://cla.opensource.microsoft.com ను సందర్శించండి.

మీరు ఒక పుల్ రిక్వెస్ట్ సమర్పించినప్పుడు, CLA బాట్ ఆటోమేటిక్‌గా మీరు CLA అందించాల్సిన అవసరం ఉందో లేదో నిర్ణయించి PR ను తగిన విధంగా (ఉదా: స్థితి తనిఖీ, వ్యాఖ్య) అలంకరించును. బాట్ ఇచ్చిన సూచనలను అనుసరించండి. మా CLA ఉపయోగించే అన్ని రిపోస్‌లో మీరు ఈ ప్రక్రియను ఒక్కసారి మాత్రమే చేయాలి.

## అభివృద్ధి వాతావరణం సెటప్

ఈ ప్రాజెక్ట్ అభివృద్ధి వాతావరణాన్ని సెటప్ చేయడానికి, డిపెండెన్సీలను నిర్వహించడానికి Poetry ఉపయోగించమని మేము సిఫార్సు చేస్తాము. మేము ప్రాజెక్ట్ డిపెండెన్సీలను నిర్వహించడానికి `pyproject.toml` ఉపయోగిస్తాము, కాబట్టి డిపెండెన్సీలను ఇన్‌స్టాల్ చేయడానికి మీరు Poetry ఉపయోగించాలి.

### వర్చువల్ ఎన్విరాన్‌మెంట్ సృష్టించండి

#### pip ఉపయోగించి

```bash
python -m venv .venv
```

#### Poetry ఉపయోగించి

```bash
poetry init
```

### వర్చువల్ ఎన్విరాన్‌మెంట్ యాక్టివేట్ చేయండి

#### pip మరియు Poetry రెండింటికీ

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry ఉపయోగించి

```bash
poetry shell
```

### ప్యాకేజీ మరియు అవసరమైన ప్యాకేజీలను ఇన్‌స్టాల్ చేయడం

#### Poetry ఉపయోగించి (pyproject.toml నుండి)

```bash
poetry install
```

### మాన్యువల్ టెస్టింగ్

PR సమర్పించే ముందు, అనువాద ఫంక్షనాలిటీని నిజమైన డాక్యుమెంటేషన్‌తో పరీక్షించడం ముఖ్యం:

1. రూట్ డైరెక్టరీలో ఒక టెస్ట్ డైరెక్టరీ సృష్టించండి:
    ```bash
    mkdir test_docs
    ```

2. మీరు అనువదించదలచిన కొన్ని మార్క్‌డౌన్ డాక్యుమెంటేషన్ మరియు చిత్రాలను టెస్ట్ డైరెక్టరీలో కాపీ చేయండి. ఉదాహరణకు:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. ప్యాకేజీని లోకల్‌గా ఇన్‌స్టాల్ చేయండి:
    ```bash
    pip install -e .
    ```

4. మీ టెస్ట్ డాక్యుమెంట్లపై కో-ఆప్ అనువాదకుడిని నడపండి:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` మరియు `test_docs/translated_images` లో అనువదించిన ఫైళ్లను తనిఖీ చేయండి:
   - అనువాద నాణ్యత
   - మెటాడేటా వ్యాఖ్యలు సరైనవిగా ఉన్నాయా
   - అసలు మార్క్‌డౌన్ నిర్మాణం నిలుపబడిందా
   - లింకులు మరియు చిత్రాలు సరిగ్గా పనిచేస్తున్నాయా

ఈ మాన్యువల్ టెస్టింగ్ మీ మార్పులు నిజ జీవిత పరిస్థితుల్లో బాగా పనిచేస్తున్నాయో లేదో నిర్ధారించడంలో సహాయపడుతుంది.

### ఎన్విరాన్‌మెంట్ వేరియబుల్స్

1. రూట్ డైరెక్టరీలో `.env.template` ఫైల్‌ను కాపీ చేసి `.env` ఫైల్ సృష్టించండి.
1. సూచనల ప్రకారం ఎన్విరాన్‌మెంట్ వేరియబుల్స్‌ను పూరించండి.

> [!TIP]
>
> ### అదనపు అభివృద్ధి వాతావరణ ఎంపికలు
>
> ప్రాజెక్ట్‌ను లోకల్‌గా నడపడమే కాకుండా, మీరు GitHub Codespaces లేదా VS Code Dev Containers ఉపయోగించి ప్రత్యామ్నాయ అభివృద్ధి వాతావరణాన్ని కూడా ఏర్పాటు చేసుకోవచ్చు.
>
> #### GitHub Codespaces
>
> GitHub Codespaces ఉపయోగించి ఈ నమూనాలను వర్చువల్‌గా నడపవచ్చు, అదనపు సెట్టింగులు లేదా సెటప్ అవసరం లేదు.
>
> ఈ బటన్ మీ బ్రౌజర్‌లో వెబ్ ఆధారిత VS Code ఇన్స్టాన్స్‌ను తెరుస్తుంది:
>
> 1. టెంప్లేట్‌ను తెరవండి (కొన్ని నిమిషాలు పట్టవచ్చు):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers ఉపయోగించి లోకల్‌గా నడపడం
>
> ⚠️ ఈ ఎంపిక మీ Docker Desktop కనీసం 16 GB RAM కేటాయించబడినప్పుడు మాత్రమే పనిచేస్తుంది. 16 GB కన్నా తక్కువ RAM ఉంటే, మీరు [GitHub Codespaces ఎంపిక](../..) లేదా [లోకల్ సెటప్](../..) ప్రయత్నించవచ్చు.
>
> సంబంధిత ఎంపిక VS Code Dev Containers, ఇది [Dev Containers ఎక్స్‌టెన్షన్](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) ఉపయోగించి ప్రాజెక్ట్‌ను మీ లోకల్ VS Code లో తెరుస్తుంది:
>
> 1. Docker Desktop ప్రారంభించండి (ఇన్‌స్టాల్ చేయకపోతే ఇన్‌స్టాల్ చేయండి)
> 2. ప్రాజెక్ట్‌ను తెరవండి:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### కోడ్ శైలి

మేము ప్రాజెక్ట్‌లో సారూప్యమైన కోడ్ శైలిని నిర్వహించడానికి [Black](https://github.com/psf/black) ను మా Python కోడ్ ఫార్మాటర్‌గా ఉపయోగిస్తాము. Black అనేది ఒక కఠినమైన కోడ్ ఫార్మాటర్, ఇది Python కోడ్‌ను ఆటోమేటిక్‌గా Black కోడ్ శైలికి అనుగుణంగా మార్చుతుంది.

#### కాన్ఫిగరేషన్

Black కాన్ఫిగరేషన్ మా `pyproject.toml` లో పేర్కొనబడింది:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black ఇన్‌స్టాల్ చేయడం

మీరు Black ను Poetry (సిఫార్సు చేయబడింది) లేదా pip ద్వారా ఇన్‌స్టాల్ చేయవచ్చు:

##### Poetry ఉపయోగించి

అభివృద్ధి వాతావరణం సెటప్ చేసినప్పుడు Black ఆటోమేటిక్‌గా ఇన్‌స్టాల్ అవుతుంది:
```bash
poetry install
```

##### pip ఉపయోగించి

pip ఉపయోగిస్తుంటే, మీరు Black ను నేరుగా ఇన్‌స్టాల్ చేయవచ్చు:
```bash
pip install black
```

#### Black ఉపయోగించడం

##### Poetry తో

1. ప్రాజెక్ట్‌లోని అన్ని Python ఫైళ్లను ఫార్మాట్ చేయండి:
    ```bash
    poetry run black .
    ```

2. ఒక నిర్దిష్ట ఫైల్ లేదా డైరెక్టరీని ఫార్మాట్ చేయండి:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip తో

1. ప్రాజెక్ట్‌లోని అన్ని Python ఫైళ్లను ఫార్మాట్ చేయండి:
    ```bash
    black .
    ```

2. ఒక నిర్దిష్ట ఫైల్ లేదా డైరెక్టరీని ఫార్మాట్ చేయండి:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> మీ ఎడిటర్‌ను Black తో కోడ్‌ను సేవ్ చేసినప్పుడు ఆటోమేటిక్‌గా ఫార్మాట్ చేయడానికి సెట్ చేయాలని మేము సిఫార్సు చేస్తాము. ఆధునిక ఎడిటర్లు ఎక్కువగా ఈ ఫీచర్‌ను ఎక్స్‌టెన్షన్లు లేదా ప్లగిన్ల ద్వారా మద్దతు ఇస్తాయి.

## కో-ఆప్ అనువాదకుడిని నడపడం

మీ వాతావరణంలో Poetry ఉపయోగించి కో-ఆప్ అనువాదకుడిని నడపడానికి, ఈ దశలను అనుసరించండి:

1. మీరు అనువాద పరీక్షలు చేయదలచిన డైరెక్టరీకి వెళ్లండి లేదా పరీక్షల కోసం తాత్కాలిక ఫోల్డర్ సృష్టించండి.

2. క్రింది కమాండ్‌ను అమలు చేయండి. `-l ko` ను మీరు అనువదించదలచిన భాషా కోడ్‌తో మార్చండి. `-d` ఫ్లాగ్ డీబగ్ మోడ్ సూచిస్తుంది.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> కమాండ్ నడపడానికి ముందు మీ Poetry వాతావరణం యాక్టివేట్ అయి ఉండాలి (poetry shell).

## కొత్త భాషను సహకరించండి

మేము కొత్త భాషలకు మద్దతు జోడించే సహకారాలను స్వాగతిస్తాము. PR తెరవడానికి ముందు, సమీక్ష సులభంగా జరిగేందుకు క్రింది దశలను పూర్తి చేయండి.

1. భాషను ఫాంట్ మ్యాపింగ్‌లో జోడించండి
   - `src/co_op_translator/fonts/font_language_mappings.yml` ను ఎడిట్ చేయండి
   - క్రింది వివరాలతో ఒక ఎంట్రీ జోడించండి:
     - `code`: ISO-లాగా భాషా కోడ్ (ఉదా: `vi`)
     - `name`: మనుషులకి సులభంగా అర్థమయ్యే ప్రదర్శన పేరు
     - `font`: `src/co_op_translator/fonts/` లో పంపిణీ అయ్యే, ఆ స్క్రిప్ట్‌కు మద్దతు ఇచ్చే ఫాంట్
     - `rtl`: కుడి నుండి ఎడమకు ఉంటే `true`, లేకపోతే `false`

2. అవసరమైతే ఫాంట్ ఫైళ్లను చేర్చండి
   - కొత్త ఫాంట్ అవసరమైతే, ఓపెన్ సోర్స్ పంపిణీకి లైసెన్స్ అనుకూలతను ధృవీకరించండి
   - ఫాంట్ ఫైల్‌ను `src/co_op_translator/fonts/` లో జోడించండి

3. లోకల్ ధృవీకరణ
   - చిన్న నమూనా (మార్క్‌డౌన్, చిత్రాలు, నోట్‌బుక్స్ అవసరమైతే) కోసం అనువాదాలు నడపండి
   - అవుట్‌పుట్ సరిగా రేండర్ అవుతుందో, ఫాంట్లు మరియు ఏమైనా RTL లేఅవుట్ ఉంటే వాటిని తనిఖీ చేయండి

4. డాక్యుమెంటేషన్ నవీకరణ
   - భాష `getting_started/supported-languages.md` లో కనిపించాలి
   - `getting_started/README_languages_template.md` లో మార్పులు అవసరం లేదు; ఇది మద్దతు పొందిన జాబితా నుండి ఉత్పత్తి అవుతుంది

5. PR తెరవండి
   - జోడించిన భాష మరియు ఫాంట్/లైసెన్స్ విషయాలను వివరించండి
   - సాధ్యమైతే రేండర్ అయిన అవుట్‌పుట్ స్క్రీన్‌షాట్లను జత చేయండి

ఉదాహరణ YAML ఎంట్రీ:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### కొత్త భాషను పరీక్షించండి

క్రింది కమాండ్ నడిపి కొత్త భాషను పరీక్షించవచ్చు:

```bash
# ఒక వర్చువల్ ఎన్విరాన్‌మెంట్ సృష్టించి యాక్టివేట్ చేయండి
python -m venv .venv
# విండోస్
.venv\Scripts\activate
# మాక్‌ఓఎస్/లినక్స్
source .venv/bin/activate
# డెవలప్‌మెంట్ ప్యాకేజీని ఇన్‌స్టాల్ చేయండి
pip install -e .
# అనువాదాన్ని నడపండి
translate -l "new_lang"
```

## నిర్వహణదారులు

### కమిట్ సందేశం మరియు మర్జ్ వ్యూహం

మా ప్రాజెక్ట్ కమిట్ చరిత్రలో సారూప్యత మరియు స్పష్టత కోసం, మేము **Squash and Merge** వ్యూహం ఉపయోగించినప్పుడు **చివరి కమిట్ సందేశం** కోసం ఒక నిర్దిష్ట కమిట్ సందేశ ఫార్మాట్‌ను అనుసరిస్తాము.

ఒక పుల్ రిక్వెస్ట్ (PR) మర్జ్ అయినప్పుడు, వ్యక్తిగత కమిట్లు ఒకే కమిట్‌గా స్క్వాష్ చేయబడతాయి. చివరి కమిట్ సందేశం క్రింది ఫార్మాట్‌ను అనుసరించాలి, తద్వారా చరిత్ర శుభ్రంగా మరియు సారూప్యంగా ఉంటుంది.

#### కమిట్ సందేశ ఫార్మాట్ (స్క్వాష్ మరియు మర్జ్ కోసం)

మేము కమిట్ సందేశాలకు క్రింది ఫార్మాట్ ఉపయోగిస్తాము:

```bash
<type>: <description> (#<PR సంఖ్య>)
```

- **type**: కమిట్ వర్గాన్ని సూచిస్తుంది. మేము ఈ క్రింది రకాల్ని ఉపయోగిస్తాము:
  - `Docs`: డాక్యుమెంటేషన్ నవీకరణలకు.
  - `Build`: బిల్డ్ సిస్టమ్ లేదా డిపెండెన్సీలకు సంబంధించిన మార్పులకు, కాన్ఫిగరేషన్ ఫైళ్లు, CI వర్క్‌ఫ్లోలు, లేదా Dockerfile నవీకరణలు సహా.
  - `Core`: ప్రాజెక్ట్ యొక్క కోర్ ఫంక్షనాలిటీ లేదా ఫీచర్లలో మార్పులకు, ముఖ్యంగా `src/co_op_translator/core` డైరెక్టరీలోని ఫైళ్లకు.

- **description**: మార్పు యొక్క సంక్షిప్త సారాంశం.
- **PR number**: కమిట్‌కు సంబంధించిన పుల్ రిక్వెస్ట్ సంఖ్య.

**ఉదాహరణలు**:

- `Docs: స్పష్టత కోసం ఇన్‌స్టాలేషన్ సూచనలను నవీకరించండి (#50)`
- `Core: చిత్రం అనువాదం నిర్వహణ మెరుగుపరచండి (#60)`

> [!NOTE]
> ప్రస్తుతం, **`Docs`**, **`Core`**, మరియు **`Build`** ప్రిఫిక్సులు మార్చబడిన సోర్స్ కోడ్‌కు వర్తించే లేబుల్స్ ఆధారంగా PR శీర్షికలకు ఆటోమేటిక్‌గా జోడించబడతాయి. సరైన లేబుల్ వర్తిస్తే, మీరు సాధారణంగా PR శీర్షికను మాన్యువల్‌గా మార్చాల్సిన అవసరం లేదు. మీరు కేవలం అన్ని సరిగా ఉన్నాయో, ప్రిఫిక్స్ సరిగ్గా ఉత్పత్తి అయ్యిందో నిర్ధారించాలి.

#### మర్జ్ వ్యూహం

మేము పుల్ రిక్వెస్ట్‌లకు డిఫాల్ట్‌గా **Squash and Merge** వ్యూహాన్ని ఉపయోగిస్తాము. ఈ వ్యూహం కమిట్ సందేశాలు మా ఫార్మాట్‌ను అనుసరించడానికి సహాయపడుతుంది, వ్యక్తిగత కమిట్లు అనుసరించకపోయినా.

**కారణాలు**:

- శుభ్రమైన, లీనియర్ ప్రాజెక్ట్ చరిత్ర.
- కమిట్ సందేశాలలో సారూప్యత.
- చిన్న కమిట్ల నుండి వచ్చే శబ్దం తగ్గింపు (ఉదా: "టైపో సరిచేయండి").

మర్జ్ చేస్తున్నప్పుడు, చివరి కమిట్ సందేశం పై వివరించిన కమిట్ సందేశ ఫార్మాట్‌ను అనుసరించాలి.

**Squash and Merge ఉదాహరణ**
ఒక PR లో ఈ క్రింది కమిట్లు ఉంటే:

- `fix typo`
- `update README`
- `adjust formatting`

వీటిని స్క్వాష్ చేసి ఇలా చేయాలి:
`Docs: డాక్యుమెంటేషన్ స్పష్టత మరియు ఫార్మాటింగ్ మెరుగుపరచండి (#65)`

### విడుదల ప్రక్రియ

ఈ విభాగం కో-ఆప్ అనువాదకుడి కొత్త విడుదలను నిర్వహించేవారికి సులభమైన మార్గాన్ని వివరిస్తుంది.

#### 1. `pyproject.toml` లో వెర్షన్ పెంచండి

1. తదుపరి వెర్షన్ నంబర్ నిర్ణయించండి (మేము సేమాంటిక్ వెర్షనింగ్ అనుసరిస్తాము: `MAJOR.MINOR.PATCH`).
2. `pyproject.toml` ను ఎడిట్ చేసి `[tool.poetry]` కింద `version` ఫీల్డ్‌ను నవీకరించండి.
3. కేవలం వెర్షన్ (మరియు ఆటోమేటిక్‌గా నవీకరించబడిన లాక్/మెటాడేటా ఫైళ్లు ఉంటే) మార్చే ప్రత్యేక పుల్ రిక్వెస్ట్ తెరవండి.
4. సమీక్ష తర్వాత, **Squash and Merge** ఉపయోగించి, చివరి కమిట్ సందేశం పై వివరించిన ఫార్మాట్‌ను అనుసరించండి.

#### 2. GitHub విడుదల సృష్టించండి

1. GitHub రిపోజిటరీ పేజీకి వెళ్లి **Releases** → **Draft a new release** తెరవండి.
2. `main` బ్రాంచ్ నుండి కొత్త ట్యాగ్ (ఉదా: `v0.13.0`) సృష్టించండి.
3. విడుదల శీర్షికను అదే వెర్షన్‌గా సెట్ చేయండి (ఉదా: `v0.13.0`).
4. **Generate release notes** క్లిక్ చేసి చేంజ్‌లాగ్ ఆటోమేటిక్‌గా పూరించండి.
5. కావలసినట్లయితే టెక్స్ట్‌ను సవరించండి (ఉదా: కొత్త మద్దతు పొందిన భాషలు లేదా ముఖ్యమైన మార్పులను హైలైట్ చేయడానికి).
6. విడుదలను ప్రచురించండి.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**అస్పష్టత**:  
ఈ పత్రాన్ని AI అనువాద సేవ [Co-op Translator](https://github.com/Azure/co-op-translator) ఉపయోగించి అనువదించబడింది. మేము ఖచ్చితత్వానికి ప్రయత్నించినప్పటికీ, ఆటోమేటెడ్ అనువాదాల్లో పొరపాట్లు లేదా తప్పిదాలు ఉండవచ్చు. మూల పత్రం దాని స్వదేశీ భాషలో అధికారిక మూలంగా పరిగణించాలి. ముఖ్యమైన సమాచారానికి, ప్రొఫెషనల్ మానవ అనువాదం సిఫార్సు చేయబడుతుంది. ఈ అనువాదం వాడకంలో ఏర్పడిన ఏవైనా అపార్థాలు లేదా తప్పుదారితీసే అర్థాలు కోసం మేము బాధ్యత వహించము.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->