<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T05:00:33+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "ta"
}
-->
# உங்கள் திட்டத்தை Co-op Translator மூலம் மொழிபெயர்க்கவும்

**Co-op Translator** என்பது ஒரு கட்டளை வரி இடைமுக (CLI) கருவி ஆகும், இது உங்கள் திட்டத்தில் உள்ள markdown மற்றும் படக் கோப்புகளை பல மொழிகளில் மொழிபெயர்க்க உதவுகிறது. இந்த பகுதி இந்த கருவியை எப்படி பயன்படுத்துவது, பல்வேறு CLI விருப்பங்கள் மற்றும் வெவ்வேறு பயன்பாட்டு உதாரணங்களை விளக்குகிறது.

---

## உதாரண நிலைகள் மற்றும் கட்டளைகள்

**Co-op Translator**-ஐ பயன்படுத்தும் சில பொதுவான நிலைகள் மற்றும் அதற்கான சரியான கட்டளைகள் கீழே கொடுக்கப்பட்டுள்ளன.

### 1. அடிப்படை மொழிபெயர்ப்பு (ஒரு மொழி)

உங்கள் முழு திட்டத்தையும் (markdown கோப்புகள் மற்றும் படங்கள்) ஒரு மொழிக்கு, உதாரணத்திற்கு கொரிய மொழிக்கு மொழிபெயர்க்க, கீழ்காணும் கட்டளையை பயன்படுத்தவும்:

```bash
translate -l "ko"
```

இந்த கட்டளை அனைத்து markdown மற்றும் படக் கோப்புகளையும் கொரிய மொழிக்கு மொழிபெயர்க்கும், ஏற்கனவே உள்ள மொழிபெயர்ப்புகளை நீக்காமல் புதிய மொழிபெயர்ப்புகளைச் சேர்க்கும்.

#### Phi-3 CookBook-ல் உதாரணம்

**Phi-3 CookBook**-இல், ஏற்கனவே உள்ள markdown கோப்புகள் மற்றும் படங்களுக்கு கொரிய மொழிபெயர்ப்பு சேர்க்க நான் பின்வரும் முறையை பயன்படுத்தினேன்.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. பல மொழிகளில் மொழிபெயர்ப்பு

உங்கள் திட்டத்தை பல மொழிகளில் (உதா: ஸ்பானிஷ், பிரெஞ்சு, ஜெர்மன்) மொழிபெயர்க்க, இந்த கட்டளையை பயன்படுத்தவும்:

```bash
translate -l "es fr de"
```

இந்த கட்டளை திட்டத்தை ஸ்பானிஷ், பிரெஞ்சு மற்றும் ஜெர்மன் மொழிகளில் மொழிபெயர்க்கும், ஏற்கனவே உள்ள மொழிபெயர்ப்புகளை மேல் எழுதாமல் புதிய மொழிபெயர்ப்புகளைச் சேர்க்கும்.

#### Phi-3 CookBook-ல் உதாரணம்

**Phi-3 CookBook**-இல், சமீபத்திய மாற்றங்களை pull செய்து, புதிய markdown கோப்புகள் மற்றும் படங்களை மொழிபெயர்க்க நான் பின்வரும் முறையை பயன்படுத்தினேன்.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### 3. மொழிபெயர்ப்புகளை புதுப்பித்தல் (ஏற்கனவே உள்ள மொழிபெயர்ப்புகளை நீக்கும்)

ஏற்கனவே உள்ள மொழிபெயர்ப்புகளை புதுப்பிக்க (அதாவது, தற்போதைய மொழிபெயர்ப்புகளை நீக்கி புதியவற்றை மாற்ற), `-u` விருப்பத்தை பயன்படுத்தவும். இது குறிப்பிடப்பட்ட மொழிகளுக்கான அனைத்து மொழிபெயர்ப்புகளையும் நீக்கி, மீண்டும் மொழிபெயர்க்கும்.

```bash
translate -l "ko" -u
```

எச்சரிக்கை: இந்த கட்டளை, ஏற்கனவே உள்ள மொழிபெயர்ப்புகளை நீக்கும் முன் உங்களிடம் உறுதிப்படுத்த கேட்கும்.

#### Phi-3 CookBook-ல் உதாரணம்

**Phi-3 CookBook**-இல், ஸ்பானிஷ் மொழியில் மொழிபெயர்க்கப்பட்ட அனைத்து கோப்புகளையும் புதுப்பிக்க நான் பின்வரும் முறையை பயன்படுத்தினேன். ஒரே நேரத்தில் பல markdown கோப்புகளில் முக்கியமான மாற்றங்கள் உள்ளபோது இந்த முறையை பயன்படுத்த பரிந்துரைக்கிறேன். சில குறிப்பிட்ட markdown கோப்புகளை மட்டும் புதுப்பிக்க வேண்டுமெனில், அந்த குறிப்பிட்ட கோப்புகளை கைமுறையாக நீக்கி, `-a` முறையை பயன்படுத்தி புதுப்பிக்கப்பட்ட மொழிபெயர்ப்புகளைச் சேர்ப்பது அதிகம் பயனுள்ளதாக இருக்கும்.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. படங்களை மட்டும் மொழிபெயர்ப்பு

உங்கள் திட்டத்தில் உள்ள படக் கோப்புகளை மட்டும் மொழிபெயர்க்க, `-img` விருப்பத்தை பயன்படுத்தவும்:

```bash
translate -l "ko" -img
```

இந்த கட்டளை markdown கோப்புகளை பாதிக்காமல், படங்களை மட்டும் கொரிய மொழிக்கு மொழிபெயர்க்கும்.

### 6. Markdown கோப்புகளை மட்டும் மொழிபெயர்ப்பு

உங்கள் திட்டத்தில் உள்ள markdown கோப்புகளை மட்டும் மொழிபெயர்க்க, `-md` விருப்பத்தை பயன்படுத்தவும்:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook-ல் உதாரணம்

**Phi-3 CookBook**-இல், கொரிய மொழி கோப்புகளில் மொழிபெயர்ப்பு பிழைகள் உள்ளதா என சரிபார்க்கவும், பிழை உள்ள கோப்புகளுக்கு தானாகவே மீண்டும் மொழிபெயர்ப்பு செய்யவும் நான் பின்வரும் முறையை பயன்படுத்தினேன்.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

இந்த விருப்பம் மொழிபெயர்ப்பு பிழைகளை சரிபார்க்கும். தற்போது, மூல மற்றும் மொழிபெயர்க்கப்பட்ட கோப்புகளுக்கு இடையே வரி முறிவில் ஆறு வரிகளுக்கு மேல் வித்தியாசம் இருந்தால், அந்த கோப்பு மொழிபெயர்ப்பு பிழை என குறிக்கப்படும். எதிர்காலத்தில் இந்த அளவுகோலை மேலும் நெகிழ்வாக மாற்ற திட்டமிட்டுள்ளேன்.

உதாரணத்திற்கு, இந்த முறையை பயன்படுத்தி காணாமல் போன பகுதிகள் அல்லது சேதமடைந்த மொழிபெயர்ப்புகளை கண்டறிந்து, அந்த கோப்புகளுக்கு தானாகவே மீண்டும் மொழிபெயர்ப்பு செய்ய முடியும்.

ஆனால், ஏற்கனவே எந்த கோப்புகள் பிழைபட்டுள்ளன என்று தெரிந்திருந்தால், அந்த கோப்புகளை கைமுறையாக நீக்கி, `-a` விருப்பத்தை பயன்படுத்தி மீண்டும் மொழிபெயர்ப்பு செய்வது அதிகம் பயனுள்ளதாக இருக்கும்.

### 8. பிழைநீக்க (Debug) பயன்முறை

பிழைநீக்க மற்றும் விரிவான பதிவு தகவல்களை பெற, `-d` விருப்பத்தை பயன்படுத்தவும்:

```bash
translate -l "ko" -d
```

இந்த கட்டளை மொழிபெயர்ப்பை பிழைநீக்க பயன்முறையில் இயக்கும், இது மொழிபெயர்ப்பு செயல்முறையில் ஏற்படும் சிக்கல்களை கண்டறிய கூடுதல் பதிவு தகவல்களை வழங்கும்.

#### Phi-3 CookBook-ல் உதாரணம்

**Phi-3 CookBook**-இல், markdown கோப்புகளில் பல இணைப்புகள் உள்ள மொழிபெயர்ப்புகள் வடிவமைப்பு பிழைகள், உடைந்த மொழிபெயர்ப்புகள் மற்றும் தவறான வரி முறிவுகள் போன்ற பிரச்சனைகளை ஏற்படுத்தின. இந்த பிரச்சனையை கண்டறிய, மொழிபெயர்ப்பு செயல்முறை எப்படி நடைபெறுகிறது என்பதை பார்க்க `-d` விருப்பத்தை பயன்படுத்தினேன்.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. அனைத்து மொழிகளிலும் மொழிபெயர்ப்பு

திட்டத்தை அனைத்து ஆதரிக்கப்படும் மொழிகளிலும் மொழிபெயர்க்க, all என்ற சொற்றொடரை பயன்படுத்தவும்.

```bash
translate -l "all"
```

இந்த கட்டளை திட்டத்தை கிடைக்கும் அனைத்து மொழிகளிலும் மொழிபெயர்க்கும். தொடர்ந்தால், திட்டத்தின் அளவைப் பொறுத்து மொழிபெயர்ப்பு நிறைய நேரம் எடுக்கலாம்.

>
> ### மொழிபெயர்க்கப்பட்ட கோப்புகளை கைமுறையாக நீக்குதல் (விரும்பினால்)
> மூல கோப்பு புதுப்பிக்கப்படும் போது மொழிபெயர்க்கப்பட்ட கோப்புகள் தானாகவே கண்டறியப்பட்டு சுத்தம் செய்யப்படும்.
>
> ஆனால், ஒரு மொழிபெயர்ப்பை கைமுறையாக புதுப்பிக்க விரும்பினால் - உதாரணத்திற்கு, ஒரு குறிப்பிட்ட கோப்பை மீண்டும் மொழிபெயர்க்க அல்லது அமைப்பு நடத்தை மீற - கீழ்காணும் கட்டளையை பயன்படுத்தி அந்த கோப்பின் அனைத்து மொழி கோப்புகளையும் நீக்கலாம்.
>
> ### Windows-ல்:
> 1. **Command Prompt பயன்படுத்தி**:
>    - Command Prompt-ஐ திறக்கவும்.
>    - `cd` கட்டளையை பயன்படுத்தி கோப்புகள் உள்ள கோப்பகத்திற்கு செல்லவும்.
>    - கோப்புகளை நீக்க கீழ்காணும் கட்டளையை பயன்படுத்தவும்:
>      ```
>      del /s *filename*
>      ```
>      `filename` என்பதை நீங்கள் தேடும் கோப்பின் பெயருடன் மாற்றவும். `/s` விருப்பம் துணைக்கோப்பகங்களிலும் தேடும்.
>
> 2. **PowerShell பயன்படுத்தி**:
>    - PowerShell-ஐ திறக்கவும்.
>    - இந்த கட்டளையை இயக்கவும்:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` என்பதை கோப்பக பாதையுடன் மற்றும் `filename` என்பதை குறிப்பிட்ட பெயருடன் மாற்றவும்.
>
> ### macOS/Linux-ல்:
> 1. **Terminal பயன்படுத்தி**:
>   - Terminal-ஐ திறக்கவும்.
>   - `cd` மூலம் கோப்பகத்திற்கு செல்லவும்.
>   - `find` கட்டளையை பயன்படுத்தவும்:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` என்பதை குறிப்பிட்ட பெயருடன் மாற்றவும்.
>
> கோப்புகளை நீக்கும் முன் எப்போதும் இருமுறை சரிபார்க்கவும், தவறுதலாக கோப்புகளை இழக்காமல் இருக்க.
>
> நீக்க வேண்டிய கோப்புகளை நீக்கிய பிறகு, உங்கள் `translate -l` கட்டளையை மீண்டும் இயக்கி சமீபத்திய கோப்பு மாற்றங்களை புதுப்பிக்கவும்.

---

**பொறுப்புத் தவிர்ப்பு**:
இந்த ஆவணம் AI மொழிபெயர்ப்பு சேவையான [Co-op Translator](https://github.com/Azure/co-op-translator) மூலம் மொழிபெயர்க்கப்பட்டுள்ளது. நாம் துல்லியத்திற்காக முயற்சி செய்தாலும், தானாக மொழிபெயர்க்கப்படும் மொழிபெயர்ப்புகளில் பிழைகள் அல்லது தவறுகள் இருக்கலாம் என்பதை தயவுசெய்து கவனிக்கவும். மூல ஆவணம் அதன் சொந்த மொழியில் அதிகாரப்பூர்வ ஆதாரமாகக் கருதப்பட வேண்டும். முக்கியமான தகவல்களுக்கு, தொழில்முறை மனித மொழிபெயர்ப்பு பரிந்துரைக்கப்படுகிறது. இந்த மொழிபெயர்ப்பைப் பயன்படுத்துவதால் ஏற்படும் எந்தவொரு தவறான புரிதல் அல்லது தவறான விளக்கத்திற்கு நாங்கள் பொறுப்பல்ல.