<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T12:55:52+00:00",
  "source_file": "README.md",
  "language_code": "ta"
}
-->
# கூட்டுறவு மொழிபெயர்ப்பாளர்

_உங்கள் கல்வி GitHub உள்ளடக்கத்தை பல மொழிகளில் எளிதாக தானாக மொழிபெயர்க்கவும், உலகளாவிய பார்வையாளர்களை அடையவும்._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 பல மொழி ஆதரவு

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) மூலம் ஆதரிக்கப்படுகிறது

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[அரபு](../ar/README.md) | [பெங்காலி](../bn/README.md) | [பல்கேரியன்](../bg/README.md) | [பர்மீஸ் (மியான்மர்)](../my/README.md) | [சீன (எளிமைப்படுத்தப்பட்ட)](../zh/README.md) | [சீன (பாரம்பரிய, ஹாங்காங்)](../hk/README.md) | [சீன (பாரம்பரிய, மாகாவ்)](../mo/README.md) | [சீன (பாரம்பரிய, தைவான்)](../tw/README.md) | [குரோஷியன்](../hr/README.md) | [செக்](../cs/README.md) | [டேனிஷ்](../da/README.md) | [டச்சு](../nl/README.md) | [எஸ்டோனியன்](../et/README.md) | [பின்னிஷ்](../fi/README.md) | [பிரெஞ்சு](../fr/README.md) | [ஜெர்மன்](../de/README.md) | [கிரேக்கம்](../el/README.md) | [ஹீப்ரூ](../he/README.md) | [இந்தி](../hi/README.md) | [ஹங்கேரியன்](../hu/README.md) | [இந்தோனேஷியன்](../id/README.md) | [இத்தாலியன்](../it/README.md) | [ஜப்பானீஸ்](../ja/README.md) | [கன்னடம்](../kn/README.md) | [கொரியன்](../ko/README.md) | [லிதுவேனியன்](../lt/README.md) | [மலாய்](../ms/README.md) | [மலையாளம்](../ml/README.md) | [மராத்தி](../mr/README.md) | [நேபாளி](../ne/README.md) | [நைஜீரியன் பிஜின்](../pcm/README.md) | [நார்வேஜியன்](../no/README.md) | [பெர்ஷியன் (பார்சி)](../fa/README.md) | [போலிஷ்](../pl/README.md) | [போர்ச்சுகீஸ் (பிரேசில்)](../br/README.md) | [போர்ச்சுகீஸ் (போர்ச்சுகல்)](../pt/README.md) | [பஞ்சாபி (குருமுகி)](../pa/README.md) | [ரோமானியன்](../ro/README.md) | [ரஷ்யன்](../ru/README.md) | [செர்பியன் (சிரிலிக்)](../sr/README.md) | [ஸ்லோவாக்](../sk/README.md) | [ஸ்லோவேனியன்](../sl/README.md) | [ஸ்பானிஷ்](../es/README.md) | [ஸ்வாஹிலி](../sw/README.md) | [ஸ்வீடிஷ்](../sv/README.md) | [டகாலோக் (பிலிப்பைனோ)](../tl/README.md) | [தமிழ்](./README.md) | [தெலுங்கு](../te/README.md) | [தை](../th/README.md) | [துருக்கி](../tr/README.md) | [உக்ரைனியன்](../uk/README.md) | [உருது](../ur/README.md) | [வியட்நாமீஸ்](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## கண்ணோட்டம்

**கூட்டுறவு மொழிபெயர்ப்பாளர்** உங்கள் கல்வி GitHub உள்ளடக்கத்தை பல மொழிகளில் எளிதாக உள்ளூர் மொழியாக்கம் செய்ய உதவுகிறது.  
நீங்கள் உங்கள் மார்க்டவுன் கோப்புகள், படங்கள் அல்லது நோட்புக்குகளை புதுப்பிக்கும் போது, மொழிபெயர்ப்புகள் தானாக ஒத்திசைக்கப்படுகின்றன, இதனால் உங்கள் உள்ளடக்கம் உலகம் முழுவதும் கற்றுக்கொள்ளும் பயனர்களுக்கு துல்லியமாகவும் புதுப்பிக்கப்பட்டதாகவும் இருக்கும்.

மொழிபெயர்க்கப்பட்ட உள்ளடக்கம் எவ்வாறு ஒழுங்குபடுத்தப்படுகிறது என்பதற்கான உதாரணம்:

![உதாரணம்](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.ta.png)

## விரைவான தொடக்கம்

```bash
# ஒரு மெய்நிகர் சூழலை உருவாக்கி செயல்படுத்தவும் (பரிந்துரைக்கப்படுகிறது)
python -m venv .venv
# விண்டோஸ்
.venv\Scripts\activate
# மேக்OS/லினக்ஸ்
source .venv/bin/activate
# தொகுப்பை நிறுவவும்
pip install co-op-translator
# மொழிபெயர்க்கவும்
translate -l "ko ja fr" -md
```

டாக்கர்:

```bash
# GHCR இலிருந்து பொதுப் படம் இழுக்கவும்
docker pull ghcr.io/azure/co-op-translator:latest
# தற்போதைய கோப்புறை மவுண்ட் செய்யப்பட்டு .env வழங்கப்பட்டு இயக்கவும் (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## குறைந்தபட்ச அமைப்பு

1. `.env` கோப்பை உருவாக்கவும்: [.env.template](../../.env.template)  
2. ஒரு LLM வழங்குநரை அமைக்கவும் (Azure OpenAI அல்லது OpenAI)  
3. (விருப்பம்) பட மொழிபெயர்ப்புக்கு (`-img`), Azure AI Vision ஐ அமைக்கவும்  
4. (பரிந்துரைக்கப்படுகிறது) முந்தைய மொழிபெயர்ப்புகளை சுத்தம் செய்யவும் (எ.கா., `translations/`)  
5. (பரிந்துரைக்கப்படுகிறது) உங்கள் README இல் மொழிபெயர்ப்பு பகுதியை சேர்க்கவும் [README languages template](./getting_started/README_languages_template.md)  
6. பார்க்கவும்: [Azure AI அமைக்க](./getting_started/set-up-azure-ai.md)  

## பயன்பாடு

அனைத்து ஆதரவு வகைகளையும் மொழிபெயர்க்கவும்:

```bash
translate -l "ko ja"
```

மார்க்டவுன் மட்டும்:

```bash
translate -l "de" -md
```

மார்க்டவுன் + படங்கள்:

```bash
translate -l "pt" -md -img
```

நோட்புக்குகள் மட்டும்:

```bash
translate -l "zh" -nb
```

மேலும் கொடிகள்: [கட்டளை குறிப்பு](./getting_started/command-reference.md)

## அம்சங்கள்

- மார்க்டவுன், நோட்புக்குகள் மற்றும் படங்களுக்கான தானாக மொழிபெயர்ப்பு  
- மூல மாற்றங்களுடன் மொழிபெயர்ப்புகளை ஒத்திசைக்கிறது  
- உள்ளகமாக (CLI) அல்லது தொடர்ச்சியான ஒருங்கிணைப்பில் (GitHub Actions) இயங்கும்  
- Azure OpenAI அல்லது OpenAI பயன்படுத்துகிறது; படங்களுக்கு விருப்பமாக Azure AI Vision  
- மார்க்டவுன் வடிவமைப்பையும் அமைப்பையும் பாதுகாக்கிறது  

## ஆவணங்கள்

- [கட்டளை வரி வழிகாட்டி](./getting_started/command-line-guide/command-line-guide.md)  
- [GitHub Actions வழிகாட்டி (பொது சேமிப்பகங்கள் & சாதாரண ரகசியங்கள்)](./getting_started/github-actions-guide/github-actions-guide-public.md)  
- [GitHub Actions வழிகாட்டி (Microsoft அமைப்புக் களஞ்சியங்கள் & அமைப்புக் கட்டமைப்புகள்)](./getting_started/github-actions-guide/github-actions-guide-org.md)  
- [README மொழி வார்ப்புரு](./getting_started/README_languages_template.md)  
- [ஆதரவு மொழிகள்](./getting_started/supported-languages.md)  
- [பங்களிப்பு](./CONTRIBUTING.md)  
- [பிரச்சனை தீர்க்கும் வழிகாட்டி](./getting_started/troubleshooting.md)  

### Microsoft-க்கு தனிப்பட்ட வழிகாட்டி
> [!NOTE]
> Microsoft “For Beginners” களஞ்சியங்களுக்கான பராமரிப்பாளர்களுக்கே.

- [“மற்ற பாடங்கள்” பட்டியலை புதுப்பித்தல் (MS Beginners களஞ்சியங்களுக்கு மட்டும்)](./getting_started/update-other-courses.md)

## எங்களை ஆதரித்து உலகளாவிய கற்றலை ஊக்குவிக்கவும்

கல்வி உள்ளடக்கம் உலகளாவிய அளவில் பகிரப்படும் முறையை மாற்றுவதில் எங்களுடன் சேருங்கள்! [Co-op Translator](https://github.com/azure/co-op-translator) க்கு GitHub இல் ⭐ கொடுத்து, கற்றலும் தொழில்நுட்பத்திலும் மொழி தடைகளை உடைக்கும் எங்கள் பணியை ஆதரிக்கவும். உங்கள் ஆர்வமும் பங்களிப்புகளும் பெரிய தாக்கத்தை ஏற்படுத்துகின்றன! குறியீடு பங்களிப்புகள் மற்றும் அம்ச பரிந்துரைகள் எப்போதும் வரவேற்கப்படுகின்றன.

### உங்கள் மொழியில் Microsoft கல்வி உள்ளடக்கத்தை ஆராயவும்

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)  
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)  
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)  
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)  
- [.NET பயன்படுத்தி Generative AI for Beginners](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)  
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)  
- [Java பயன்படுத்தி Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners-java)  
- [ML for Beginners](https://aka.ms/ml-beginners)  
- [Data Science for Beginners](https://aka.ms/datascience-beginners)  
- [AI for Beginners](https://aka.ms/ai-beginners)  
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)  
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)  
- [IoT for Beginners](https://aka.ms/iot-beginners)  
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)  

## வீடியோ அறிமுகங்கள்

👉 கீழே உள்ள படத்தை கிளிக் செய்து YouTube இல் பாருங்கள்.

- **Microsoft இல் திறக்கவும்**: Co-op Translator ஐ எவ்வாறு பயன்படுத்துவது என்பதற்கான சுருக்கமான 18 நிமிட அறிமுகம் மற்றும் விரைவு வழிகாட்டி.

  [![Microsoft இல் திறக்கவும்](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.ta.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## பங்களிப்பு

இந்த திட்டம் பங்களிப்புகளையும் பரிந்துரைகளையும் வரவேற்கிறது. Azure Co-op Translator இல் பங்களிக்க ஆர்வமுள்ளவரா? எங்கள் [CONTRIBUTING.md](./CONTRIBUTING.md) ஐப் பார்த்து, Co-op Translator ஐ மேலும் அணுகக்கூடியதாக மாற்ற நீங்கள் எவ்வாறு உதவலாம் என்பதை அறியவும்.

## பங்களிப்பாளர்கள்

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## நடத்தை விதிகள்

இந்த திட்டம் [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) ஐ ஏற்றுக்கொண்டுள்ளது.  
மேலும் தகவலுக்கு [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) ஐப் பார்க்கவும் அல்லது  
[opencode@microsoft.com](mailto:opencode@microsoft.com) என்ற முகவரிக்கு மேலதிக கேள்விகள் அல்லது கருத்துக்களுக்காக தொடர்பு கொள்ளவும்.

## பொறுப்பான AI

Microsoft, எங்கள் AI தயாரிப்புகளை பொறுப்புடன் பயன்படுத்துவதற்கு எங்கள் வாடிக்கையாளர்களுக்கு உதவ உறுதிபடுகிறது, எங்கள் கற்றல்களை பகிர்ந்து, Transparency Notes மற்றும் Impact Assessments போன்ற கருவிகளின் மூலம் நம்பிக்கையுள்ள கூட்டாண்மைகளை உருவாக்குகிறது. இந்த வளங்கள் பலவற்றை [https://aka.ms/RAI](https://aka.ms/RAI) இல் காணலாம்.  
Microsoft இன் பொறுப்பான AI அணுகுமுறை நியாயம், நம்பகத்தன்மை மற்றும் பாதுகாப்பு, தனியுரிமை மற்றும் பாதுகாப்பு, உட்புகுத்தல், வெளிப்படைத்தன்மை மற்றும் பொறுப்புத்தன்மை ஆகிய AI கொள்கைகளில் அடிப்படையாக உள்ளது.

பெரிய அளவிலான இயற்கை மொழி, படம் மற்றும் பேச்சு மாதிரிகள் - இந்த மாதிரியில் பயன்படுத்தப்படும் மாதிரிகள் போன்றவை - சில நேரங்களில் நியாயமற்ற, நம்பகமற்ற அல்லது அவமரியாதையான நடத்தை காட்டக்கூடும், இதனால் பாதிப்புகள் ஏற்படலாம். அபாயங்கள் மற்றும் வரம்புகளைப் பற்றி அறிய [Azure OpenAI சேவை Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) ஐ அணுகவும்.
இந்த ஆபத்துக்களை குறைக்க பரிந்துரைக்கப்படும் முறையானது உங்கள் கட்டமைப்பில் ஒரு பாதுகாப்பு அமைப்பை சேர்ப்பது, இது தீங்கு விளைவிக்கும் நடத்தை கண்டறிந்து தடுக்கும் வகையில் இருக்க வேண்டும். [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) ஒரு சுயாதீன பாதுகாப்பு அடுக்கு வழங்குகிறது, இது பயன்பாடுகள் மற்றும் சேவைகளில் பயனர் உருவாக்கிய மற்றும் AI உருவாக்கிய தீங்கு விளைவிக்கும் உள்ளடக்கத்தை கண்டறிய முடியும். Azure AI Content Safety உரை மற்றும் பட API-களை கொண்டுள்ளது, இது தீங்கு விளைவிக்கும் பொருளை கண்டறிய உதவுகிறது. மேலும், பல்வேறு வகைகளில் தீங்கு விளைவிக்கும் உள்ளடக்கத்தை கண்டறிய உதவும் மாதிரி குறியீடுகளை பார்க்க, ஆராய மற்றும் முயற்சிக்க உதவும் ஒரு இடைமுக Content Safety Studio-வும் உள்ளது. சேவைக்கு கோரிக்கைகள் செய்ய கீழ்க்கண்ட [துரித தொடக்க ஆவணம்](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) உங்களுக்கு வழிகாட்டும்.

மற்றொரு முக்கிய அம்சம் முழுமையான பயன்பாட்டு செயல்திறன் ஆகும். பல்வேறு வகை மற்றும் பல்வேறு மாதிரிகள் கொண்ட பயன்பாடுகளில், செயல்திறன் என்பது நீங்கள் மற்றும் உங்கள் பயனர்கள் எதிர்பார்க்கும் விதத்தில் அமைப்பு செயல்படுவதாக பொருள், அதாவது தீங்கு விளைவிக்கும் வெளியீடுகளை உருவாக்காமல் இருக்க வேண்டும். உங்கள் முழு பயன்பாட்டின் செயல்திறனை [உருவாக்கும் தரம் மற்றும் ஆபத்து மற்றும் பாதுகாப்பு அளவுகோல்கள்](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) மூலம் மதிப்பீடு செய்வது முக்கியம்.

[prompt flow SDK](https://microsoft.github.io/promptflow/index.html) பயன்படுத்தி உங்கள் AI பயன்பாட்டை உங்கள் மேம்பாட்டு சூழலில் மதிப்பீடு செய்யலாம். ஒரு சோதனை தரவுத்தொகுப்பு அல்லது இலக்கை கொடுத்தால், உங்கள் உருவாக்கும் AI பயன்பாட்டின் உருவாக்கங்கள் உள்ளமைக்கப்பட்ட மதிப்பீட்டாளர்கள் அல்லது உங்கள் விருப்பமான தனிப்பயன் மதிப்பீட்டாளர்களால் அளவிடப்படும். உங்கள் அமைப்பை மதிப்பீடு செய்ய prompt flow sdk-யுடன் தொடங்க, [துரித தொடக்க வழிகாட்டி](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) பின்பற்றலாம். ஒரு மதிப்பீடு ஓட்டத்தை இயக்கிய பிறகு, [Azure AI Studio-வில் முடிவுகளை காட்சிப்படுத்தலாம்](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## வர்த்தக அடையாளங்கள்

இந்த திட்டத்தில் திட்டங்கள், தயாரிப்புகள் அல்லது சேவைகளுக்கான வர்த்தக அடையாளங்கள் அல்லது லோகோக்கள் இருக்கலாம். Microsoft வர்த்தக அடையாளங்கள் அல்லது லோகோக்களின் அங்கீகாரம் பெற்ற பயன்பாடு [Microsoft வர்த்தக அடையாளம் மற்றும் பிராண்ட் வழிகாட்டுதல்கள்](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) உடன் இணங்க வேண்டும். இந்த திட்டத்தின் மாற்றப்பட்ட பதிப்புகளில் Microsoft வர்த்தக அடையாளங்கள் அல்லது லோகோக்களை பயன்படுத்துவது குழப்பத்தை ஏற்படுத்தக்கூடாது அல்லது Microsoft ஆதரவைக் குறிக்கக்கூடாது. மூன்றாம் தரப்பு வர்த்தக அடையாளங்கள் அல்லது லோகோக்களின் எந்தவொரு பயன்பாடும் அந்த மூன்றாம் தரப்பு கொள்கைகளுக்கு உட்பட்டது.

## உதவி பெறுதல்

AI பயன்பாடுகளை உருவாக்கும் போது சிக்கல் ஏற்பட்டால் அல்லது கேள்விகள் இருந்தால், கீழ்க்கண்ட இடத்தில் சேரவும்:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

உற்பத்தி கருத்துக்களோ அல்லது பிழைகளோ இருந்தால், கீழ்க்கண்ட இடத்தைப் பார்வையிடவும்:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**குறிப்பு**:  
இந்த ஆவணம் AI மொழிபெயர்ப்பு சேவை [Co-op Translator](https://github.com/Azure/co-op-translator) மூலம் மொழிபெயர்க்கப்பட்டுள்ளது. நாங்கள் துல்லியத்திற்காக முயற்சித்தாலும், தானியங்கி மொழிபெயர்ப்புகளில் பிழைகள் அல்லது தவறுகள் இருக்கக்கூடும் என்பதை தயவுசெய்து கவனிக்கவும். அசல் ஆவணம் அதன் சொந்த மொழியில் அதிகாரப்பூர்வ மூலமாக கருதப்பட வேண்டும். முக்கியமான தகவல்களுக்கு, தொழில்முறை மனித மொழிபெயர்ப்பு பரிந்துரைக்கப்படுகிறது. இந்த மொழிபெயர்ப்பின் பயன்பாட்டால் ஏற்படும் எந்த தவறான புரிதல்கள் அல்லது தவறான விளக்கங்களுக்கும் நாங்கள் பொறுப்பேற்கமாட்டோம்.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->