<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T12:54:59+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "ta"
}
-->
# Co-op Translator-க்கு பங்களிப்பு செய்வது

இந்த திட்டம் பங்களிப்புகளையும் பரிந்துரைகளையும் வரவேற்கிறது. பெரும்பாலான பங்களிப்புகளுக்கு நீங்கள் பங்களிப்பு உரிமம் உங்களிடம் உள்ளது மற்றும் நீங்கள் உண்மையில் அதை வழங்குகிறீர்கள் என்று அறிவிக்கும் பங்களிப்பு உரிமம் ஒப்பந்தம் (CLA) ஒன்றை ஏற்க வேண்டும். விவரங்களுக்கு, https://cla.opensource.microsoft.com ஐ பார்வையிடவும்.

நீங்கள் ஒரு pull request சமர்ப்பிக்கும் போது, CLA பாட்டி தானாகவே நீங்கள் CLA வழங்க வேண்டுமா என்பதை தீர்மானித்து PR-ஐ சரியான முறையில் அலங்கரிக்கும் (உதாரணமாக, நிலை சரிபார்ப்பு, கருத்து). பாட்டி வழங்கும் வழிமுறைகளை பின்பற்றுங்கள். இந்த செயல்முறை அனைத்து ரெப்போக்களிலும் ஒருமுறை மட்டுமே செய்ய வேண்டும்.

## மேம்பாட்டு சூழல் அமைப்பு

இந்த திட்டத்தின் மேம்பாட்டு சூழலை அமைக்க, சார்புகளை நிர்வகிக்க Poetry பயன்படுத்த பரிந்துரைக்கப்படுகிறது. நாங்கள் `pyproject.toml` மூலம் திட்ட சார்புகளை நிர்வகிக்கிறோம், ஆகவே சார்புகளை நிறுவ Poetry பயன்படுத்த வேண்டும்.

### ஒரு மெய்நிகர் சூழலை உருவாக்குதல்

#### pip பயன்படுத்தி

```bash
python -m venv .venv
```

#### Poetry பயன்படுத்தி

```bash
poetry init
```

### மெய்நிகர் சூழலை செயல்படுத்துதல்

#### pip மற்றும் Poetry இரண்டிற்கும்

- விண்டோஸ்:

    ```bash
    .venv\Scripts\activate.bat
    ```

- மேக்/லினக்ஸ்:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry பயன்படுத்தி

```bash
poetry shell
```

### தொகுப்பையும் தேவையான தொகுப்புகளையும் நிறுவுதல்

#### Poetry (pyproject.toml மூலம்) பயன்படுத்தி

```bash
poetry install
```

### கைமுறை சோதனை

PR சமர்ப்பிப்பதற்கு முன், உண்மையான ஆவணங்களுடன் மொழிபெயர்ப்பு செயல்பாட்டை சோதிப்பது முக்கியம்:

1. ரூட் அடைவில் ஒரு சோதனை அடைவை உருவாக்கவும்:
    ```bash
    mkdir test_docs
    ```

2. நீங்கள் மொழிபெயர்க்க விரும்பும் சில மார்க்டவுன் ஆவணங்களையும் படங்களையும் சோதனை அடைவுக்கு நகலெடுக்கவும். உதாரணமாக:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. தொகுப்பை உள்ளூர் முறையில் நிறுவவும்:
    ```bash
    pip install -e .
    ```

4. உங்கள் சோதனை ஆவணங்களில் Co-op Translator-ஐ இயக்கவும்:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` மற்றும் `test_docs/translated_images` இல் மொழிபெயர்க்கப்பட்ட கோப்புகளை சரிபார்க்கவும்:
   - மொழிபெயர்ப்பு தரம்
   - மெட்டாடேட்டா கருத்துக்கள் சரியானவை
   - அசல் மார்க்டவுன் அமைப்பு பாதுகாக்கப்பட்டுள்ளது
   - இணைப்புகள் மற்றும் படங்கள் சரியாக வேலை செய்கின்றன

இந்த கைமுறை சோதனை உங்கள் மாற்றங்கள் உண்மையான சூழலில் நன்றாக செயல்படுவதை உறுதி செய்ய உதவுகிறது.

### சூழல் மாறிலிகள்

1. ரூட் அடைவில் `.env.template` கோப்பை நகலெடுத்து `.env` கோப்பை உருவாக்கவும்.
2. வழிகாட்டப்பட்டபடி சூழல் மாறிலிகளை நிரப்பவும்.

> [!TIP]
>
> ### கூடுதல் மேம்பாட்டு சூழல் விருப்பங்கள்
>
> திட்டத்தை உள்ளூரில் இயக்குவதற்குப் பதிலாக, GitHub Codespaces அல்லது VS Code Dev Containers பயன்படுத்தி மாற்று மேம்பாட்டு சூழலை அமைக்கலாம்.
>
> #### GitHub Codespaces
>
> GitHub Codespaces பயன்படுத்தி இந்த மாதிரிகளை மெய்நிகர்வாக இயக்கலாம், கூடுதல் அமைப்புகள் தேவையில்லை.
>
> கீழ்காணும் பொத்தானை உங்கள் உலாவியில் VS Code இணையதள பதிப்பை திறக்கும்:
>
> 1. மாதிரியை திறக்கவும் (சில நிமிடங்கள் ஆகலாம்):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers மூலம் உள்ளூரில் இயக்குதல்
>
> ⚠️ இந்த விருப்பம் உங்கள் Docker Desktop-க்கு குறைந்தது 16 GB RAM ஒதுக்கப்பட்டிருந்தால் மட்டுமே வேலை செய்யும். 16 GB-க்கு குறைவான RAM இருந்தால், [GitHub Codespaces விருப்பத்தை](../..) முயற்சிக்கவும் அல்லது [உள்ளூரில் அமைக்கவும்](../..).
>
> தொடர்புடைய விருப்பமாக VS Code Dev Containers உள்ளது, இது [Dev Containers விரிவாக்கம்](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) பயன்படுத்தி உங்கள் உள்ளூர் VS Code-ல் திட்டத்தை திறக்கும்:
>
> 1. Docker Desktop-ஐ துவக்கவும் (இன்ஸ்டால் செய்யப்படவில்லை என்றால் இன்ஸ்டால் செய்யவும்)
> 2. திட்டத்தை திறக்கவும்:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### குறியீட்டு பாணி

நாங்கள் திட்டத்தில் ஒரே மாதிரியான குறியீட்டு பாணியை பராமரிக்க Python குறியீட்டு வடிவமைப்பாளராக [Black](https://github.com/psf/black) ஐ பயன்படுத்துகிறோம். Black என்பது Python குறியீட்டை தானாகவே Black பாணிக்கு ஏற்ப மறுவடிவமைக்கும் கடுமையான வடிவமைப்பாளர்.

#### கட்டமைப்பு

Black கட்டமைப்பு `pyproject.toml` இல் குறிப்பிடப்பட்டுள்ளது:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black ஐ நிறுவுதல்

Black ஐ Poetry (பரிந்துரைக்கப்படுகிறது) அல்லது pip மூலம் நிறுவலாம்:

##### Poetry பயன்படுத்தி

மேம்பாட்டு சூழலை அமைக்கும் போது Black தானாக நிறுவப்படும்:
```bash
poetry install
```

##### pip பயன்படுத்தி

pip பயன்படுத்தினால், நேரடியாக Black ஐ நிறுவலாம்:
```bash
pip install black
```

#### Black பயன்படுத்துதல்

##### Poetry உடன்

1. திட்டத்தில் உள்ள அனைத்து Python கோப்புகளையும் வடிவமைக்க:
    ```bash
    poetry run black .
    ```

2. குறிப்பிட்ட கோப்பு அல்லது அடைவைக் வடிவமைக்க:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip உடன்

1. திட்டத்தில் உள்ள அனைத்து Python கோப்புகளையும் வடிவமைக்க:
    ```bash
    black .
    ```

2. குறிப்பிட்ட கோப்பு அல்லது அடைவைக் வடிவமைக்க:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> உங்கள் எடிட்டரை Black-ஐ சேமிப்பின் போது தானாக குறியீட்டை வடிவமைக்க அமைக்க பரிந்துரைக்கிறோம். பெரும்பாலான நவீன எடிட்டர்கள் இதை விரிவாக்கங்கள் அல்லது பிளக்கின்கள் மூலம் ஆதரிக்கின்றன.

## Co-op Translator இயக்குதல்

உங்கள் சூழலில் Poetry பயன்படுத்தி Co-op Translator-ஐ இயக்க, கீழ்காணும் படிகளை பின்பற்றவும்:

1. மொழிபெயர்ப்பு சோதனைகள் செய்ய விரும்பும் அடைவிற்கு செல்லவும் அல்லது சோதனைக்காக தற்காலிக அடைவை உருவாக்கவும்.

2. கீழ்காணும் கட்டளையை இயக்கவும். `-l ko` என்பதை நீங்கள் மொழிபெயர்க்க விரும்பும் மொழி குறியீட்டுடன் மாற்றவும். `-d` கொடி டீபக் முறையை குறிக்கிறது.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> கட்டளையை இயக்குவதற்கு முன் உங்கள் Poetry சூழல் செயல்படுத்தப்பட்டிருக்க வேண்டும் (poetry shell).

## புதிய மொழி ஒன்றை பங்களிக்கவும்

புதிய மொழிகளுக்கு ஆதரவு சேர்க்கும் பங்களிப்புகளை வரவேற்கிறோம். PR திறப்பதற்கு முன், சரியான மதிப்பாய்வுக்காக கீழ்காணும் படிகளை முடிக்கவும்.

1. எழுத்துரு வரைபடத்தில் மொழியை சேர்க்கவும்
   - `src/co_op_translator/fonts/font_language_mappings.yml` கோப்பை திருத்தவும்
   - கீழ்காணும் விவரங்களுடன் ஒரு நுழைவைச் சேர்க்கவும்:
     - `code`: ISO போன்ற மொழி குறியீடு (உதா., `vi`)
     - `name`: மனிதர்களுக்கு புரிந்துகொள்ளக்கூடிய பெயர்
     - `font`: `src/co_op_translator/fonts/` இல் உள்ள, அந்த எழுத்துருவை ஆதரிக்கும் எழுத்துரு
     - `rtl`: வலமிருந்து இடத்திற்கு எழுத்து என்றால் `true`, இல்லையெனில் `false`

2. தேவையான எழுத்துரு கோப்புகளை சேர்க்கவும் (தேவைப்பட்டால்)
   - புதிய எழுத்துரு தேவையானால், திறந்த மூல விநியோகத்திற்கு உரிமம் பொருந்துகிறதா என சரிபார்க்கவும்
   - எழுத்துரு கோப்பை `src/co_op_translator/fonts/` இல் சேர்க்கவும்

3. உள்ளூர் சரிபார்ப்பு
   - சிறிய மாதிரிகளுக்கு (Markdown, படங்கள், நோட்புக்குகள்) மொழிபெயர்ப்புகளை இயக்கவும்
   - வெளியீடு சரியாக காணப்படுகிறதா, எழுத்துருக்கள் மற்றும் RTL அமைப்பும் சரியா என உறுதி செய்யவும்

4. ஆவணங்களை புதுப்பிக்கவும்
   - மொழி `getting_started/supported-languages.md` இல் தோன்றுகிறதா என உறுதி செய்யவும்
   - `getting_started/README_languages_template.md` இல் மாற்றங்கள் தேவையில்லை; அது ஆதரவு பட்டியலிலிருந்து உருவாக்கப்படுகிறது

5. PR திறக்கவும்
   - சேர்க்கப்பட்ட மொழி மற்றும் எழுத்துரு/உரிமம் தொடர்பான விவரங்களை விளக்கவும்
   - சாத்தியமானால் வெளியீட்டின் ஸ்கிரீன்ஷாட்களை இணைக்கவும்

உதாரண YAML நுழைவு:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### புதிய மொழியை சோதிக்கவும்

புதிய மொழியை கீழ்காணும் கட்டளையை இயக்கி சோதிக்கலாம்:

```bash
# ஒரு மெய்நிகர் சூழலை உருவாக்கி செயல்படுத்தவும்
python -m venv .venv
# விண்டோஸ்
.venv\Scripts\activate
# மேக்OS/லினக்ஸ்
source .venv/bin/activate
# மேம்பாட்டு தொகுப்பை நிறுவவும்
pip install -e .
# மொழிபெயர்ப்பை இயக்கவும்
translate -l "new_lang"
```

## பராமரிப்பாளர்கள்

### கமிட் செய்தி மற்றும் இணைக்கும் (Merge) தந்திரம்

எங்கள் திட்டத்தின் கமிட் வரலாற்றில் ஒருமைப்பாடு மற்றும் தெளிவை உறுதி செய்ய, **Squash and Merge** தந்திரத்தைப் பயன்படுத்தும் போது **இறுதி கமிட் செய்திக்கான** குறிப்பிட்ட வடிவத்தை பின்பற்றுகிறோம்.

ஒரு pull request (PR) இணைக்கப்படும் போது, தனித்தனியான கமிட்கள் ஒரே கமிட் ஆக சுருக்கப்படும். இறுதி கமிட் செய்தி கீழ்காணும் வடிவத்தை பின்பற்ற வேண்டும்.

#### கமிட் செய்தி வடிவம் (squash and merge க்கானது)

கமிட் செய்திகளுக்கு கீழ்காணும் வடிவத்தை பயன்படுத்துகிறோம்:

```bash
<type>: <description> (#<PR எண்>)
```

- **type**: கமிட் வகையை குறிப்பிடும். கீழ்காணும் வகைகள் உள்ளன:
  - `Docs`: ஆவண புதுப்பிப்புகளுக்கு.
  - `Build`: கட்டமைப்பு அமைப்புகள், சார்பு மாற்றங்கள், CI வேலைப்பாடுகள், Dockerfile மாற்றங்கள் போன்றவற்றுக்கு.
  - `Core`: திட்டத்தின் முக்கிய செயல்பாடுகள் அல்லது அம்சங்கள், குறிப்பாக `src/co_op_translator/core` அடைவின் கோப்புகளுக்கு.

- **description**: மாற்றத்தின் சுருக்கமான விளக்கம்.
- **PR number**: தொடர்புடைய pull request எண்.

**உதாரணங்கள்**:

- `Docs: நிறுவல் வழிமுறைகளை தெளிவுபடுத்துதல் (#50)`
- `Core: பட மொழிபெயர்ப்பை மேம்படுத்துதல் (#60)`

> [!NOTE]
> தற்போது, **`Docs`**, **`Core`**, மற்றும் **`Build`** முன்னொட்டுக்கள் மாற்றப்பட்ட மூலக் குறியீட்டின் லேபிள்களின் அடிப்படையில் PR தலைப்பில் தானாக சேர்க்கப்படுகின்றன. சரியான லேபிள் இருந்தால், PR தலைப்பை கைமுறையாக மாற்ற தேவையில்லை. அனைத்தும் சரியானதா என சரிபார்க்கவும்.

#### இணைக்கும் (Merge) தந்திரம்

நாங்கள் pull request க்கான இயல்புநிலை தந்திரமாக **Squash and Merge** ஐ பயன்படுத்துகிறோம். இது தனித்தனியான கமிட்கள் இல்லாவிட்டாலும் கமிட் செய்தி வடிவத்தை பின்பற்ற உறுதி செய்கிறது.

**காரணங்கள்**:

- சுத்தமான, நேர்காணல் திட்ட வரலாறு.
- கமிட் செய்திகளில் ஒருமைப்பாடு.
- சிறிய கமிட் களின் சத்தம் குறைவு (உதா., "விருத்தி பிழை").

இணைக்கும் போது, இறுதி கமிட் செய்தி மேலே விவரிக்கப்பட்ட வடிவத்தை பின்பற்ற வேண்டும்.

**Squash and Merge உதாரணம்**  
ஒரு PR இல் கீழ்காணும் கமிட்கள் இருந்தால்:

- `fix typo`
- `update README`
- `adjust formatting`

அவை இவ்வாறு சுருக்கப்பட வேண்டும்:  
`Docs: Improve documentation clarity and formatting (#65)`

### வெளியீட்டு செயல்முறை

இந்த பகுதி பராமரிப்பாளர்களுக்கு Co-op Translator-ன் புதிய வெளியீட்டை வெளியிட எளிய முறையை விளக்குகிறது.

#### 1. `pyproject.toml` இல் பதிப்பை உயர்த்துதல்

1. அடுத்த பதிப்பு எண்ணை தீர்மானிக்கவும் (நாங்கள் semantic versioning பின்பற்றுகிறோம்: `MAJOR.MINOR.PATCH`).
2. `pyproject.toml`-இல் `[tool.poetry]` கீழ் உள்ள `version` புலத்தை புதுப்பிக்கவும்.
3. பதிப்பு மட்டும் மாற்றப்பட்ட தனித்த pull request ஒன்றை திறக்கவும் (தானாக புதுப்பிக்கப்படும் lock/metadata கோப்புகள் இருந்தால் அவையும் சேர்க்கவும்).
4. மதிப்பாய்வுக்குப் பிறகு, **Squash and Merge** பயன்படுத்தி இறுதி கமிட் செய்தி வடிவத்தை பின்பற்றவும்.

#### 2. GitHub வெளியீட்டை உருவாக்குதல்

1. GitHub ரெப்போ பக்கத்திற்கு சென்று **Releases** → **Draft a new release** திறக்கவும்.
2. `main` கிளையிலிருந்து புதிய டேக் (உதா., `v0.13.0`) உருவாக்கவும்.
3. வெளியீட்டு தலைப்பை அதே பதிப்பாக அமைக்கவும் (உதா., `v0.13.0`).
4. **Generate release notes** கிளிக் செய்து மாற்றக்குறிப்புகளை தானாக நிரப்பவும்.
5. விருப்பப்படி உரையை திருத்தவும் (புதிய ஆதரவு மொழிகள் அல்லது முக்கிய மாற்றங்களை குறிப்பிட).
6. வெளியீட்டை வெளியிடவும்.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**குறிப்பு**:  
இந்த ஆவணம் AI மொழிபெயர்ப்பு சேவை [Co-op Translator](https://github.com/Azure/co-op-translator) மூலம் மொழிபெயர்க்கப்பட்டுள்ளது. நாங்கள் துல்லியத்திற்காக முயற்சித்தாலும், தானியங்கி மொழிபெயர்ப்புகளில் பிழைகள் அல்லது தவறுகள் இருக்கக்கூடும் என்பதை தயவுசெய்து கவனிக்கவும். அசல் ஆவணம் அதன் சொந்த மொழியில் அதிகாரப்பூர்வ மூலமாக கருதப்பட வேண்டும். முக்கியமான தகவல்களுக்கு, தொழில்முறை மனித மொழிபெயர்ப்பு பரிந்துரைக்கப்படுகிறது. இந்த மொழிபெயர்ப்பின் பயன்பாட்டால் ஏற்படும் எந்த தவறான புரிதல்கள் அல்லது தவறான விளக்கங்களுக்கும் நாங்கள் பொறுப்பேற்கமாட்டோம்.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->