<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T12:00:21+00:00",
  "source_file": "README.md",
  "language_code": "sw"
}
-->
# Mtafsiri wa Co-op

_Rahisi kuendesha mchakato wa kutafsiri maudhui yako ya elimu ya GitHub katika lugha nyingi ili kufikia hadhira ya kimataifa._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 Msaada wa Lugha Nyingi

#### Inasaidiwa na [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[Kiarabu](../ar/README.md) | [Kibengali](../bn/README.md) | [Kibulgaria](../bg/README.md) | [Kiburma (Myanmar)](../my/README.md) | [Kichina (Rahisi)](../zh/README.md) | [Kichina (Kiasili, Hong Kong)](../hk/README.md) | [Kichina (Kiasili, Macau)](../mo/README.md) | [Kichina (Kiasili, Taiwan)](../tw/README.md) | [Kikroeshia](../hr/README.md) | [Kicheki](../cs/README.md) | [Kidenmaki](../da/README.md) | [Kiholanzi](../nl/README.md) | [Kiestonia](../et/README.md) | [Kifini](../fi/README.md) | [Kifaransa](../fr/README.md) | [Kijerumani](../de/README.md) | [Kigiriki](../el/README.md) | [Kiebrania](../he/README.md) | [Kihindi](../hi/README.md) | [Kihungari](../hu/README.md) | [Kiindonesia](../id/README.md) | [Kiitaliano](../it/README.md) | [Kijapani](../ja/README.md) | [Kikannada](../kn/README.md) | [Kikorea](../ko/README.md) | [Kilithuania](../lt/README.md) | [Kimalay](../ms/README.md) | [Kimalayalam](../ml/README.md) | [Kimarathi](../mr/README.md) | [Kinepali](../ne/README.md) | [Kipidgin cha Nigeria](../pcm/README.md) | [Kinorwe](../no/README.md) | [Kiajemi (Farsi)](../fa/README.md) | [Kipolandi](../pl/README.md) | [Kireno (Brazil)](../br/README.md) | [Kireno (Portugal)](../pt/README.md) | [Kipunabi (Gurmukhi)](../pa/README.md) | [Kiromania](../ro/README.md) | [Kirusi](../ru/README.md) | [Kiserbia (Cyrillic)](../sr/README.md) | [Kislovakia](../sk/README.md) | [Kislovenia](../sl/README.md) | [Kihispania](../es/README.md) | [Kiswahili](./README.md) | [Kiswidi](../sv/README.md) | [Kitagalog (Kifilipino)](../tl/README.md) | [Kitamili](../ta/README.md) | [Kitelugu](../te/README.md) | [Kithai](../th/README.md) | [Kituruki](../tr/README.md) | [Kiukraini](../uk/README.md) | [Kiurdu](../ur/README.md) | [Kivietinamu](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## Muhtasari

**Co-op Translator** inakusaidia kuweka maudhui yako ya elimu ya GitHub katika lugha nyingi kwa urahisi.
Unapobadilisha faili zako za Markdown, picha, au daftari za maelezo, tafsiri zinaendeshwa moja kwa moja, kuhakikisha maudhui yako yanabaki sahihi na ya kisasa kwa wanafunzi duniani kote.

Mfano wa jinsi maudhui yaliyotafsiriwa yanavyopangwa:

![Mfano](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.sw.png)

## Anza Haraka

```bash
# Unda na wezesha mazingira pepe (inapendekezwa)
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Sakinisha kifurushi
pip install co-op-translator
# Tafsiri
translate -l "ko ja fr" -md
```

Docker:

```bash
# Vuta picha ya umma kutoka GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# Endesha na folda ya sasa imeunganishwa na .env imewekwa (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## Usanidi wa Msingi

1. Tengeneza faili `.env` ukitumia kiolezo: [.env.template](../../.env.template)
2. Sanidi mtoa huduma mmoja wa LLM (Azure OpenAI au OpenAI)
3. (Hiari) Kwa tafsiri ya picha (`-img`), sanidi Azure AI Vision
4. (Inapendekezwa) Safisha tafsiri za awali ili kuepuka migongano (mfano, `translations/`)
5. (Inapendekezwa) Ongeza sehemu ya tafsiri kwenye README yako ukitumia [kiolezo cha lugha za README](./getting_started/README_languages_template.md)
6. Angalia: [Sanidi Azure AI](./getting_started/set-up-azure-ai.md)

## Matumizi

Tafsiri aina zote zinazotegemewa:

```bash
translate -l "ko ja"
```

Markdown pekee:

```bash
translate -l "de" -md
```

Markdown + picha:

```bash
translate -l "pt" -md -img
```

Daftari pekee:

```bash
translate -l "zh" -nb
```

Bendera zaidi: [Marejeleo ya amri](./getting_started/command-reference.md)

## Sifa

- Tafsiri ya moja kwa moja kwa Markdown, daftari, na picha
- Hufanya tafsiri ziendane na mabadiliko ya chanzo
- Inafanya kazi kwa ndani (CLI) au katika CI (GitHub Actions)
- Inatumia Azure OpenAI au OpenAI; hiari Azure AI Vision kwa picha
- Huhifadhi muundo na mpangilio wa Markdown

## Nyaraka

- [Mwongozo wa amri za mstari wa amri](./getting_started/command-line-guide/command-line-guide.md)
- [Mwongozo wa GitHub Actions (Hifadhidata za umma & siri za kawaida)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [Mwongozo wa GitHub Actions (Hifadhidata za shirika la Microsoft & usanidi wa ngazi ya shirika)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [Kiolezo cha lugha za README](./getting_started/README_languages_template.md)
- [Lugha zinazotegemewa](./getting_started/supported-languages.md)
- [Kushiriki](./CONTRIBUTING.md)
- [Kutatua matatizo](./getting_started/troubleshooting.md)

### Mwongozo maalum wa Microsoft
> [!NOTE]
> Kwa watunzaji wa hifadhidata za Microsoft “Kwa Waanzilishi” pekee.

- [Kusasisha orodha ya “kozi nyingine” (kwa hifadhidata za MS Beginners pekee)](./getting_started/update-other-courses.md)

## Tusaidie na kuendeleza elimu ya kimataifa

Jiunge nasi katika mapinduzi ya jinsi maudhui ya elimu yanavyoshirikiwa duniani kote! Toa [Co-op Translator](https://github.com/azure/co-op-translator) nyota ⭐ kwenye GitHub na saidia dhamira yetu ya kuvunja vizuizi vya lugha katika kujifunza na teknolojia. Shauku na michango yako ina athari kubwa! Michango ya msimbo na mapendekezo ya vipengele daima yanakaribishwa.

### Chunguza maudhui ya elimu ya Microsoft kwa lugha yako

- [AZD kwa Waanzilishi](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI kwa Waanzilishi](https://github.com/microsoft/edgeai-for-beginners)
- [Itifaki ya Muktadha wa Mfano (MCP) Kwa Waanzilishi](https://github.com/microsoft/mcp-for-beginners)
- [Wakala wa AI kwa Waanzilishi](https://github.com/microsoft/ai-agents-for-beginners)
- [AI ya Kizazi kwa Waanzilishi kwa kutumia .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [AI ya Kizazi kwa Waanzilishi](https://github.com/microsoft/generative-ai-for-beginners)
- [AI ya Kizazi kwa Waanzilishi kwa kutumia Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML kwa Waanzilishi](https://aka.ms/ml-beginners)
- [Sayansi ya Data kwa Waanzilishi](https://aka.ms/datascience-beginners)
- [AI kwa Waanzilishi](https://aka.ms/ai-beginners)
- [Usalama wa Mtandao kwa Waanzilishi](https://github.com/microsoft/Security-101)
- [Uendelezaji wa Wavuti kwa Waanzilishi](https://aka.ms/webdev-beginners)
- [IoT kwa Waanzilishi](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## Maonyesho ya Video

👉 Bonyeza picha hapa chini kutazama kwenye YouTube.

- **Open at Microsoft**: Utangulizi mfupi wa dakika 18 na mwongozo wa haraka jinsi ya kutumia Co-op Translator.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.sw.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## Kushiriki

Mradi huu unakaribisha michango na mapendekezo. Unavutiwa kushiriki katika Azure Co-op Translator? Tafadhali angalia [CONTRIBUTING.md](./CONTRIBUTING.md) kwa miongozo ya jinsi unavyoweza kusaidia kufanya Co-op Translator ipatikane kwa urahisi zaidi.

## Washiriki

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## Kanuni ya Maadili

Mradi huu umechukua [Kanuni ya Maadili ya Chanzo Huria ya Microsoft](https://opensource.microsoft.com/codeofconduct/).
Kwa maelezo zaidi angalia [Maswali Yanayoulizwa Mara kwa Mara kuhusu Kanuni ya Maadili](https://opensource.microsoft.com/codeofconduct/faq/) au
wasiliana na [opencode@microsoft.com](mailto:opencode@microsoft.com) kwa maswali au maoni zaidi.

## AI Inayohusika

Microsoft imejizatiti kusaidia wateja wetu kutumia bidhaa zetu za AI kwa uwajibikaji, kushiriki mafunzo yetu, na kujenga ushirikiano unaotegemea uaminifu kupitia zana kama Vidokezo vya Uwajibikaji na Tathmini za Athari. Rasilimali nyingi za aina hii zinaweza kupatikana kwenye [https://aka.ms/RAI](https://aka.ms/RAI).
Mbinu ya Microsoft kwa AI inayohusika inatokana na kanuni zetu za AI za haki, kuaminika na usalama, faragha na usalama, ujumuishaji, uwazi, na uwajibikaji.

Mifano mikubwa ya lugha asilia, picha, na sauti - kama ile inayotumika katika sampuli hii - inaweza kuonyesha tabia zisizo za haki, zisizo za kuaminika, au za kuudhi, na kusababisha madhara. Tafadhali rejelea [Kumbukumbu ya Uwajibikaji ya Huduma ya Azure OpenAI](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) ili ujue kuhusu hatari na vikwazo.
Njia inayopendekezwa kupunguza hatari hizi ni kujumuisha mfumo wa usalama katika usanifu wako ambao unaweza kugundua na kuzuia tabia hatarishi. <a href="https://learn.microsoft.com/azure/ai-services/content-safety/overview">Azure AI Content Safety</a> hutoa tabaka huru la ulinzi, linaloweza kugundua maudhui hatarishi yanayotengenezwa na watumiaji na AI katika programu na huduma. Azure AI Content Safety inajumuisha API za maandishi na picha zinazokuwezesha kugundua nyenzo hatarishi. Pia tuna <i>Content Safety Studio</i> ya mwingiliano inayokuwezesha kuona, kuchunguza na kujaribu mifano ya msimbo wa kugundua maudhui hatarishi katika aina mbalimbali. Hati ifuatayo ya <a href="https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest">mwongozo wa kuanza haraka</a> itakuongoza jinsi ya kutuma maombi kwa huduma hiyo.

Jambo lingine la kuzingatia ni utendaji wa jumla wa programu. Kwa programu zenye modaliti nyingi na mifano mingi, tunachukulia utendaji kuwa mfumo unafanya kazi kama unavyotarajia wewe na watumiaji wako, ikiwa ni pamoja na kutotengeneza matokeo hatarishi. Ni muhimu kutathmini utendaji wa programu yako kwa kutumia <a href="https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in">viwango vya ubora wa uzalishaji na hatari na usalama</a>.

Unaweza kutathmini programu yako ya AI katika mazingira yako ya maendeleo kwa kutumia <a href="https://microsoft.github.io/promptflow/index.html">prompt flow SDK</a>. Ukiwa na seti ya data ya majaribio au lengo, uzalishaji wa programu yako ya AI ya kizazi hupimwa kwa kiasi kwa kutumia wachambuzi waliopo au wachambuzi maalum wa chaguo lako. Ili kuanza kutumia prompt flow SDK kutathmini mfumo wako, unaweza kufuata <a href="https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk">mwongozo wa kuanza haraka</a>. Mara tu unapokamilisha mtihani wa tathmini, unaweza <a href="https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results">kuonyesha matokeo katika Azure AI Studio</a>.

## Alama za Biashara

Mradi huu unaweza kuwa na alama za biashara au nembo za miradi, bidhaa, au huduma. Matumizi yaliyoruhusiwa ya alama za biashara au nembo za Microsoft yanategemea na lazima yafuatilie <a href="https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general">Miongozo ya Alama za Biashara na Brand za Microsoft</a>. Matumizi ya alama za biashara au nembo za Microsoft katika matoleo yaliyobadilishwa ya mradi huu hayapaswi kusababisha mkanganyiko au kuashiria udhamini wa Microsoft. Matumizi yoyote ya alama za biashara au nembo za wahusika wengine yanategemea sera za wahusika hao.

## Kupata Msaada

Kama utakumbwa na changamoto au una maswali kuhusu ujenzi wa programu za AI, jiunge na:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

Kama una maoni kuhusu bidhaa au makosa wakati wa ujenzi, tembelea:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Kiarifa cha Kukataa**:
Hati hii imetafsiriwa kwa kutumia huduma ya tafsiri ya AI [Co-op Translator](https://github.com/Azure/co-op-translator). Ingawa tunajitahidi kwa usahihi, tafadhali fahamu kuwa tafsiri za kiotomatiki zinaweza kuwa na makosa au upungufu wa usahihi. Hati ya asili katika lugha yake ya asili inapaswa kuzingatiwa kama chanzo cha mamlaka. Kwa taarifa muhimu, tafsiri ya kitaalamu ya binadamu inapendekezwa. Hatubebei dhamana kwa kutoelewana au tafsiri potofu zinazotokana na matumizi ya tafsiri hii.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->