<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "822238e4451d04bb152cebb1be6f13c2",
  "translation_date": "2025-11-30T12:28:42+00:00",
  "source_file": "getting_started/command-reference.md",
  "language_code": "sr"
}
-->
# Командни референс

CLI алат **Co-op Translator** нуди неколико опција за прилагођавање процеса превођења:

Команда                                      | Опис
----------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
translate -l "language_codes"                 | Преводи ваш пројекат на наведене језике. Пример: translate -l "es fr de" преводи на шпански, француски и немачки. Користите translate -l "all" за превођење на све подржане језике.
translate -l "language_codes" -u              | Ажурира преводе брисањем постојећих и поновним креирањем. Упозорење: Ово ће избрисати све тренутне преводе за наведене језике.
translate -l "language_codes" -img            | Преводи само сликовне фајлове.
translate -l "language_codes" -md             | Преводи само Markdown фајлове.
translate -l "language_codes" -nb             | Преводи само Jupyter notebook фајлове (.ipynb).
translate -l "language_codes" --fix           | Поново преводи фајлове са ниским нивоом поверења на основу претходних резултата процене.
translate -l "language_codes" -d              | Омогућава debug режим за детаљно логовање.
translate -l "language_codes" --save-logs, -s | Снима DEBUG нивое логова у фајлове у <root_dir>/logs/ (конзола остаје под контролом -d)
translate -l "language_codes" -r "root_dir"   | Одређује коренски директоријум пројекта
translate -l "language_codes" -f              | Користи брзи режим за превођење слика (до 3 пута брже цртање уз мањи губитак квалитета и поравнања).
translate -l "language_codes" -y              | Аутоматски потврђује све упите (корисно за CI/CD процесе)
translate -l "language_codes" --add-disclaimer/--no-disclaimer | Омогућава или онемогућава додавање одељка са одрицањем од одговорности за машински превод у преведеним markdown и notebook фајловима (подразумевано: омогућено).
translate -l "language_codes" --help          | Приказ помоћи у CLI-ју са доступним командама
evaluate -l "language_code"                  | Процењује квалитет превода за одређени језик и даје оцене поверења
evaluate -l "language_code" -c 0.8           | Процењује преводе са прилагођеним прагом поверења
evaluate -l "language_code" -f               | Брзи режим процене (само на основу правила, без LLM)
evaluate -l "language_code" -D               | Дубински режим процене (само LLM, темељнији али спорији)
evaluate -l "language_code" --save-logs, -s  | Снима DEBUG нивое логова у фајлове у <root_dir>/logs/
migrate-links -l "language_codes"             | Поново обрађује преведене Markdown фајлове да ажурира линкове ка notebook-овима (.ipynb). Преферира преведене notebook-ове када су доступни; у супротном може користити оригиналне.
migrate-links -l "language_codes" -r          | Одређује коренски директоријум пројекта (подразумевано: тренутни директоријум).
migrate-links -l "language_codes" --dry-run   | Приказује који би фајлови били измењени без уписивања промена.
migrate-links -l "language_codes" --no-fallback-to-original | Не преписује линкове ка оригиналним notebook-овима када преведени недостају (ажурира само ако преведени постоји).
migrate-links -l "language_codes" -d          | Омогућава debug режим за детаљно логовање.
migrate-links -l "language_codes" --save-logs, -s | Снима DEBUG нивое логова у фајлове у <root_dir>/logs/
migrate-links -l "all" -y                      | Обрађује све језике и аутоматски потврђује упозорење.

## Примери коришћења

  1. Подразумевано понашање (додаје нове преводе без брисања постојећих):   translate -l "ko"    translate -l "es fr de" -r "./my_project"

  2. Додаје само нове корејске преводе слика (постојећи преводи се не бришу):    translate -l "ko" -img

  3. Ажурира све корејске преводе (Упозорење: Ово брише све постојеће корејске преводе пре поновног превођења):    translate -l "ko" -u

  4. Ажурира само корејске слике (Упозорење: Ово брише све постојеће корејске слике пре поновног превођења):    translate -l "ko" -img -u

  5. Додаје нове markdown преводе за корејски без утицаја на друге преводе:    translate -l "ko" -md

  6. Поправља преводе са ниским поверењем на основу претходних резултата процене: translate -l "ko" --fix

  7. Поправља преводе са ниским поверењем само за одређене фајлове (markdown): translate -l "ko" --fix -md

  8. Поправља преводе са ниским поверењем само за одређене фајлове (слике): translate -l "ko" --fix -img

  9. Користи брзи режим за превођење слика:    translate -l "ko" -img -f

  10. Поправља преводе са ниским поверењем са прилагођеним праговима: translate -l "ko" --fix -c 0.8

  11. Пример debug режима: - translate -l "ko" -d: Омогућава debug логовање.
  12. Снима логове у фајлове: translate -l "ko" -s
  13. DEBUG у конзоли и у фајловима: translate -l "ko" -d -s
  14. Преводи без додавања одрицања од одговорности за машински превод: translate -l "ko" --no-disclaimer

  15. Мигрира линкове ка notebook-овима за корејске преводе (ажурира линкове ка преведеним notebook-овима када су доступни):    migrate-links -l "ko"

  15. Мигрира линкове са dry-run (без уписивања промена):    migrate-links -l "ko" --dry-run

  16. Ажурира линкове само када преведени notebook-ови постоје (не враћа се на оригинале):    migrate-links -l "ko" --no-fallback-to-original

  17. Обрађује све језике са потврдом:    migrate-links -l "all"

  18. Обрађује све језике и аутоматски потврђује:    migrate-links -l "all" -y
  19. Снима логове у фајлове за migrate-links:    migrate-links -l "ko ja" -s

### Примери процене

> [!WARNING]  
> **Бета функција**: Функционалност процене је тренутно у бета фази. Ова функција је објављена за процену преведених докумената, а методе процене и детаљна имплементација су још у развоју и могу се мењати.

  1. Процена корејских превода: evaluate -l "ko"

  2. Процена са прилагођеним праговима поверења: evaluate -l "ko" -c 0.8

  3. Брза процена (само на основу правила): evaluate -l "ko" -f

  4. Дубинска процена (само LLM): evaluate -l "ko" -D

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Одрицање од одговорности**:
Овај документ је преведен коришћењем AI услуге за превођење [Co-op Translator](https://github.com/Azure/co-op-translator). Иако се трудимо да превод буде тачан, имајте у виду да аутоматизовани преводи могу садржати грешке или нетачности. Оригинални документ на његовом изворном језику треба сматрати ауторитетним извором. За критичне информације препоручује се професионални људски превод. Нисмо одговорни за било каква неспоразума или погрешна тумачења која произилазе из коришћења овог превода.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->