<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T04:04:06+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "sr"
}
-->
# Преведите ваш пројекат помоћу Co-op Translator-а

**Co-op Translator** је алатка за рад из командне линије (CLI) која вам помаже да преведете markdown и сликовне фајлове у вашем пројекту на више језика. Овај одељак објашњава како да користите алатку, покрива различите CLI опције и даје примере за различите ситуације.

---

## Пример сценарија и команди

Овде су неки уобичајени начини коришћења **Co-op Translator**-а, заједно са одговарајућим командама.

### 1. Основни превод (један језик)

Да бисте превели цео ваш пројекат (markdown фајлове и слике) на један језик, на пример корејски, користите следећу команду:

```bash
translate -l "ko"
```

Ова команда ће превести све markdown и сликовне фајлове на корејски, додајући нове преводе без брисања постојећих.

#### Пример на Phi-3 CookBook-у

У **Phi-3 CookBook**-у, користио сам следећи метод да додам корејски превод за постојеће markdown фајлове и слике.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. Превод на више језика

Да бисте превели ваш пројекат на више језика (нпр. шпански, француски и немачки), користите ову команду:

```bash
translate -l "es fr de"
```

Ова команда ће превести пројекат на шпански, француски и немачки, додајући нове преводе без преписивања постојећих.

#### Пример на Phi-3 CookBook-у

У **Phi-3 CookBook**-у, након што сам повукао најновије измене да бих ажурирао садржај, користио сам следећи метод да преведем ново додате markdown фајлове и слике.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### 3. Ажурирање превода (брише постојеће преводе)

Да бисте ажурирали постојеће преводе (тј. обрисали тренутне преводе и заменили их новим), користите `-u` опцију. Ово ће обрисати све постојеће преводе за наведене језике и поново их превести.

```bash
translate -l "ko" -u
```

Упозорење: Ова команда ће вас питати за потврду пре него што обрише постојеће преводе.

#### Пример на Phi-3 CookBook-у

У **Phi-3 CookBook**-у, користио сам следећи метод да ажурирам све преведене фајлове на шпанском. Препоручујем овај метод када има значајних измена у оригиналном садржају кроз више markdown докумената. Ако има само неколико markdown фајлова за ажурирање, ефикасније је ручно обрисати те фајлове и затим користити `-a` метод за додавање ажурираних превода.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. Превод само слика

Да бисте превели само сликовне фајлове у вашем пројекту, користите `-img` опцију:

```bash
translate -l "ko" -img
```

Ова команда ће превести само слике на корејски, без утицаја на markdown фајлове.

### 6. Превод само markdown фајлова

Да бисте превели само markdown фајлове у вашем пројекту, користите `-md` опцију:

```bash
translate -l "ko" -md
```

#### Пример на Phi-3 CookBook-у

У **Phi-3 CookBook**-у, користио сам следећи метод да проверим грешке у преводу корејских фајлова и аутоматски поново покренем превод за све фајлове са детектованим проблемима.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

Ова опција проверава грешке у преводу. Тренутно, ако је разлика у преломима линија између оригиналног и преведеног фајла већа од шест, фајл се означава као проблематичан. Планирам да унапредим овај критеријум за већу флексибилност у будућности.

На пример, овај метод је користан за откривање недостајућих делова или оштећених превода, и аутоматски ће поново покренути превод за те фајлове.

Међутим, ако већ знате који су фајлови проблематични, ефикасније је ручно обрисати те фајлове и користити `-a` опцију за поновни превод.

### 8. Debug режим

Да бисте омогућили детаљно логовање ради решавања проблема, користите `-d` опцију:

```bash
translate -l "ko" -d
```

Ова команда ће покренути превод у debug режиму, пружајући додатне информације које могу помоћи да идентификујете проблеме током процеса превођења.

#### Пример на Phi-3 CookBook-у

У **Phi-3 CookBook**-у, наишао сам на проблем где преводи са много линкова у markdown фајловима изазивају грешке у форматирању, као што су покварени преводи и игнорисани преломи линија. Да бих дијагностиковао овај проблем, користио сам `-d` опцију да видим како процес превођења функционише.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. Превод на све језике

Ако желите да преведете пројекат на све подржане језике, користите all кључну реч.

```bash
translate -l "all"
```

Ова команда ће превести пројекат на све доступне језике. Ако наставите, превођење може потрајати дуже у зависности од величине пројекта.

### Ручно брисање преведених фајлова (опционо)
Преведени фајлови се сада аутоматски детектују и чисте када се изворни фајл ажурира.

Међутим, ако желите ручно да ажурирате превод – на пример, да поново урадите одређени фајл или да препишете системско понашање – можете користити следећу команду да обришете све верзије фајла у језичким фасциклама.

### На Windows-у:
1. **Коришћење Command Prompt-а**:
   - Отворите Command Prompt.
   - Идите у фасциклу где се налазе фајлови помоћу `cd` команде.
   - Користите следећу команду за брисање фајлова:
>      ```
>      del /s *filename*
>      ```
   Замените `filename` са делом имена фајла који тражите. `/s` опција претражује подфасцикле.

2. **Коришћење PowerShell-а**:
   - Отворите PowerShell.
   - Покрените ову команду:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
   Замените `"C:\YourPath"` са путањом до фасцикле и `filename` са конкретним именом.

### На macOS/Linux-у:
1. **Коришћење Terminal-а**:
  - Отворите Terminal.
  - Идите у фасциклу помоћу `cd`.
  - Користите `find` команду:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
  Замените `filename` са конкретним именом.

Увек пажљиво проверите фајлове пре брисања да не бисте случајно изгубили податке.

Када обришете фајлове које треба заменити, једноставно поново покрените вашу `translate -l` команду да ажурирате најновије измене.

---

**Одрицање од одговорности**:  
Овај документ је преведен коришћењем AI услуге за превођење [Co-op Translator](https://github.com/Azure/co-op-translator). Иако тежимо тачности, имајте у виду да аутоматски преводи могу садржати грешке или нетачности. Оригинални документ на изворном језику треба сматрати ауторитативним извором. За критичне информације препоручује се професионални људски превод. Не сносимо одговорност за било каква неспоразума или погрешна тумачења настала коришћењем овог превода.