<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T04:03:55+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "sr"
}
-->
# Инсталирајте Co-op Translator пакет

**Co-op Translator** је алатка за командну линију (CLI) направљена да вам помогне да преведете све markdown фајлове и слике у вашем пројекту на више језика. Овај водич ће вас провести кроз подешавање преводиоца и његово коришћење за различите сценарије.

### Креирајте виртуелно окружење

Виртуелно окружење можете креирати помоћу `pip` или `Poetry`. Унесите једну од следећих команди у вашем терминалу.

#### Коришћење pip-а

```bash
python -m venv .venv
```

#### Коришћење Poetry-а

```bash
poetry init
```

### Активирајте виртуелно окружење

Након креирања виртуелног окружења, потребно је да га активирате. Кораци се разликују у зависности од вашег оперативног система. Унесите следећу команду у вашем терминалу.

#### За оба, pip и Poetry

- Windows:

    ```bash
    .venv\Scripts\activate
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Коришћење Poetry-а

1. Ако сте окружење креирали помоћу Poetry-а, унесите следећу команду у вашем терминалу да га активирате.

    ```bash
    poetry shell
    ```

### Инсталирање пакета и потребних зависности

Када је ваше виртуелно окружење спремно и активно, следећи корак је инсталација неопходних зависности.

### Брза инсталација

Инсталирајте Co-Op Translator преко pip-а

```
pip install co-op-translator
```
Или 

Инсталирајте преко poetry-а
```
poetry add co-op-translator
```

#### Коришћење pip-а (из requirements.txt) ако сте клонирали овај репо

> [!NOTE]
> Молимо вас да ово НЕ радите ако сте инсталирали co-op translator преко брзе инсталације.

1. Ако користите pip, унесите следећу команду у вашем терминалу. Ово ће аутоматски инсталирати потребне пакете наведене у `requirements.txt` фајлу:

    ```bash
    pip install -r requirements.txt
    ```

#### Коришћење Poetry-а (из pyproject.toml)

1. Ако користите Poetry, унесите следећу команду у вашем терминалу. Ово ће аутоматски инсталирати потребне пакете наведене у `pyproject.toml` фајлу:

    ```bash
    poetry install
    ```

---

**Одрицање од одговорности**:  
Овај документ је преведен коришћењем AI услуге за превођење [Co-op Translator](https://github.com/Azure/co-op-translator). Иако тежимо тачности, молимо вас да имате у виду да аутоматски преводи могу садржати грешке или нетачности. Оригинални документ на изворном језику треба сматрати ауторитативним извором. За критичне информације препоручује се професионални људски превод. Не сносимо одговорност за било каква погрешна тумачења или неспоразуме који могу настати коришћењем овог превода.