<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T12:26:51+00:00",
  "source_file": "README.md",
  "language_code": "sr"
}
-->
# Co-op преводилац

_Лако аутоматизујте превод вашег образовног GitHub садржаја на више језика како бисте досегли глобалну публику._

[![Python пакет](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![Лиценца: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Преузимања](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Преузимања](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Контейнер: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Стил кода: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub сарадници](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub проблеми](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub захтеви за повлачење](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Добродошли](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 Подршка за више језика

#### Подржано од стране [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[Арапски](../ar/README.md) | [Бенгалски](../bn/README.md) | [Бугарски](../bg/README.md) | [Бирмански (Мјанмар)](../my/README.md) | [Кинески (поједностављени)](../zh/README.md) | [Кинески (традиционални, Хонг Конг)](../hk/README.md) | [Кинески (традиционални, Макао)](../mo/README.md) | [Кинески (традиционални, Тајван)](../tw/README.md) | [Хрватски](../hr/README.md) | [Чешки](../cs/README.md) | [Дански](../da/README.md) | [Холандски](../nl/README.md) | [Естонски](../et/README.md) | [Фински](../fi/README.md) | [Француски](../fr/README.md) | [Немачки](../de/README.md) | [Грчки](../el/README.md) | [Хебрејски](../he/README.md) | [Хинди](../hi/README.md) | [Мађарски](../hu/README.md) | [Индонежански](../id/README.md) | [Италијански](../it/README.md) | [Јапански](../ja/README.md) | [Канада](../kn/README.md) | [Кореијски](../ko/README.md) | [Литвански](../lt/README.md) | [Малајски](../ms/README.md) | [Малајалам](../ml/README.md) | [Марати](../mr/README.md) | [Непалски](../ne/README.md) | [Нигеријски Пидгин](../pcm/README.md) | [Норвешки](../no/README.md) | [Персијски (Фарси)](../fa/README.md) | [Пољски](../pl/README.md) | [Португалски (Бразил)](../br/README.md) | [Португалски (Португал)](../pt/README.md) | [Пунџаби (Гурмукхи)](../pa/README.md) | [Румунски](../ro/README.md) | [Руски](../ru/README.md) | [Српски (ћирилица)](./README.md) | [Словачки](../sk/README.md) | [Словеначки](../sl/README.md) | [Шпански](../es/README.md) | [Свахили](../sw/README.md) | [Шведски](../sv/README.md) | [Тагалог (Филипински)](../tl/README.md) | [Тамилски](../ta/README.md) | [Телугу](../te/README.md) | [Тајландски](../th/README.md) | [Турски](../tr/README.md) | [Украјински](../uk/README.md) | [Урду](../ur/README.md) | [Вијетнамски](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub пратиоци](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub форкови](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub звезде](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Отвори у GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## Преглед

**Co-op преводилац** вам помаже да лако локализујете ваш образовни GitHub садржај на више језика.
Када ажурирате Markdown фајлове, слике или бележнице, преводи се аутоматски синхронизују, осигуравајући да ваш садржај буде тачан и ажуран за ученике широм света.

Пример како је преведени садржај организован:

![Пример](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.sr.png)

## Брзи почетак

```bash
# Креирајте и активирајте виртуелно окружење (препоручено)
python -m venv .venv
# Виндоус
.venv\Scripts\activate
# мацОС/Линукс
source .venv/bin/activate
# Инсталирајте пакет
pip install co-op-translator
# Преведи
translate -l "ko ja fr" -md
```

Docker:

```bash
# Повуците јавну слику са GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# Покрените са монтираном тренутном фасциклом и обезбеђеним .env (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## Минимална подешавања

1. Креирајте `.env` фајл користећи шаблон: [.env.template](../../.env.template)
2. Конфигуришите једног LLM провајдера (Azure OpenAI или OpenAI)
3. (Опционо) За превод слика (`-img`), конфигуришите Azure AI Vision
4. (Препоручено) Очистите претходне преводе да бисте избегли конфликте (нпр. `translations/`)
5. (Препоручено) Додајте одељак за превод у ваш README користећи [README шаблон за језике](./getting_started/README_languages_template.md)
6. Погледајте: [Подешавање Azure AI](./getting_started/set-up-azure-ai.md)

## Коришћење

Преведите све подржане типове:

```bash
translate -l "ko ja"
```

Само Markdown:

```bash
translate -l "de" -md
```

Markdown + слике:

```bash
translate -l "pt" -md -img
```

Само бележнице:

```bash
translate -l "zh" -nb
```

Више опција: [Референца команди](./getting_started/command-reference.md)

## Карактеристике

- Аутоматизован превод за Markdown, бележнице и слике
- Одржава преводе усклађене са изменама извора
- Ради локално (CLI) или у CI (GitHub Actions)
- Користи Azure OpenAI или OpenAI; опционално Azure AI Vision за слике
- Чува формат и структуру Markdown-а

## Документација

- [Водич за командну линију](./getting_started/command-line-guide/command-line-guide.md)
- [Водич за GitHub Actions (Јавни репозиторијуми и стандардни тајни подаци)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [Водич за GitHub Actions (Microsoft организациони репозиторијуми и подешавања на нивоу организације)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [README шаблон за језике](./getting_started/README_languages_template.md)
- [Подржани језици](./getting_started/supported-languages.md)
- [Учествовање](./CONTRIBUTING.md)
- [Решавање проблема](./getting_started/troubleshooting.md)

### Водич специфичан за Microsoft
> [!NOTE]
> Само за одржаваоце Microsoft “For Beginners” репозиторијума.

- [Ажурирање листе „других курсева“ (само за MS Beginners репозиторијуме)](./getting_started/update-other-courses.md)

## Подржите нас и подстакните глобално учење

Придружите нам се у револуцији начина на који се образовни садржај дели широм света! Дајте [Co-op Translator](https://github.com/azure/co-op-translator) ⭐ на GitHub-у и подржите нашу мисију да скинемо језичке баријере у учењу и технологији. Ваш интерес и доприноси имају велики утицај! Код и предлози за нове функције су увек добродошли.

### Истражите Microsoft образовни садржај на вашем језику

- [AZD за почетнике](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI за почетнике](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) за почетнике](https://github.com/microsoft/mcp-for-beginners)
- [AI агенти за почетнике](https://github.com/microsoft/ai-agents-for-beginners)
- [Generative AI за почетнике користећи .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI за почетнике](https://github.com/microsoft/generative-ai-for-beginners)
- [Generative AI за почетнике користећи Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML за почетнике](https://aka.ms/ml-beginners)
- [Data Science за почетнике](https://aka.ms/datascience-beginners)
- [AI за почетнике](https://aka.ms/ai-beginners)
- [Cybersecurity за почетнике](https://github.com/microsoft/Security-101)
- [Web Dev за почетнике](https://aka.ms/webdev-beginners)
- [IoT за почетнике](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## Видео презентације

👉 Кликните на слику испод да бисте гледали на YouTube-у.

- **Open at Microsoft**: Кратак 18-минутни увод и брзи водич како користити Co-op Translator.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.sr.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## Учествовање

Овај пројекат поздравља доприносе и предлоге. Желите да допринесете Azure Co-op Translator-у? Молимо вас да погледате наш [CONTRIBUTING.md](./CONTRIBUTING.md) за смернице како можете помоћи да Co-op Translator буде приступачнији.

## Сарадници

[![co-op-translator сарадници](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## Кодекс понашања

Овај пројекат је усвојио [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
За више информација погледајте [Често постављана питања о Кодексу понашања](https://opensource.microsoft.com/codeofconduct/faq/) или
контактирајте [opencode@microsoft.com](mailto:opencode@microsoft.com) за додатна питања или коментаре.

## Одговорна вештачка интелигенција

Microsoft је посвећен помагању нашим корисницима да одговорно користе наше AI производе, делећи наша сазнања и градећи партнерства заснована на поверењу кроз алате као што су Transparency Notes и Impact Assessments. Многи од ових ресурса доступни су на [https://aka.ms/RAI](https://aka.ms/RAI).
Приступ Microsoft-а одговорној AI заснован је на нашим AI принципима правичности, поузданости и безбедности, приватности и сигурности, инклузивности, транспарентности и одговорности.

Велики модели за природни језик, слике и говор - као они који се користе у овом примеру - могу потенцијално да се понашају на начине који нису праведни, поуздани или могу бити увредљиви, што може изазвати штету. Молимо вас да консултујете [Azure OpenAI service Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) да бисте били информисани о ризицима и ограничењима.
Препоручени приступ за смањење ових ризика је укључивање безбедносног система у вашу архитектуру који може да детектује и спречи штетно понашање. <a href="https://learn.microsoft.com/azure/ai-services/content-safety/overview">Azure AI Content Safety</a> пружа независни слој заштите, способан да открије штетни садржај који корисници или вештачка интелигенција генеришу у апликацијама и услугама. Azure AI Content Safety укључује текстуалне и сликовне API-је који вам омогућавају да детектујете штетан материјал. Такође имамо интерактивни Content Safety Studio који вам омогућава да прегледате, истражујете и испробате пример кода за детекцију штетног садржаја у различитим модалитетима. Следећа <a href="https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest">документација за брзи почетак</a> води вас кроз прављење захтева ка сервису.

Још један аспект који треба узети у обзир је укупна перформанса апликације. Код мултимодалних и мултимоделских апликација, перформансе подразумевамо као то да систем ради онако како ви и ваши корисници очекујете, укључујући и то да не генерише штетне излазе. Важно је проценити перформансе ваше укупне апликације користећи <a href="https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in">метрике квалитета генерисања и ризика и безбедности</a>.

Можете оценити вашу AI апликацију у развојном окружењу користећи <a href="https://microsoft.github.io/promptflow/index.html">prompt flow SDK</a>. Уз тест скуп података или циљ, генерисања ваше генеративне AI апликације се квантитативно мере уграђеним или прилагођеним евалуаторима по вашем избору. Да бисте почели са prompt flow SDK за процену вашег система, можете пратити <a href="https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk">водич за брзи почетак</a>. Када извршите процену, можете <a href="https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results">визуализовати резултате у Azure AI Studio</a>.

## Заштитни знаци

Овај пројекат може садржати заштитне знакове или логотипе пројеката, производа или услуга. Овлашћена употреба Microsoft-ових
заштитних знакова или логотипа подлеже и мора се придржавати
<a href="https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general">Microsoft-ових смерница за заштитне знакове и бренд</a>.
Употреба Microsoft-ових заштитних знакова или логотипа у модификованим верзијама овог пројекта не сме изазивати конфузију нити имплицирати спонзорство од стране Microsoft-а.
Свака употреба заштитних знакова или логотипа трећих страна подлеже политикама тих трећих страна.

## Добијање помоћи

Ако запнете или имате питања о изградњи AI апликација, придружите се:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

Ако имате повратне информације о производу или наиђете на грешке током развоја, посетите:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Одрицање од одговорности**:
Овај документ је преведен коришћењем AI услуге за превођење [Co-op Translator](https://github.com/Azure/co-op-translator). Иако се трудимо да превод буде тачан, молимо вас да имате у виду да аутоматски преводи могу садржати грешке или нетачности. Оригинални документ на његовом изворном језику треба сматрати ауторитетним извором. За критичне информације препоручује се професионални људски превод. Нисмо одговорни за било каква неспоразума или погрешна тумачења која произилазе из коришћења овог превода.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->