<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T12:25:59+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "sr"
}
-->
# Допринoс Co-op Translator-у

Овај пројекат прихвата доприносе и предлоге. Већина доприноса захтева да се сложите са Уговором о лиценци за допринос (CLA) којим изјављујете да имате право и заправо нам дајете права да користимо ваш допринос. За детаље посетите https://cla.opensource.microsoft.com.

Када пошаљете pull request, CLA бот ће аутоматски одредити да ли је потребно да доставите CLA и одговарајуће означити PR (нпр. провера статуса, коментар). Једноставно пратите упутства бота. Ово ћете морати урадити само једном за све репозиторијуме који користе наш CLA.

## Подешавање развојног окружења

За подешавање развојног окружења за овај пројекат препоручујемо коришћење Poetry за управљање зависностима. Користимо `pyproject.toml` за управљање зависностима пројекта, па за инсталацију зависности треба да користите Poetry.

### Креирање виртуелног окружења

#### Коришћење pip-а

```bash
python -m venv .venv
```

#### Коришћење Poetry-а

```bash
poetry init
```

### Активирање виртуелног окружења

#### За pip и Poetry

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Коришћење Poetry-а

```bash
poetry shell
```

### Инсталација пакета и потребних зависности

#### Коришћење Poetry-а (из pyproject.toml)

```bash
poetry install
```

### Ручно тестирање

Пре слања PR-а, важно је тестирати функционалност превођења са стварном документацијом:

1. Креирајте директоријум за тестирање у корену пројекта:
    ```bash
    mkdir test_docs
    ```

2. Копирајте неку markdown документацију и слике које желите да преведете у тест директоријум. На пример:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. Локално инсталирајте пакет:
    ```bash
    pip install -e .
    ```

4. Покрените Co-op Translator на вашим тест документима:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. Проверите преведене фајлове у `test_docs/translations` и `test_docs/translated_images` да бисте проверили:
   - Квалитет превода
   - Да ли су коментари са метаподацима исправни
   - Да ли је оригинална структура markdown-а сачувана
   - Да ли линкови и слике исправно функционишу

Ово ручно тестирање помаже да се осигура да ваше измене добро функционишу у стварним условима.

### Променљиве окружења

1. Копирајте `.env.template` у `.env` у корену пројекта.
2. Попуните променљиве окружења према упутствима.

> [!TIP]
>
> ### Додатне опције за развојно окружење
>
> Поред покретања пројекта локално, можете користити и GitHub Codespaces или VS Code Dev Containers као алтернативу за развојно окружење.
>
> #### GitHub Codespaces
>
> Овај пример можете покренути виртуелно коришћењем GitHub Codespaces без додатних подешавања.
>
> Дугме ће отворити VS Code у веб прегледачу:
>
> 1. Отворите шаблон (може потрајати неколико минута):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### Локално покретање користећи VS Code Dev Containers
>
> ⚠️ Ова опција ради само ако Docker Desktop има додељено најмање 16 GB RAM-а. Ако имате мање од 16 GB, можете пробати [GitHub Codespaces опцију](../..) или [локално подешавање](../..).
>
> Поред тога, можете користити VS Code Dev Containers који ће отворити пројекат у вашем локалном VS Code-у уз помоћ [Dev Containers екстензије](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers):
>
> 1. Покрените Docker Desktop (инсталирајте ако већ није инсталиран)
> 2. Отворите пројекат:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### Стил кода

Користимо [Black](https://github.com/psf/black) као форматер Python кода да бисмо одржали доследан стил кода у пројекту. Black је неумољиви форматер који аутоматски преуређује Python код да би био у складу са Black стилом.

#### Конфигурација

Black конфигурација је наведена у нашем `pyproject.toml`:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Инсталација Black-а

Black можете инсталирати преко Poetry-а (препоручено) или pip-а:

##### Коришћење Poetry-а

Black се аутоматски инсталира приликом подешавања развојног окружења:
```bash
poetry install
```

##### Коришћење pip-а

Ако користите pip, можете директно инсталирати Black:
```bash
pip install black
```

#### Коришћење Black-а

##### Са Poetry-ом

1. Форматирајте све Python фајлове у пројекту:
    ```bash
    poetry run black .
    ```

2. Форматирајте одређени фајл или директоријум:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### Са pip-ом

1. Форматирајте све Python фајлове у пројекту:
    ```bash
    black .
    ```

2. Форматирајте одређени фајл или директоријум:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> Препоручујемо да подесите ваш уређивач да аутоматски форматира код помоћу Black приликом чувања. Већина модерних уређивача то подржава кроз екстензије или додатке.

## Покретање Co-op Translator-а

Да бисте покренули Co-op Translator користећи Poetry у вашем окружењу, следите ове кораке:

1. Идите у директоријум где желите да извршите тестове превођења или креирајте привремени фолдер за тестирање.

2. Покрените следећу команду. Замените `-l ko` кодом језика на који желите да преведете. Опција `-d` означава debug режим.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> Уверите се да је ваше Poetry окружење активирано (poetry shell) пре покретања команде.

## Допринесите нови језик

Добродошли су доприноси који додају подршку за нове језике. Пре него што отворите PR, молимо вас да завршите следеће кораке како би преглед прошао глатко.

1. Додајте језик у мапирање фонтова
   - Уредите `src/co_op_translator/fonts/font_language_mappings.yml`
   - Додајте унос са:
     - `code`: ISO-подобан језички код (нпр. `vi`)
     - `name`: Пријатељски приказни назив
     - `font`: Фонт који се испоручује у `src/co_op_translator/fonts/` и подржава скрипту
     - `rtl`: `true` ако је десно-лево, иначе `false`

2. Укључите потребне фонт фајлове (ако је потребно)
   - Ако је потребан нови фонт, проверите компатибилност лиценце за отворени софтвер
   - Додајте фонт фајл у `src/co_op_translator/fonts/`

3. Локална провера
   - Покрените превод за мали узорак (Markdown, слике и notebook-ове по потреби)
   - Проверите да ли излаз правилно приказује фонтове и евентуални RTL распоред

4. Ажурирајте документацију
   - Уверите се да је језик наведен у `getting_started/supported-languages.md`
   - Није потребно мењати `getting_started/README_languages_template.md`; он се генерише из листе подржаних језика

5. Отворите PR
   - Опишите додати језик и евентуалне напомене о фонтовима/лиценцама
   - Прикачите снимке екрана ако је могуће

Пример YAML уноса:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### Тестирање новог језика

Нов језик можете тестирати покретањем следеће команде:

```bash
# Креирајте и активирајте виртуелно окружење
python -m venv .venv
# Виндоус
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Инсталирајте развојни пакет
pip install -e .
# Покрените превод
translate -l "new_lang"
```

## Одржаваоци

### Формат поруке комита и стратегија спајања

Да бисмо обезбедили доследност и јасноћу у историји комита пројекта, користимо специфичан формат поруке комита **за коначну поруку комита** када користимо стратегију **Squash and Merge**.

Када се pull request (PR) споји, појединачни комити ће бити спојени у један комит. Коначна порука комита треба да прати формат испод ради одржавања чисте и доследне историје.

#### Формат поруке комита (за squash and merge)

Користимо следећи формат за поруке комита:

```bash
<type>: <description> (#<Број ПР-а>)
```

- **type**: Категорија комита. Користимо следеће типове:
  - `Docs`: За ажурирања документације.
  - `Build`: За промене у систему изградње или зависностима, укључујући конфигурационе фајлове, CI workflow-је или Dockerfile.
  - `Core`: За измене у основној функционалности или карактеристикама пројекта, посебно оне у `src/co_op_translator/core` директоријуму.

- **description**: Кратак опис промене.
- **PR number**: Број pull request-а повезан са комитом.

**Примери**:

- `Docs: Ажурирање упутстава за инсталацију ради јасноће (#50)`
- `Core: Побољшано руковање преводом слика (#60)`

> [!NOTE]
> Тренутно, префикси **`Docs`**, **`Core`** и **`Build`** се аутоматски додају на наслове PR-а на основу ознака које су додељене измењеном коду. Дакле, ако је исправна ознака додељена, обично није потребно ручно мењати наслов PR-а. Само проверите да је све исправно и да је префикс правилно генерисан.

#### Стратегија спајања

Као подразумевану стратегију за pull request-ове користимо **Squash and Merge**. Ова стратегија осигурава да поруке комита прате наш формат, чак и ако појединачни комити то не чине.

**Разлози**:

- Чиста, линеарна историја пројекта.
- Доследност у порукама комита.
- Смањење буке од мањих комита (нпр. "исправка правописне грешке").

При спајању, уверите се да коначна порука комита прати горе описани формат.

**Пример Squash and Merge**
Ако PR садржи следеће комите:

- `fix typo`
- `update README`
- `adjust formatting`

Они ће бити спојени у:
`Docs: Побољшање јасноће и форматирања документације (#65)`

### Процес издавања верзије

Овај одељак описује најједноставнији начин за одржаваоце да објаве нову верзију Co-op Translator-а.

#### 1. Повећајте верзију у `pyproject.toml`

1. Одлучите следећи број верзије (пратимо семантичко верзионисање: `MAJOR.MINOR.PATCH`).
2. Уредите `pyproject.toml` и ажурирајте поље `version` у одељку `[tool.poetry]`.
3. Отворите посебан pull request који мења само верзију (и евентуално аутоматски ажуриране lock/metadata фајлове, ако постоје).
4. Након прегледа, користите **Squash and Merge** и уверите се да коначна порука комита прати горе описани формат.

#### 2. Креирајте GitHub издање (Release)

1. Идите на страницу GitHub репозиторијума и отворите **Releases** → **Draft a new release**.
2. Креирајте нови таг (нпр. `v0.13.0`) из `main` гране.
3. Поставите наслов издања на исти број верзије (нпр. `v0.13.0`).
4. Кликните на **Generate release notes** да аутоматски попуните changelog.
5. По жељи измените текст (нпр. да истакнете нове подржане језике или важне промене).
6. Објавите издање.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Одрицање од одговорности**:
Овај документ је преведен коришћењем AI услуге за превођење [Co-op Translator](https://github.com/Azure/co-op-translator). Иако се трудимо да превод буде тачан, молимо вас да имате у виду да аутоматски преводи могу садржати грешке или нетачности. Оригинални документ на његовом изворном језику треба сматрати ауторитетним извором. За критичне информације препоручује се професионални људски превод. Нисмо одговорни за било каква неспоразума или погрешна тумачења која произилазе из коришћења овог превода.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->