<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "d11fe2b5308a8752a994869658751533",
  "translation_date": "2025-11-30T12:15:58+00:00",
  "source_file": "getting_started/supported-languages.md",
  "language_code": "sk"
}
-->
# Podporované jazyky

Nižšie uvedená tabuľka obsahuje jazyky, ktoré sú momentálne podporované v **Co-op Translator**. Zahŕňa kódy jazykov, názvy jazykov a prípadné známe problémy spojené s každým jazykom. Ak chcete pridať podporu pre nový jazyk, pridajte príslušný kód jazyka, názov a vhodné písmo do súboru `font_language_mappings.yml`, ktorý sa nachádza v `src/co_op_translator/fonts/`, a po otestovaní odošlite pull request.

| Kód jazyka   | Názov jazyka          | Písmo                             | Podpora RTL | Známé problémy |
|--------------|-----------------------|----------------------------------|-------------|----------------|
| en           | Angličtina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| fr           | Francúzština          | NotoSans-Medium.ttf              | Nie         | Nie            |
| es           | Španielčina           | NotoSans-Medium.ttf              | Nie         | Nie            |
| de           | Nemčina               | NotoSans-Medium.ttf              | Nie         | Nie            |
| ru           | Ruština               | NotoSans-Medium.ttf              | Nie         | Nie            |
| ar           | Arabčina              | NotoSansArabic-Medium.ttf        | Áno         | Nie            |
| fa           | Perzština (Farsi)     | NotoSansArabic-Medium.ttf        | Áno         | Nie            |
| ur           | Urdu                  | NotoSansArabic-Medium.ttf        | Áno         | Nie            |
| zh           | Čínština (zjednodušená)| NotoSansCJK-Medium.ttc           | Nie         | Nie            |
| mo           | Čínština (tradičná, Macau) | NotoSansCJK-Medium.ttc      | Nie         | Nie            |
| hk           | Čínština (tradičná, Hong Kong) | NotoSansCJK-Medium.ttc  | Nie         | Nie            |
| tw           | Čínština (tradičná, Taiwan) | NotoSansCJK-Medium.ttc       | Nie         | Nie            |
| ja           | Japončina             | NotoSansCJK-Medium.ttc           | Nie         | Nie            |
| ko           | Kórejčina             | NotoSansCJK-Medium.ttc           | Nie         | Nie            |
| hi           | Hindčina              | NotoSansDevanagari-Medium.ttf    | Nie         | Nie            |
| bn           | Bengálčina            | NotoSansBengali-Medium.ttf       | Nie         | Nie            |
| mr           | Maráthčina            | NotoSansDevanagari-Medium.ttf    | Nie         | Nie            |
| ne           | Nepálčina             | NotoSansDevanagari-Medium.ttf    | Nie         | Nie            |
| pa           | Pandžábčina (Gurmukhi)| NotoSansGurmukhi-Medium.ttf      | Nie         | Nie            |
| pt           | Portugalčina          | NotoSans-Medium.ttf              | Nie         | Nie            |
| br           | Brazilská portugalčina| NotoSans-Medium.ttf              | Nie         | Nie            |
| it           | Taliančina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| lt           | Litovčina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| pl           | Poľština              | NotoSans-Medium.ttf              | Nie         | Nie            |
| tr           | Turečtina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| el           | Gréčtina              | NotoSans-Medium.ttf              | Nie         | Nie            |
| th           | Thajčina              | NotoSansThai-Medium.ttf          | Nie         | Nie            |
| sv           | Švédčina              | NotoSans-Medium.ttf              | Nie         | Nie            |
| da           | Dánčina               | NotoSans-Medium.ttf              | Nie         | Nie            |
| no           | Nórčina               | NotoSans-Medium.ttf              | Nie         | Nie            |
| fi           | Fínčina               | NotoSans-Medium.ttf              | Nie         | Nie            |
| nl           | Holandčina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| he           | Hebrejčina            | NotoSansHebrew-Medium.ttf        | Áno         | Nie            |
| vi           | Vietnamčina           | NotoSans-Medium.ttf              | Nie         | Nie            |
| id           | Indonézština          | NotoSans-Medium.ttf              | Nie         | Nie            |
| ms           | Malajčina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| tl           | Tagalog (Filipínčina) | NotoSans-Medium.ttf              | Nie         | Nie            |
| sw           | Swahilčina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| hu           | Maďarčina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| cs           | Čeština               | NotoSans-Medium.ttf              | Nie         | Nie            |
| sk           | Slovenčina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| ro           | Rumunčina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| bg           | Bulharčina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| sr           | Srbčina (cyrilika)    | NotoSans-Medium.ttf              | Nie         | Nie            |
| hr           | Chorvátčina           | NotoSans-Medium.ttf              | Nie         | Nie            |
| sl           | Slovinčina            | NotoSans-Medium.ttf              | Nie         | Nie            |
| uk           | Ukrajinčina           | NotoSans-Medium.ttf              | Nie         | Nie            |
| my           | Barmský (Myanmar)     | NotoSansMyanmar-Medium.ttf       | Nie         | Nie            |
| ta           | Tamilčina             | NotoSansTamil-Medium.ttf         | Nie         | Nie            |
| et           | Estónčina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| pcm          | Nigerijský pidžin     | NotoSans-Medium.ttf              | Nie         | Nie            |
| te           | Telugčina             | NotoSans-Medium.ttf              | Nie         | Nie            |
| ml           | Malajálamčina         | NotoSans-Medium.ttf              | Nie         | Nie            |
| kn           | Kannadčina            | NotoSans-Medium.ttf              | Nie         | Nie            |

## Pridanie nového jazyka

Máte záujem pridať nový jazyk? Postupujte podľa príručky pre prispievateľov:

- Pozrite si sekciu Contributing: [Prispieť novým jazykom](../CONTRIBUTING.md#contribute-a-new-language)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Zrieknutie sa zodpovednosti**:
Tento dokument bol preložený pomocou AI prekladateľskej služby [Co-op Translator](https://github.com/Azure/co-op-translator). Aj keď sa snažíme o presnosť, majte prosím na pamäti, že automatizované preklady môžu obsahovať chyby alebo nepresnosti. Originálny dokument v jeho pôvodnom jazyku by mal byť považovaný za autoritatívny zdroj. Pre kritické informácie sa odporúča profesionálny ľudský preklad. Nie sme zodpovední za akékoľvek nedorozumenia alebo nesprávne interpretácie vyplývajúce z použitia tohto prekladu.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->