<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "cc205495d4eace1fabcdee963024069f",
  "translation_date": "2025-06-12T11:12:16+00:00",
  "source_file": "SECURITY.md",
  "language_code": "sk"
}
-->
## Bezpečnosť

Microsoft berie bezpečnosť našich softvérových produktov a služieb vážne, vrátane všetkých zdrojových kódových repozitárov spravovaných prostredníctvom našich GitHub organizácií, medzi ktoré patria [Microsoft](https://github.com/Microsoft), [Azure](https://github.com/Azure), [DotNet](https://github.com/dotnet), [AspNet](https://github.com/aspnet) a [Xamarin](https://github.com/xamarin).

Ak máte podozrenie, že ste našli bezpečnostnú zraniteľnosť v niektorom z repozitárov vlastnených Microsoftom, ktorá spĺňa [Microsoftovu definíciu bezpečnostnej zraniteľnosti](https://aka.ms/security.md/definition), prosím, nahláste nám ju podľa nižšie uvedených pokynov.

## Nahlasovanie bezpečnostných problémov

**Prosím, nehláste bezpečnostné zraniteľnosti cez verejné GitHub issues.**

Namiesto toho ich nahláste Microsoft Security Response Center (MSRC) na [https://msrc.microsoft.com/create-report](https://aka.ms/security.md/msrc/create-report).

Ak preferujete odoslanie bez prihlásenia, pošlite e-mail na [secure@microsoft.com](mailto:secure@microsoft.com). Ak je to možné, zašifrujte svoju správu naším PGP kľúčom; stiahnuť ho môžete na stránke [Microsoft Security Response Center PGP Key](https://aka.ms/security.md/msrc/pgp).

Očakávajte odpoveď do 24 hodín. Ak z nejakého dôvodu nedostanete odpoveď, prosím, kontaktujte nás znova e-mailom, aby sme potvrdili prijatie vašej pôvodnej správy. Ďalšie informácie nájdete na [microsoft.com/msrc](https://www.microsoft.com/msrc).

Prosíme, zahrňte čo najviac z požadovaných informácií uvedených nižšie, aby sme lepšie pochopili povahu a rozsah možného problému:

  * Typ problému (napr. buffer overflow, SQL injection, cross-site scripting a pod.)
  * Kompletné cesty k zdrojovým súborom súvisiacim s prejavom problému
  * Umiestnenie postihnutého zdrojového kódu (tag/branch/commit alebo priama URL)
  * Akákoľvek špeciálna konfigurácia potrebná na reprodukciu problému
  * Krok za krokom inštrukcie na reprodukciu problému
  * Dôkaz konceptu alebo exploit kód (ak je to možné)
  * Dopad problému vrátane toho, ako by mohol útočník problém zneužiť

Tieto informácie nám pomôžu rýchlejšie spracovať vašu správu.

Ak nahlasujete chybu v rámci bug bounty programu, podrobnejšie správy môžu viesť k vyššej odmienke. Viac informácií o našich aktívnych programoch nájdete na stránke [Microsoft Bug Bounty Program](https://aka.ms/security.md/msrc/bounty).

## Preferované jazyky

Uprednostňujeme, aby všetka komunikácia prebiehala v angličtine.

## Politika

Microsoft sa riadi princípom [Koordinovaného zverejňovania zraniteľností](https://aka.ms/security.md/cvd).

**Zrieknutie sa zodpovednosti**:  
Tento dokument bol preložený pomocou AI prekladateľskej služby [Co-op Translator](https://github.com/Azure/co-op-translator). Aj keď sa snažíme o presnosť, prosím, berte na vedomie, že automatické preklady môžu obsahovať chyby alebo nepresnosti. Originálny dokument v jeho pôvodnom jazyku by mal byť považovaný za autoritatívny zdroj. Pre kritické informácie sa odporúča profesionálny ľudský preklad. Nie sme zodpovední za akékoľvek nedorozumenia alebo nesprávne interpretácie vyplývajúce z použitia tohto prekladu.