<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T02:15:40+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "ru"
}
-->
# Руководство по устранению неполадок Microsoft Co-op Translator

## Обзор
Microsoft Co-Op Translator — это мощный инструмент для бесшовного перевода Markdown-документов. В этом руководстве вы найдете решения распространенных проблем, которые могут возникнуть при работе с этим инструментом.

## Частые проблемы и их решения

### 1. Проблема с тегом Markdown
**Проблема:** В переведённом Markdown-документе появляется тег `markdown` в начале, что вызывает ошибки отображения.

**Решение:** Просто удалите тег `markdown` в начале файла. После этого файл будет корректно отображаться.

**Шаги:**
1. Откройте переведённый Markdown (`.md`) файл.
2. Найдите тег `markdown` в самом начале документа.
3. Удалите этот тег.
4. Сохраните изменения.
5. Откройте файл заново и убедитесь, что он отображается правильно.

### 2. Проблема с URL встроенных изображений
**Проблема:** URL встроенных изображений не соответствует языковой локали, из-за чего изображения отображаются неправильно или отсутствуют.

**Решение:** Проверьте URL изображений и убедитесь, что они соответствуют языковой локали. Все изображения находятся в папке `translated_images`, и в имени каждого файла есть тег локали.

**Шаги:**
1. Откройте переведённый Markdown-документ.
2. Найдите встроенные изображения и их URL.
3. Проверьте, что тег локали в имени файла изображения совпадает с языком документа.
4. При необходимости обновите URL.
5. Сохраните изменения и откройте документ заново, чтобы убедиться, что изображения отображаются корректно.

### 3. Точность перевода
**Проблема:** Переведённый текст неточен или требует доработки.

**Решение:** Просмотрите переведённый документ и внесите необходимые правки для повышения точности и читаемости.

**Шаги:**
1. Откройте переведённый документ.
2. Внимательно проверьте содержимое.
3. Внесите необходимые изменения для улучшения качества перевода.
4. Сохраните изменения.

## 4. Ошибка доступа или 404

Если изображения или текст не переводятся на нужный язык, а при запуске в режиме -d debug появляется ошибка 401, это классическая проблема с аутентификацией — ключ недействителен, истёк или не связан с регионом конечной точки.

Запустите co-op translator с [флагом -d debug](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md), чтобы лучше понять причину ошибки.

- **Сообщение об ошибке:** `Access denied due to invalid subscription key or wrong API endpoint.`
- **Возможные причины:**
  - Ключ подписки был скрыт или неверно указан в запросе.
  - Ключ AI Services или Subscription Key принадлежит другому ресурсу Azure (например, Translator или OpenAI), а не **Azure AI Vision**.

 **Тип ресурса**
  - Перейдите в [Azure Portal](https://portal.azure.com) или [Azure AI Foundry](https://ai.azure.com) и убедитесь, что ресурс имеет тип `Azure AI services` → `Vision`.
  - Проверьте ключи и убедитесь, что используется правильный ключ.

## 5. Ошибки конфигурации (новая обработка ошибок)

В новой системе выборочного перевода Co-op Translator теперь явно сообщает об ошибках, если необходимые сервисы не настроены.

### 5.1. Azure AI Service не настроен для перевода изображений

**Проблема:** Вы запросили перевод изображений (флаг `-img`), но Azure AI Service не настроен.

**Сообщение об ошибке:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**Решение:**
1. **Вариант 1:** Настроить Azure AI Service
   - Добавьте `AZURE_AI_SERVICE_API_KEY` в ваш `.env` файл
   - Добавьте `AZURE_AI_SERVICE_ENDPOINT` в ваш `.env` файл
   - Убедитесь, что сервис доступен

2. **Вариант 2:** Уберите запрос на перевод изображений
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. Отсутствует необходимая конфигурация

**Проблема:** Не хватает обязательной конфигурации LLM.

**Сообщение об ошибке:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**Решение:**
1. Проверьте, что в вашем `.env` файле есть хотя бы одна из следующих конфигураций LLM:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` и `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   Должна быть настроена либо Azure OpenAI, либо OpenAI, но не обе сразу.

### 5.3. Путаница с выборочным переводом

**Проблема:** Файлы не были переведены, хотя команда завершилась успешно.

**Возможные причины:**
- Неправильные флаги типа файлов (`-md`, `-img`, `-nb`)
- Нет подходящих файлов в проекте
- Неправильная структура каталогов

**Решение:**
1. **Используйте режим отладки**, чтобы понять, что происходит:
   ```bash
   translate -l "ko" -md -d
   ```

2. **Проверьте типы файлов** в вашем проекте:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **Проверьте комбинации флагов:**
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. Миграция с прежней системы

### 6.1. Режим только Markdown устарел

**Проблема:** Команды, которые раньше автоматически переводили только Markdown, больше не работают как раньше.

**Старое поведение:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**Новое поведение:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**Решение:**
- **Явно указывайте**, что именно хотите перевести:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. Неожиданное поведение ссылок

**Проблема:** Ссылки в переведённых файлах ведут в неожиданные места.

**Причина:** Динамическая обработка ссылок зависит от выбранных типов файлов.

**Решение:**
1. **Поймите новое поведение ссылок:**
   - Включён `-nb`: ссылки на ноутбуки ведут на переведённые версии
   - `-nb` не включён: ссылки на ноутбуки ведут на оригинальные файлы
   - Включён `-img`: ссылки на изображения ведут на переведённые версии
   - `-img` не включён: ссылки на изображения ведут на оригинальные файлы

2. **Выберите правильную комбинацию** для вашей задачи:
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. GitHub Action сработал, но Pull Request (PR) не создан

**Симптом:** В логах workflow для `peter-evans/create-pull-request` написано:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**Возможные причины:**
- **Нет изменений:** Шаг перевода не создал различий (репозиторий уже актуален).
- **Игнорируемые выходные файлы:** `.gitignore` исключает файлы, которые вы хотите закоммитить (например, `*.ipynb`, `translations/`, `translated_images/`).
- **Несоответствие add-paths:** Пути, указанные в action, не совпадают с фактическими выходными файлами.
- **Логика workflow/условия:** Шаг перевода завершился раньше или записал файлы не туда.

**Как исправить / проверить:**
1. **Проверьте выходные файлы:** После перевода убедитесь, что в рабочей директории появились новые/изменённые файлы в `translations/` и/или `translated_images/`.
   - Если переводите ноутбуки, убедитесь, что файлы `.ipynb` действительно записаны в `translations/<lang>/...`.
2. **Проверьте `.gitignore`:** Не игнорируйте сгенерированные файлы. Убедитесь, что НЕ игнорируются:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (если переводите ноутбуки)
3. **Проверьте соответствие add-paths выходным файлам:** Используйте многострочное значение и включите обе папки, если нужно:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **Принудительно создайте PR для отладки:** Временно разрешите пустые коммиты, чтобы убедиться, что всё настроено правильно:
   ```yaml
   with:
     commit-empty: true
   ```
5. **Запустите с отладкой:** Добавьте `-d` к команде перевода, чтобы увидеть, какие файлы были найдены и записаны.
6. **Права доступа (GITHUB_TOKEN):** Убедитесь, что workflow имеет права на запись для создания коммитов и PR:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```

## Краткий чек-лист для отладки

При устранении проблем с переводом:

1. **Используйте режим отладки:** Добавьте флаг `-d` для подробных логов
2. **Проверьте флаги:** Убедитесь, что `-md`, `-img`, `-nb` соответствуют вашим задачам
3. **Проверьте конфигурацию:** Убедитесь, что в `.env` есть необходимые ключи
4. **Тестируйте поэтапно:** Начните с `-md`, затем добавляйте другие типы
5. **Проверьте структуру файлов:** Убедитесь, что исходные файлы существуют и доступны

Для подробной информации о доступных командах и флагах смотрите [Command Reference](./command-reference.md).

---

**Отказ от ответственности**:
Этот документ был переведен с помощью сервиса автоматического перевода [Co-op Translator](https://github.com/Azure/co-op-translator). Несмотря на стремление к точности, автоматические переводы могут содержать ошибки или неточности. Оригинальный документ на исходном языке следует считать авторитетным источником. Для получения критически важной информации рекомендуется использовать профессиональный человеческий перевод. Мы не несём ответственности за любые недоразумения или неправильные толкования, возникшие в результате использования данного перевода.