<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "822238e4451d04bb152cebb1be6f13c2",
  "translation_date": "2025-11-30T09:53:46+00:00",
  "source_file": "getting_started/command-reference.md",
  "language_code": "ru"
}
-->
# Справочник команд

CLI **Co-op Translator** предлагает несколько опций для настройки процесса перевода:

Команда                                      | Описание
---------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
translate -l "language_codes"                | Переводит ваш проект на указанные языки. Пример: translate -l "es fr de" переводит на испанский, французский и немецкий. Используйте translate -l "all" для перевода на все поддерживаемые языки.
translate -l "language_codes" -u             | Обновляет переводы, удаляя существующие и создавая их заново. Внимание: это удалит все текущие переводы для указанных языков.
translate -l "language_codes" -img           | Переводит только файлы изображений.
translate -l "language_codes" -md            | Переводит только Markdown-файлы.
translate -l "language_codes" -nb            | Переводит только Jupyter notebook файлы (.ipynb).
translate -l "language_codes" --fix          | Повторно переводит файлы с низкими оценками уверенности на основе предыдущих результатов оценки.
translate -l "language_codes" -d              | Включает режим отладки для подробного логирования.
translate -l "language_codes" --save-logs, -s | Сохраняет логи уровня DEBUG в файлы в <root_dir>/logs/ (консоль управляется опцией -d)
translate -l "language_codes" -r "root_dir"  | Указывает корневую директорию проекта
translate -l "language_codes" -f              | Использует быстрый режим для перевода изображений (до 3 раз быстрее, с небольшим снижением качества и выравнивания).
translate -l "language_codes" -y              | Автоматически подтверждает все запросы (удобно для CI/CD пайплайнов)
translate -l "language_codes" --add-disclaimer/--no-disclaimer | Включает или отключает добавление раздела с предупреждением о машинном переводе в переведённые markdown и ноутбуки (по умолчанию включено).
translate -l "language_codes" --help          | Показать справку с доступными командами в CLI
evaluate -l "language_code"                   | Оценивает качество перевода для конкретного языка и предоставляет оценки уверенности
evaluate -l "language_code" -c 0.8            | Оценивает переводы с пользовательским порогом уверенности
evaluate -l "language_code" -f                | Быстрая оценка (только на основе правил, без LLM)
evaluate -l "language_code" -D                | Глубокая оценка (только на основе LLM, более тщательная, но медленнее)
evaluate -l "language_code" --save-logs, -s   | Сохраняет логи уровня DEBUG в файлы в <root_dir>/logs/
migrate-links -l "language_codes"             | Повторно обрабатывает переведённые Markdown-файлы для обновления ссылок на ноутбуки (.ipynb). Предпочитает переведённые ноутбуки, если они доступны; иначе может использовать оригинальные.
migrate-links -l "language_codes" -r          | Указывает корневую директорию проекта (по умолчанию: текущая директория).
migrate-links -l "language_codes" --dry-run   | Показывает, какие файлы будут изменены, без записи изменений.
migrate-links -l "language_codes" --no-fallback-to-original | Не переписывать ссылки на оригинальные ноутбуки, если переведённые отсутствуют (обновлять только при наличии переведённых).
migrate-links -l "language_codes" -d          | Включает режим отладки для подробного логирования.
migrate-links -l "language_codes" --save-logs, -s | Сохраняет логи уровня DEBUG в файлы в <root_dir>/logs/
migrate-links -l "all" -y                      | Обрабатывает все языки и автоматически подтверждает предупреждающий запрос.

## Примеры использования

  1. Поведение по умолчанию (добавить новые переводы без удаления существующих):   translate -l "ko"    translate -l "es fr de" -r "./my_project"

  2. Добавить только новые переводы изображений на корейский (существующие переводы не удаляются):    translate -l "ko" -img

  3. Обновить все корейские переводы (Внимание: это удалит все существующие корейские переводы перед повторным переводом):    translate -l "ko" -u

  4. Обновить только корейские изображения (Внимание: это удалит все существующие корейские изображения перед повторным переводом):    translate -l "ko" -img -u

  5. Добавить новые переводы markdown для корейского без изменения других переводов:    translate -l "ko" -md

  6. Исправить переводы с низкой уверенностью на основе предыдущих результатов оценки: translate -l "ko" --fix

  7. Исправить переводы с низкой уверенностью только для определённых файлов (markdown): translate -l "ko" --fix -md

  8. Исправить переводы с низкой уверенностью только для определённых файлов (изображения): translate -l "ko" --fix -img

  9. Использовать быстрый режим для перевода изображений:    translate -l "ko" -img -f

  10. Исправить переводы с низкой уверенностью с пользовательским порогом: translate -l "ko" --fix -c 0.8

  11. Пример режима отладки: - translate -l "ko" -d: Включить логирование отладки.
  12. Сохранить логи в файлы: translate -l "ko" -s
  13. DEBUG в консоли и в файлах: translate -l "ko" -d -s
  14. Перевод без добавления предупреждений о машинном переводе: translate -l "ko" --no-disclaimer

  15. Миграция ссылок на ноутбуки для корейских переводов (обновить ссылки на переведённые ноутбуки, если доступны):    migrate-links -l "ko"

  15. Миграция ссылок с dry-run (без записи изменений):    migrate-links -l "ko" --dry-run

  16. Обновлять ссылки только если переведённые ноутбуки существуют (не использовать оригиналы):    migrate-links -l "ko" --no-fallback-to-original

  17. Обработать все языки с запросом подтверждения:    migrate-links -l "all"

  18. Обработать все языки и автоматически подтвердить:    migrate-links -l "all" -y
  19. Сохранить логи в файлы для migrate-links:    migrate-links -l "ko ja" -s

### Примеры оценки

> [!WARNING]  
> **Бета-функция**: Функция оценки находится в стадии бета. Эта возможность была выпущена для оценки переведённых документов, методы оценки и подробная реализация всё ещё разрабатываются и могут измениться.

  1. Оценить корейские переводы: evaluate -l "ko"

  2. Оценить с пользовательским порогом уверенности: evaluate -l "ko" -c 0.8

  3. Быстрая оценка (только на основе правил): evaluate -l "ko" -f

  4. Глубокая оценка (только на основе LLM): evaluate -l "ko" -D

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Отказ от ответственности**:  
Этот документ был переведен с помощью сервиса автоматического перевода [Co-op Translator](https://github.com/Azure/co-op-translator). Несмотря на наши усилия по обеспечению точности, имейте в виду, что автоматический перевод может содержать ошибки или неточности. Оригинальный документ на его исходном языке следует считать авторитетным источником. Для получения критически важной информации рекомендуется использовать профессиональный перевод, выполненный человеком. Мы не несем ответственности за любые недоразумения или неправильные толкования, возникшие в результате использования данного перевода.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->