<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:16:05+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "ru"
}
-->
# Перевод вашего проекта с помощью Co-op Translator

**Co-op Translator** — это инструмент командной строки (CLI), который помогает переводить файлы markdown и изображения в вашем проекте на несколько языков. В этом разделе объясняется, как пользоваться инструментом, описываются различные параметры CLI и приводятся примеры для разных сценариев использования.

> [!NOTE]
> Полный список команд и их подробные описания смотрите в разделе [Справочник команд](./command-reference.md).

---

## Примеры сценариев и команд

Вот несколько типичных случаев использования **Co-op Translator** с соответствующими командами.

### 1. Базовый перевод (один язык)

Чтобы перевести весь ваш проект (файлы markdown и изображения) на один язык, например, корейский, используйте следующую команду:

```bash
translate -l "ko"
```

Эта команда переведет все файлы markdown и изображения на корейский язык, добавив новые переводы, не удаляя существующие.

> [!TIP]
>
> Хотите узнать, какие языковые коды доступны в **Co-op Translator**? Посетите раздел [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) в репозитории для подробностей.

#### Пример на Phi-3 CookBook

В **Phi-3 CookBook** я использовал следующий способ для добавления корейского перевода к существующим файлам markdown и изображениям.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. Перевод на несколько языков

Чтобы перевести ваш проект на несколько языков (например, испанский, французский и немецкий), используйте эту команду:

```bash
translate -l "es fr de"
```

Эта команда переведет проект на испанский, французский и немецкий языки, добавив новые переводы, не перезаписывая существующие.

#### Пример на Phi-3 CookBook

В **Phi-3 CookBook** после получения последних изменений для актуализации коммитов я использовал следующий способ для перевода недавно добавленных файлов markdown и изображений.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> Обычно рекомендуется переводить по одному языку за раз, но в таких случаях, когда нужно добавить конкретные изменения, перевод на несколько языков одновременно может быть эффективным.

### 3. Обновление переводов (удаляет существующие переводы)

Чтобы обновить существующие переводы (то есть удалить текущие переводы и заменить их новыми), используйте опцию `-u`. Она удалит все существующие переводы для указанных языков и выполнит повторный перевод.

```bash
translate -l "ko" -u
```

Внимание: Эта команда запросит подтверждение перед удалением существующих переводов.

#### Пример на Phi-3 CookBook

В **Phi-3 CookBook** я использовал следующий способ для обновления всех переведенных файлов на испанском языке. Рекомендую использовать этот метод, если в оригинальном содержимом произошло много изменений сразу в нескольких документах markdown. Если нужно обновить только несколько переведенных файлов markdown, проще вручную удалить эти файлы и затем использовать метод `-a` для добавления обновленных переводов.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. Перевод только изображений

Чтобы перевести только файлы изображений в вашем проекте, используйте опцию `-img`:

```bash
translate -l "ko" -img
```

Эта команда переведет только изображения на корейский язык, не затрагивая файлы markdown.

### 6. Перевод только файлов Markdown

Чтобы перевести только файлы markdown в вашем проекте, используйте опцию `-md`:

```bash
translate -l "ko" -md
```

#### Пример на Phi-3 CookBook

В **Phi-3 CookBook** я использовал следующий способ для проверки ошибок перевода в корейских файлах и автоматического повторного перевода файлов с обнаруженными проблемами.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

Эта опция проверяет наличие ошибок перевода. В настоящее время, если разница в переносах строк между оригинальным и переведенным файлом превышает шесть, файл помечается как содержащий ошибку перевода. В будущем я планирую сделать этот критерий более гибким.

Например, этот способ полезен для обнаружения пропущенных фрагментов или поврежденных переводов, и он автоматически повторно переводит такие файлы.

Однако если вы уже знаете, какие файлы проблемные, проще вручную удалить эти файлы и использовать опцию `-a` для их повторного перевода.

### 8. Режим отладки

Чтобы включить подробное логирование для поиска и устранения ошибок, используйте опцию `-d`:

```bash
translate -l "ko" -d
```

Эта команда запустит перевод в режиме отладки, предоставляя дополнительную информацию в логах, которая поможет выявить проблемы в процессе перевода.

#### Пример на Phi-3 CookBook

В **Phi-3 CookBook** я столкнулся с проблемой, когда переводы файлов markdown с большим количеством ссылок приводили к ошибкам форматирования, например, к поврежденным переводам и игнорированию переносов строк. Чтобы диагностировать эту проблему, я использовал опцию `-d`, чтобы посмотреть, как работает процесс перевода.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. Перевод на все языки

Если вы хотите перевести проект на все поддерживаемые языки, используйте ключевое слово all.

> [!WARNING]
> Перевод на все языки сразу может занять много времени в зависимости от размера проекта. Например, перевод **Phi-3 CookBook** на испанский занял около 2 часов. С учетом масштаба одному человеку нецелесообразно переводить на 20 языков. Рекомендуется разделить работу между несколькими участниками, чтобы каждый отвечал за один-два языка, и постепенно обновлять переводы.

```bash
translate -l "all"
```

Эта команда переведет проект на все доступные языки. Если вы продолжите, перевод может занять много времени в зависимости от размера проекта.

> [!TIP]
>
> ### Ручное удаление переведенных файлов (опционально)
> Переведенные файлы теперь автоматически обнаруживаются и очищаются при обновлении исходного файла.
>
> Однако если вы хотите вручную обновить перевод — например, чтобы повторно перевести конкретный файл или переопределить поведение системы — вы можете использовать следующую команду для удаления всех версий файла во всех языковых папках.
>
> ### В Windows:
> 1. **Через командную строку**:
>    - Откройте командную строку.
>    - Перейдите в папку с файлами с помощью команды `cd`.
>    - Используйте следующую команду для удаления файлов:
>      ```
>      del /s *filename*
>      ```
>      Замените `filename` на нужную часть имени файла. Опция `/s` ищет в подкаталогах.
>
> 2. **Через PowerShell**:
>    - Откройте PowerShell.
>    - Выполните команду:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      Замените `"C:\YourPath"` на путь к папке, а `filename` — на нужное имя.
>
> ### В macOS/Linux:
> 1. **Через терминал**:
>   - Откройте терминал.
>   - Перейдите в нужную директорию с помощью `cd`.
>   - Используйте команду `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     Замените `filename` на нужное имя.
>
> Всегда внимательно проверяйте файлы перед удалением, чтобы избежать случайной потери данных.
>
> После удаления файлов, которые нужно заменить, просто повторно выполните вашу команду `translate -l`, чтобы обновить последние изменения в файлах.

---

**Отказ от ответственности**:
Этот документ был переведен с помощью сервиса автоматического перевода [Co-op Translator](https://github.com/Azure/co-op-translator). Несмотря на стремление к точности, автоматические переводы могут содержать ошибки или неточности. Оригинальный документ на исходном языке следует считать авторитетным источником. Для получения критически важной информации рекомендуется профессиональный перевод человеком. Мы не несём ответственности за любые недоразумения или неправильные толкования, возникшие в результате использования данного перевода.