<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T02:15:59+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "ru"
}
-->
# Установка пакета Co-op Translator

**Co-op Translator** — это инструмент командной строки (CLI), который помогает переводить все ваши markdown-файлы и изображения в проекте на разные языки. В этом руководстве вы узнаете, как настроить переводчик и использовать его для различных задач.

### Создание виртуального окружения

Виртуальное окружение можно создать с помощью `pip` или `Poetry`. Введите одну из следующих команд в терминале.

#### С помощью pip

```bash
python -m venv .venv
```

#### С помощью Poetry

```bash
poetry init
```

### Активация виртуального окружения

После создания виртуального окружения его нужно активировать. Шаги зависят от вашей операционной системы. Введите следующую команду в терминале.

#### Для pip и Poetry

- Windows:

    ```bash
    .venv\Scripts\activate
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### С помощью Poetry

1. Если вы создали окружение с помощью Poetry, введите следующую команду в терминале для активации.

    ```bash
    poetry shell
    ```

### Установка пакета и необходимых зависимостей

Когда виртуальное окружение создано и активировано, следующим шагом будет установка нужных зависимостей.

### Быстрая установка

Установите Co-Op Translator через pip

```
pip install co-op-translator
```
Или

Установите через poetry
```
poetry add co-op-translator
```

#### С помощью pip (из requirements.txt), если вы клонировали этот репозиторий

> [!NOTE]
> Не делайте это, если вы устанавливаете co-op translator через быструю установку.

1. Если вы используете pip, введите следующую команду в терминале. Она автоматически установит необходимые пакеты, указанные в файле `requirements.txt`:

    ```bash
    pip install -r requirements.txt
    ```

#### С помощью Poetry (из pyproject.toml)

1. Если вы используете Poetry, введите следующую команду в терминале. Она автоматически установит необходимые пакеты, указанные в файле `pyproject.toml`:

    ```bash
    poetry install
    ```

---

**Отказ от ответственности**:
Этот документ был переведен с помощью сервиса автоматического перевода [Co-op Translator](https://github.com/Azure/co-op-translator). Несмотря на стремление к точности, автоматические переводы могут содержать ошибки или неточности. Оригинальный документ на исходном языке следует считать авторитетным источником. Для получения критически важной информации рекомендуется использовать профессиональный человеческий перевод. Мы не несём ответственности за любые недоразумения или неправильные толкования, возникшие в результате использования данного перевода.