<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T09:52:23+00:00",
  "source_file": "README.md",
  "language_code": "ru"
}
-->
# Co-op Translator

_Легко автоматизируйте перевод вашего образовательного контента на GitHub на несколько языков, чтобы охватить глобальную аудиторию._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 Поддержка нескольких языков

#### Поддерживается [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[Арабский](../ar/README.md) | [Бенгальский](../bn/README.md) | [Болгарский](../bg/README.md) | [Бирманский (Мьянма)](../my/README.md) | [Китайский (упрощённый)](../zh/README.md) | [Китайский (традиционный, Гонконг)](../hk/README.md) | [Китайский (традиционный, Макао)](../mo/README.md) | [Китайский (традиционный, Тайвань)](../tw/README.md) | [Хорватский](../hr/README.md) | [Чешский](../cs/README.md) | [Датский](../da/README.md) | [Нидерландский](../nl/README.md) | [Эстонский](../et/README.md) | [Финский](../fi/README.md) | [Французский](../fr/README.md) | [Немецкий](../de/README.md) | [Греческий](../el/README.md) | [Иврит](../he/README.md) | [Хинди](../hi/README.md) | [Венгерский](../hu/README.md) | [Индонезийский](../id/README.md) | [Итальянский](../it/README.md) | [Японский](../ja/README.md) | [Каннада](../kn/README.md) | [Корейский](../ko/README.md) | [Литовский](../lt/README.md) | [Малайский](../ms/README.md) | [Малаялам](../ml/README.md) | [Маратхи](../mr/README.md) | [Непальский](../ne/README.md) | [Нигерийский пиджин](../pcm/README.md) | [Норвежский](../no/README.md) | [Персидский (фарси)](../fa/README.md) | [Польский](../pl/README.md) | [Португальский (Бразилия)](../br/README.md) | [Португальский (Португалия)](../pt/README.md) | [Панджаби (гурмукхи)](../pa/README.md) | [Румынский](../ro/README.md) | [Русский](./README.md) | [Сербский (кириллица)](../sr/README.md) | [Словацкий](../sk/README.md) | [Словенский](../sl/README.md) | [Испанский](../es/README.md) | [Суахили](../sw/README.md) | [Шведский](../sv/README.md) | [Тагалог (филиппинский)](../tl/README.md) | [Тамильский](../ta/README.md) | [Телугу](../te/README.md) | [Тайский](../th/README.md) | [Турецкий](../tr/README.md) | [Украинский](../uk/README.md) | [Урду](../ur/README.md) | [Вьетнамский](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## Обзор

**Co-op Translator** помогает легко локализовать ваш образовательный контент на GitHub на несколько языков.  
Когда вы обновляете Markdown-файлы, изображения или ноутбуки, переводы автоматически синхронизируются, обеспечивая актуальность и точность контента для обучающихся по всему миру.

Пример организации переведённого контента:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.ru.png)

## Быстрый старт

```bash
# Создайте и активируйте виртуальное окружение (рекомендуется)
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Установите пакет
pip install co-op-translator
# Перевести
translate -l "ko ja fr" -md
```

Docker:

```bash
# Загрузить публичный образ из GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# Запустить с текущей папкой, смонтированной и с предоставленным .env (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## Минимальная настройка

1. Создайте файл `.env` на основе шаблона: [.env.template](../../.env.template)  
2. Настройте одного из провайдеров LLM (Azure OpenAI или OpenAI)  
3. (Опционально) Для перевода изображений (`-img`) настройте Azure AI Vision  
4. (Рекомендуется) Очистите предыдущие переводы, чтобы избежать конфликтов (например, папку `translations/`)  
5. (Рекомендуется) Добавьте раздел с переводами в ваш README, используя [шаблон языков README](./getting_started/README_languages_template.md)  
6. См. также: [Настройка Azure AI](./getting_started/set-up-azure-ai.md)

## Использование

Перевести все поддерживаемые типы:

```bash
translate -l "ko ja"
```

Только Markdown:

```bash
translate -l "de" -md
```

Markdown + изображения:

```bash
translate -l "pt" -md -img
```

Только ноутбуки:

```bash
translate -l "zh" -nb
```

Дополнительные флаги: [Справочник команд](./getting_started/command-reference.md)

## Возможности

- Автоматический перевод Markdown, ноутбуков и изображений  
- Поддержание синхронизации переводов с исходным контентом  
- Работает локально (CLI) или в CI (GitHub Actions)  
- Использует Azure OpenAI или OpenAI; опционально Azure AI Vision для изображений  
- Сохраняет форматирование и структуру Markdown

## Документация

- [Руководство по командной строке](./getting_started/command-line-guide/command-line-guide.md)  
- [Руководство по GitHub Actions (публичные репозитории и стандартные секреты)](./getting_started/github-actions-guide/github-actions-guide-public.md)  
- [Руководство по GitHub Actions (репозитории Microsoft и настройки на уровне организации)](./getting_started/github-actions-guide/github-actions-guide-org.md)  
- [Шаблон языков для README](./getting_started/README_languages_template.md)  
- [Поддерживаемые языки](./getting_started/supported-languages.md)  
- [Вклад в проект](./CONTRIBUTING.md)  
- [Устранение неполадок](./getting_started/troubleshooting.md)

### Руководство для Microsoft
> [!NOTE]
> Только для поддерживающих репозитории Microsoft “Для начинающих”.

- [Обновление списка «других курсов» (только для репозиториев MS Beginners)](./getting_started/update-other-courses.md)

## Поддержите нас и способствуйте глобальному обучению

Присоединяйтесь к нам в революции обмена образовательным контентом по всему миру! Поставьте ⭐ [Co-op Translator](https://github.com/azure/co-op-translator) на GitHub и поддержите нашу миссию по устранению языковых барьеров в обучении и технологиях. Ваш интерес и вклад имеют большое значение! Мы всегда рады вашим предложениям и коду.

### Изучайте образовательный контент Microsoft на вашем языке

- [AZD для начинающих](https://github.com/microsoft/AZD-for-beginners)  
- [Edge AI для начинающих](https://github.com/microsoft/edgeai-for-beginners)  
- [Model Context Protocol (MCP) для начинающих](https://github.com/microsoft/mcp-for-beginners)  
- [AI Agents для начинающих](https://github.com/microsoft/ai-agents-for-beginners)  
- [Generative AI для начинающих на .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)  
- [Generative AI для начинающих](https://github.com/microsoft/generative-ai-for-beginners)  
- [Generative AI для начинающих на Java](https://github.com/microsoft/generative-ai-for-beginners-java)  
- [ML для начинающих](https://aka.ms/ml-beginners)  
- [Data Science для начинающих](https://aka.ms/datascience-beginners)  
- [AI для начинающих](https://aka.ms/ai-beginners)  
- [Кибербезопасность для начинающих](https://github.com/microsoft/Security-101)  
- [Веб-разработка для начинающих](https://aka.ms/webdev-beginners)  
- [IoT для начинающих](https://aka.ms/iot-beginners)  
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## Видеопрезентации

👉 Нажмите на изображение ниже, чтобы посмотреть на YouTube.

- **Open at Microsoft**: Краткое 18-минутное введение и быстрое руководство по использованию Co-op Translator.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.ru.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## Вклад в проект

Этот проект приветствует ваши предложения и участие. Хотите помочь развитию Azure Co-op Translator? Ознакомьтесь с нашим [CONTRIBUTING.md](./CONTRIBUTING.md) для инструкций о том, как сделать Co-op Translator более доступным.

## Участники проекта

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## Кодекс поведения

В этом проекте принят [Кодекс поведения Microsoft Open Source](https://opensource.microsoft.com/codeofconduct/).  
Для дополнительной информации смотрите [FAQ по Кодексу поведения](https://opensource.microsoft.com/codeofconduct/faq/) или  
свяжитесь с нами по адресу [opencode@microsoft.com](mailto:opencode@microsoft.com) для любых вопросов или комментариев.

## Ответственный ИИ

Microsoft стремится помогать клиентам ответственно использовать наши продукты ИИ, делиться опытом и строить доверительные партнерства с помощью таких инструментов, как Transparency Notes и Impact Assessments. Многие из этих ресурсов доступны по адресу [https://aka.ms/RAI](https://aka.ms/RAI).  
Подход Microsoft к ответственному ИИ основан на принципах справедливости, надежности и безопасности, конфиденциальности и безопасности, инклюзивности, прозрачности и подотчетности.

Крупномасштабные модели обработки естественного языка, изображений и речи — такие, как используемые в этом примере — могут иногда вести себя несправедливо, ненадежно или оскорбительно, что может привести к негативным последствиям. Пожалуйста, ознакомьтесь с [Transparency note сервиса Azure OpenAI](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text), чтобы быть в курсе рисков и ограничений.
Рекомендуемый подход к снижению этих рисков — включить в архитектуру систему безопасности, которая может обнаруживать и предотвращать вредоносное поведение. [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) предоставляет независимый уровень защиты, способный выявлять вредоносный контент, созданный пользователями и ИИ, в приложениях и сервисах. Azure AI Content Safety включает API для текста и изображений, которые позволяют обнаруживать вредоносный материал. Также у нас есть интерактивная Content Safety Studio, которая позволяет просматривать, исследовать и пробовать пример кода для обнаружения вредоносного контента в разных модальностях. Следующая [документация по быстрому старту](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) проведет вас через процесс отправки запросов к сервису.

Еще один аспект, который следует учитывать — общая производительность приложения. В много-модальных и много-модельных приложениях под производительностью понимается то, что система работает так, как вы и ваши пользователи ожидаете, включая отсутствие генерации вредоносных результатов. Важно оценивать производительность вашего приложения в целом с помощью [метрик качества генерации, риска и безопасности](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in).

Вы можете оценить ваше AI-приложение в среде разработки с помощью [prompt flow SDK](https://microsoft.github.io/promptflow/index.html). Имея тестовый набор данных или целевой результат, генерации вашего генеративного AI-приложения количественно измеряются с помощью встроенных или пользовательских оценщиков по вашему выбору. Чтобы начать работу с prompt flow sdk для оценки вашей системы, вы можете следовать [руководству по быстрому старту](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk). После выполнения оценки вы можете [визуализировать результаты в Azure AI Studio](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## Торговые марки

Этот проект может содержать торговые марки или логотипы проектов, продуктов или сервисов. Авторизованное использование торговых марок или логотипов Microsoft подчиняется и должно соответствовать [Руководству по торговым маркам и брендам Microsoft](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general). Использование торговых марок или логотипов Microsoft в изменённых версиях этого проекта не должно вызывать путаницу или подразумевать спонсорство Microsoft. Любое использование торговых марок или логотипов третьих сторон подчиняется политикам этих третьих сторон.

## Получение помощи

Если вы застряли или у вас есть вопросы по созданию AI-приложений, присоединяйтесь к:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

Если у вас есть отзывы о продукте или ошибки при разработке, посетите:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Отказ от ответственности**:  
Этот документ был переведен с помощью сервиса автоматического перевода [Co-op Translator](https://github.com/Azure/co-op-translator). Несмотря на наши усилия обеспечить точность, имейте в виду, что автоматические переводы могут содержать ошибки или неточности. Оригинальный документ на его исходном языке следует считать авторитетным источником. Для получения критически важной информации рекомендуется профессиональный перевод человеком. Мы не несем ответственности за любые недоразумения или неправильные толкования, возникшие в результате использования данного перевода.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->