<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T09:51:48+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "ru"
}
-->
# Вклад в Co-op Translator

Этот проект приветствует вклад и предложения. Большинство вкладов требуют вашего согласия с
Лицензионным соглашением для участников (CLA), в котором вы подтверждаете, что имеете право и действительно предоставляете нам
права на использование вашего вклада. Для подробностей посетите https://cla.opensource.microsoft.com.

При отправке pull request, бот CLA автоматически определит, нужно ли вам предоставить
CLA, и отметит PR соответствующим образом (например, проверка статуса, комментарий). Просто следуйте инструкциям
бота. Вам нужно будет сделать это только один раз для всех репозиториев, использующих наш CLA.

## Настройка среды разработки

Для настройки среды разработки этого проекта мы рекомендуем использовать Poetry для управления зависимостями. Мы используем `pyproject.toml` для управления зависимостями проекта, поэтому для установки зависимостей следует использовать Poetry.

### Создание виртуального окружения

#### С помощью pip

```bash
python -m venv .venv
```

#### С помощью Poetry

```bash
poetry init
```

### Активация виртуального окружения

#### Для pip и Poetry

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### С помощью Poetry

```bash
poetry shell
```

### Установка пакета и необходимых зависимостей

#### С помощью Poetry (из pyproject.toml)

```bash
poetry install
```

### Ручное тестирование

Перед отправкой PR важно протестировать функциональность перевода на реальной документации:

1. Создайте тестовую папку в корневом каталоге:
    ```bash
    mkdir test_docs
    ```

2. Скопируйте в тестовую папку несколько markdown-документов и изображений, которые хотите перевести. Например:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. Установите пакет локально:
    ```bash
    pip install -e .
    ```

4. Запустите Co-op Translator на ваших тестовых документах:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. Проверьте переведённые файлы в `test_docs/translations` и `test_docs/translated_images`, чтобы убедиться:
   - В качестве перевода
   - В корректности комментариев с метаданными
   - В сохранении исходной структуры markdown
   - В правильной работе ссылок и изображений

Это ручное тестирование помогает убедиться, что ваши изменения хорошо работают в реальных условиях.

### Переменные окружения

1. Создайте файл `.env` в корневом каталоге, скопировав предоставленный файл `.env.template`.
1. Заполните переменные окружения согласно инструкциям.

> [!TIP]
>
> ### Дополнительные варианты настройки среды разработки
>
> Помимо локального запуска проекта, вы можете использовать GitHub Codespaces или VS Code Dev Containers для альтернативной настройки среды разработки.
>
> #### GitHub Codespaces
>
> Вы можете запускать эти примеры виртуально с помощью GitHub Codespaces без дополнительной настройки.
>
> Кнопка откроет веб-версию VS Code в вашем браузере:
>
> 1. Откройте шаблон (это может занять несколько минут):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### Локальный запуск с помощью VS Code Dev Containers
>
> ⚠️ Этот вариант работает только если Docker Desktop выделено не менее 16 ГБ оперативной памяти. Если у вас меньше 16 ГБ, попробуйте [GitHub Codespaces](../..) или [настройку локально](../..).
>
> Связанный вариант — VS Code Dev Containers, который откроет проект в вашем локальном VS Code с помощью [расширения Dev Containers](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers):
>
> 1. Запустите Docker Desktop (установите, если ещё не установлен)
> 2. Откройте проект:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### Стиль кода

Мы используем [Black](https://github.com/psf/black) как форматировщик Python-кода для поддержания единого стиля кода в проекте. Black — это бескомпромиссный форматировщик, который автоматически приводит Python-код к стилю Black.

#### Конфигурация

Конфигурация Black указана в нашем `pyproject.toml`:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Установка Black

Вы можете установить Black с помощью Poetry (рекомендуется) или pip:

##### С помощью Poetry

Black устанавливается автоматически при настройке среды разработки:
```bash
poetry install
```

##### С помощью pip

Если вы используете pip, Black можно установить напрямую:
```bash
pip install black
```

#### Использование Black

##### С Poetry

1. Отформатировать все Python-файлы в проекте:
    ```bash
    poetry run black .
    ```

2. Отформатировать конкретный файл или папку:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### С pip

1. Отформатировать все Python-файлы в проекте:
    ```bash
    black .
    ```

2. Отформатировать конкретный файл или папку:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> Рекомендуем настроить ваш редактор так, чтобы он автоматически форматировал код с помощью Black при сохранении. Большинство современных редакторов поддерживают это через расширения или плагины.

## Запуск Co-op Translator

Чтобы запустить Co-op Translator с помощью Poetry в вашей среде, выполните следующие шаги:

1. Перейдите в каталог, где хотите провести тесты перевода, или создайте временную папку для тестирования.

2. Выполните следующую команду. Замените `-l ko` на код языка, на который хотите перевести. Флаг `-d` включает режим отладки.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> Убедитесь, что ваша среда Poetry активирована (poetry shell) перед запуском команды.

## Добавление нового языка

Мы приветствуем вклад, добавляющий поддержку новых языков. Перед открытием PR выполните следующие шаги для упрощения проверки.

1. Добавьте язык в сопоставление шрифтов
   - Отредактируйте `src/co_op_translator/fonts/font_language_mappings.yml`
   - Добавьте запись с:
     - `code`: код языка в стиле ISO (например, `vi`)
     - `name`: удобочитаемое название
     - `font`: шрифт из `src/co_op_translator/fonts/`, поддерживающий данный алфавит
     - `rtl`: `true`, если язык пишется справа налево, иначе `false`

2. Добавьте необходимые файлы шрифтов (если нужно)
   - Если требуется новый шрифт, проверьте лицензию на совместимость с открытым исходным кодом
   - Добавьте файл шрифта в `src/co_op_translator/fonts/`

3. Локальная проверка
   - Запустите перевод небольшого примера (Markdown, изображения и ноутбуки по необходимости)
   - Проверьте корректность отображения, включая шрифты и RTL-верстку, если применимо

4. Обновите документацию
   - Убедитесь, что язык добавлен в `getting_started/supported-languages.md`
   - Изменения в `getting_started/README_languages_template.md` не требуются; он генерируется из списка поддерживаемых языков

5. Откройте PR
   - Опишите добавленный язык и особенности шрифтов/лицензирования
   - Прикрепите скриншоты результатов, если возможно

Пример записи в YAML:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### Тестирование нового языка

Вы можете протестировать новый язык, выполнив следующую команду:

```bash
# Создайте и активируйте виртуальное окружение
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Установите пакет для разработки
pip install -e .
# Запустите перевод
translate -l "new_lang"
```

## Поддерживающие проект

### Формат сообщений коммитов и стратегия слияния

Для обеспечения последовательности и ясности истории коммитов в проекте мы используем определённый формат сообщений коммитов **для итогового сообщения коммита** при использовании стратегии **Squash and Merge**.

При слиянии pull request (PR) отдельные коммиты объединяются в один. Итоговое сообщение коммита должно соответствовать формату ниже для поддержания чистой и последовательной истории.

#### Формат сообщения коммита (для squash and merge)

Мы используем следующий формат сообщений коммитов:

```bash
<type>: <description> (#<номер PR>)
```

- **type**: Категория коммита. Используем следующие типы:
  - `Docs`: для обновлений документации.
  - `Build`: для изменений, связанных со сборкой или зависимостями, включая обновления конфигураций, CI-процессов или Dockerfile.
  - `Core`: для изменений в основной функциональности проекта, особенно в файлах из `src/co_op_translator/core`.

- **description**: Краткое описание изменений.
- **PR number**: Номер pull request, связанного с коммитом.

**Примеры**:

- `Docs: Обновить инструкции по установке для ясности (#50)`
- `Core: Улучшить обработку перевода изображений (#60)`

> [!NOTE]
> В настоящее время префиксы **`Docs`**, **`Core`** и **`Build`** автоматически добавляются к заголовкам PR на основе меток, применённых к изменённому коду. Если метка применена правильно, обычно не нужно вручную менять заголовок PR. Просто убедитесь, что всё корректно и префикс сгенерирован.

#### Стратегия слияния

Мы используем **Squash and Merge** как стандартную стратегию для pull request. Эта стратегия гарантирует, что сообщения коммитов соответствуют нашему формату, даже если отдельные коммиты — нет.

**Причины**:

- Чистая, линейная история проекта.
- Последовательность сообщений коммитов.
- Меньше шума от мелких коммитов (например, "исправить опечатку").

При слиянии убедитесь, что итоговое сообщение коммита соответствует описанному формату.

**Пример Squash and Merge**
Если PR содержит коммиты:

- `fix typo`
- `update README`
- `adjust formatting`

Они должны быть объединены в:
`Docs: Улучшить ясность и форматирование документации (#65)`

### Процесс выпуска релиза

В этом разделе описан самый простой способ для поддерживающих проект опубликовать новый релиз Co-op Translator.

#### 1. Обновление версии в `pyproject.toml`

1. Определите следующий номер версии (мы используем семантическое версионирование: `MAJOR.MINOR.PATCH`).
2. Отредактируйте `pyproject.toml`, обновив поле `version` в разделе `[tool.poetry]`.
3. Откройте отдельный pull request, который изменяет только версию (и любые автоматически обновляемые lock/метаданные, если есть).
4. После проверки используйте **Squash and Merge** и убедитесь, что итоговое сообщение коммита соответствует описанному формату.

#### 2. Создание релиза на GitHub

1. Перейдите на страницу репозитория на GitHub и откройте **Releases** → **Draft a new release**.
2. Создайте новый тег (например, `v0.13.0`) на основе ветки `main`.
3. Установите заголовок релиза такой же, как версия (например, `v0.13.0`).
4. Нажмите **Generate release notes** для автоматического заполнения журнала изменений.
5. При необходимости отредактируйте текст (например, чтобы выделить новые поддерживаемые языки или важные изменения).
6. Опубликуйте релиз.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Отказ от ответственности**:  
Этот документ был переведен с помощью сервиса автоматического перевода [Co-op Translator](https://github.com/Azure/co-op-translator). Несмотря на наши усилия по обеспечению точности, имейте в виду, что автоматические переводы могут содержать ошибки или неточности. Оригинальный документ на его исходном языке следует считать авторитетным источником. Для получения критически важной информации рекомендуется использовать профессиональный перевод, выполненный человеком. Мы не несем ответственности за любые недоразумения или неправильные толкования, возникшие в результате использования данного перевода.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->