<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T10:45:55+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "pa"
}
-->
# ਕੋ-ਆਪ ਟ੍ਰਾਂਸਲੇਟਰ ਵਿੱਚ ਯੋਗਦਾਨ ਪਾਉਣਾ

ਇਹ ਪ੍ਰੋਜੈਕਟ ਯੋਗਦਾਨ ਅਤੇ ਸੁਝਾਵਾਂ ਦਾ ਸਵਾਗਤ ਕਰਦਾ ਹੈ। ਜ਼ਿਆਦਾਤਰ ਯੋਗਦਾਨਾਂ ਲਈ ਤੁਹਾਨੂੰ ਇੱਕ Contributor License Agreement (CLA) ਨਾਲ ਸਹਿਮਤ ਹੋਣਾ ਪੈਂਦਾ ਹੈ, ਜਿਸ ਵਿੱਚ ਤੁਸੀਂ ਇਹ ਘੋਸ਼ਣਾ ਕਰਦੇ ਹੋ ਕਿ ਤੁਹਾਡੇ ਕੋਲ ਆਪਣੇ ਯੋਗਦਾਨ ਦੇ ਉਪਯੋਗ ਦੇ ਹੱਕ ਹਨ ਅਤੇ ਤੁਸੀਂ ਸਾਨੂੰ ਉਹ ਹੱਕ ਦਿੰਦੇ ਹੋ। ਵਿਸਥਾਰ ਲਈ, https://cla.opensource.microsoft.com ਵੇਖੋ।

ਜਦੋਂ ਤੁਸੀਂ ਇੱਕ ਪੁਲ ਰਿਕਵੇਸਟ (PR) ਸਬਮਿਟ ਕਰਦੇ ਹੋ, ਤਾਂ CLA ਬੋਟ ਆਪਣੇ ਆਪ ਇਹ ਨਿਰਧਾਰਤ ਕਰੇਗਾ ਕਿ ਤੁਹਾਨੂੰ CLA ਦੇਣੀ ਲੋੜ ਹੈ ਜਾਂ ਨਹੀਂ ਅਤੇ PR ਨੂੰ ਢੰਗ ਨਾਲ ਸਜਾਏਗਾ (ਜਿਵੇਂ ਕਿ ਸਥਿਤੀ ਜਾਂਚ, ਟਿੱਪਣੀ)। ਸਿਰਫ ਬੋਟ ਵੱਲੋਂ ਦਿੱਤੇ ਗਏ ਨਿਰਦੇਸ਼ਾਂ ਦੀ ਪਾਲਣਾ ਕਰੋ। ਤੁਹਾਨੂੰ ਸਿਰਫ ਇੱਕ ਵਾਰੀ ਸਾਰੇ ਰਿਪੋਜ਼ ਵਿੱਚ ਇਹ ਕਰਨਾ ਪਵੇਗਾ ਜਿਹੜੇ ਸਾਡੇ CLA ਦੀ ਵਰਤੋਂ ਕਰਦੇ ਹਨ।

## ਵਿਕਾਸ ਵਾਤਾਵਰਣ ਸੈਟਅਪ

ਇਸ ਪ੍ਰੋਜੈਕਟ ਲਈ ਵਿਕਾਸ ਵਾਤਾਵਰਣ ਸੈਟਅਪ ਕਰਨ ਲਈ, ਅਸੀਂ ਡਿਪੈਂਡੈਂਸੀਜ਼ ਦੇ ਪ੍ਰਬੰਧ ਲਈ Poetry ਦੀ ਸਿਫਾਰਸ਼ ਕਰਦੇ ਹਾਂ। ਅਸੀਂ ਪ੍ਰੋਜੈਕਟ ਡਿਪੈਂਡੈਂਸੀਜ਼ ਨੂੰ ਸੰਭਾਲਣ ਲਈ `pyproject.toml` ਦੀ ਵਰਤੋਂ ਕਰਦੇ ਹਾਂ, ਇਸ ਲਈ ਡਿਪੈਂਡੈਂਸੀਜ਼ ਇੰਸਟਾਲ ਕਰਨ ਲਈ ਤੁਹਾਨੂੰ Poetry ਦੀ ਵਰਤੋਂ ਕਰਨੀ ਚਾਹੀਦੀ ਹੈ।

### ਵਰਚੁਅਲ ਵਾਤਾਵਰਣ ਬਣਾਓ

#### pip ਦੀ ਵਰਤੋਂ ਕਰਕੇ

```bash
python -m venv .venv
```

#### Poetry ਦੀ ਵਰਤੋਂ ਕਰਕੇ

```bash
poetry init
```

### ਵਰਚੁਅਲ ਵਾਤਾਵਰਣ ਐਕਟੀਵੇਟ ਕਰੋ

#### pip ਅਤੇ Poetry ਦੋਹਾਂ ਲਈ

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry ਦੀ ਵਰਤੋਂ ਕਰਕੇ

```bash
poetry shell
```

### ਪੈਕੇਜ ਅਤੇ ਲੋੜੀਂਦੇ ਪੈਕੇਜ ਇੰਸਟਾਲ ਕਰਨਾ

#### Poetry ਦੀ ਵਰਤੋਂ ਕਰਕੇ (pyproject.toml ਤੋਂ)

```bash
poetry install
```

### ਮੈਨੂਅਲ ਟੈਸਟਿੰਗ

PR ਸਬਮਿਟ ਕਰਨ ਤੋਂ ਪਹਿਲਾਂ, ਅਸਲੀ ਡੌਕਯੂਮੈਂਟੇਸ਼ਨ ਨਾਲ ਅਨੁਵਾਦ ਫੰਕਸ਼ਨਾਲਿਟੀ ਦੀ ਜਾਂਚ ਕਰਨਾ ਜਰੂਰੀ ਹੈ:

1. ਰੂਟ ਡਾਇਰੈਕਟਰੀ ਵਿੱਚ ਇੱਕ ਟੈਸਟ ਡਾਇਰੈਕਟਰੀ ਬਣਾਓ:
    ```bash
    mkdir test_docs
    ```

2. ਕੁਝ ਮਾਰਕਡਾਊਨ ਡੌਕਯੂਮੈਂਟੇਸ਼ਨ ਅਤੇ ਚਿੱਤਰ ਜੋ ਤੁਸੀਂ ਅਨੁਵਾਦ ਕਰਨਾ ਚਾਹੁੰਦੇ ਹੋ, ਟੈਸਟ ਡਾਇਰੈਕਟਰੀ ਵਿੱਚ ਕਾਪੀ ਕਰੋ। ਉਦਾਹਰਨ ਵਜੋਂ:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. ਪੈਕੇਜ ਨੂੰ ਲੋਕਲ ਤੌਰ 'ਤੇ ਇੰਸਟਾਲ ਕਰੋ:
    ```bash
    pip install -e .
    ```

4. ਆਪਣੇ ਟੈਸਟ ਦਸਤਾਵੇਜ਼ਾਂ 'ਤੇ ਕੋ-ਆਪ ਟ੍ਰਾਂਸਲੇਟਰ ਚਲਾਓ:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` ਅਤੇ `test_docs/translated_images` ਵਿੱਚ ਅਨੁਵਾਦਿਤ ਫਾਈਲਾਂ ਦੀ ਜਾਂਚ ਕਰੋ:
   - ਅਨੁਵਾਦ ਦੀ ਗੁਣਵੱਤਾ
   - ਮੈਟਾਡੇਟਾ ਟਿੱਪਣੀਆਂ ਸਹੀ ਹਨ
   - ਮੂਲ ਮਾਰਕਡਾਊਨ ਢਾਂਚਾ ਬਰਕਰਾਰ ਹੈ
   - ਲਿੰਕ ਅਤੇ ਚਿੱਤਰ ਠੀਕ ਕੰਮ ਕਰ ਰਹੇ ਹਨ

ਇਹ ਮੈਨੂਅਲ ਟੈਸਟਿੰਗ ਇਹ ਯਕੀਨੀ ਬਣਾਉਂਦੀ ਹੈ ਕਿ ਤੁਹਾਡੇ ਬਦਲਾਅ ਅਸਲੀ ਦੁਨੀਆ ਦੇ ਸੰਦਰਭ ਵਿੱਚ ਚੰਗੀ ਤਰ੍ਹਾਂ ਕੰਮ ਕਰਦੇ ਹਨ।

### ਵਾਤਾਵਰਣ ਵੈਰੀਏਬਲ

1. ਰੂਟ ਡਾਇਰੈਕਟਰੀ ਵਿੱਚ `.env` ਫਾਈਲ ਬਣਾਓ, ਦਿੱਤੀ ਗਈ `.env.template` ਫਾਈਲ ਨੂੰ ਕਾਪੀ ਕਰਕੇ।
1. ਵਾਤਾਵਰਣ ਵੈਰੀਏਬਲ ਨੂੰ ਦਿਓ ਗਈ ਹਦਾਇਤਾਂ ਅਨੁਸਾਰ ਭਰੋ।

> [!TIP]
>
> ### ਵਾਧੂ ਵਿਕਾਸ ਵਾਤਾਵਰਣ ਵਿਕਲਪ
>
> ਪ੍ਰੋਜੈਕਟ ਨੂੰ ਲੋਕਲ ਤੌਰ 'ਤੇ ਚਲਾਉਣ ਦੇ ਇਲਾਵਾ, ਤੁਸੀਂ ਵਿਕਲਾਸ ਵਾਤਾਵਰਣ ਸੈਟਅਪ ਲਈ GitHub Codespaces ਜਾਂ VS Code Dev Containers ਦੀ ਵਰਤੋਂ ਵੀ ਕਰ ਸਕਦੇ ਹੋ।
>
> #### GitHub Codespaces
>
> ਤੁਸੀਂ GitHub Codespaces ਦੀ ਵਰਤੋਂ ਕਰਕੇ ਇਸ ਸੈਂਪਲ ਨੂੰ ਵਰਚੁਅਲ ਤੌਰ 'ਤੇ ਚਲਾ ਸਕਦੇ ਹੋ ਅਤੇ ਕਿਸੇ ਵਾਧੂ ਸੈਟਅਪ ਦੀ ਲੋੜ ਨਹੀਂ ਹੈ।
>
> ਬਟਨ ਤੁਹਾਡੇ ਬ੍ਰਾਊਜ਼ਰ ਵਿੱਚ ਵੈੱਬ-ਆਧਾਰਿਤ VS Code ਇੰਸਟੈਂਸ ਖੋਲ੍ਹੇਗਾ:
>
> 1. ਟੈਮਪਲੇਟ ਖੋਲ੍ਹੋ (ਇਸ ਵਿੱਚ ਕੁਝ ਮਿੰਟ ਲੱਗ ਸਕਦੇ ਹਨ):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers ਦੀ ਵਰਤੋਂ ਕਰਕੇ ਲੋਕਲ ਚਲਾਉਣਾ
>
> ⚠️ ਇਹ ਵਿਕਲਪ ਸਿਰਫ਼ ਤਦ ਹੀ ਕੰਮ ਕਰੇਗਾ ਜਦੋਂ ਤੁਹਾਡੇ Docker Desktop ਨੂੰ ਘੱਟੋ-ਘੱਟ 16 GB RAM ਦਿੱਤੀ ਗਈ ਹੋਵੇ। ਜੇ ਤੁਹਾਡੇ ਕੋਲ 16 GB ਤੋਂ ਘੱਟ RAM ਹੈ, ਤਾਂ ਤੁਸੀਂ [GitHub Codespaces ਵਿਕਲਪ](../..) ਜਾਂ [ਲੋਕਲ ਸੈਟਅਪ](../..) ਦੀ ਕੋਸ਼ਿਸ਼ ਕਰ ਸਕਦੇ ਹੋ।
>
> ਇੱਕ ਸੰਬੰਧਿਤ ਵਿਕਲਪ VS Code Dev Containers ਹੈ, ਜੋ ਤੁਹਾਡੇ ਲੋਕਲ VS Code ਵਿੱਚ ਪ੍ਰੋਜੈਕਟ ਖੋਲ੍ਹੇਗਾ [Dev Containers ਐਕਸਟੈਂਸ਼ਨ](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) ਦੀ ਵਰਤੋਂ ਕਰਕੇ:
>
> 1. Docker Desktop ਸ਼ੁਰੂ ਕਰੋ (ਜੇ ਇੰਸਟਾਲ ਨਹੀਂ ਹੈ ਤਾਂ ਇੰਸਟਾਲ ਕਰੋ)
> 2. ਪ੍ਰੋਜੈਕਟ ਖੋਲ੍ਹੋ:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### ਕੋਡ ਸਟਾਈਲ

ਅਸੀਂ ਪ੍ਰੋਜੈਕਟ ਵਿੱਚ ਸਥਿਰ ਕੋਡ ਸਟਾਈਲ ਬਣਾਈ ਰੱਖਣ ਲਈ Python ਕੋਡ ਫਾਰਮੈਟਰ ਵਜੋਂ [Black](https://github.com/psf/black) ਦੀ ਵਰਤੋਂ ਕਰਦੇ ਹਾਂ। Black ਇੱਕ ਬਿਨਾਂ ਸਮਝੌਤੇ ਵਾਲਾ ਕੋਡ ਫਾਰਮੈਟਰ ਹੈ ਜੋ Python ਕੋਡ ਨੂੰ ਆਪਣੇ ਨਿਯਮਾਂ ਅਨੁਸਾਰ ਆਪਣੇ ਆਪ ਫਾਰਮੈਟ ਕਰਦਾ ਹੈ।

#### ਸੰਰਚਨਾ

Black ਦੀ ਸੰਰਚਨਾ ਸਾਡੇ `pyproject.toml` ਵਿੱਚ ਦਿੱਤੀ ਗਈ ਹੈ:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black ਇੰਸਟਾਲ ਕਰਨਾ

ਤੁਸੀਂ Black ਨੂੰ Poetry (ਸਿਫਾਰਸ਼ੀ) ਜਾਂ pip ਦੀ ਵਰਤੋਂ ਕਰਕੇ ਇੰਸਟਾਲ ਕਰ ਸਕਦੇ ਹੋ:

##### Poetry ਦੀ ਵਰਤੋਂ ਕਰਕੇ

ਜਦੋਂ ਤੁਸੀਂ ਵਿਕਾਸ ਵਾਤਾਵਰਣ ਸੈਟਅਪ ਕਰਦੇ ਹੋ, Black ਆਪਣੇ ਆਪ ਇੰਸਟਾਲ ਹੋ ਜਾਂਦਾ ਹੈ:
```bash
poetry install
```

##### pip ਦੀ ਵਰਤੋਂ ਕਰਕੇ

ਜੇ ਤੁਸੀਂ pip ਵਰਤ ਰਹੇ ਹੋ, ਤਾਂ ਤੁਸੀਂ Black ਨੂੰ ਸਿੱਧਾ ਇੰਸਟਾਲ ਕਰ ਸਕਦੇ ਹੋ:
```bash
pip install black
```

#### Black ਦੀ ਵਰਤੋਂ

##### Poetry ਨਾਲ

1. ਪ੍ਰੋਜੈਕਟ ਵਿੱਚ ਸਾਰੇ Python ਫਾਈਲਾਂ ਨੂੰ ਫਾਰਮੈਟ ਕਰੋ:
    ```bash
    poetry run black .
    ```

2. ਕਿਸੇ ਖਾਸ ਫਾਈਲ ਜਾਂ ਡਾਇਰੈਕਟਰੀ ਨੂੰ ਫਾਰਮੈਟ ਕਰੋ:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip ਨਾਲ

1. ਪ੍ਰੋਜੈਕਟ ਵਿੱਚ ਸਾਰੇ Python ਫਾਈਲਾਂ ਨੂੰ ਫਾਰਮੈਟ ਕਰੋ:
    ```bash
    black .
    ```

2. ਕਿਸੇ ਖਾਸ ਫਾਈਲ ਜਾਂ ਡਾਇਰੈਕਟਰੀ ਨੂੰ ਫਾਰਮੈਟ ਕਰੋ:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> ਅਸੀਂ ਸਿਫਾਰਸ਼ ਕਰਦੇ ਹਾਂ ਕਿ ਤੁਸੀਂ ਆਪਣੇ ਐਡੀਟਰ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਸੈਟ ਕਰੋ ਕਿ ਕੋਡ ਸੇਵ ਕਰਨ 'ਤੇ ਆਪਣੇ ਆਪ Black ਨਾਲ ਫਾਰਮੈਟ ਹੋ ਜਾਵੇ। ਜ਼ਿਆਦਾਤਰ ਆਧੁਨਿਕ ਐਡੀਟਰ ਇਸ ਨੂੰ ਐਕਸਟੈਂਸ਼ਨ ਜਾਂ ਪਲੱਗਇਨ ਰਾਹੀਂ ਸਹਾਇਤਾ ਦਿੰਦੇ ਹਨ।

## ਕੋ-ਆਪ ਟ੍ਰਾਂਸਲੇਟਰ ਚਲਾਉਣਾ

ਆਪਣੇ ਵਾਤਾਵਰਣ ਵਿੱਚ Poetry ਦੀ ਵਰਤੋਂ ਕਰਕੇ ਕੋ-ਆਪ ਟ੍ਰਾਂਸਲੇਟਰ ਚਲਾਉਣ ਲਈ, ਹੇਠਾਂ ਦਿੱਤੇ ਕਦਮਾਂ ਦੀ ਪਾਲਣਾ ਕਰੋ:

1. ਉਸ ਡਾਇਰੈਕਟਰੀ ਵਿੱਚ ਜਾਓ ਜਿੱਥੇ ਤੁਸੀਂ ਅਨੁਵਾਦ ਟੈਸਟ ਕਰਨਾ ਚਾਹੁੰਦੇ ਹੋ ਜਾਂ ਟੈਸਟਿੰਗ ਲਈ ਇੱਕ ਅਸਥਾਈ ਫੋਲਡਰ ਬਣਾਓ।

2. ਹੇਠਾਂ ਦਿੱਤਾ ਕਮਾਂਡ ਚਲਾਓ। `-l ko` ਨੂੰ ਉਸ ਭਾਸ਼ਾ ਕੋਡ ਨਾਲ ਬਦਲੋ ਜਿਸ ਵਿੱਚ ਤੁਸੀਂ ਅਨੁਵਾਦ ਕਰਨਾ ਚਾਹੁੰਦੇ ਹੋ। `-d` ਫਲੈਗ ਡੀਬੱਗ ਮੋਡ ਲਈ ਹੈ।

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> ਕਮਾਂਡ ਚਲਾਉਣ ਤੋਂ ਪਹਿਲਾਂ ਯਕੀਨੀ ਬਣਾਓ ਕਿ ਤੁਹਾਡਾ Poetry ਵਾਤਾਵਰਣ ਐਕਟੀਵੇਟ ਹੈ (poetry shell)।

## ਨਵੀਂ ਭਾਸ਼ਾ ਵਿੱਚ ਯੋਗਦਾਨ ਪਾਉਣਾ

ਅਸੀਂ ਨਵੀਆਂ ਭਾਸ਼ਾਵਾਂ ਲਈ ਸਹਿਯੋਗ ਦਾ ਸਵਾਗਤ ਕਰਦੇ ਹਾਂ। PR ਖੋਲ੍ਹਣ ਤੋਂ ਪਹਿਲਾਂ, ਕਿਰਪਾ ਕਰਕੇ ਹੇਠਾਂ ਦਿੱਤੇ ਕਦਮ ਪੂਰੇ ਕਰੋ ਤਾਂ ਜੋ ਸਮੀਖਿਆ ਸੁਗਮ ਹੋ ਸਕੇ।

1. ਫੋਂਟ ਮੈਪਿੰਗ ਵਿੱਚ ਭਾਸ਼ਾ ਸ਼ਾਮਲ ਕਰੋ
   - `src/co_op_translator/fonts/font_language_mappings.yml` ਨੂੰ ਸੋਧੋ
   - ਇੱਕ ਐਂਟਰੀ ਸ਼ਾਮਲ ਕਰੋ ਜਿਸ ਵਿੱਚ:
     - `code`: ISO-ਜਿਹੇ ਭਾਸ਼ਾ ਕੋਡ (ਜਿਵੇਂ `vi`)
     - `name`: ਮਨੁੱਖੀ-ਪਾਠਯੋਗ ਨਾਮ
     - `font`: `src/co_op_translator/fonts/` ਵਿੱਚ ਮੌਜੂਦ ਕੋਈ ਫੋਂਟ ਜੋ ਸਕ੍ਰਿਪਟ ਨੂੰ ਸਹਿਯੋਗ ਦਿੰਦਾ ਹੋਵੇ
     - `rtl`: ਜੇ ਸੱਜੇ ਤੋਂ ਖੱਬੇ ਲਿਖਾਈ ਵਾਲੀ ਭਾਸ਼ਾ ਹੈ ਤਾਂ `true`, ਨਹੀਂ ਤਾਂ `false`

2. ਲੋੜੀਂਦੇ ਫੋਂਟ ਫਾਈਲਾਂ ਸ਼ਾਮਲ ਕਰੋ (ਜੇ ਜ਼ਰੂਰੀ ਹੋਵੇ)
   - ਜੇ ਨਵਾਂ ਫੋਂਟ ਲੋੜੀਂਦਾ ਹੈ, ਤਾਂ ਖੁੱਲ੍ਹੇ ਸਰੋਤ ਵੰਡ ਲਈ ਲਾਇਸੈਂਸ ਦੀ ਜਾਂਚ ਕਰੋ
   - ਫੋਂਟ ਫਾਈਲ ਨੂੰ `src/co_op_translator/fonts/` ਵਿੱਚ ਸ਼ਾਮਲ ਕਰੋ

3. ਸਥਾਨਕ ਜਾਂਚ
   - ਛੋਟੇ ਨਮੂਨੇ (ਮਾਰਕਡਾਊਨ, ਚਿੱਤਰ, ਅਤੇ ਨੋਟਬੁੱਕ) ਲਈ ਅਨੁਵਾਦ ਚਲਾਓ
   - ਨਤੀਜੇ ਨੂੰ ਸਹੀ ਤਰੀਕੇ ਨਾਲ ਰੇਂਡਰ ਹੋਣ ਦੀ ਜਾਂਚ ਕਰੋ, ਜਿਸ ਵਿੱਚ ਫੋਂਟ ਅਤੇ ਕੋਈ ਵੀ RTL ਲੇਆਉਟ ਸ਼ਾਮਲ ਹੈ

4. ਡੌਕਯੂਮੈਂਟੇਸ਼ਨ ਅਪਡੇਟ ਕਰੋ
   - ਯਕੀਨੀ ਬਣਾਓ ਕਿ ਭਾਸ਼ਾ `getting_started/supported-languages.md` ਵਿੱਚ ਦਰਸਾਈ ਗਈ ਹੈ
   - `getting_started/README_languages_template.md` ਵਿੱਚ ਕੋਈ ਬਦਲਾਅ ਕਰਨ ਦੀ ਲੋੜ ਨਹੀਂ; ਇਹ ਸਹਿਯੋਗੀ ਸੂਚੀ ਤੋਂ ਬਣਦਾ ਹੈ

5. PR ਖੋਲ੍ਹੋ
   - ਸ਼ਾਮਲ ਕੀਤੀ ਭਾਸ਼ਾ ਅਤੇ ਕਿਸੇ ਵੀ ਫੋਂਟ/ਲਾਇਸੈਂਸਿੰਗ ਸੰਬੰਧੀ ਗੱਲਾਂ ਦਾ ਵਰਣਨ ਕਰੋ
   - ਸੰਭਵ ਹੋਵੇ ਤਾਂ ਰੇਂਡਰ ਕੀਤੇ ਨਤੀਜਿਆਂ ਦੇ ਸਕ੍ਰੀਨਸ਼ਾਟ ਜੁੜੋ

ਉਦਾਹਰਨ YAML ਐਂਟਰੀ:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### ਨਵੀਂ ਭਾਸ਼ਾ ਦੀ ਜਾਂਚ ਕਰੋ

ਤੁਸੀਂ ਹੇਠਾਂ ਦਿੱਤਾ ਕਮਾਂਡ ਚਲਾ ਕੇ ਨਵੀਂ ਭਾਸ਼ਾ ਦੀ ਜਾਂਚ ਕਰ ਸਕਦੇ ਹੋ:

```bash
# ਇੱਕ ਵਰਚੁਅਲ ਵਾਤਾਵਰਣ ਬਣਾਓ ਅਤੇ ਸਰਗਰਮ ਕਰੋ
python -m venv .venv
# ਵਿਂਡੋਜ਼
.venv\Scripts\activate
# ਮੈਕਓਐਸ/ਲਿਨਕਸ
source .venv/bin/activate
# ਵਿਕਾਸ ਪੈਕੇਜ ਇੰਸਟਾਲ ਕਰੋ
pip install -e .
# ਅਨੁਵਾਦ ਚਲਾਓ
translate -l "new_lang"
```

## ਮੇਨਟੇਨਰਜ਼

### ਕਮਿਟ ਸੁਨੇਹਾ ਅਤੇ ਮਰਜ ਰਣਨੀਤੀ

ਸਾਡੇ ਪ੍ਰੋਜੈਕਟ ਦੇ ਕਮਿਟ ਇਤਿਹਾਸ ਵਿੱਚ ਸਥਿਰਤਾ ਅਤੇ ਸਪਸ਼ਟਤਾ ਲਈ, ਅਸੀਂ **Squash and Merge** ਰਣਨੀਤੀ ਵਰਤਦੇ ਸਮੇਂ **ਆਖਰੀ ਕਮਿਟ ਸੁਨੇਹੇ** ਲਈ ਇੱਕ ਖਾਸ ਫਾਰਮੈਟ ਦੀ ਪਾਲਣਾ ਕਰਦੇ ਹਾਂ।

ਜਦੋਂ ਇੱਕ ਪੁਲ ਰਿਕਵੇਸਟ (PR) ਮਰਜ ਹੁੰਦੀ ਹੈ, ਤਾਂ ਵੱਖ-ਵੱਖ ਕਮਿਟਾਂ ਨੂੰ ਇੱਕ ਕਮਿਟ ਵਿੱਚ ਸੰਗ੍ਰਹਿਤ ਕੀਤਾ ਜਾਂਦਾ ਹੈ। ਆਖਰੀ ਕਮਿਟ ਸੁਨੇਹਾ ਹੇਠਾਂ ਦਿੱਤੇ ਫਾਰਮੈਟ ਅਨੁਸਾਰ ਹੋਣਾ ਚਾਹੀਦਾ ਹੈ ਤਾਂ ਜੋ ਇਤਿਹਾਸ ਸਾਫ਼ ਅਤੇ ਸਥਿਰ ਰਹੇ।

#### ਕਮਿਟ ਸੁਨੇਹਾ ਫਾਰਮੈਟ (squash and merge ਲਈ)

ਅਸੀਂ ਕਮਿਟ ਸੁਨੇਹਿਆਂ ਲਈ ਹੇਠਾਂ ਦਿੱਤਾ ਫਾਰਮੈਟ ਵਰਤਦੇ ਹਾਂ:

```bash
<type>: <description> (#<ਪੀ ਆਰ ਨੰਬਰ>)
```

- **type**: ਕਮਿਟ ਦੀ ਸ਼੍ਰੇਣੀ ਦਰਸਾਉਂਦਾ ਹੈ। ਅਸੀਂ ਹੇਠਾਂ ਦਿੱਤੇ ਕਿਸਮਾਂ ਵਰਤਦੇ ਹਾਂ:
  - `Docs`: ਡੌਕਯੂਮੈਂਟੇਸ਼ਨ ਅਪਡੇਟ ਲਈ।
  - `Build`: ਬਿਲਡ ਸਿਸਟਮ ਜਾਂ ਡਿਪੈਂਡੈਂਸੀਜ਼ ਨਾਲ ਸੰਬੰਧਿਤ ਬਦਲਾਅ ਲਈ, ਜਿਸ ਵਿੱਚ ਸੰਰਚਨਾ ਫਾਈਲਾਂ, CI ਵਰਕਫਲੋਜ਼, ਜਾਂ Dockerfile ਅਪਡੇਟ ਸ਼ਾਮਲ ਹਨ।
  - `Core`: ਪ੍ਰੋਜੈਕਟ ਦੇ ਮੁੱਖ ਫੰਕਸ਼ਨਾਲਿਟੀ ਜਾਂ ਫੀਚਰਾਂ ਵਿੱਚ ਬਦਲਾਅ ਲਈ, ਖਾਸ ਕਰਕੇ `src/co_op_translator/core` ਡਾਇਰੈਕਟਰੀ ਵਿੱਚ ਫਾਈਲਾਂ ਨਾਲ ਸੰਬੰਧਿਤ।

- **description**: ਬਦਲਾਅ ਦਾ ਸੰਖੇਪ ਵਰਣਨ।
- **PR number**: ਉਸ ਪੁਲ ਰਿਕਵੇਸਟ ਦਾ ਨੰਬਰ ਜਿਸ ਨਾਲ ਕਮਿਟ ਸੰਬੰਧਿਤ ਹੈ।

**ਉਦਾਹਰਨਾਂ**:

- `Docs: ਸਪਸ਼ਟਤਾ ਲਈ ਇੰਸਟਾਲੇਸ਼ਨ ਹਦਾਇਤਾਂ ਅਪਡੇਟ ਕਰੋ (#50)`
- `Core: ਚਿੱਤਰ ਅਨੁਵਾਦ ਸੰਭਾਲ ਵਿੱਚ ਸੁਧਾਰ (#60)`

> [!NOTE]
> ਇਸ ਸਮੇਂ, **`Docs`**, **`Core`**, ਅਤੇ **`Build`** ਪ੍ਰੀਫਿਕਸ ਆਪਣੇ ਆਪ PR ਸਿਰਲੇਖਾਂ ਵਿੱਚ ਲਗਦੇ ਹਨ ਜਦੋਂ ਸੋਧੇ ਗਏ ਸੋਰਸ ਕੋਡ 'ਤੇ ਲੇਬਲ ਲਗਾਈ ਜਾਂਦੀ ਹੈ। ਜੇ ਸਹੀ ਲੇਬਲ ਲਗਾਈ ਗਈ ਹੈ, ਤਾਂ ਤੁਹਾਨੂੰ ਆਮ ਤੌਰ 'ਤੇ PR ਸਿਰਲੇਖ ਨੂੰ ਹੱਥੋਂ ਬਦਲਣ ਦੀ ਲੋੜ ਨਹੀਂ। ਸਿਰਫ ਇਹ ਯਕੀਨੀ ਬਣਾਓ ਕਿ ਸਭ ਕੁਝ ਠੀਕ ਹੈ ਅਤੇ ਪ੍ਰੀਫਿਕਸ ਢੰਗ ਨਾਲ ਬਣਾਇਆ ਗਿਆ ਹੈ।

#### ਮਰਜ ਰਣਨੀਤੀ

ਅਸੀਂ ਪੁਲ ਰਿਕਵੇਸਟਾਂ ਲਈ ਡਿਫਾਲਟ ਰਣਨੀਤੀ ਵਜੋਂ **Squash and Merge** ਵਰਤਦੇ ਹਾਂ। ਇਹ ਰਣਨੀਤੀ ਇਹ ਯਕੀਨੀ ਬਣਾਉਂਦੀ ਹੈ ਕਿ ਕਮਿਟ ਸੁਨੇਹੇ ਸਾਡੇ ਫਾਰਮੈਟ ਅਨੁਸਾਰ ਹੋਣ, ਭਾਵੇਂ ਵੱਖ-ਵੱਖ ਕਮਿਟਾਂ ਵਿੱਚ ਨਾ ਹੋਣ।

**ਕਾਰਨ**:

- ਸਾਫ਼, ਲੀਨੀਅਰ ਪ੍ਰੋਜੈਕਟ ਇਤਿਹਾਸ।
- ਕਮਿਟ ਸੁਨੇਹਿਆਂ ਵਿੱਚ ਸਥਿਰਤਾ।
- ਛੋਟੇ ਕਮਿਟਾਂ (ਜਿਵੇਂ "ਟਾਈਪੋ ਠੀਕ ਕੀਤਾ") ਤੋਂ ਘੱਟ ਸ਼ੋਰ।

ਮਰਜ ਕਰਦੇ ਸਮੇਂ, ਯਕੀਨੀ ਬਣਾਓ ਕਿ ਆਖਰੀ ਕਮਿਟ ਸੁਨੇਹਾ ਉਪਰ ਦਿੱਤੇ ਫਾਰਮੈਟ ਅਨੁਸਾਰ ਹੈ।

**Squash and Merge ਦਾ ਉਦਾਹਰਨ**
ਜੇ ਕਿਸੇ PR ਵਿੱਚ ਹੇਠਾਂ ਦਿੱਤੇ ਕਮਿਟ ਹਨ:

- `fix typo`
- `update README`
- `adjust formatting`

ਉਹਨਾਂ ਨੂੰ ਸੰਗ੍ਰਹਿਤ ਕਰਕੇ ਬਣਾਇਆ ਜਾਵੇਗਾ:
`Docs: ਡੌਕਯੂਮੈਂਟੇਸ਼ਨ ਦੀ ਸਪਸ਼ਟਤਾ ਅਤੇ ਫਾਰਮੈਟਿੰਗ ਵਿੱਚ ਸੁਧਾਰ (#65)`

### ਰਿਲੀਜ਼ ਪ੍ਰਕਿਰਿਆ

ਇਹ ਹਿੱਸਾ ਮੇਨਟੇਨਰਜ਼ ਲਈ ਕੋ-ਆਪ ਟ੍ਰ

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**ਅਸਵੀਕਾਰੋਪੱਤਰ**:  
ਇਹ ਦਸਤਾਵੇਜ਼ AI ਅਨੁਵਾਦ ਸੇਵਾ [Co-op Translator](https://github.com/Azure/co-op-translator) ਦੀ ਵਰਤੋਂ ਕਰਕੇ ਅਨੁਵਾਦਿਤ ਕੀਤਾ ਗਿਆ ਹੈ। ਜਦੋਂ ਕਿ ਅਸੀਂ ਸਹੀਤਾ ਲਈ ਕੋਸ਼ਿਸ਼ ਕਰਦੇ ਹਾਂ, ਕਿਰਪਾ ਕਰਕੇ ਧਿਆਨ ਵਿੱਚ ਰੱਖੋ ਕਿ ਸਵੈਚਾਲਿਤ ਅਨੁਵਾਦਾਂ ਵਿੱਚ ਗਲਤੀਆਂ ਜਾਂ ਅਸਮਰਥਤਾਵਾਂ ਹੋ ਸਕਦੀਆਂ ਹਨ। ਮੂਲ ਦਸਤਾਵੇਜ਼ ਆਪਣੀ ਮੂਲ ਭਾਸ਼ਾ ਵਿੱਚ ਪ੍ਰਮਾਣਿਕ ਸਰੋਤ ਮੰਨਿਆ ਜਾਣਾ ਚਾਹੀਦਾ ਹੈ। ਮਹੱਤਵਪੂਰਨ ਜਾਣਕਾਰੀ ਲਈ, ਪੇਸ਼ੇਵਰ ਮਨੁੱਖੀ ਅਨੁਵਾਦ ਦੀ ਸਿਫਾਰਸ਼ ਕੀਤੀ ਜਾਂਦੀ ਹੈ। ਅਸੀਂ ਇਸ ਅਨੁਵਾਦ ਦੀ ਵਰਤੋਂ ਤੋਂ ਉਤਪੰਨ ਕਿਸੇ ਵੀ ਗਲਤਫਹਿਮੀ ਜਾਂ ਗਲਤ ਵਿਆਖਿਆ ਲਈ ਜ਼ਿੰਮੇਵਾਰ ਨਹੀਂ ਹਾਂ।
<!-- CO-OP TRANSLATOR DISCLAIMER END -->