<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:54:04+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "ne"
}
-->
# आफ्नो परियोजना Co-op Translator प्रयोग गरेर अनुवाद गर्नुहोस्

**Co-op Translator** एउटा कमाण्ड-लाइन इन्टरफेस (CLI) उपकरण हो जसले तपाईंको परियोजनामा भएका मार्कडाउन र इमेज फाइलहरूलाई धेरै भाषामा अनुवाद गर्न मद्दत गर्छ। यो खण्डमा उपकरण कसरी प्रयोग गर्ने, विभिन्न CLI विकल्पहरू, र विभिन्न प्रयोगका लागि उदाहरणहरू दिइएको छ।

> [!NOTE]
> सबै कमाण्डहरूको सूची र विस्तृत विवरणका लागि कृपया [Command reference](./command-reference.md) हेर्नुहोस्।

---

## उदाहरण परिदृश्यहरू र कमाण्डहरू

यहाँ **Co-op Translator** का केही सामान्य प्रयोगका केसहरू र तिनीहरूका लागि उपयुक्त कमाण्डहरू छन्।

### 1. आधारभूत अनुवाद (एकल भाषा)

आफ्नो सम्पूर्ण परियोजना (मार्कडाउन फाइलहरू र इमेजहरू) एकल भाषामा, जस्तै कोरियनमा अनुवाद गर्न तलको कमाण्ड प्रयोग गर्नुहोस्:

```bash
translate -l "ko"
```

यो कमाण्डले सबै मार्कडाउन र इमेज फाइलहरूलाई कोरियनमा अनुवाद गर्नेछ, नयाँ अनुवादहरू थप्नेछ तर पहिलेका अनुवादहरू मेट्ने छैन।

> [!TIP]
>
> **Co-op Translator** मा कुन भाषा कोडहरू उपलब्ध छन् हेर्न चाहनुहुन्छ? थप जानकारीका लागि रिपोजिटरीको [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) खण्डमा जानुहोस्।

#### Phi-3 CookBook मा उदाहरण

**Phi-3 CookBook** मा, मैले पहिलेका मार्कडाउन फाइलहरू र इमेजहरूका लागि कोरियन अनुवाद थप्न तलको विधि प्रयोग गरेँ।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. धेरै भाषामा अनुवाद

आफ्नो परियोजनालाई धेरै भाषामा (जस्तै स्पेनिस, फ्रेन्च, र जर्मन) अनुवाद गर्न यो कमाण्ड प्रयोग गर्नुहोस्:

```bash
translate -l "es fr de"
```

यो कमाण्डले परियोजनालाई स्पेनिस, फ्रेन्च, र जर्मनमा अनुवाद गर्नेछ, नयाँ अनुवादहरू थप्नेछ तर पहिलेका अनुवादहरू मेट्ने छैन।

#### Phi-3 CookBook मा उदाहरण

**Phi-3 CookBook** मा, पछिल्लो परिवर्तनहरू तानिसकेपछि, मैले नयाँ थपिएका मार्कडाउन फाइलहरू र इमेजहरू अनुवाद गर्न तलको विधि प्रयोग गरेँ।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> सामान्यतया एक पटकमा एक भाषा अनुवाद गर्न सिफारिस गरिन्छ, तर यस्तो अवस्थामा जहाँ विशेष परिवर्तनहरू थप्नुपर्छ, धेरै भाषामा एकैपटक अनुवाद गर्नु प्रभावकारी हुन सक्छ।

### 3. अनुवाद अपडेट गर्नुहोस् (पहिलेका अनुवादहरू मेट्छ)

पहिलेका अनुवादहरू अपडेट गर्न (अर्थात् हालका अनुवादहरू मेटेर नयाँ अनुवाद राख्न), `-u` विकल्प प्रयोग गर्नुहोस्। यसले निर्दिष्ट भाषाहरूका सबै अनुवादहरू मेट्नेछ र फेरि अनुवाद गर्नेछ।

```bash
translate -l "ko" -u
```

सावधानी: यो कमाण्डले पहिलेका अनुवादहरू मेट्न अघि तपाईंलाई पुष्टि गर्न सोध्नेछ।

#### Phi-3 CookBook मा उदाहरण

**Phi-3 CookBook** मा, मैले स्पेनिसमा सबै अनुवादित फाइलहरू अपडेट गर्न तलको विधि प्रयोग गरेँ। यदि मूल सामग्रीमा धेरै परिवर्तन भएको छ भने यो विधि प्रयोग गर्न सिफारिस गर्छु। तर, यदि अपडेट गर्नुपर्ने अनुवादित मार्कडाउन फाइलहरू थोरै छन् भने, ती फाइलहरू म्यानुअली मेटेर `-a` विधि प्रयोग गरेर अपडेट गर्नु बढी प्रभावकारी हुन्छ।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. केवल इमेजहरू अनुवाद गर्नुहोस्

आफ्नो परियोजनामा केवल इमेज फाइलहरू अनुवाद गर्न `-img` विकल्प प्रयोग गर्नुहोस्:

```bash
translate -l "ko" -img
```

यो कमाण्डले केवल इमेजहरूलाई कोरियनमा अनुवाद गर्नेछ, मार्कडाउन फाइलहरूमा कुनै असर गर्दैन।

### 6. केवल मार्कडाउन फाइलहरू अनुवाद गर्नुहोस्

आफ्नो परियोजनामा केवल मार्कडाउन फाइलहरू अनुवाद गर्न `-md` विकल्प प्रयोग गर्नुहोस्:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook मा उदाहरण

**Phi-3 CookBook** मा, मैले कोरियन फाइलहरूमा अनुवाद त्रुटि जाँच गर्न र समस्या भएका फाइलहरूमा स्वत: पुन: अनुवाद गर्न तलको विधि प्रयोग गरेँ।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

यो विकल्पले अनुवाद त्रुटि जाँच गर्छ। हाल, यदि मूल र अनुवादित फाइलहरूमा लाइन ब्रेकको अन्तर छ भन्दा बढी छ भने, फाइललाई अनुवाद त्रुटि भएको भनेर चिनिन्छ। भविष्यमा यो मापदण्ड अझ लचिलो बनाउने योजना छ।

उदाहरणका लागि, यो विधि हराएका भागहरू वा बिग्रिएको अनुवाद पत्ता लगाउन उपयोगी छ, र ती फाइलहरूमा स्वत: पुन: अनुवाद गर्छ।

तर, यदि तपाईंलाई पहिले नै थाहा छ कुन फाइलहरूमा समस्या छ भने, ती फाइलहरू म्यानुअली मेटेर `-a` विकल्प प्रयोग गरेर पुन: अनुवाद गर्नु बढी सजिलो हुन्छ।

### 8. डिबग मोड

समस्या समाधानका लागि विस्तृत लग हेर्न `-d` विकल्प प्रयोग गर्नुहोस्:

```bash
translate -l "ko" -d
```

यो कमाण्डले अनुवादलाई डिबग मोडमा चलाउनेछ, जसले थप लग जानकारी दिनेछ र अनुवाद प्रक्रियामा समस्या पत्ता लगाउन मद्दत गर्छ।

#### Phi-3 CookBook मा उदाहरण

**Phi-3 CookBook** मा, मैले मार्कडाउन फाइलहरूमा धेरै लिंक हुँदा अनुवादमा त्रुटि आएको समस्या देखेँ, जस्तै अनुवाद बिग्रनु वा लाइन ब्रेक हराउनु। यो समस्या पत्ता लगाउन मैले `-d` विकल्प प्रयोग गरेँ र अनुवाद प्रक्रिया कसरी चलिरहेको छ हेरेँ।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. सबै भाषामा अनुवाद गर्नुहोस्

यदि तपाईं परियोजनालाई सबै समर्थित भाषामा अनुवाद गर्न चाहनुहुन्छ भने, all कीवर्ड प्रयोग गर्नुहोस्।

> [!WARNING]
> सबै भाषामा एकैपटक अनुवाद गर्दा परियोजनाको आकार अनुसार धेरै समय लाग्न सक्छ। उदाहरणका लागि, **Phi-3 CookBook** लाई स्पेनिसमा अनुवाद गर्न लगभग २ घण्टा लाग्यो। ठूलो परियोजनामा २० भाषामा अनुवाद एक जनाले गर्न सम्भव छैन। सिफारिस गरिन्छ कि कामलाई धेरै योगदानकर्ताहरूमा बाँड्नुहोस्, प्रत्येकले एक वा दुई भाषाको जिम्मा लिनुहोस्, र अनुवादहरू क्रमशः अपडेट गर्नुहोस्।

```bash
translate -l "all"
```

यो कमाण्डले परियोजनालाई सबै उपलब्ध भाषामा अनुवाद गर्नेछ। यदि तपाईं अगाडि बढ्नुहुन्छ भने, परियोजनाको आकार अनुसार अनुवादमा धेरै समय लाग्न सक्छ।

> [!TIP]
>
> ### अनुवादित फाइलहरू म्यानुअली मेट्ने (वैकल्पिक)
> स्रोत फाइल अपडेट हुँदा अनुवादित फाइलहरू अब स्वत: पत्ता लाग्छन् र सफा गरिन्छ।
>
> तर, यदि तपाईं अनुवाद म्यानुअली अपडेट गर्न चाहनुहुन्छ - जस्तै कुनै फाइल पुन: अनुवाद गर्न वा सिस्टम व्यवहार ओभरराइड गर्न - तलको कमाण्ड प्रयोग गरेर फाइलको सबै संस्करणहरू भाषा फोल्डरहरूबाट मेट्न सक्नुहुन्छ।
>
> ### Windows मा:
> 1. **Command Prompt प्रयोग गर्दै**:
>    - Command Prompt खोल्नुहोस्।
>    - `cd` कमाण्ड प्रयोग गरेर फाइलहरू भएको फोल्डरमा जानुहोस्।
>    - फाइलहरू मेट्न तलको कमाण्ड प्रयोग गर्नुहोस्:
>      ```
>      del /s *filename*
>      ```
>      `filename` लाई तपाईं खोज्न चाहनु भएको फाइलको भागले बदल्नुहोस्। `/s` विकल्पले सबडाइरेक्टरीहरूमा खोज्छ।
>
> 2. **PowerShell प्रयोग गर्दै**:
>    - PowerShell खोल्नुहोस्।
>    - यो कमाण्ड चलाउनुहोस्:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` लाई फोल्डरको पथले र `filename` लाई विशेष नामले बदल्नुहोस्।
>
> ### macOS/Linux मा:
> 1. **Terminal प्रयोग गर्दै**:
>   - Terminal खोल्नुहोस्।
>   - `cd` प्रयोग गरेर डाइरेक्टरीमा जानुहोस्।
>   - `find` कमाण्ड प्रयोग गर्नुहोस्:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` लाई विशेष नामले बदल्नुहोस्।
>
> मेट्नुअघि फाइलहरू दोहोरो जाँच गर्नुहोस् ताकि गल्तीले फाइल हराउने जोखिम नहोस्।
>
> तपाईंले बदल्न चाहनु भएका फाइलहरू मेटिसकेपछि, आफ्नो `translate -l` कमाण्ड पुन: चलाउनुहोस् ताकि सबैभन्दा नयाँ फाइल परिवर्तनहरू अपडेट होस्।

---

**अस्वीकरण**:
यो दस्तावेज़ AI अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) प्रयोग गरेर अनुवाद गरिएको हो। हामी शुद्धताको लागि प्रयास गर्छौं, तर कृपया ध्यान दिनुहोस् कि स्वचालित अनुवादमा त्रुटि वा अशुद्धता हुन सक्छ। मूल भाषामा रहेको दस्तावेज़लाई नै अधिकारिक स्रोत मान्नुपर्छ। महत्वपूर्ण जानकारीको लागि, पेशेवर मानव अनुवाद सिफारिस गरिन्छ। यस अनुवादको प्रयोगबाट उत्पन्न हुने कुनै पनि गलतफहमी वा गलत व्याख्याको लागि हामी जिम्मेवार हुने छैनौं।