<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T10:43:01+00:00",
  "source_file": "README.md",
  "language_code": "ne"
}
-->
# को-अप अनुवादक

_आफ्नो शैक्षिक GitHub सामग्रीलाई सजिलै विभिन्न भाषाहरूमा अनुवाद गरेर विश्वव्यापी दर्शकसम्म पुग्नुहोस्।_

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 बहुभाषिक समर्थन

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) द्वारा समर्थित

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[अरबी](../ar/README.md) | [बंगाली](../bn/README.md) | [बुल्गेरियन](../bg/README.md) | [बर्मी (म्यानमार)](../my/README.md) | [चिनी (सरलीकृत)](../zh/README.md) | [चिनी (परम्परागत, हङकङ)](../hk/README.md) | [चिनी (परम्परागत, मकाउ)](../mo/README.md) | [चिनी (परम्परागत, ताइवान)](../tw/README.md) | [क्रोएशियन](../hr/README.md) | [चेक](../cs/README.md) | [डेनिश](../da/README.md) | [डच](../nl/README.md) | [एस्टोनियन](../et/README.md) | [फिनिश](../fi/README.md) | [फ्रेन्च](../fr/README.md) | [जर्मन](../de/README.md) | [ग्रीक](../el/README.md) | [हिब्रू](../he/README.md) | [हिन्दी](../hi/README.md) | [हंगेरीयन](../hu/README.md) | [इन्डोनेशियन](../id/README.md) | [इटालियन](../it/README.md) | [जापानी](../ja/README.md) | [कन्नड](../kn/README.md) | [कोरियन](../ko/README.md) | [लिथुआनियन](../lt/README.md) | [मलय](../ms/README.md) | [मलयालम](../ml/README.md) | [मराठी](../mr/README.md) | [नेपाली](./README.md) | [नाइजेरियन पिजिन](../pcm/README.md) | [नर्वेजियन](../no/README.md) | [फारसी (पर्शियन)](../fa/README.md) | [पोलिश](../pl/README.md) | [पोर्चुगिज (ब्राजिल)](../br/README.md) | [पोर्चुगिज (पोर्चुगल)](../pt/README.md) | [पञ्जाबी (गुरुमुखी)](../pa/README.md) | [रोमानियन](../ro/README.md) | [रूसी](../ru/README.md) | [सर्बियन (सिरिलिक)](../sr/README.md) | [स्लोभाक](../sk/README.md) | [स्लोभेनियन](../sl/README.md) | [स्पेनिश](../es/README.md) | [स्वाहिली](../sw/README.md) | [स्विडिश](../sv/README.md) | [टागालोग (फिलिपिनो)](../tl/README.md) | [तमिल](../ta/README.md) | [तेलुगु](../te/README.md) | [थाई](../th/README.md) | [टर्किश](../tr/README.md) | [युक्रेनीयन](../uk/README.md) | [उर्दू](../ur/README.md) | [भियतनामी](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## अवलोकन

**को-अप अनुवादक** ले तपाईंलाई सजिलै आफ्नो शैक्षिक GitHub सामग्रीलाई विभिन्न भाषाहरूमा स्थानीयकरण गर्न मद्दत गर्छ।  
जब तपाईंले Markdown फाइलहरू, तस्बिरहरू, वा नोटबुकहरू अपडेट गर्नुहुन्छ, अनुवादहरू स्वचालित रूपमा समक्रमित रहन्छन्, जसले विश्वभरिका सिक्नेहरूका लागि तपाईंको सामग्री सही र अद्यावधिक रहन्छ।

अनुवादित सामग्री कसरी व्यवस्थित हुन्छ भन्ने उदाहरण:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.ne.png)

## छिटो सुरु

```bash
# भर्चुअल वातावरण सिर्जना गर्नुहोस् र सक्रिय गर्नुहोस् (सिफारिस गरिएको)
python -m venv .venv
# विन्डोज
.venv\Scripts\activate
# म्याकओएस/लिनक्स
source .venv/bin/activate
# प्याकेज स्थापना गर्नुहोस्
pip install co-op-translator
# अनुवाद गर्नुहोस्
translate -l "ko ja fr" -md
```

Docker:

```bash
# GHCR बाट सार्वजनिक छवि तान्नुहोस्
docker pull ghcr.io/azure/co-op-translator:latest
# हालको फोल्डर माउन्ट गरिएको र .env प्रदान गरिएको साथ चलाउनुहोस् (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## न्यूनतम सेटअप

1. टेम्प्लेट प्रयोग गरेर `.env` फाइल बनाउनुहोस्: [.env.template](../../.env.template)
2. एउटा LLM प्रदायक कन्फिगर गर्नुहोस् (Azure OpenAI वा OpenAI)
3. (वैकल्पिक) तस्बिर अनुवादको लागि (`-img`), Azure AI Vision कन्फिगर गर्नुहोस्
4. (सिफारिस गरिएको) कुनै पनि पुराना अनुवादहरू हटाएर द्वन्द्वबाट बच्नुहोस् (जस्तै `translations/`)
5. (सिफारिस गरिएको) आफ्नो README मा अनुवाद सेक्सन थप्नुहोस् [README भाषाहरू टेम्प्लेट](./getting_started/README_languages_template.md) प्रयोग गरेर
6. हेर्नुहोस्: [Azure AI सेटअप](./getting_started/set-up-azure-ai.md)

## प्रयोग

सबै समर्थित प्रकारहरू अनुवाद गर्नुहोस्:

```bash
translate -l "ko ja"
```

Markdown मात्र:

```bash
translate -l "de" -md
```

Markdown + तस्बिरहरू:

```bash
translate -l "pt" -md -img
```

मात्र नोटबुकहरू:

```bash
translate -l "zh" -nb
```

थप झण्डाहरू: [कमाण्ड सन्दर्भ](./getting_started/command-reference.md)

## विशेषताहरू

- Markdown, नोटबुक, र तस्बिरहरूको स्वचालित अनुवाद
- स्रोत परिवर्तनहरूसँग अनुवादहरू समक्रमित राख्छ
- स्थानीय (CLI) वा CI (GitHub Actions) मा काम गर्छ
- Azure OpenAI वा OpenAI प्रयोग गर्छ; तस्बिरहरूको लागि वैकल्पिक Azure AI Vision
- Markdown ढाँचा र संरचना जोगाउँछ

## कागजातहरू

- [कमाण्ड-लाइन मार्गदर्शिका](./getting_started/command-line-guide/command-line-guide.md)
- [GitHub Actions मार्गदर्शिका (सार्वजनिक रिपोजिटोरी र मानक गोप्य जानकारी)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [GitHub Actions मार्गदर्शिका (Microsoft संगठन रिपोजिटोरी र संगठन स्तर सेटअप)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [README भाषाहरू टेम्प्लेट](./getting_started/README_languages_template.md)
- [समर्थित भाषाहरू](./getting_started/supported-languages.md)
- [योगदान गर्ने तरिका](./CONTRIBUTING.md)
- [समस्या समाधान](./getting_started/troubleshooting.md)

### Microsoft-विशेष मार्गदर्शिका
> [!NOTE]
> Microsoft “For Beginners” रिपोजिटोरीका मर्मतकर्ताहरूका लागि मात्र।

- [“अन्य कोर्सहरू” सूची अद्यावधिक गर्ने तरिका (MS Beginners रिपोजिटोरीका लागि मात्र)](./getting_started/update-other-courses.md)

## हामीलाई समर्थन गर्नुहोस् र विश्वव्यापी सिकाइ प्रवर्द्धन गर्नुहोस्

शैक्षिक सामग्री विश्वव्यापी रूपमा कसरी साझा गरिन्छ भन्ने क्रान्तिमा हामीसँग सामेल हुनुहोस्! [Co-op Translator](https://github.com/azure/co-op-translator) लाई GitHub मा ⭐ दिनुहोस् र सिकाइ र प्रविधिमा भाषा अवरोधहरू तोड्ने हाम्रो मिशनलाई समर्थन गर्नुहोस्। तपाईंको रुचि र योगदानले ठूलो प्रभाव पार्छ! कोड योगदान र नयाँ सुविधाहरूको सुझाव सधैं स्वागत छ।

### आफ्नो भाषामा Microsoft शैक्षिक सामग्री अन्वेषण गर्नुहोस्

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)
- [.NET प्रयोग गरेर Generative AI for Beginners](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)
- [Java प्रयोग गरेर Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML for Beginners](https://aka.ms/ml-beginners)
- [Data Science for Beginners](https://aka.ms/datascience-beginners)
- [AI for Beginners](https://aka.ms/ai-beginners)
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)
- [IoT for Beginners](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## भिडियो प्रस्तुतीकरणहरू

👉 तलको तस्बिरमा क्लिक गरेर YouTube मा हेर्नुहोस्।

- **Open at Microsoft**: को-अप अनुवादक कसरी प्रयोग गर्ने बारे छोटो १८ मिनेटको परिचय र छिटो मार्गदर्शिका।

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.ne.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## योगदान

यो परियोजनाले योगदान र सुझावहरूलाई स्वागत गर्दछ। Azure Co-op Translator मा योगदान गर्न इच्छुक हुनुहुन्छ? कृपया हाम्रो [CONTRIBUTING.md](./CONTRIBUTING.md) हेर्नुहोस् जसले तपाईंलाई को-अप अनुवादकलाई अझ पहुँचयोग्य बनाउन कसरी मद्दत गर्न सकिन्छ भन्ने मार्गदर्शन गर्छ।

## योगदानकर्ताहरू

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## आचार संहिता

यस परियोजनाले [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) अपनाएको छ।  
थप जानकारीका लागि [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) हेर्नुहोस् वा  
[opencode@microsoft.com](mailto:opencode@microsoft.com) मा कुनै प्रश्न वा टिप्पणीहरू पठाउनुहोस्।

## जिम्मेवार AI

Microsoft ले हाम्रा ग्राहकहरूलाई AI उत्पादनहरू जिम्मेवार तरिकाले प्रयोग गर्न मद्दत गर्न प्रतिबद्ध छ, हाम्रा सिकाइहरू साझा गर्छ, र Transparency Notes र Impact Assessments जस्ता उपकरणहरू मार्फत विश्वासमा आधारित साझेदारीहरू निर्माण गर्छ। यी स्रोतहरू धेरै [https://aka.ms/RAI](https://aka.ms/RAI) मा उपलब्ध छन्।  
Microsoft को जिम्मेवार AI दृष्टिकोण हाम्रो AI सिद्धान्तहरूमा आधारित छ: न्याय, विश्वसनीयता र सुरक्षा, गोपनीयता र सुरक्षा, समावेशिता, पारदर्शिता, र जवाफदेहिता।

ठूला प्राकृतिक भाषा, तस्बिर, र भाषण मोडेलहरू - जस्तै यस नमूनामा प्रयोग गरिएका - सम्भावित रूपमा अन्यायपूर्ण, अविश्वसनीय, वा अपमानजनक व्यवहार गर्न सक्छन्, जसले हानि पुर्याउन सक्छ। कृपया जोखिम र सीमाहरूको जानकारीका लागि [Azure OpenAI सेवा Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) सल्लाह लिनुहोस्।
यी जोखिमहरूलाई कम गर्ने सिफारिस गरिएको तरिका भनेको तपाईंको आर्किटेक्चरमा एउटा सुरक्षा प्रणाली समावेश गर्नु हो जसले हानिकारक व्यवहार पत्ता लगाउन र रोक्न सक्छ। [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) ले स्वतन्त्र सुरक्षा तह प्रदान गर्दछ, जसले अनुप्रयोग र सेवाहरूमा प्रयोगकर्ताद्वारा सिर्जित र AI द्वारा सिर्जित हानिकारक सामग्री पत्ता लगाउन सक्षम छ। Azure AI Content Safety मा पाठ र छवि API हरू समावेश छन् जसले तपाईंलाई हानिकारक सामग्री पत्ता लगाउन अनुमति दिन्छ। हामीसँग एउटा अन्तरक्रियात्मक Content Safety Studio पनि छ जसले तपाईंलाई विभिन्न मोडालिटीहरूमा हानिकारक सामग्री पत्ता लगाउन नमूना कोड हेर्न, अन्वेषण गर्न र प्रयास गर्न अनुमति दिन्छ। तलको [छिटो सुरु गर्ने कागजात](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) ले तपाईंलाई सेवामा अनुरोधहरू कसरी गर्ने भनेर मार्गदर्शन गर्दछ।

अर्को विचार गर्नुपर्ने पक्ष भनेको समग्र अनुप्रयोग प्रदर्शन हो। बहु-मोडाल र बहु-मोडेल अनुप्रयोगहरूमा, हामी प्रदर्शनलाई यस्तो अर्थमा लिन्छौं कि प्रणाली तपाईं र तपाईंका प्रयोगकर्ताहरूले अपेक्षा गरेजस्तै काम गर्छ, जसमा हानिकारक आउटपुटहरू उत्पन्न नगर्नु पनि समावेश छ। तपाईंको समग्र अनुप्रयोगको प्रदर्शन [उत्पादन गुणस्तर र जोखिम तथा सुरक्षा मेट्रिक्स](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) प्रयोग गरेर मूल्याङ्कन गर्नु महत्त्वपूर्ण छ।

तपाईं आफ्नो विकास वातावरणमा [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) प्रयोग गरेर आफ्नो AI अनुप्रयोग मूल्याङ्कन गर्न सक्नुहुन्छ। परीक्षण डेटासेट वा लक्ष्य दिइएपछि, तपाईंको जेनेरेटिभ AI अनुप्रयोगका उत्पादनहरू स्वचालित मूल्याङ्कनकर्ताहरू वा तपाईंले रोजेको अनुकूलित मूल्याङ्कनकर्ताहरूको साथ मात्रात्मक रूपमा मापन गरिन्छ। तपाईंको प्रणाली मूल्याङ्कन गर्न prompt flow SDK सँग सुरु गर्न, तपाईं [छिटो सुरु गर्ने मार्गदर्शन](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) अनुसरण गर्न सक्नुहुन्छ। मूल्याङ्कन चलाएपछि, तपाईं [Azure AI Studio मा परिणामहरू दृश्यात्मक रूपमा हेर्न](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results) सक्नुहुन्छ।

## ट्रेडमार्कहरू

यो परियोजनामा परियोजना, उत्पादन वा सेवाहरूका ट्रेडमार्क वा लोगोहरू समावेश हुन सक्छन्। Microsoft का ट्रेडमार्क वा लोगोहरूको अधिकृत प्रयोग [Microsoft को ट्रेडमार्क र ब्रान्ड दिशानिर्देशहरू](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) अनुसार हुनुपर्छ। यस परियोजनाको संशोधित संस्करणहरूमा Microsoft ट्रेडमार्क वा लोगोहरूको प्रयोगले भ्रम सिर्जना गर्नु हुँदैन वा Microsoft को प्रायोजन संकेत गर्नु हुँदैन। तेस्रो पक्षका ट्रेडमार्क वा लोगोहरूको कुनै पनि प्रयोग तिनका नीतिहरूको अधीनमा हुन्छ।

## सहयोग प्राप्त गर्ने तरिका

यदि तपाईं अड्किनुभयो वा AI अनुप्रयोगहरू निर्माण गर्दा कुनै प्रश्न छ भने, सामेल हुनुहोस्:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

यदि तपाईंलाई उत्पादन सम्बन्धी प्रतिक्रिया वा निर्माण गर्दा त्रुटिहरू छन् भने भ्रमण गर्नुहोस्:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**अस्वीकरण**:
यो दस्तावेज AI अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) प्रयोग गरी अनुवाद गरिएको हो। हामी शुद्धताका लागि प्रयासरत छौं, तर कृपया ध्यान दिनुहोस् कि स्वचालित अनुवादमा त्रुटि वा अशुद्धता हुन सक्छ। मूल दस्तावेज यसको मूल भाषामा आधिकारिक स्रोत मानिनु पर्छ। महत्वपूर्ण जानकारीका लागि व्यावसायिक मानव अनुवाद सिफारिस गरिन्छ। यस अनुवादको प्रयोगबाट उत्पन्न कुनै पनि गलतफहमी वा गलत व्याख्याका लागि हामी जिम्मेवार छैनौं।
<!-- CO-OP TRANSLATOR DISCLAIMER END -->