<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T10:42:17+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "ne"
}
-->
# Co-op Translator मा योगदान गर्ने

यो परियोजनाले योगदान र सुझावहरूलाई स्वागत गर्दछ। अधिकांश योगदानहरूका लागि तपाईंले Contributor License Agreement (CLA) मा सहमति जनाउनु आवश्यक छ जसले तपाईंलाई तपाईंको योगदान प्रयोग गर्ने अधिकार दिन्छ। विवरणका लागि https://cla.opensource.microsoft.com मा जानुहोस्।

जब तपाईंले pull request पेश गर्नुहुन्छ, CLA बोटले स्वचालित रूपमा निर्धारण गर्नेछ कि तपाईंले CLA प्रदान गर्न आवश्यक छ कि छैन र PR लाई उपयुक्त रूपमा चिन्ह लगाउनेछ (जस्तै, स्थिति जाँच, टिप्पणी)। बोटले दिएको निर्देशनहरू पालना गर्नुहोस्। तपाईंले हाम्रो CLA प्रयोग गर्ने सबै रिपोजमा यो एक पटक मात्र गर्नु पर्नेछ।

## विकास वातावरण सेटअप

यस परियोजनाको विकास वातावरण सेटअप गर्न हामीले निर्भरता व्यवस्थापनका लागि Poetry प्रयोग गर्न सिफारिस गर्छौं। हामी `pyproject.toml` मार्फत परियोजनाका निर्भरता व्यवस्थापन गर्छौं, त्यसैले निर्भरता स्थापना गर्न Poetry प्रयोग गर्नुहोस्।

### भर्चुअल वातावरण सिर्जना गर्ने

#### pip प्रयोग गरेर

```bash
python -m venv .venv
```

#### Poetry प्रयोग गरेर

```bash
poetry init
```

### भर्चुअल वातावरण सक्रिय गर्ने

#### pip र Poetry दुवैका लागि

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry प्रयोग गरेर

```bash
poetry shell
```

### प्याकेज र आवश्यक प्याकेजहरू स्थापना गर्ने

#### Poetry प्रयोग गरेर (pyproject.toml बाट)

```bash
poetry install
```

### म्यानुअल परीक्षण

PR पेश गर्नु अघि, वास्तविक डकुमेन्टेसनसँग अनुवाद कार्यक्षमता परीक्षण गर्नु महत्त्वपूर्ण छ:

1. मूल डाइरेक्टरीमा test डाइरेक्टरी सिर्जना गर्नुहोस्:
    ```bash
    mkdir test_docs
    ```

2. अनुवाद गर्न चाहनुभएको केही मार्कडाउन डकुमेन्टेसन र छविहरू test डाइरेक्टरीमा कपी गर्नुहोस्। उदाहरणका लागि:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. प्याकेज स्थानीय रूपमा स्थापना गर्नुहोस्:
    ```bash
    pip install -e .
    ```

4. तपाईंको परीक्षण कागजातहरूमा Co-op Translator चलाउनुहोस्:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` र `test_docs/translated_images` मा अनुवादित फाइलहरू जाँच गर्नुहोस् र सुनिश्चित गर्नुहोस्:
   - अनुवादको गुणस्तर राम्रो छ
   - मेटाडाटा टिप्पणीहरू सही छन्
   - मूल मार्कडाउन संरचना सुरक्षित छ
   - लिंक र छविहरू ठीकसँग काम गरिरहेका छन्

यस म्यानुअल परीक्षणले तपाईंका परिवर्तनहरू वास्तविक प्रयोगमा राम्रोसँग काम गर्छन् भन्ने सुनिश्चित गर्न मद्दत गर्छ।

### वातावरण चरहरू

1. मूल डाइरेक्टरीमा `.env.template` फाइलको कपी गरेर `.env` फाइल सिर्जना गर्नुहोस्।
2. निर्देशन अनुसार वातावरण चरहरू भर्नुहोस्।

> [!TIP]
>
> ### थप विकास वातावरण विकल्पहरू
>
> परियोजना स्थानीय रूपमा चलाउनुको अतिरिक्त, तपाईं GitHub Codespaces वा VS Code Dev Containers पनि प्रयोग गर्न सक्नुहुन्छ।
>
> #### GitHub Codespaces
>
> GitHub Codespaces प्रयोग गरेर यो नमूनाहरू भर्चुअल रूपमा चलाउन सकिन्छ र कुनै अतिरिक्त सेटअप आवश्यक पर्दैन।
>
> तलको बटनले तपाईंको ब्राउजरमा वेब-आधारित VS Code खोल्नेछ:
>
> 1. टेम्प्लेट खोल्नुहोस् (केही मिनेट लाग्न सक्छ):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers प्रयोग गरेर स्थानीय रूपमा चलाउने
>
> ⚠️ यो विकल्पले काम गर्नका लागि तपाईंको Docker Desktop मा कम्तीमा १६ GB RAM छुट्याइएको हुनुपर्छ। यदि तपाईंको RAM १६ GB भन्दा कम छ भने, तपाईं [GitHub Codespaces विकल्प](../..) वा [स्थानीय सेटअप](../..) प्रयास गर्न सक्नुहुन्छ।
>
> VS Code Dev Containers विकल्पले तपाईंको स्थानीय VS Code मा परियोजना खोल्छ, जसका लागि [Dev Containers एक्सटेन्सन](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) आवश्यक छ:
>
> 1. Docker Desktop सुरु गर्नुहोस् (यदि छैन भने स्थापना गर्नुहोस्)
> 2. परियोजना खोल्नुहोस्:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### कोड शैली

हामीले परियोजनामा एकरूपता कायम राख्न Python कोड फर्म्याटरको रूपमा [Black](https://github.com/psf/black) प्रयोग गर्छौं। Black एक कडाइका साथ कोडलाई पुनः फर्म्याट गर्ने उपकरण हो जसले Python कोडलाई Black कोड शैलीमा स्वतः रूपान्तरण गर्छ।

#### कन्फिगरेसन

Black को कन्फिगरेसन हाम्रो `pyproject.toml` मा निर्दिष्ट गरिएको छ:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black स्थापना गर्ने

तपाईंले Black लाई Poetry (सिफारिस गरिएको) वा pip बाट स्थापना गर्न सक्नुहुन्छ:

##### Poetry प्रयोग गरेर

विकास वातावरण सेटअप गर्दा Black स्वतः स्थापना हुन्छ:
```bash
poetry install
```

##### pip प्रयोग गरेर

pip प्रयोग गर्दा Black सिधै स्थापना गर्न सकिन्छ:
```bash
pip install black
```

#### Black प्रयोग गर्ने

##### Poetry सँग

1. परियोजनाका सबै Python फाइलहरू फर्म्याट गर्नुहोस्:
    ```bash
    poetry run black .
    ```

2. कुनै विशेष फाइल वा डाइरेक्टरी फर्म्याट गर्नुहोस्:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip सँग

1. परियोजनाका सबै Python फाइलहरू फर्म्याट गर्नुहोस्:
    ```bash
    black .
    ```

2. कुनै विशेष फाइल वा डाइरेक्टरी फर्म्याट गर्नुहोस्:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> हामी सिफारिस गर्छौं कि तपाईंको सम्पादकलाई Black प्रयोग गरेर कोडलाई सेभ गर्दा स्वतः फर्म्याट गर्ने गरी सेटअप गर्नुहोस्। धेरै आधुनिक सम्पादकहरूले यो एक्सटेन्सन वा प्लगइनमार्फत समर्थन गर्छन्।

## Co-op Translator चलाउने

तपाईंको वातावरणमा Poetry प्रयोग गरेर Co-op Translator चलाउन तलका चरणहरू पालना गर्नुहोस्:

1. अनुवाद परीक्षण गर्न चाहनुभएको डाइरेक्टरीमा जानुहोस् वा परीक्षणका लागि अस्थायी फोल्डर सिर्जना गर्नुहोस्।

2. तलको कमाण्ड चलाउनुहोस्। `-l ko` लाई तपाईं अनुवाद गर्न चाहनुभएको भाषा कोडले प्रतिस्थापन गर्नुहोस्। `-d` फ्ल्यागले डिबग मोड जनाउँछ।

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> कमाण्ड चलाउनु अघि तपाईंको Poetry वातावरण सक्रिय (poetry shell) भएको सुनिश्चित गर्नुहोस्।

## नयाँ भाषा योगदान गर्ने

हामी नयाँ भाषाहरूको समर्थन थप्ने योगदानहरूलाई स्वागत गर्छौं। PR खोल्नु अघि तलका चरणहरू पूरा गर्नुहोस् ताकि समीक्षा सहज होस्।

1. भाषा फन्ट म्यापिङमा थप्नुहोस्
   - `src/co_op_translator/fonts/font_language_mappings.yml` सम्पादन गर्नुहोस्
   - निम्न विवरण सहित एउटा प्रविष्टि थप्नुहोस्:
     - `code`: ISO-जस्तो भाषा कोड (जस्तै, `vi`)
     - `name`: मानवीय रूपमा बुझिने नाम
     - `font`: `src/co_op_translator/fonts/` मा उपलब्ध स्क्रिप्ट समर्थन गर्ने फन्ट
     - `rtl`: यदि दायाँदेखि बाँया लेखिन्छ भने `true`, नभए `false`

2. आवश्यक फन्ट फाइलहरू समावेश गर्नुहोस् (यदि आवश्यक छ)
   - नयाँ फन्ट आवश्यक भएमा, खुला स्रोत वितरणका लागि लाइसेन्स उपयुक्तता जाँच गर्नुहोस्
   - फन्ट फाइल `src/co_op_translator/fonts/` मा थप्नुहोस्

3. स्थानीय रूपमा जाँच गर्नुहोस्
   - सानो नमूनामा अनुवाद चलाउनुहोस् (Markdown, छवि, नोटबुकहरू जस्तै)
   - आउटपुट सही रूपमा देखिन्छ कि छैन जाँच गर्नुहोस्, फन्ट र RTL लेआउट सहित

4. डकुमेन्टेसन अपडेट गर्नुहोस्
   - भाषा `getting_started/supported-languages.md` मा देखिने सुनिश्चित गर्नुहोस्
   - `getting_started/README_languages_template.md` मा परिवर्तन आवश्यक छैन; यो समर्थित सूचीबाट स्वतः उत्पन्न हुन्छ

5. PR खोल्नुहोस्
   - थपिएको भाषा र फन्ट/लाइसेन्स सम्बन्धी विवरण दिनुहोस्
   - सम्भव भएमा रेंडर गरिएको आउटपुटका स्क्रिनशटहरू संलग्न गर्नुहोस्

उदाहरण YAML प्रविष्टि:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### नयाँ भाषा परीक्षण गर्ने

तपाईंले नयाँ भाषा परीक्षण गर्न तलको कमाण्ड चलाउन सक्नुहुन्छ:

```bash
# भर्चुअल वातावरण सिर्जना गर्नुहोस् र सक्रिय गर्नुहोस्
python -m venv .venv
# विन्डोज
.venv\Scripts\activate
# म्याकओएस/लिनक्स
source .venv/bin/activate
# विकास प्याकेज स्थापना गर्नुहोस्
pip install -e .
# अनुवाद चलाउनुहोस्
translate -l "new_lang"
```

## मर्मतकर्ता

### कमिट सन्देश र मर्ज रणनीति

हाम्रो परियोजनाको कमिट इतिहासमा एकरूपता र स्पष्टता कायम राख्न, हामीले **Squash and Merge** रणनीति प्रयोग गर्दा अन्तिम कमिट सन्देशको लागि विशेष ढाँचा पालना गर्छौं।

जब PR मर्ज हुन्छ, व्यक्तिगत कमिटहरू एकै कमिटमा समेटिन्छन्। अन्तिम कमिट सन्देश तलको ढाँचामा हुनुपर्छ ताकि इतिहास सफा र एकरूप रहोस्।

#### कमिट सन्देश ढाँचा (squash and merge का लागि)

हामी कमिट सन्देशका लागि तलको ढाँचा प्रयोग गर्छौं:

```bash
<type>: <description> (#<PR नम्बर>)
```

- **type**: कमिटको वर्गीकरण जनाउँछ। हामीले यी प्रकारहरू प्रयोग गर्छौं:
  - `Docs`: डकुमेन्टेसन अपडेटका लागि।
  - `Build`: बिल्ड प्रणाली वा निर्भरता सम्बन्धी परिवर्तनहरू, जस्तै कन्फिग फाइल, CI वर्कफ्लो, वा Dockerfile अपडेट।
  - `Core`: परियोजनाको मुख्य कार्यक्षमता वा फिचरहरूमा परिवर्तन, विशेष गरी `src/co_op_translator/core` भित्रका फाइलहरूमा।

- **description**: परिवर्तनको संक्षिप्त सारांश।
- **PR number**: सम्बन्धित pull request नम्बर।

**उदाहरणहरू**:

- `Docs: Update installation instructions for clarity (#50)`
- `Core: Improve handling of image translation (#60)`

> [!NOTE]
> हाल, **`Docs`**, **`Core`**, र **`Build`** उपसर्गहरू PR शीर्षकमा स्वचालित रूपमा थपिन्छन् जब स्रोत कोडमा उपयुक्त लेबलहरू लागू हुन्छन्। सही लेबल लागिसकेपछि तपाईंले सामान्यतया PR शीर्षक म्यानुअली परिवर्तन गर्न आवश्यक पर्दैन। केवल सबै कुरा सही छ र उपसर्ग ठीकसँग उत्पन्न भएको छ भनी जाँच गर्नुहोस्।

#### मर्ज रणनीति

हामीले pull request हरूका लागि डिफल्ट रूपमा **Squash and Merge** रणनीति प्रयोग गर्छौं। यसले सुनिश्चित गर्छ कि कमिट सन्देश हाम्रो ढाँचामा हुन्छ, चाहे व्यक्तिगत कमिटहरू नहोस्।

**कारणहरू**:

- सफा, रेखीय परियोजना इतिहास।
- कमिट सन्देशमा एकरूपता।
- साना कमिटहरूबाट हुने अव्यवस्था कम हुन्छ (जस्तै, "fix typo")।

मर्ज गर्दा अन्तिम कमिट सन्देश माथि वर्णन गरिएको ढाँचामा हुनु आवश्यक छ।

**Squash and Merge को उदाहरण**
यदि PR मा यी कमिटहरू छन्:

- `fix typo`
- `update README`
- `adjust formatting`

तिनीहरूलाई यसरी समेट्नुपर्छ:
`Docs: Improve documentation clarity and formatting (#65)`

### रिलिज प्रक्रिया

यो खण्डले मर्मतकर्ताहरूलाई Co-op Translator को नयाँ रिलिज प्रकाशन गर्ने सबैभन्दा सरल तरिका वर्णन गर्छ।

#### १. `pyproject.toml` मा संस्करण बढाउने

1. अर्को संस्करण नम्बर निर्णय गर्नुहोस् (हामी semantic versioning पालना गर्छौं: `MAJOR.MINOR.PATCH`)।
2. `pyproject.toml` सम्पादन गरी `[tool.poetry]` अन्तर्गत `version` फिल्ड अपडेट गर्नुहोस्।
3. केवल संस्करण परिवर्तन गर्ने (र यदि छ भने स्वतः अपडेट हुने lock/metadata फाइलहरू) समावेश गर्ने समर्पित PR खोल्नुहोस्।
4. समीक्षा पछि, **Squash and Merge** प्रयोग गरी अन्तिम कमिट सन्देश माथि वर्णन गरिएको ढाँचामा सुनिश्चित गर्नुहोस्।

#### २. GitHub Release सिर्जना गर्ने

1. GitHub रिपोजिटरी पृष्ठमा जानुहोस् र **Releases** → **Draft a new release** खोल्नुहोस्।
2. `main` शाखाबाट नयाँ ट्याग (जस्तै, `v0.13.0`) सिर्जना गर्नुहोस्।
3. रिलिज शीर्षक सोही संस्करणमा सेट गर्नुहोस् (जस्तै, `v0.13.0`)।
4. **Generate release notes** क्लिक गरी चेंजलॉग स्वचालित रूपमा भर्नुहोस्।
5. आवश्यक परे टेक्स्ट सम्पादन गर्नुहोस् (जस्तै, नयाँ समर्थित भाषाहरू वा महत्वपूर्ण परिवर्तनहरू हाइलाइट गर्न)।
6. रिलिज प्रकाशित गर्नुहोस्।

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**अस्वीकरण**:
यो दस्तावेज AI अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) प्रयोग गरी अनुवाद गरिएको हो। हामी शुद्धताका लागि प्रयासरत छौं, तर कृपया ध्यान दिनुहोस् कि स्वचालित अनुवादमा त्रुटि वा अशुद्धता हुन सक्छ। मूल दस्तावेज यसको मूल भाषामा नै अधिकारिक स्रोत मानिनु पर्छ। महत्वपूर्ण जानकारीका लागि व्यावसायिक मानव अनुवाद सिफारिस गरिन्छ। यस अनुवादको प्रयोगबाट उत्पन्न कुनै पनि गलतफहमी वा गलत व्याख्याका लागि हामी जिम्मेवार छैनौं।
<!-- CO-OP TRANSLATOR DISCLAIMER END -->