<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "822238e4451d04bb152cebb1be6f13c2",
  "translation_date": "2025-11-30T12:43:41+00:00",
  "source_file": "getting_started/command-reference.md",
  "language_code": "my"
}
-->
# Command reference

**Co-op Translator** CLI သည် ဘာသာပြန်လုပ်ငန်းစဉ်ကို စိတ်ကြိုက်ပြင်ဆင်နိုင်ရန် အမျိုးမျိုးသောရွေးချယ်စရာများကို ပေးဆောင်သည်။

Command                                       | ဖော်ပြချက်
----------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
translate -l "language_codes"                 | သင့်ပရောဂျက်ကို သတ်မှတ်ထားသောဘာသာစကားများသို့ ဘာသာပြန်သည်။ ဥပမာ - translate -l "es fr de" သည် စပိန်၊ ပြင်သစ်နှင့် ဂျာမန်ဘာသာသို့ ဘာသာပြန်သည်။ translate -l "all" ကို အသုံးပြု၍ ပံ့ပိုးထားသော ဘာသာစကားအားလုံးသို့ ဘာသာပြန်နိုင်သည်။
translate -l "language_codes" -u              | ရှိပြီးသားဘာသာပြန်ချက်များကို ဖျက်ပြီး ပြန်လည်ဖန်တီးခြင်းဖြင့် ဘာသာပြန်ချက်များကို အပ်ဒိတ်လုပ်သည်။ သတိပြုရန် - သတ်မှတ်ထားသောဘာသာစကားများအတွက် လက်ရှိဘာသာပြန်ချက်အားလုံးကို ဖျက်ပစ်မည်။
translate -l "language_codes" -img            | ပုံဖိုင်များကိုသာ ဘာသာပြန်သည်။
translate -l "language_codes" -md             | Markdown ဖိုင်များကိုသာ ဘာသာပြန်သည်။
translate -l "language_codes" -nb             | Jupyter notebook ဖိုင်များ (.ipynb) ကိုသာ ဘာသာပြန်သည်။
translate -l "language_codes" --fix           | ယခင်အကဲဖြတ်မှုရလဒ်အရ ယုံကြည်မှုနည်းသော ဘာသာပြန်ချက်များကို ပြန်လည်ဘာသာပြန်သည်။
translate -l "language_codes" -d              | အသေးစိတ်မှတ်တမ်းတင်မှုအတွက် debug mode ကို ဖွင့်သည်။
translate -l "language_codes" --save-logs, -s | DEBUG အဆင့်မှတ်တမ်းများကို <root_dir>/logs/ အောက်တွင် ဖိုင်များအဖြစ် သိမ်းဆည်းသည် (console သည် -d ဖြင့် ထိန်းချုပ်ထားသည်)
translate -l "language_codes" -r "root_dir"   | ပရောဂျက်၏ root directory ကို သတ်မှတ်သည်။
translate -l "language_codes" -f              | ပုံဘာသာပြန်မှုအတွက် အမြန် mode ကို အသုံးပြုသည် (အရည်အသွေးနှင့် alignment အနည်းငယ်ကျဆင်းသော်လည်း ၃ ဆအထိ မြန်ဆန်စေသည်)။
translate -l "language_codes" -y              | အားလုံးသော prompt များကို အလိုအလျောက် အတည်ပြုသည် (CI/CD pipeline များအတွက် အသုံးဝင်သည်)
translate -l "language_codes" --add-disclaimer/--no-disclaimer | ဘာသာပြန်ထားသော markdown နှင့် notebook များတွင် စက်ဘာသာပြန်ချက် သတိပေးစာပိုင်း ထည့်သွင်းခြင်းကို ဖွင့်/ပိတ်သည် (ပုံမှန် - ဖွင့်ထားသည်)။
translate -l "language_codes" --help          | CLI အတွင်းရှိ ရနိုင်သော command များအကြောင်း အကူအညီ ဖော်ပြချက်
evaluate -l "language_code"                  | သတ်မှတ်ထားသောဘာသာစကားအတွက် ဘာသာပြန်အရည်အသွေးကို အကဲဖြတ်ပြီး ယုံကြည်မှုအဆင့်များကို ပေးသည်။
evaluate -l "language_code" -c 0.8           | စိတ်ကြိုက် ယုံကြည်မှုနည်းနည်းကို သတ်မှတ်၍ ဘာသာပြန်ချက်များကို အကဲဖြတ်သည်။
evaluate -l "language_code" -f               | အမြန် အကဲဖြတ်မှု mode (rule-based သာဖြစ်ပြီး LLM မပါဝင်)
evaluate -l "language_code" -D               | နက်ရှိုင်းသော အကဲဖြတ်မှု mode (LLM-based သာဖြစ်ပြီး ပိုမိုအသေးစိတ် သော်လည်း နှေးကွေး)
evaluate -l "language_code" --save-logs, -s  | DEBUG အဆင့်မှတ်တမ်းများကို <root_dir>/logs/ အောက်တွင် ဖိုင်များအဖြစ် သိမ်းဆည်းသည်။
migrate-links -l "language_codes"             | ဘာသာပြန်ထားသော Markdown ဖိုင်များကို ပြန်လည်ဆန်းစစ်ပြီး notebook (.ipynb) များသို့ လင့်ခ်များကို အပ်ဒိတ်လုပ်သည်။ ဘာသာပြန်ထားသော notebook များ ရှိပါက အဲဒီကို ဦးစားပေးသုံးစွဲပြီး မရှိပါက မူလ notebook များသို့ ပြန်လည်ဆက်သွယ်နိုင်သည်။
migrate-links -l "language_codes" -r          | ပရောဂျက် root directory ကို သတ်မှတ်သည် (ပုံမှန် - လက်ရှိ directory)။
migrate-links -l "language_codes" --dry-run   | ဘယ်ဖိုင်များပြောင်းလဲမည်ကိုသာ ပြသပြီး ဖိုင်များကို မရေးသားပါ။
migrate-links -l "language_codes" --no-fallback-to-original | ဘာသာပြန်ထားသော notebook မရှိပါက မူလ notebook များသို့ လင့်ခ်ပြန်ရေးခြင်း မပြုလုပ်ပါ (ဘာသာပြန်ထားသော notebook ရှိသောအခါတွင်သာ အပ်ဒိတ်လုပ်သည်)။
migrate-links -l "language_codes" -d          | အသေးစိတ်မှတ်တမ်းတင်မှုအတွက် debug mode ကို ဖွင့်သည်။
migrate-links -l "language_codes" --save-logs, -s | DEBUG အဆင့်မှတ်တမ်းများကို <root_dir>/logs/ အောက်တွင် ဖိုင်များအဖြစ် သိမ်းဆည်းသည်။
migrate-links -l "all" -y                      | ဘာသာစကားအားလုံးကို လုပ်ဆောင်ပြီး သတိပေး prompt ကို အလိုအလျောက် အတည်ပြုသည်။

## အသုံးပြုမှု ဥပမာများ

  1. ပုံမှန်အပြုအမူ (ရှိပြီးသားဘာသာပြန်ချက်များကို ဖျက်မထားဘဲ အသစ်ထည့်သည်) - translate -l "ko"    translate -l "es fr de" -r "./my_project"

  2. ကိုရီးယားဘာသာ ပုံများသာ အသစ်ထည့်သည် (ရှိပြီးသားဘာသာပြန်ချက် မဖျက်ပါ) - translate -l "ko" -img

  3. ကိုရီးယားဘာသာ ဘာသာပြန်ချက်အားလုံးကို အပ်ဒိတ်လုပ်သည် (သတိ - ရှိပြီးသား ဘာသာပြန်ချက်အားလုံးကို ဖျက်ပြီး ပြန်လည်ဘာသာပြန်မည်) - translate -l "ko" -u

  4. ကိုရီးယားဘာသာ ပုံများကိုသာ အပ်ဒိတ်လုပ်သည် (သတိ - ရှိပြီးသား ပုံများအားလုံးကို ဖျက်ပြီး ပြန်လည်ဘာသာပြန်မည်) - translate -l "ko" -img -u

  5. ကိုရီးယားဘာသာ Markdown ဘာသာပြန်ချက်အသစ်များကိုသာ ထည့်သွင်းသည်၊ အခြားဘာသာပြန်ချက်များကို မထိခိုက်စေပါ - translate -l "ko" -md

  6. ယခင်အကဲဖြတ်မှုအရ ယုံကြည်မှုနည်းသော ဘာသာပြန်ချက်များကို ပြင်ဆင်သည် - translate -l "ko" --fix

  7. ယုံကြည်မှုနည်းသော ဘာသာပြန်ချက်များကို ဖိုင်အမျိုးအစားအလိုက်သာ ပြင်ဆင်သည် (Markdown) - translate -l "ko" --fix -md

  8. ယုံကြည်မှုနည်းသော ဘာသာပြန်ချက်များကို ဖိုင်အမျိုးအစားအလိုက်သာ ပြင်ဆင်သည် (ပုံ) - translate -l "ko" --fix -img

  9. ပုံဘာသာပြန်မှုအတွက် အမြန် mode ကို အသုံးပြုသည် - translate -l "ko" -img -f

  10. စိတ်ကြိုက် ယုံကြည်မှုနည်းနည်းဖြင့် ယုံကြည်မှုနည်းသော ဘာသာပြန်ချက်များကို ပြင်ဆင်သည် - translate -l "ko" --fix -c 0.8

  11. Debug mode ဥပမာ - translate -l "ko" -d: debug မှတ်တမ်းတင်မှုကို ဖွင့်သည်။
  12. မှတ်တမ်းများကို ဖိုင်များအဖြစ် သိမ်းဆည်းသည် - translate -l "ko" -s
  13. Console DEBUG နှင့် ဖိုင် DEBUG နှစ်ခုလုံး - translate -l "ko" -d -s
  14. စက်ဘာသာပြန် သတိပေးစာပိုင်း မထည့်သွင်းဘဲ ဘာသာပြန်သည် - translate -l "ko" --no-disclaimer

  15. ကိုရီးယားဘာသာ ဘာသာပြန်ထားသော notebook များအတွက် လင့်ခ်များကို ပြောင်းလဲသည် (ဘာသာပြန်ထားသော notebook များရှိပါက အပ်ဒိတ်လုပ်သည်) - migrate-links -l "ko"

  15. လင့်ခ်များကို dry-run ဖြင့် ပြသသည် (ဖိုင် မရေးသားပါ) - migrate-links -l "ko" --dry-run

  16. ဘာသာပြန်ထားသော notebook မရှိပါက မူလ notebook များသို့ ပြန်မသွားဘဲ လင့်ခ်များကိုသာ အပ်ဒိတ်လုပ်သည် - migrate-links -l "ko" --no-fallback-to-original

  17. ဘာသာစကားအားလုံးကို prompt ဖြင့် လုပ်ဆောင်သည် - migrate-links -l "all"

  18. ဘာသာစကားအားလုံးကို လုပ်ဆောင်ပြီး အလိုအလျောက် အတည်ပြုသည် - migrate-links -l "all" -y
  19. migrate-links အတွက် မှတ်တမ်းများကို ဖိုင်များအဖြစ် သိမ်းဆည်းသည် - migrate-links -l "ko ja" -s

### အကဲဖြတ်မှု ဥပမာများ

> [!WARNING]  
> **Beta Feature**: အကဲဖြတ်မှု လုပ်ဆောင်ချက်သည် လက်ရှိ beta အဆင့်တွင် ရှိသည်။ ဤလုပ်ဆောင်ချက်ကို ဘာသာပြန်ထားသော စာရွက်စာတမ်းများကို အကဲဖြတ်ရန် ထုတ်ပြန်ထားပြီး၊ အကဲဖြတ်နည်းလမ်းများနှင့် အသေးစိတ် အကောင်အထည်ဖော်မှုများကို ဆက်လက်တိုးတက်အောင် လုပ်ဆောင်နေဆဲဖြစ်ပြီး ပြောင်းလဲနိုင်ပါသည်။

  1. ကိုရီးယားဘာသာ ဘာသာပြန်ချက်များကို အကဲဖြတ်သည် - evaluate -l "ko"

  2. စိတ်ကြိုက် ယုံကြည်မှုနည်းနည်းဖြင့် အကဲဖြတ်သည် - evaluate -l "ko" -c 0.8

  3. အမြန် အကဲဖြတ်မှု (rule-based သာ) - evaluate -l "ko" -f

  4. နက်ရှိုင်းသော အကဲဖြတ်မှု (LLM-based သာ) - evaluate -l "ko" -D

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**အကြောင်းကြားချက်**  
ဤစာတမ်းကို AI ဘာသာပြန်ဝန်ဆောင်မှု [Co-op Translator](https://github.com/Azure/co-op-translator) ဖြင့် ဘာသာပြန်ထားပါသည်။ ကျွန်ုပ်တို့သည် တိကျမှန်ကန်မှုအတွက် ကြိုးစားသော်လည်း အလိုအလျောက် ဘာသာပြန်ချက်များတွင် အမှားများ သို့မဟုတ် မှားယွင်းချက်များ ပါဝင်နိုင်ကြောင်း သတိပြုပါရန် မေတ္တာရပ်ခံအပ်ပါသည်။ မူရင်းစာတမ်းကို မိမိဘာသာစကားဖြင့်သာ တရားဝင်အချက်အလက်အဖြစ် ယူဆသင့်ပါသည်။ အရေးကြီးသော အချက်အလက်များအတွက် လူ့ပညာရှင်များ၏ ဘာသာပြန်ချက်ကို အကြံပြုပါသည်။ ဤဘာသာပြန်ချက်ကို အသုံးပြုရာမှ ဖြစ်ပေါ်လာနိုင်သည့် နားလည်မှုမှားယွင်းမှုများအတွက် ကျွန်ုပ်တို့သည် တာဝန်မယူပါ။
<!-- CO-OP TRANSLATOR DISCLAIMER END -->