<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T12:41:26+00:00",
  "source_file": "README.md",
  "language_code": "my"
}
-->
# Co-op Translator

_သင်၏ပညာရေးဆိုင်ရာ GitHub အကြောင်းအရာများကို ဘာသာစကားစုံသို့ အလွယ်တကူ အလိုအလျောက် ဘာသာပြန်နိုင်ရန်၊ ကမ္ဘာလုံးဆိုင်ရာ ပရိသတ်ထံ ရောက်ရှိစေပါ။_

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 ဘာသာစကားစုံကို ထောက်ပံ့မှု

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) မှ ထောက်ပံ့ထားသည်

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[အာရဗီ](../ar/README.md) | [ဘင်္ဂါလီ](../bn/README.md) | [ဘူလ်ဂေးရီးယား](../bg/README.md) | [မြန်မာ (Burmese)](./README.md) | [တရုတ် (ရိုးရိုး)](../zh/README.md) | [တရုတ် (ရိုးရာ၊ ဟောင်ကောင်)](../hk/README.md) | [တရုတ် (ရိုးရာ၊ မာကာအို)](../mo/README.md) | [တရုတ် (ရိုးရာ၊ ထိုင်ဝမ်)](../tw/README.md) | [ခရိုအေးရှား](../hr/README.md) | [ချက်](../cs/README.md) | [ဒိန်းမတ်](../da/README.md) | [ဒတ်ချ်](../nl/README.md) | [အက်စတိုးနီးယား](../et/README.md) | [ဖင်နစ်](../fi/README.md) | [ပြင်သစ်](../fr/README.md) | [ဂျာမန်](../de/README.md) | [ဂရိ](../el/README.md) | [ဟီဘရူး](../he/README.md) | [ဟိန္ဒီ](../hi/README.md) | [ဟန်ဂေရီ](../hu/README.md) | [အင်ဒိုနီးရှား](../id/README.md) | [အီတလီ](../it/README.md) | [ဂျပန်](../ja/README.md) | [ကန်နာဒါ](../kn/README.md) | [ကိုရီးယား](../ko/README.md) | [လစ်သူအေးနီးယား](../lt/README.md) | [မလေး](../ms/README.md) | [မလေးလာမ်](../ml/README.md) | [မာရသီ](../mr/README.md) | [နီပေါလီ](../ne/README.md) | [နိုင်ဂျီးရီးယား ပစ်ဂင်](../pcm/README.md) | [နော်ဝေ](../no/README.md) | [ပါရှန် (ဖာစီ)](../fa/README.md) | [ပိုလန်](../pl/README.md) | [ပေါ်တူဂီ (ဘရာဇီးလ်)](../br/README.md) | [ပေါ်တူဂီ (ပေါ်တူဂီ)](../pt/README.md) | [ပန်ဂျာဘီ (ဂူရ်မူခီ)](../pa/README.md) | [ရိုမေးနီးယား](../ro/README.md) | [ရုရှား](../ru/README.md) | [ဆားဘီးယား (စီရီးလစ်)](../sr/README.md) | [စလိုဗက်](../sk/README.md) | [စလိုဗေးနီးယား](../sl/README.md) | [စပိန်](../es/README.md) | [ဆွာဟီလီ](../sw/README.md) | [ဆွီဒင်](../sv/README.md) | [တာဂလို (ဖိလစ်ပိုင်)](../tl/README.md) | [တမီးလ်](../ta/README.md) | [တီလူဂူ](../te/README.md) | [ထိုင်း](../th/README.md) | [တူရကီ](../tr/README.md) | [ယူကရိန်း](../uk/README.md) | [ဥရုဒူ](../ur/README.md) | [ဗီယက်နမ်](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## အနှစ်ချုပ်

**Co-op Translator** သည် သင်၏ပညာရေးဆိုင်ရာ GitHub အကြောင်းအရာများကို ဘာသာစကားစုံသို့ အလွယ်တကူ ပြောင်းလဲနိုင်စေသည်။
Markdown ဖိုင်များ၊ ပုံများ သို့မဟုတ် notebook များကို ပြင်ဆင်သည့်အခါ ဘာသာပြန်ချက်များသည် အလိုအလျောက် ကိုက်ညီမှုရှိနေပြီး ကမ္ဘာတစ်ဝှမ်းရှိ သင်ယူသူများအတွက် အချက်အလက်မှန်ကန်ပြီး နောက်ဆုံးပေါ်ဖြစ်စေပါသည်။

ဘာသာပြန်ထားသော အကြောင်းအရာများကို စီစဉ်ထားသည့် နမူနာ -

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.my.png)

## အလျင်အမြန် စတင်အသုံးပြုခြင်း

```bash
# မျှဝေမှု ပတ်ဝန်းကျင်တစ်ခု ဖန်တီးပြီး ဖွင့်ပါ (အကြံပြုသည်)
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# ပက်ကေ့ချ်ကို ထည့်သွင်းပါ
pip install co-op-translator
# ဘာသာပြန်ပါ
translate -l "ko ja fr" -md
```

Docker:

```bash
# GHCR မှ ပြည်သူ့ပုံရိပ်ကို ဆွဲယူပါ
docker pull ghcr.io/azure/co-op-translator:latest
# လက်ရှိဖိုလ်ဒါကို တပ်ဆင်ပြီး .env ဖိုင်ကို ပေးပြီး (Bash/Zsh) ပြေးပါ
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## အနည်းဆုံး ပြင်ဆင်မှု

1. `.env` ဖိုင်ကို အောက်ပါ template ဖြင့် ဖန်တီးပါ - [.env.template](../../.env.template)
2. LLM ပံ့ပိုးသူတစ်ခု (Azure OpenAI သို့မဟုတ် OpenAI) ကို ပြင်ဆင်ပါ
3. (ရွေးချယ်စရာ) ပုံများ ဘာသာပြန်ရန် (`-img`) Azure AI Vision ကို ပြင်ဆင်ပါ
4. (အကြံပြု) ယခင် ဘာသာပြန်ချက်များကို ရှင်းလင်းပြီး ပြဿနာမဖြစ်စေရန် (ဥပမာ - `translations/`)
5. (အကြံပြု) README တွင် ဘာသာစကား အပိုင်းတစ်ခု ထည့်သွင်းရန် [README languages template](./getting_started/README_languages_template.md) ကို အသုံးပြုပါ
6. ကြည့်ရှုရန် - [Azure AI ကို ပြင်ဆင်ခြင်း](./getting_started/set-up-azure-ai.md)

## အသုံးပြုနည်း

ထောက်ပံ့ထားသော အမျိုးအစားအားလုံး ဘာသာပြန်ရန် -

```bash
translate -l "ko ja"
```

Markdown သာ -

```bash
translate -l "de" -md
```

Markdown + ပုံများ -

```bash
translate -l "pt" -md -img
```

Notebook သာ -

```bash
translate -l "zh" -nb
```

အပို flag များ - [Command reference](./getting_started/command-reference.md)

## အင်္ဂါရပ်များ

- Markdown, notebook နှင့် ပုံများအတွက် အလိုအလျောက် ဘာသာပြန်ခြင်း
- မူရင်းအချက်အလက် ပြောင်းလဲမှုနှင့် ကိုက်ညီစေရန် ဘာသာပြန်ချက်များကို ထိန်းသိမ်းထားခြင်း
- ဒေသတွင်း (CLI) သို့မဟုတ် CI (GitHub Actions) တွင် အသုံးပြုနိုင်ခြင်း
- Azure OpenAI သို့မဟုတ် OpenAI ကို အသုံးပြုခြင်း၊ ပုံများအတွက် Azure AI Vision ကို ရွေးချယ်အသုံးပြုနိုင်ခြင်း
- Markdown ဖော်မတ်နှင့် ဖွဲ့စည်းမှုကို ထိန်းသိမ်းထားခြင်း

## စာတမ်းများ

- [Command-line လမ်းညွှန်](./getting_started/command-line-guide/command-line-guide.md)
- [GitHub Actions လမ်းညွှန် (အများပြည်သူ repository များနှင့် စံ secret များ)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [GitHub Actions လမ်းညွှန် (Microsoft အဖွဲ့အစည်း repository များနှင့် အဖွဲ့အဆင့် ပြင်ဆင်မှုများ)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [README ဘာသာစကား template](./getting_started/README_languages_template.md)
- [ထောက်ပံ့ထားသော ဘာသာစကားများ](./getting_started/supported-languages.md)
- [အထောက်အပံ့ ပေးခြင်း](./CONTRIBUTING.md)
- [ပြဿနာဖြေရှင်းခြင်း](./getting_started/troubleshooting.md)

### Microsoft အထူး လမ်းညွှန်
> [!NOTE]
> Microsoft “For Beginners” repository များကိုသာ ထိန်းသိမ်းသူများအတွက်။

- [“အခြားသင်တန်းများ” စာရင်း ပြင်ဆင်ခြင်း (MS Beginners repository များအတွက်)](./getting_started/update-other-courses.md)

## ကျွန်ုပ်တို့အား ထောက်ပံ့ပြီး ကမ္ဘာလုံးဆိုင်ရာ သင်ယူမှုကို မြှင့်တင်ပါ

ပညာရေးဆိုင်ရာ အကြောင်းအရာများကို ကမ္ဘာတစ်ဝှမ်း မျှဝေရာတွင် ပြောင်းလဲမှုတစ်ခု ဖြစ်စေဖို့ ကျွန်ုပ်တို့နှင့် ပူးပေါင်းပါ! [Co-op Translator](https://github.com/azure/co-op-translator) ကို GitHub တွင် ⭐ ပေးပြီး သင်ယူမှုနှင့် နည်းပညာတွင် ဘာသာစကားအတားအဆီးများကို ဖျက်ဆီးရန် ကျွန်ုပ်တို့၏ မစ်ရှင်ကို ထောက်ပံ့ပါ။ သင်၏ စိတ်ဝင်စားမှုနှင့် အထောက်အပံ့များသည် အရေးကြီးသော သက်ရောက်မှုရှိစေပါသည်။ ကုဒ်ထည့်သွင်းခြင်းနှင့် အင်္ဂါရပ် အကြံပြုချက်များကို အမြဲကြိုဆိုပါသည်။

### Microsoft ပညာရေး အကြောင်းအရာများကို သင့်ဘာသာစကားဖြင့် ရှာဖွေပါ

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)
- [Generative AI for Beginners using .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)
- [Generative AI for Beginners using Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML for Beginners](https://aka.ms/ml-beginners)
- [Data Science for Beginners](https://aka.ms/datascience-beginners)
- [AI for Beginners](https://aka.ms/ai-beginners)
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)
- [IoT for Beginners](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## ဗီဒီယို တင်ဆက်ချက်များ

👉 အောက်ပါ ပုံကို နှိပ်၍ YouTube တွင် ကြည့်ရှုနိုင်ပါသည်။

- **Open at Microsoft**: Co-op Translator ကို မည်သို့ အသုံးပြုရမည်ကို ၁၈ မိနစ်အတွင်း အကျဉ်းချုပ်နှင့် လမ်းညွှန်။

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.my.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## အထောက်အပံ့ ပေးခြင်း

ဤပရောဂျက်သည် အထောက်အပံ့များနှင့် အကြံပြုချက်များကို ကြိုဆိုပါသည်။ Azure Co-op Translator တွင် ပါဝင်ဆောင်ရွက်လိုပါက ကျွန်ုပ်တို့၏ [CONTRIBUTING.md](./CONTRIBUTING.md) ကို ကြည့်ရှု၍ Co-op Translator ကို ပိုမိုလွယ်ကူစေရန် မည်သို့ ကူညီနိုင်သည်ကို သိရှိပါ။

## ပါဝင်သူများ

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## အပြုအမူ စည်းကမ်းချက်

ဤပရောဂျက်သည် [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) ကို လက်ခံအသုံးပြုထားသည်။
အသေးစိတ်အချက်အလက်များအတွက် [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) ကို ကြည့်ရှုပါ၊ သို့မဟုတ် မေးခွန်းများရှိပါက [opencode@microsoft.com](mailto:opencode@microsoft.com) သို့ ဆက်သွယ်နိုင်ပါသည်။

## တာဝန်ရှိသော AI

Microsoft သည် ကျွန်ုပ်တို့၏ AI ထုတ်ကုန်များကို တာဝန်ရှိစွာ အသုံးပြုနိုင်ရန် ကူညီပေးခြင်း၊ သင်ယူမှုများကို မျှဝေခြင်းနှင့် Transparency Notes နှင့် Impact Assessments ကဲ့သို့သော ကိရိယာများမှတဆင့် ယုံကြည်မှုအခြေပြု မိတ်ဖက်ဆက်ဆံရေးများ တည်ဆောက်ခြင်းတို့ကို အဓိကထားဆောင်ရွက်နေပါသည်။ ဤအရင်းအမြစ်များအများစုကို [https://aka.ms/RAI](https://aka.ms/RAI) တွင် ရှာဖွေနိုင်ပါသည်။
Microsoft ၏ တာဝန်ရှိသော AI ကို ကိုင်တွယ်ရာတွင် တရားမျှတမှု၊ ယုံကြည်စိတ်ချရမှုနှင့် လုံခြုံမှု၊ ကိုယ်ရေးကိုယ်တာနှင့် လုံခြုံရေး၊ ပါဝင်ဆောင်ရွက်မှု၊ ထင်ရှားမှုနှင့် တာဝန်ယူမှုတို့ကို အခြေခံထားသည်။

ဤနမူနာတွင် အသုံးပြုထားသည့် အကြီးစား သဘာဝဘာသာစကား၊ ပုံနှင့် အသံ မော်ဒယ်များသည် မတရားမှု၊ ယုံကြည်စိတ်ချရမှုမရှိမှု သို့မဟုတ် မလေးစားဖွယ် အပြုအမူများ ပြုလုပ်နိုင်ပြီး ထိုကြောင့် ထိခိုက်မှုများ ဖြစ်ပေါ်စေနိုင်သည်။ အန္တရာယ်များနှင့် ကန့်သတ်ချက်များကို သိရှိရန် [Azure OpenAI service Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) ကို ကြည့်ရှုပါ။
ဤအန္တရာယ်များကို လျော့နည်းစေရန် အကြံပြုထားသောနည်းလမ်းမှာ သင့်အင်ဂျင်နီယာရေးဆွဲမှုတွင် အန္တရာယ်ရှိသောအပြုအမူများကို တွေ့ရှိကာ တားဆီးနိုင်သော လုံခြုံရေးစနစ်တစ်ခု ထည့်သွင်းခြင်းဖြစ်သည်။ [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) သည် လွတ်လပ်သောကာကွယ်မှုအလွှာတစ်ခုဖြစ်ပြီး၊ အသုံးပြုသူနှင့် AI ဖန်တီးသော အန္တရာယ်ရှိသောအကြောင်းအရာများကို အက်ပလီကေးရှင်းများနှင့် ဝန်ဆောင်မှုများတွင် တွေ့ရှိနိုင်သည်။ Azure AI Content Safety တွင် စာသားနှင့် ပုံ API များပါဝင်ပြီး၊ အန္တရာယ်ရှိသောအကြောင်းအရာများကို တွေ့ရှိနိုင်စေသည်။ ထို့အပြင် Content Safety Studio အပြန်အလှန်ဆက်သွယ်နိုင်သော စနစ်တစ်ခုလည်းရှိပြီး၊ အမျိုးမျိုးသော မော်ဒယ်များအတွင်း အန္တရာယ်ရှိသောအကြောင်းအရာများကို တွေ့ရှိရန်၊ စူးစမ်းရန်နှင့် နမူနာကုဒ်များကို စမ်းသပ်ရန် ခွင့်ပြုသည်။ အောက်ပါ [quickstart စာတမ်း](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) သည် ဝန်ဆောင်မှုသို့ တောင်းဆိုမှုများ ပြုလုပ်ပုံကို လမ်းညွှန်ပေးသည်။

အခြားတစ်ခုမှာ အက်ပလီကေးရှင်း၏ စုစုပေါင်း လုပ်ဆောင်မှုကိုလည်း စဉ်းစားရမည်ဖြစ်သည်။ မော်ဒယ်များစွာနှင့် မော်ဒယ်အမျိုးမျိုးပါဝင်သည့် အက်ပလီကေးရှင်းများတွင်၊ လုပ်ဆောင်မှုဆိုသည်မှာ သင်နှင့် သင့်အသုံးပြုသူများ မျှော်လင့်သလို စနစ်က လုပ်ဆောင်ပေးခြင်းဖြစ်ပြီး၊ အန္တရာယ်ရှိသော ထွက်ရှိမှုများ မဖြစ်ပေါ်စေရန်ပါဝင်သည်။ သင့်အက်ပလီကေးရှင်း၏ စုစုပေါင်းလုပ်ဆောင်မှုကို [ဖန်တီးမှုအရည်အသွေးနှင့် အန္တရာယ်နှင့် လုံခြုံရေးတိုင်းတာချက်များ](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) အသုံးပြု၍ သုံးသပ်ခြင်း အရေးကြီးသည်။

သင်၏ AI အက်ပလီကေးရှင်းကို ဖွံ့ဖြိုးရေးပတ်ဝန်းကျင်တွင် [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) အသုံးပြု၍ သုံးသပ်နိုင်သည်။ စမ်းသပ်ဒေတာစနစ် သို့မဟုတ် ရည်မှန်းချက်တစ်ခုကို အသုံးပြု၍ သင်၏ ဖန်တီး AI အက်ပလီကေးရှင်း၏ ဖန်တီးမှုများကို အတွင်းပိုင်း သုံးသပ်သူများ သို့မဟုတ် သင်ရွေးချယ်ထားသော စိတ်ကြိုက် သုံးသပ်သူများဖြင့် အရေအတွက်ဖြင့် တိုင်းတာနိုင်သည်။ သင့်စနစ်ကို သုံးသပ်ရန် prompt flow SDK ဖြင့် စတင်လိုပါက [quickstart လမ်းညွှန်](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) ကို လိုက်နာနိုင်သည်။ သုံးသပ်မှုတစ်ခု ပြုလုပ်ပြီးနောက် [Azure AI Studio တွင် ရလဒ်များကို မြင်ကွင်းဖော်ပြနိုင်သည်](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results)။

## ကုန်အမှတ်တံဆိပ်များ

ဤပရောဂျက်တွင် ပရောဂျက်များ၊ ထုတ်ကုန်များ သို့မဟုတ် ဝန်ဆောင်မှုများအတွက် ကုန်အမှတ်တံဆိပ်များ သို့မဟုတ် လိုဂိုများ ပါဝင်နိုင်သည်။ Microsoft ၏ ကုန်အမှတ်တံဆိပ်များ သို့မဟုတ် လိုဂိုများကို အသုံးပြုခြင်းသည် [Microsoft ၏ ကုန်အမှတ်တံဆိပ်နှင့် အမှတ်တံဆိပ် လမ်းညွှန်ချက်များ](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) ကို လိုက်နာရမည်ဖြစ်သည်။ ဤပရောဂျက်၏ ပြင်ဆင်ထားသော ဗားရှင်းများတွင် Microsoft ၏ ကုန်အမှတ်တံဆိပ်များ သို့မဟုတ် လိုဂိုများကို အသုံးပြုခြင်းသည် ရောထွေးမှု ဖြစ်စေခြင်း သို့မဟုတ် Microsoft ၏ အားပေးမှုကို ဆိုလိုခြင်း မဖြစ်စေရန် လိုအပ်သည်။ တတိယပါတီ ကုန်အမှတ်တံဆိပ်များ သို့မဟုတ် လိုဂိုများကို အသုံးပြုခြင်းသည် ထိုတတိယပါတီ၏ မူဝါဒများအရ ဖြစ်သည်။

## အကူအညီရယူရန်

AI အက်ပလီကေးရှင်းများ တည်ဆောက်ရာတွင် အခက်အခဲရှိပါက သို့မဟုတ် မေးခွန်းများရှိပါက အောက်ပါနေရာတွင် ပါဝင်ဆွေးနွေးနိုင်ပါသည်-

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

ထုတ်ကုန်တုံ့ပြန်ချက် သို့မဟုတ် အမှားများရှိပါက အောက်ပါနေရာသို့ သွားရောက်ကြည့်ရှုနိုင်ပါသည်-

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**အကြောင်းကြားချက်**  
ဤစာတမ်းကို AI ဘာသာပြန်ဝန်ဆောင်မှု [Co-op Translator](https://github.com/Azure/co-op-translator) ဖြင့် ဘာသာပြန်ထားပါသည်။ ကျွန်ုပ်တို့သည် တိကျမှန်ကန်မှုအတွက် ကြိုးစားသော်လည်း အလိုအလျောက် ဘာသာပြန်ချက်များတွင် အမှားများ သို့မဟုတ် မှားယွင်းချက်များ ပါဝင်နိုင်ကြောင်း သတိပြုပါရန် မေတ္တာရပ်ခံအပ်ပါသည်။ မူရင်းစာတမ်းကို မူလဘာသာဖြင့်သာ တရားဝင်အရင်းအမြစ်အဖြစ် ယူဆသင့်ပါသည်။ အရေးကြီးသော အချက်အလက်များအတွက် လူ့ဘာသာပြန်ပညာရှင်မှ ဘာသာပြန်ခြင်းကို အကြံပြုပါသည်။ ဤဘာသာပြန်ချက်ကို အသုံးပြုရာမှ ဖြစ်ပေါ်လာနိုင်သည့် နားလည်မှုမှားယွင်းမှုများအတွက် ကျွန်ုပ်တို့သည် တာဝန်မယူပါ။
<!-- CO-OP TRANSLATOR DISCLAIMER END -->