<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:51:02+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "mr"
}
-->
# Co-op Translator वापरून तुमचा प्रोजेक्ट भाषांतरित करा

**Co-op Translator** हे एक कमांड-लाइन इंटरफेस (CLI) टूल आहे जे तुमच्या प्रोजेक्टमधील मार्कडाउन आणि इमेज फाइल्स अनेक भाषांमध्ये भाषांतरित करण्यात मदत करते. या विभागात हे टूल कसे वापरायचे, विविध CLI पर्याय कोणते आहेत, आणि वेगवेगळ्या वापराच्या उदाहरणांसाठी कमांड्स कशा वापरायच्या हे समजावले आहे.

> [!NOTE]
> सर्व कमांड्स आणि त्यांचे तपशीलवार वर्णन पाहण्यासाठी [Command reference](./command-reference.md) पहा.

---

## उदाहरणे आणि कमांड्स

**Co-op Translator** साठी काही सामान्य वापराच्या उदाहरणांसह योग्य कमांड्स खाली दिल्या आहेत.

### 1. बेसिक भाषांतर (एकाच भाषेत)

तुमचा संपूर्ण प्रोजेक्ट (मार्कडाउन फाइल्स आणि इमेजेस) एका भाषेत, जसे की कोरियन, भाषांतरित करण्यासाठी खालील कमांड वापरा:

```bash
translate -l "ko"
```

ही कमांड सर्व मार्कडाउन आणि इमेज फाइल्स कोरियनमध्ये भाषांतरित करेल, आणि नवीन भाषांतरे जोडेल, विद्यमान भाषांतर नष्ट न करता.

> [!TIP]
>
> **Co-op Translator** मध्ये कोणते भाषा कोड्स उपलब्ध आहेत हे पाहायचे आहे का? अधिक माहितीसाठी रेपॉजिटरीमधील [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) विभाग पहा.

#### Phi-3 CookBook वर उदाहरण

**Phi-3 CookBook** मध्ये, मी विद्यमान मार्कडाउन फाइल्स आणि इमेजेससाठी कोरियन भाषांतर जोडण्यासाठी खालील पद्धत वापरली.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. एकापेक्षा जास्त भाषांमध्ये भाषांतर

तुमचा प्रोजेक्ट एकापेक्षा जास्त भाषांमध्ये (उदा. स्पॅनिश, फ्रेंच, आणि जर्मन) भाषांतरित करण्यासाठी ही कमांड वापरा:

```bash
translate -l "es fr de"
```

ही कमांड प्रोजेक्टचे स्पॅनिश, फ्रेंच, आणि जर्मनमध्ये भाषांतर करेल, आणि नवीन भाषांतरे जोडेल, विद्यमान भाषांतर नष्ट न करता.

#### Phi-3 CookBook वर उदाहरण

**Phi-3 CookBook** मध्ये, नवीन कमिट्सनुसार ताज्या बदलांसाठी अपडेट केल्यानंतर, मी नवीन मार्कडाउन फाइल्स आणि इमेजेसचे भाषांतर करण्यासाठी ही पद्धत वापरली.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> एकावेळी एकच भाषा भाषांतरित करणे सामान्यतः शिफारसीय आहे, पण अशा परिस्थितीत जिथे विशिष्ट बदल जोडायचे असतात, तिथे एकाच वेळी अनेक भाषांमध्ये भाषांतर करणे उपयुक्त ठरते.

### 3. भाषांतर अपडेट करणे (विद्यमान भाषांतर हटवते)

विद्यमान भाषांतर अपडेट करण्यासाठी (म्हणजेच, सध्याचे भाषांतर हटवून नवीन भाषांतर करणे), `-u` पर्याय वापरा. हे दिलेल्या भाषांसाठी सर्व विद्यमान भाषांतरे हटवेल आणि पुन्हा भाषांतर करेल.

```bash
translate -l "ko" -u
```

इशारा: ही कमांड विद्यमान भाषांतर हटवण्यापूर्वी पुष्टी मागेल.

#### Phi-3 CookBook वर उदाहरण

**Phi-3 CookBook** मध्ये, मी स्पॅनिशमधील सर्व भाषांतरित फाइल्स अपडेट करण्यासाठी ही पद्धत वापरली. मूळ मजकुरात मोठे बदल असतील तेव्हा ही पद्धत वापरणे योग्य आहे. फक्त काहीच भाषांतरित मार्कडाउन फाइल्स अपडेट करायच्या असतील, तर त्या फाइल्स स्वतः हटवून `-a` पद्धतीने अपडेटेड भाषांतर जोडणे अधिक सोयीचे आहे.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. फक्त इमेजेसचे भाषांतर

तुमच्या प्रोजेक्टमधील फक्त इमेज फाइल्स भाषांतरित करायच्या असतील, तर `-img` पर्याय वापरा:

```bash
translate -l "ko" -img
```

ही कमांड फक्त इमेजेसचे कोरियनमध्ये भाषांतर करेल, मार्कडाउन फाइल्सना न बदलता.

### 6. फक्त मार्कडाउन फाइल्सचे भाषांतर

तुमच्या प्रोजेक्टमधील फक्त मार्कडाउन फाइल्स भाषांतरित करायच्या असतील, तर `-md` पर्याय वापरा:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook वर उदाहरण

**Phi-3 CookBook** मध्ये, मी कोरियन फाइल्समधील भाषांतरातील त्रुटी तपासण्यासाठी आणि त्रुटी आढळलेल्या फाइल्ससाठी आपोआप पुन्हा भाषांतर करण्यासाठी ही पद्धत वापरली.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

हा पर्याय भाषांतरातील त्रुटी तपासतो. सध्या, मूळ आणि भाषांतरित फाइल्समधील ओळींच्या ब्रेक्समधील फरक सहापेक्षा जास्त असेल, तर ती फाइल त्रुटी म्हणून चिन्हांकित होते. भविष्यात हे निकष अधिक लवचिक करण्याचा विचार आहे.

उदाहरणार्थ, ही पद्धत हरवलेले भाग किंवा खराब झालेली भाषांतरे शोधण्यासाठी उपयुक्त आहे, आणि अशा फाइल्ससाठी आपोआप पुन्हा भाषांतर करेल.

पण, तुम्हाला आधीच माहिती असेल की कोणत्या फाइल्समध्ये समस्या आहे, तर त्या फाइल्स स्वतः हटवून `-a` पर्याय वापरून पुन्हा भाषांतर करणे अधिक सोयीचे आहे.

### 8. डिबग मोड

समस्या शोधण्यासाठी तपशीलवार लॉगिंग सुरू करायचे असल्यास, `-d` पर्याय वापरा:

```bash
translate -l "ko" -d
```

ही कमांड भाषांतर डिबग मोडमध्ये चालवेल, ज्यामुळे अतिरिक्त लॉगिंग माहिती मिळेल आणि भाषांतर प्रक्रियेत समस्या शोधणे सोपे जाईल.

#### Phi-3 CookBook वर उदाहरण

**Phi-3 CookBook** मध्ये, मार्कडाउन फाइल्समध्ये अनेक लिंक्स असलेल्या भाषांतरांमुळे फॉरमॅटिंग त्रुटी येत होत्या, जसे की तुटलेली भाषांतरे आणि दुर्लक्षित ओळी. ही समस्या शोधण्यासाठी, मी `-d` पर्याय वापरून भाषांतर प्रक्रिया कशी चालते हे पाहिले.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. सर्व भाषांमध्ये भाषांतर

तुम्हाला प्रोजेक्ट सर्व समर्थित भाषांमध्ये भाषांतरित करायचा असेल, तर all हे कीवर्ड वापरा.

> [!WARNING]
> सर्व भाषांमध्ये एकाच वेळी भाषांतर करणे प्रोजेक्टच्या आकारावर अवलंबून खूप वेळ घेऊ शकते. उदाहरणार्थ, **Phi-3 CookBook** चे स्पॅनिशमध्ये भाषांतर सुमारे 2 तास लागले. इतक्या मोठ्या प्रमाणावर, 20 भाषांसाठी एकट्या व्यक्तीने हे करणे शक्य नाही. काम विभागून, प्रत्येकाने एक किंवा दोन भाषांची जबाबदारी घेऊन, हळूहळू भाषांतर अपडेट करणे शिफारसीय आहे.

```bash
translate -l "all"
```

ही कमांड प्रोजेक्ट सर्व उपलब्ध भाषांमध्ये भाषांतरित करेल. पुढे गेल्यास, प्रोजेक्टच्या आकारावर अवलंबून भाषांतरास बराच वेळ लागू शकतो.

> [!TIP]
>
> ### भाषांतरित फाइल्स स्वतः हटवणे (ऐच्छिक)
> आता भाषांतरित फाइल्स आपोआप ओळखल्या जातात आणि मूळ फाइल अपडेट झाल्यावर साफ केल्या जातात.
>
> पण, तुम्हाला विशिष्ट फाइल पुन्हा भाषांतरित करायची असेल किंवा सिस्टमचे वर्तन ओव्हरराईड करायचे असेल, तर खालील कमांड वापरून सर्व भाषांमधील त्या फाइलचे व्हर्जन्स हटवू शकता.
>
> ### Windows वर:
> 1. **Command Prompt वापरून**:
>    - Command Prompt उघडा.
>    - `cd` कमांड वापरून फाइल्स असलेल्या फोल्डरमध्ये जा.
>    - फाइल्स हटवण्यासाठी खालील कमांड वापरा:
>      ```
>      del /s *filename*
>      ```
>      `filename` मध्ये तुम्ही शोधत असलेल्या फाइलच्या नावाचा भाग द्या. `/s` पर्याय उपफोल्डर्समध्ये शोधतो.
>
> 2. **PowerShell वापरून**:
>    - PowerShell उघडा.
>    - ही कमांड चालवा:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` मध्ये फोल्डरचा पथ आणि `filename` मध्ये विशिष्ट नाव द्या.
>
> ### macOS/Linux वर:
> 1. **Terminal वापरून**:
>   - Terminal उघडा.
>   - `cd` वापरून डिरेक्टरीमध्ये जा.
>   - `find` कमांड वापरा:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` मध्ये विशिष्ट नाव द्या.
>
> फाइल्स हटवण्यापूर्वी नेहमी दोनदा तपासा, चुकून फाइल्स नष्ट होऊ नयेत.
>
> एकदा गरजेच्या फाइल्स हटवल्यावर, फक्त तुमची `translate -l` कमांड पुन्हा चालवा, म्हणजे ताज्या बदलांसह फाइल्स अपडेट होतील.

---

**अस्वीकरण**:
हे दस्तऐवज AI भाषांतर सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) वापरून भाषांतरित केले आहे. आम्ही अचूकतेसाठी प्रयत्नशील असलो तरी, कृपया लक्षात घ्या की स्वयंचलित भाषांतरात चुका किंवा अचूकतेचा अभाव असू शकतो. मूळ भाषेतील दस्तऐवज हा अधिकृत स्रोत मानावा. अत्यावश्यक माहितीसाठी, व्यावसायिक मानवी भाषांतराची शिफारस केली जाते. या भाषांतराचा वापर करून झालेल्या कोणत्याही गैरसमज किंवा चुकीच्या अर्थासाठी आम्ही जबाबदार राहणार नाही.