<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T10:39:10+00:00",
  "source_file": "README.md",
  "language_code": "mr"
}
-->
# को-ऑप ट्रान्सलेटर

_आपल्या शैक्षणिक GitHub सामग्रीचे अनेक भाषांमध्ये सहजपणे भाषांतर करून जागतिक प्रेक्षकांपर्यंत पोहोचवा._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 बहुभाषिक समर्थन

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) द्वारे समर्थित

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[अरबी](../ar/README.md) | [बंगाली](../bn/README.md) | [बल्गेरियन](../bg/README.md) | [बर्मी (म्यानमार)](../my/README.md) | [चिनी (सोपे)](../zh/README.md) | [चिनी (परंपरागत, हॉंग कॉंग)](../hk/README.md) | [चिनी (परंपरागत, मकाऊ)](../mo/README.md) | [चिनी (परंपरागत, तैवान)](../tw/README.md) | [क्रोएशियन](../hr/README.md) | [चेक](../cs/README.md) | [डॅनिश](../da/README.md) | [डच](../nl/README.md) | [एस्टोनियन](../et/README.md) | [फिनिश](../fi/README.md) | [फ्रेंच](../fr/README.md) | [जर्मन](../de/README.md) | [ग्रीक](../el/README.md) | [हिब्रू](../he/README.md) | [हिंदी](../hi/README.md) | [हंगेरियन](../hu/README.md) | [इंडोनेशियन](../id/README.md) | [इटालियन](../it/README.md) | [जपानी](../ja/README.md) | [कन्नड](../kn/README.md) | [कोरियन](../ko/README.md) | [लिथुआनियन](../lt/README.md) | [मलय](../ms/README.md) | [मलयाळम](../ml/README.md) | [मराठी](./README.md) | [नेपाली](../ne/README.md) | [नायजेरियन पिजिन](../pcm/README.md) | [नॉर्वेजियन](../no/README.md) | [फारसी (पर्शियन)](../fa/README.md) | [पोलिश](../pl/README.md) | [पोर्तुगीज (ब्राझील)](../br/README.md) | [पोर्तुगीज (पोर्तुगाल)](../pt/README.md) | [पंजाबी (गुरमुखी)](../pa/README.md) | [रोमानियन](../ro/README.md) | [रशियन](../ru/README.md) | [सर्बियन (सिरिलिक)](../sr/README.md) | [स्लोव्हाक](../sk/README.md) | [स्लोव्हेनियन](../sl/README.md) | [स्पॅनिश](../es/README.md) | [स्वाहिली](../sw/README.md) | [स्वीडिश](../sv/README.md) | [टागालॉग (फिलिपिनो)](../tl/README.md) | [तमिळ](../ta/README.md) | [तेलुगू](../te/README.md) | [थाई](../th/README.md) | [तुर्की](../tr/README.md) | [युक्रेनियन](../uk/README.md) | [उर्दू](../ur/README.md) | [व्हिएतनामी](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## आढावा

**को-ऑप ट्रान्सलेटर** आपली शैक्षणिक GitHub सामग्री अनेक भाषांमध्ये सहजपणे स्थानिक करण्यास मदत करतो.
जेव्हा आपण आपली Markdown फाइल्स, प्रतिमा किंवा नोटबुक्स अपडेट करता, तेव्हा भाषांतर आपोआप समक्रमित राहते, ज्यामुळे आपल्या सामग्रीची अचूकता आणि अद्ययावतता जगभरातील शिकणाऱ्यांसाठी कायम राहते.

भाषांतरित सामग्री कशी आयोजित केली जाते याचे उदाहरण:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.mr.png)

## जलद प्रारंभ

```bash
# एक आभासी वातावरण तयार करा आणि सक्रिय करा (शिफारस केलेले)
python -m venv .venv
# विंडोज
.venv\Scripts\activate
# मॅकओएस/लिनक्स
source .venv/bin/activate
# पॅकेज स्थापित करा
pip install co-op-translator
# भाषांतर करा
translate -l "ko ja fr" -md
```

Docker:

```bash
# GHCR मधून सार्वजनिक प्रतिमा ओढा
docker pull ghcr.io/azure/co-op-translator:latest
# चालू फोल्डर माउंट करून आणि .env प्रदान करून चालवा (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## किमान सेटअप

1. टेम्प्लेट वापरून `.env` फाइल तयार करा: [.env.template](../../.env.template)
2. एक LLM प्रदाता कॉन्फिगर करा (Azure OpenAI किंवा OpenAI)
3. (ऐच्छिक) प्रतिमा भाषांतरासाठी (`-img`), Azure AI Vision कॉन्फिगर करा
4. (शिफारस) कोणत्याही आधीच्या भाषांतरांना साफ करा जेणेकरून संघर्ष टाळता येईल (उदा., `translations/`)
5. (शिफारस) आपल्या README मध्ये भाषांतर विभाग जोडा [README languages template](./getting_started/README_languages_template.md) वापरून
6. पहा: [Azure AI सेटअप करा](./getting_started/set-up-azure-ai.md)

## वापर

सर्व समर्थित प्रकारांचे भाषांतर करा:

```bash
translate -l "ko ja"
```

फक्त Markdown:

```bash
translate -l "de" -md
```

Markdown + प्रतिमा:

```bash
translate -l "pt" -md -img
```

फक्त नोटबुक्स:

```bash
translate -l "zh" -nb
```

अधिक फलक: [कमांड संदर्भ](./getting_started/command-reference.md)

## वैशिष्ट्ये

- Markdown, नोटबुक्स आणि प्रतिमांसाठी स्वयंचलित भाषांतर
- स्रोत बदलांसह भाषांतर समक्रमित ठेवते
- स्थानिक (CLI) किंवा CI (GitHub Actions) मध्ये कार्य करते
- Azure OpenAI किंवा OpenAI वापरते; प्रतिमांसाठी ऐच्छिक Azure AI Vision
- Markdown स्वरूपन आणि रचना जपते

## दस्तऐवज

- [कमांड-लाइन मार्गदर्शक](./getting_started/command-line-guide/command-line-guide.md)
- [GitHub Actions मार्गदर्शक (सार्वजनिक रेपॉझिटरीज आणि मानक गुपिते)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [GitHub Actions मार्गदर्शक (Microsoft संघटना रेपॉझिटरीज आणि संघटनात्मक सेटअप)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [README भाषांतर टेम्प्लेट](./getting_started/README_languages_template.md)
- [समर्थित भाषा](./getting_started/supported-languages.md)
- [योगदान](./CONTRIBUTING.md)
- [समस्या निवारण](./getting_started/troubleshooting.md)

### Microsoft-विशिष्ट मार्गदर्शक
> [!NOTE]
> फक्त Microsoft “For Beginners” रेपॉझिटरीजच्या देखभाल करणाऱ्यांसाठी.

- [“इतर कोर्सेस” यादी अद्यतनित करणे (फक्त MS Beginners रेपॉझिटरीजसाठी)](./getting_started/update-other-courses.md)

## आमचे समर्थन करा आणि जागतिक शिक्षणाला प्रोत्साहन द्या

शैक्षणिक सामग्री जागतिक स्तरावर कशी शेअर केली जाते यामध्ये आमच्यासोबत क्रांती घडवा! [Co-op Translator](https://github.com/azure/co-op-translator) ला GitHub वर ⭐ द्या आणि शिक्षण व तंत्रज्ञानातील भाषिक अडथळे दूर करण्याच्या आमच्या मिशनला समर्थन द्या. आपली आवड आणि योगदान मोठा फरक घडवतात! कोड योगदान आणि वैशिष्ट्यांच्या सूचना नेहमी स्वागतार्ह आहेत.

### Microsoft शैक्षणिक सामग्री आपल्या भाषेत एक्सप्लोर करा

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)
- [.NET वापरून Generative AI for Beginners](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)
- [Java वापरून Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML for Beginners](https://aka.ms/ml-beginners)
- [Data Science for Beginners](https://aka.ms/datascience-beginners)
- [AI for Beginners](https://aka.ms/ai-beginners)
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)
- [IoT for Beginners](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## व्हिडिओ सादरीकरणे

👉 खालील प्रतिमेवर क्लिक करून YouTube वर पाहा.

- **Open at Microsoft**: को-ऑप ट्रान्सलेटर कसा वापरायचा याचा 18 मिनिटांचा संक्षिप्त परिचय आणि जलद मार्गदर्शक.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.mr.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## योगदान

हा प्रकल्प योगदान आणि सूचना स्वागत करतो. Azure Co-op Translator मध्ये योगदान देण्यास इच्छुक आहात? कृपया आमचा [CONTRIBUTING.md](./CONTRIBUTING.md) पहा ज्यात को-ऑप ट्रान्सलेटर अधिक सुलभ करण्यासाठी कसे मदत करता येईल याचे मार्गदर्शन आहे.

## योगदानकर्ते

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## आचारसंहिता

या प्रकल्पाने [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) स्वीकारली आहे.
अधिक माहितीसाठी [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) पहा किंवा
कोणत्याही अतिरिक्त प्रश्नांसाठी किंवा टिप्पण्यांसाठी [opencode@microsoft.com](mailto:opencode@microsoft.com) शी संपर्क करा.

## जबाबदार AI

Microsoft आपल्या ग्राहकांना आमची AI उत्पादने जबाबदारीने वापरण्यास मदत करण्यासाठी, आमचे अनुभव शेअर करण्यासाठी आणि Transparency Notes आणि Impact Assessments सारख्या साधनांद्वारे विश्वासावर आधारित भागीदारी तयार करण्यासाठी वचनबद्ध आहे. या संसाधनांपैकी बरेच काही येथे उपलब्ध आहे: [https://aka.ms/RAI](https://aka.ms/RAI).
Microsoft चे जबाबदार AI चे दृष्टिकोन आमच्या AI तत्त्वांवर आधारित आहे: न्याय, विश्वासार्हता आणि सुरक्षितता, गोपनीयता आणि सुरक्षा, समावेश, पारदर्शकता आणि जबाबदारी.

मोठ्या प्रमाणावर नैसर्गिक भाषा, प्रतिमा आणि भाषण मॉडेल्स - जसे की या नमुन्यात वापरलेले - कधीकधी अन्यायकारक, अविश्वसनीय किंवा अपमानास्पद वर्तन करू शकतात, ज्यामुळे हानी होऊ शकते. कृपया धोके आणि मर्यादा जाणून घेण्यासाठी [Azure OpenAI सेवा Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) पहा.
या धोके कमी करण्यासाठी शिफारस केलेली पद्धत म्हणजे आपल्या आर्किटेक्चरमध्ये एक सुरक्षा प्रणाली समाविष्ट करणे जी हानिकारक वर्तन ओळखू आणि प्रतिबंधित करू शकेल. [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) स्वतंत्र संरक्षण स्तर प्रदान करते, जे अनुप्रयोगांमध्ये आणि सेवांमध्ये वापरकर्त्यांनी तयार केलेल्या आणि AI-निर्मित हानिकारक सामग्रीचा शोध घेऊ शकते. Azure AI Content Safety मध्ये मजकूर आणि प्रतिमा API समाविष्ट आहेत जे तुम्हाला हानिकारक सामग्री ओळखण्याची परवानगी देतात. आमच्याकडे एक इंटरऐक्टिव्ह Content Safety Studio देखील आहे जे तुम्हाला वेगवेगळ्या प्रकारच्या हानिकारक सामग्रीचा शोध घेण्यासाठी नमुना कोड पाहण्याची, एक्सप्लोर करण्याची आणि वापरून पाहण्याची संधी देते. खालील [क्विकस्टार्ट दस्तऐवज](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) तुम्हाला सेवेवर विनंत्या कशा करायच्या याचे मार्गदर्शन करतो.

दुसरी बाब लक्षात घेण्यासारखी म्हणजे एकूण अनुप्रयोग कार्यक्षमता. मल्टी-मोडल आणि मल्टी-मॉडेल अनुप्रयोगांसह, आम्ही कार्यक्षमता याचा अर्थ असा घेतो की प्रणाली तुम्ही आणि तुमचे वापरकर्ते अपेक्षित तशी कामगिरी करते, ज्यात हानिकारक आउटपुट तयार न करणे देखील समाविष्ट आहे. तुमच्या एकूण अनुप्रयोगाची कार्यक्षमता [निर्मिती गुणवत्ता आणि धोका व सुरक्षा मेट्रिक्स](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) वापरून मोजणे महत्त्वाचे आहे.

तुम्ही तुमच्या विकास वातावरणात [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) वापरून तुमचा AI अनुप्रयोग मूल्यांकन करू शकता. चाचणी डेटासेट किंवा लक्ष्य दिल्यास, तुमच्या जनरेटिव्ह AI अनुप्रयोगाच्या निर्मितींचे प्रमाणात्मक मापन अंगभूत मूल्यांकन करणारे किंवा तुमच्या पसंतीचे सानुकूल मूल्यांकन करणारे वापरून केले जाते. तुमची प्रणाली मूल्यांकन करण्यासाठी prompt flow SDK वापरण्यास सुरुवात करण्यासाठी, तुम्ही [क्विकस्टार्ट मार्गदर्शक](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) अनुसरू शकता. एकदा तुम्ही मूल्यांकन चालवले की, तुम्ही [Azure AI Studio मध्ये निकालांचे दृश्य पाहू शकता](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## ट्रेडमार्क

हा प्रकल्प प्रकल्प, उत्पादने किंवा सेवांसाठी ट्रेडमार्क किंवा लोगो असू शकतो. Microsoft ट्रेडमार्क किंवा लोगोचा अधिकृत वापर [Microsoft च्या ट्रेडमार्क आणि ब्रँड मार्गदर्शक तत्त्वांचे](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) पालन करणे आवश्यक आहे. या प्रकल्पाच्या सुधारित आवृत्त्यांमध्ये Microsoft ट्रेडमार्क किंवा लोगोचा वापर गोंधळ निर्माण करू नये किंवा Microsoft च्या प्रायोजकत्वाचा भास देऊ नये. तृतीय पक्षांच्या ट्रेडमार्क किंवा लोगोचा वापर त्या तृतीय पक्षांच्या धोरणांनुसार असतो.

## मदत मिळवा

जर तुम्हाला अडचण आली किंवा AI अॅप्स तयार करताना काही प्रश्न असतील, तर सामील व्हा:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

जर तुम्हाला उत्पादनाबाबत अभिप्राय किंवा त्रुटी आढळल्या तर भेट द्या:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**अस्वीकरण**:
हा दस्तऐवज AI अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) वापरून अनुवादित केला आहे. आम्ही अचूकतेसाठी प्रयत्न करतो, तरी कृपया लक्षात घ्या की स्वयंचलित अनुवादांमध्ये चुका किंवा अचूकतेची कमतरता असू शकते. मूळ दस्तऐवज त्याच्या स्थानिक भाषेत अधिकृत स्रोत मानला जावा. महत्त्वाच्या माहितीसाठी व्यावसायिक मानवी अनुवाद शिफारसीय आहे. या अनुवादाच्या वापरामुळे उद्भवलेल्या कोणत्याही गैरसमजुती किंवा चुकीच्या अर्थलागी आम्ही जबाबदार नाही.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->