<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-11-23T02:21:50+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "ml"
}
-->
# Microsoft Co-op Translator Troubleshooting Guide

## അവലോകനം
Microsoft Co-Op Translator എന്നത് Markdown പ്രമാണങ്ങൾ എളുപ്പത്തിൽ പരിഭാഷപ്പെടുത്താൻ സഹായിക്കുന്ന ശക്തമായ ഉപകരണമാണ്. ഈ ഗൈഡ് ഉപകരണം ഉപയോഗിക്കുമ്പോൾ നേരിടുന്ന സാധാരണ പ്രശ്നങ്ങൾ പരിഹരിക്കാൻ സഹായിക്കും.

## സാധാരണ പ്രശ്നങ്ങളും പരിഹാരങ്ങളും

### 1. Markdown ടാഗ് പ്രശ്നം
**പ്രശ്നം:** പരിഭാഷപ്പെടുത്തിയ Markdown പ്രമാണത്തിൽ മുകളിൽ `markdown` ടാഗ് ഉൾപ്പെടുന്നു, ഇത് പ്രദർശന പ്രശ്നങ്ങൾ സൃഷ്ടിക്കുന്നു.

**പരിഹാരം:** ഇത് പരിഹരിക്കാൻ, പ്രമാണത്തിന്റെ മുകളിൽ ഉള്ള `markdown` ടാഗ് നീക്കം ചെയ്യുക. ഇത് Markdown പ്രമാണം ശരിയായി പ്രദർശിപ്പിക്കാൻ സഹായിക്കും.

**ചുവടെയുള്ള ഘട്ടങ്ങൾ:**
1. പരിഭാഷപ്പെടുത്തിയ Markdown (`.md`) പ്രമാണം തുറക്കുക.
2. പ്രമാണത്തിന്റെ മുകളിൽ `markdown` ടാഗ് കണ്ടെത്തുക.
3. `markdown` ടാഗ് നീക്കം ചെയ്യുക.
4. പ്രമാണം സംരക്ഷിക്കുക.
5. പ്രമാണം വീണ്ടും തുറന്ന് ശരിയായി പ്രദർശിപ്പിക്കുന്നുണ്ടോ എന്ന് ഉറപ്പാക്കുക.

### 2. എമ്പഡഡ് ഇമേജുകളുടെ URL പ്രശ്നം
**പ്രശ്നം:** എമ്പഡഡ് ഇമേജുകളുടെ URL ഭാഷാ ലോക്കേൽ-നുമായി പൊരുത്തപ്പെടുന്നില്ല, ഇത് തെറ്റായ അല്ലെങ്കിൽ കാണാനില്ലാത്ത ചിത്രങ്ങൾ സൃഷ്ടിക്കുന്നു.

**പരിഹാരം:** എമ്പഡഡ് ഇമേജുകളുടെ URL പരിശോധിച്ച് അവ ഭാഷാ ലോക്കേലുമായി പൊരുത്തപ്പെടുന്നുണ്ടെന്ന് ഉറപ്പാക്കുക. എല്ലാ ചിത്രങ്ങളും `translated_images` ഫോൾഡറിൽ സ്ഥിതിചെയ്യുന്നു, ഓരോ ചിത്രത്തിനും ചിത്ര ഫയൽ നാമത്തിൽ ഭാഷാ ലോക്കേൽ ടാഗ് ഉണ്ട്.

**ചുവടെയുള്ള ഘട്ടങ്ങൾ:**
1. പരിഭാഷപ്പെടുത്തിയ Markdown പ്രമാണം തുറക്കുക.
2. എമ്പഡഡ് ഇമേജുകളും അവയുടെ URL-കളും തിരിച്ചറിയുക.
3. ചിത്ര ഫയൽ നാമത്തിലെ ഭാഷാ ലോക്കേൽ പ്രമാണത്തിന്റെ ഭാഷയുമായി പൊരുത്തപ്പെടുന്നുണ്ടോ എന്ന് പരിശോധിക്കുക.
4. ആവശ്യമെങ്കിൽ URL-കൾ അപ്ഡേറ്റ് ചെയ്യുക.
5. മാറ്റങ്ങൾ സംരക്ഷിച്ച് പ്രമാണം വീണ്ടും തുറന്ന് ചിത്രങ്ങൾ ശരിയായി പ്രദർശിപ്പിക്കുന്നുണ്ടോ എന്ന് ഉറപ്പാക്കുക.

### 3. പരിഭാഷയുടെ കൃത്യത
**പ്രശ്നം:** പരിഭാഷപ്പെടുത്തിയ ഉള്ളടക്കം കൃത്യമായതല്ല അല്ലെങ്കിൽ കൂടുതൽ എഡിറ്റിംഗ് ആവശ്യമാണ്.

**പരിഹാരം:** പരിഭാഷപ്പെടുത്തിയ പ്രമാണം പരിശോധിച്ച് കൃത്യതയും വായനാസൗകര്യവും മെച്ചപ്പെടുത്താൻ ആവശ്യമായ എഡിറ്റുകൾ ചെയ്യുക.

**ചുവടെയുള്ള ഘട്ടങ്ങൾ:**
1. പരിഭാഷപ്പെടുത്തിയ പ്രമാണം തുറക്കുക.
2. ഉള്ളടക്കം ശ്രദ്ധാപൂർവ്വം പരിശോധിക്കുക.
3. പരിഭാഷയുടെ കൃത്യത മെച്ചപ്പെടുത്താൻ ആവശ്യമായ എഡിറ്റുകൾ ചെയ്യുക.
4. മാറ്റങ്ങൾ സംരക്ഷിക്കുക.

## 4. അനുമതി പിഴവ് Redacted അല്ലെങ്കിൽ 404

ചിത്രങ്ങൾ അല്ലെങ്കിൽ ടെക്സ്റ്റ് ശരിയായ ഭാഷയിലേക്ക് പരിഭാഷപ്പെടുത്തുന്നില്ല, കൂടാതെ -d ഡീബഗ് മോഡിൽ പ്രവർത്തിപ്പിക്കുമ്പോൾ നിങ്ങൾ 401 പിഴവ് അനുഭവപ്പെടുന്നു. ഇത് ക്ലാസിക് ഓത്തന്റിക്കേഷൻ പരാജയമാണ്—കീ അസാധുവാണ്, കാലഹരണപ്പെട്ടിരിക്കുന്നു, അല്ലെങ്കിൽ എന്റ്പോയിന്റിന്റെ പ്രദേശവുമായി ബന്ധിപ്പിച്ചിട്ടില്ല.

@@INLINE_CODE_x@@ ഉപയോഗിച്ച് ഡീബഗ് മോഡിൽ Co-op Translator പ്രവർത്തിപ്പിച്ച് അടിസ്ഥാന കാരണത്തെക്കുറിച്ച് കൂടുതൽ മനസ്സിലാക്കുക.

- **പിഴവിന്റെ സന്ദേശം:** `Access denied due to invalid subscription key or wrong API endpoint.`
- **സാധ്യമായ കാരണങ്ങൾ:**
  - സബ്സ്ക്രിപ്ഷൻ കീ അഭ്യർത്ഥനയിൽ തെറ്റായതോ redacted ആയതോ.
  - AI Services Key അല്ലെങ്കിൽ Subscription Key **Azure AI Vision** റിസോഴ്സിന് പകരം Translator അല്ലെങ്കിൽ OpenAI പോലുള്ള വ്യത്യസ്ത Azure റിസോഴ്സുമായി ബന്ധപ്പെട്ടിരിക്കാം.

**റിസോഴ്സ് തരം**
- [Azure Portal](https://portal.azure.com) അല്ലെങ്കിൽ [Azure AI Foundry](https://ai.azure.com) സന്ദർശിച്ച് റിസോഴ്സ് `Azure AI services` → `Vision` തരം ആണെന്ന് ഉറപ്പാക്കുക.
- കീകൾ സാധൂകരിച്ച് ശരിയായ കീ ഉപയോഗിക്കുന്നുണ്ടെന്ന് ഉറപ്പാക്കുക.

## 5. കോൺഫിഗറേഷൻ പിഴവുകൾ (പുതിയ പിഴവുകൾ കൈകാര്യം ചെയ്യൽ)

പുതിയ സെലക്ടീവ് പരിഭാഷാ സിസ്റ്റം ആരംഭിച്ച്, Co-op Translator ആവശ്യമായ സേവനങ്ങൾ കോൺഫിഗർ ചെയ്തിട്ടില്ലെങ്കിൽ വ്യക്തമായ പിഴവുകൾ നൽകുന്നു.

### 5.1. ചിത്ര പരിഭാഷയ്ക്കായി Azure AI Service കോൺഫിഗർ ചെയ്തിട്ടില്ല

**പ്രശ്നം:** നിങ്ങൾ ചിത്ര പരിഭാഷ (`-img` ഫ്ലാഗ്) അഭ്യർത്ഥിച്ചു, പക്ഷേ Azure AI Service ശരിയായി കോൺഫിഗർ ചെയ്തിട്ടില്ല.

**പിഴവിന്റെ സന്ദേശം:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**പരിഹാരം:**
1. **ഓപ്ഷൻ 1**: Azure AI Service കോൺഫിഗർ ചെയ്യുക
   - നിങ്ങളുടെ `.env` ഫയലിൽ `AZURE_AI_SERVICE_API_KEY` ചേർക്കുക
   - നിങ്ങളുടെ `.env` ഫയലിൽ `AZURE_AI_SERVICE_ENDPOINT` ചേർക്കുക
   - സേവനം ആക്സസ് ചെയ്യാവുന്നതാണെന്ന് സ്ഥിരീകരിക്കുക

2. **ഓപ്ഷൻ 2**: ചിത്ര പരിഭാഷ അഭ്യർത്ഥന നീക്കം ചെയ്യുക
   ```bash
   # പകരം: translate -l "ko" -img
   # ഉപയോഗിക്കുക: translate -l "ko" -md
   ```


### 5.2. ആവശ്യമായ കോൺഫിഗറേഷൻ ഇല്ല

**പ്രശ്നം:** അടിസ്ഥാന LLM കോൺഫിഗറേഷൻ ഇല്ല.

**പിഴവിന്റെ സന്ദേശം:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**പരിഹാരം:**
1. നിങ്ങളുടെ `.env` ഫയലിൽ താഴെ പറയുന്ന LLM കോൺഫിഗറേഷനുകളിൽ കുറഞ്ഞത് ഒന്നെങ്കിലും ഉണ്ട് എന്ന് ഉറപ്പാക്കുക:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` and `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   Azure OpenAI അല്ലെങ്കിൽ OpenAI കോൺഫിഗർ ചെയ്തിരിക്കണം, രണ്ടും ആവശ്യമില്ല.

### 5.3. സെലക്ടീവ് പരിഭാഷാ ആശയക്കുഴപ്പം

**പ്രശ്നം:** കമാൻഡ് വിജയകരമായി പ്രവർത്തിച്ചിട്ടും ഒരു പ്രമാണവും പരിഭാഷപ്പെടുത്തിയിട്ടില്ല.

**സാധ്യമായ കാരണങ്ങൾ:**
- തെറ്റായ ഫയൽ തരം ഫ്ലാഗുകൾ (`-md`, `-img`, `-nb`)
- പ്രോജക്റ്റിൽ പൊരുത്തപ്പെടുന്ന ഫയലുകൾ ഇല്ല
- തെറ്റായ ഡയറക്ടറി ഘടന

**പരിഹാരം:**
1. **ഡീബഗ് മോഡ് ഉപയോഗിക്കുക**:
   ```bash
   translate -l "ko" -md -d
   ```

2. **പ്രോജക്റ്റിലെ ഫയൽ തരം പരിശോധിക്കുക**:
   ```bash
   # മാർക്ക്ഡൗൺ ഫയലുകൾക്കായി
   find . -name "*.md" -not -path "./translations/*"
   
   # നോട്ട്‌ബുക്കുകൾക്കായി
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # ചിത്രങ്ങൾക്കായി
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **ഫ്ലാഗ് കോമ്പിനേഷനുകൾ സ്ഥിരീകരിക്കുക**:
   ```bash
   # എല്ലാം വിവർത്തനം ചെയ്യുക (സ്വതേയുള്ളത്)
   translate -l "ko"
   
   # പ്രത്യേക തരം വിവർത്തനം ചെയ്യുക
   translate -l "ko" -md -img
   ```


## 6. പഴയ സിസ്റ്റത്തിൽ നിന്ന് മൈഗ്രേഷൻ

### 6.1. Markdown-മാത്രം മോഡ് ഡിപ്രിക്കേറ്റഡ്

**പ്രശ്നം:** സ്വയമേവ Markdown-മാത്രം fallback ആശ്രയിച്ച കമാൻഡുകൾ ഇനി പ്രതീക്ഷിച്ച രീതിയിൽ പ്രവർത്തിക്കുന്നില്ല.

**പഴയ പെരുമാറ്റം:**
```bash
# ഇത് സ്വയമേവ മാർക്ക്ഡൗൺ-മാത്രം മോഡിലേക്ക് മാറാൻ ഉപയോഗിച്ചിരുന്നു
translate -l "ko"  # (Azure AI Vision ക്രമീകരിച്ചിട്ടില്ലാത്തപ്പോൾ)
```

**പുതിയ പെരുമാറ്റം:**
```bash
# ഇത് ഇമേജ് വിവർത്തനം അഭ്യർത്ഥിക്കുമ്പോൾ എന്നാൽ ക്രമീകരിച്ചിട്ടില്ലെങ്കിൽ ഒരു പിശക് ഉൽപ്പാദിപ്പിക്കുന്നു
translate -l "ko" -img
```

**പരിഹാരം:**
- **നിങ്ങൾ എന്താണ് പരിഭാഷപ്പെടുത്താൻ ആഗ്രഹിക്കുന്നതെന്ന് വ്യക്തമായി പറയുക**:
  ```bash
  translate -l "ko" -md        # മാത്രം മാർക്ക്ഡൗൺ
  translate -l "ko" -md -img   # മാർക്ക്ഡൗൺയും ചിത്രങ്ങളും
  translate -l "ko"            # എല്ലാം (എല്ലാ സേവനങ്ങളും ക്രമീകരിച്ചാൽ)
  ```


### 6.2. അനിയന്ത്രിതമായ ലിങ്ക് പെരുമാറ്റം

**പ്രശ്നം:** പരിഭാഷപ്പെടുത്തിയ പ്രമാണങ്ങളിലെ ലിങ്കുകൾ അനിയന്ത്രിതമായ സ്ഥലങ്ങളിലേക്ക് പോയി.

**കാരണം:** തിരഞ്ഞെടുക്കുന്ന ഫയൽ തരം അടിസ്ഥാനമാക്കി ഡൈനാമിക് ലിങ്ക് പ്രോസസ്സിംഗ് മാറ്റങ്ങൾ.

**പരിഹാരം:**
1. **പുതിയ ലിങ്ക് പെരുമാറ്റം മനസ്സിലാക്കുക**:
   - `-nb` ഉൾപ്പെടുത്തിയാൽ: Notebook ലിങ്കുകൾ പരിഭാഷപ്പെടുത്തിയ പതിപ്പുകളിലേക്ക് പോയി
   - `-nb` ഒഴിവാക്കിയാൽ: Notebook ലിങ്കുകൾ ഒറിജിനൽ ഫയലുകളിലേക്ക് പോയി
   - `-img` ഉൾപ്പെടുത്തിയാൽ: ചിത്ര ലിങ്കുകൾ പരിഭാഷപ്പെടുത്തിയ പതിപ്പുകളിലേക്ക് പോയി
   - `-img` ഒഴിവാക്കിയാൽ: ചിത്ര ലിങ്കുകൾ ഒറിജിനൽ ഫയലുകളിലേക്ക് പോയി

2. **നിങ്ങളുടെ ആവശ്യത്തിന് ശരിയായ കോമ്പിനേഷൻ തിരഞ്ഞെടുക്കുക**:
   ```bash
   # എല്ലാ ആന്തരിക ലിങ്കുകളും വിവർത്തനം ചെയ്ത പതിപ്പുകളിലേക്ക് സൂചിപ്പിക്കുന്നു
   translate -l "ko" -md -img -nb
   
   # മാർക്ക്ഡൗൺ മാത്രം വിവർത്തനം ചെയ്തിരിക്കുന്നു, മറ്റ് ലിങ്കുകൾ ഒറിജിനലുകളിലേക്ക് സൂചിപ്പിക്കുന്നു
   translate -l "ko" -md
   ```


## 7. GitHub Action പ്രവർത്തിച്ചു, പക്ഷേ Pull Request (PR) സൃഷ്ടിച്ചില്ല

**ലക്ഷണം:** `peter-evans/create-pull-request` എന്ന workflow ലോഗുകളിൽ കാണുന്നു:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**സാധ്യമായ കാരണങ്ങൾ:**
- **മാറ്റങ്ങൾ കണ്ടെത്തിയില്ല:** പരിഭാഷാ ഘട്ടം മാറ്റങ്ങൾ സൃഷ്ടിച്ചില്ല (repo ഇതിനകം അപ്‌ടുഡേറ്റാണ്).
- **അവഗണിച്ച output-കൾ:** `.gitignore` നിങ്ങൾ commit ചെയ്യാൻ പ്രതീക്ഷിക്കുന്ന ഫയലുകൾ ഒഴിവാക്കുന്നു (ഉദാ., `*.ipynb`, `translations/`, `translated_images/`).
- **add-paths mismatch:** പ്രവർത്തനത്തിന് output ലൊക്കേഷനുകൾ പൊരുത്തപ്പെടുന്നില്ല.
- **Workflow ലജിക്/നിബന്ധനകൾ:** പരിഭാഷാ ഘട്ടം നേരത്തെ അവസാനിച്ചു അല്ലെങ്കിൽ അനിയന്ത്രിതമായ ഡയറക്ടറികളിലേക്ക് എഴുതിയിട്ടുണ്ട്.

**പരിഹാരം / സ്ഥിരീകരിക്കുക:**
1. **Output-കൾ ഉണ്ട് എന്ന് ഉറപ്പാക്കുക:** പരിഭാഷയ്ക്കു ശേഷം, `translations/` അല്ലെങ്കിൽ `translated_images/` എന്നതിൽ പുതിയ/മാറ്റം വന്ന ഫയലുകൾ ഉണ്ടെന്ന് ഉറപ്പാക്കുക.
   - Notebook-കൾ പരിഭാഷപ്പെടുത്തുകയാണെങ്കിൽ, `.ipynb` ഫയലുകൾ `translations/<lang>/...` കീഴിൽ എഴുതിയിട്ടുണ്ടെന്ന് ഉറപ്പാക്കുക.
2. **`.gitignore` പരിശോധിക്കുക:** സൃഷ്ടിച്ച output-കൾ അവഗണിക്കരുത്. നിങ്ങൾ താഴെ പറയുന്നവ ഒഴിവാക്കുന്നില്ലെന്ന് ഉറപ്പാക്കുക:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (Notebook-കൾ പരിഭാഷപ്പെടുത്തുകയാണെങ്കിൽ)
3. **add-paths output-കളുമായി പൊരുത്തപ്പെടുന്നു എന്ന് ഉറപ്പാക്കുക:** ഒരു മൾട്ടിലൈൻ മൂല്യം ഉപയോഗിച്ച് രണ്ട് ഫോൾഡറുകളും ഉൾപ്പെടുത്തുക:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **ഡീബഗിംഗിനായി PR നിർബന്ധിക്കുക:** കണക്ഷൻ ശരിയാണെന്ന് സ്ഥിരീകരിക്കാൻ താൽക്കാലികമായി ശൂന്യമായ commits അനുവദിക്കുക:
   ```yaml
   with:
     commit-empty: true
   ```
5. **ഡീബഗ് ഉപയോഗിച്ച് പ്രവർത്തിക്കുക:** പരിഭാഷാ കമാൻഡിൽ `-d` ചേർത്ത് കണ്ടെത്തിയതും എഴുതിയതുമായ ഫയലുകൾ പ്രിന്റ് ചെയ്യുക.
6. **അനുമതികൾ (GITHUB_TOKEN):** commits, PRs സൃഷ്ടിക്കുന്നതിന് workflow-ക്ക് എഴുതാനുള്ള അനുമതികൾ ഉണ്ട് എന്ന് ഉറപ്പാക്കുക:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```


## ദ്രുത ഡീബഗിംഗ് ചെക്ക്ലിസ്റ്റ്

പരിഭാഷാ പ്രശ്നങ്ങൾ പരിഹരിക്കുമ്പോൾ:

1. **ഡീബഗ് മോഡ് ഉപയോഗിക്കുക**: വിശദമായ ലോഗുകൾ കാണാൻ `-d` ഫ്ലാഗ് ചേർക്കുക
2. **നിങ്ങളുടെ ഫ്ലാഗുകൾ പരിശോധിക്കുക**: `-md`, `-img`, `-nb` നിങ്ങളുടെ ഉദ്ദേശവുമായി പൊരുത്തപ്പെടുന്നുണ്ടെന്ന് ഉറപ്പാക്കുക
3. **കോൺഫിഗറേഷൻ പരിശോധിക്കുക**: നിങ്ങളുടെ `.env` ഫയലിൽ ആവശ്യമായ കീകൾ ഉണ്ട് എന്ന് ഉറപ്പാക്കുക
4. **ക്രമമായി പരീക്ഷിക്കുക**: ആദ്യം `-md` മാത്രം ഉപയോഗിച്ച് ആരംഭിച്ച്, തുടർന്ന് മറ്റ് തരം ചേർക്കുക
5. **ഫയൽ ഘടന പരിശോധിക്കുക**: ഉറവിട ഫയലുകൾ ഉണ്ട്, ആക്സസ് ചെയ്യാവുന്നതാണ് എന്ന് ഉറപ്പാക്കുക

കമാൻഡുകളും ഫ്ലാഗുകളും സംബന്ധിച്ച കൂടുതൽ വിശദമായ വിവരങ്ങൾക്കായി, [Command Reference](./command-reference.md) കാണുക.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**അറിയിപ്പ്**:  
ഈ രേഖ AI വിവർത്തന സേവനം [Co-op Translator](https://github.com/Azure/co-op-translator) ഉപയോഗിച്ച് വിവർത്തനം ചെയ്തതാണ്. ഞങ്ങൾ കൃത്യതയ്ക്കായി ശ്രമിക്കുന്നുവെങ്കിലും, ഓട്ടോമേറ്റഡ് വിവർത്തനങ്ങളിൽ പിഴവുകൾ അല്ലെങ്കിൽ തെറ്റായ വിവരങ്ങൾ ഉണ്ടാകാൻ സാധ്യതയുണ്ട്. അതിന്റെ സ്വഭാവഭാഷയിലുള്ള അസൽ രേഖയാണ് പ്രാമാണികമായ ഉറവിടമായി പരിഗണിക്കേണ്ടത്. നിർണായകമായ വിവരങ്ങൾക്ക്, പ്രൊഫഷണൽ മനുഷ്യ വിവർത്തനം ശുപാർശ ചെയ്യുന്നു. ഈ വിവർത്തനം ഉപയോഗിച്ച് ഉണ്ടാകുന്ന തെറ്റിദ്ധാരണകൾ അല്ലെങ്കിൽ തെറ്റായ വ്യാഖ്യാനങ്ങൾക്കായി ഞങ്ങൾ ഉത്തരവാദികളല്ല.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->