<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-11-23T02:23:50+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "ml"
}
-->
# നിങ്ങളുടെ പ്രോജക്റ്റ് Co-op Translator ഉപയോഗിച്ച് പരിഭാഷപ്പെടുത്തുക

**Co-op Translator** എന്നത് ഒരു കമാൻഡ്-ലൈൻ ഇന്റർഫേസ് (CLI) ഉപകരണമാണോ, ഇത് നിങ്ങളുടെ പ്രോജക്റ്റിലെ മാർക്ക്ഡൗൺ ഫയലുകളും ഇമേജ് ഫയലുകളും പല ഭാഷകളിലേക്ക് പരിഭാഷപ്പെടുത്താൻ സഹായിക്കുന്നു. ഈ വിഭാഗത്തിൽ ഉപകരണം എങ്ങനെ ഉപയോഗിക്കാമെന്ന് വിശദീകരിക്കുന്നു, വിവിധ CLI ഓപ്ഷനുകൾ ഉൾക്കൊള്ളുന്നു, കൂടാതെ വ്യത്യസ്ത ഉപയോഗ കേസുകൾക്കുള്ള ഉദാഹരണങ്ങൾ നൽകുന്നു.

> [!NOTE]
> കമാൻഡുകളുടെ പൂർണ്ണമായ പട്ടികയും അവയുടെ വിശദമായ വിവരണങ്ങളും കാണാൻ, [Command reference](./command-reference.md) കാണുക.

---

## ഉദാഹരണങ്ങൾക്കും കമാൻഡുകൾക്കും

**Co-op Translator** ഉപയോഗിച്ച് ചില സാധാരണ ഉപയോഗ കേസുകൾ, കൂടാതെ അനുയോജ്യമായ കമാൻഡുകൾ ഇവിടെ നൽകിയിരിക്കുന്നു.

### 1. അടിസ്ഥാന പരിഭാഷ (ഒരു ഭാഷ)

നിങ്ങളുടെ മുഴുവൻ പ്രോജക്റ്റ് (മാർക്ക്ഡൗൺ ഫയലുകളും ഇമേജുകളും) ഒരു ഭാഷയിലേക്ക്, ഉദാഹരണത്തിന് കൊറിയൻ, പരിഭാഷപ്പെടുത്താൻ താഴെ കാണുന്ന കമാൻഡ് ഉപയോഗിക്കുക:

```bash
translate -l "ko"
```

ഈ കമാൻഡ് എല്ലാ മാർക്ക്ഡൗൺ ഫയലുകളും ഇമേജ് ഫയലുകളും കൊറിയൻ ഭാഷയിലേക്ക് പരിഭാഷപ്പെടുത്തും, നിലവിലുള്ളവ ഇല്ലാതാക്കാതെ പുതിയവ ചേർക്കും.

> [!TIP]
>
> **Co-op Translator**-ൽ ലഭ്യമായ ഭാഷാ കോഡുകൾ എന്തൊക്കെയാണെന്ന് അറിയാൻ ആഗ്രഹിക്കുന്നുണ്ടോ? [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) വിഭാഗം സന്ദർശിക്കുക.

#### Phi-3 CookBook-ൽ ഉദാഹരണം

**Phi-3 CookBook**-ൽ, നിലവിലുള്ള മാർക്ക്ഡൗൺ ഫയലുകൾക്കും ഇമേജുകൾക്കും കൊറിയൻ പരിഭാഷ ചേർക്കാൻ ഞാൻ താഴെ കാണുന്ന രീതിയാണ് ഉപയോഗിച്ചത്.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. പല ഭാഷകളിലേക്ക് പരിഭാഷപ്പെടുത്തൽ

നിങ്ങളുടെ പ്രോജക്റ്റ് പല ഭാഷകളിലേക്ക് (ഉദാ: സ്പാനിഷ്, ഫ്രഞ്ച്, ജർമൻ) പരിഭാഷപ്പെടുത്താൻ ഈ കമാൻഡ് ഉപയോഗിക്കുക:

```bash
translate -l "es fr de"
```

ഈ കമാൻഡ് പ്രോജക്റ്റ് സ്പാനിഷ്, ഫ്രഞ്ച്, ജർമൻ ഭാഷകളിലേക്ക് പരിഭാഷപ്പെടുത്തും, നിലവിലുള്ളവ ഇല്ലാതാക്കാതെ പുതിയവ ചേർക്കും.

#### Phi-3 CookBook-ൽ ഉദാഹരണം

**Phi-3 CookBook**-ൽ, ഏറ്റവും പുതിയ മാറ്റങ്ങൾ പ്രതിഫലിപ്പിക്കുന്നതിന് പുതിയ കമ്മിറ്റുകൾ ചേർത്ത ശേഷം, പുതിയ മാർക്ക്ഡൗൺ ഫയലുകളും ഇമേജുകളും പരിഭാഷപ്പെടുത്താൻ ഞാൻ താഴെ കാണുന്ന രീതിയാണ് ഉപയോഗിച്ചത്.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> സാധാരണയായി ഒരു ഭാഷയിൽ ഒരേസമയം പരിഭാഷപ്പെടുത്താൻ ശുപാർശ ചെയ്യുന്നു, എന്നാൽ ഇത്തരം സാഹചര്യങ്ങളിൽ പ്രത്യേക മാറ്റങ്ങൾ ചേർക്കേണ്ടതുണ്ടെങ്കിൽ, ഒരേസമയം പല ഭാഷകളിലും പരിഭാഷപ്പെടുത്തുന്നത് കാര്യക്ഷമമായിരിക്കും.

### 3. പരിഭാഷകൾ അപ്ഡേറ്റ് ചെയ്യുക (നിലവിലുള്ളവ ഇല്ലാതാക്കുന്നു)

നിലവിലുള്ള പരിഭാഷകൾ അപ്ഡേറ്റ് ചെയ്യാൻ (അത് നിലവിലുള്ളവ ഇല്ലാതാക്കി പുതിയവ ചേർക്കുക), `-u` ഓപ്ഷൻ ഉപയോഗിക്കുക. ഇത് നിർദ്ദിഷ്ട ഭാഷകളുടെ എല്ലാ നിലവിലുള്ള പരിഭാഷകളും ഇല്ലാതാക്കി അവ വീണ്ടും പരിഭാഷപ്പെടുത്തും.

```bash
translate -l "ko" -u
```

മുന്നറിയിപ്പ്: നിലവിലുള്ള പരിഭാഷകൾ ഇല്ലാതാക്കുന്നതിന് മുമ്പ് ഈ കമാൻഡ് നിങ്ങൾക്ക് സ്ഥിരീകരണത്തിനായി ചോദിക്കും.

#### Phi-3 CookBook-ൽ ഉദാഹരണം

**Phi-3 CookBook**-ൽ, സ്പാനിഷ് ഭാഷയിൽ എല്ലാ പരിഭാഷപ്പെടുത്തിയ ഫയലുകളും അപ്ഡേറ്റ് ചെയ്യാൻ ഞാൻ താഴെ കാണുന്ന രീതിയാണ് ഉപയോഗിച്ചത്. നിരവധി മാർക്ക്ഡൗൺ ഡോക്യുമെന്റുകളിൽ ഉള്ള പ്രാഥമിക ഉള്ളടക്കത്തിൽ വലിയ മാറ്റങ്ങൾ ഉണ്ടായപ്പോൾ ഈ രീതിയാണ് ഞാൻ ശുപാർശ ചെയ്തത്. പരിഭാഷപ്പെടുത്തിയ കുറച്ച് മാർക്ക്ഡൗൺ ഫയലുകൾ മാത്രമേ അപ്ഡേറ്റ് ചെയ്യേണ്ടതുണ്ടെങ്കിൽ, അവ പ്രത്യേകമായി ഇല്ലാതാക്കി, `-a` രീതിയിലൂടെ അപ്ഡേറ്റുചെയ്ത പരിഭാഷകൾ ചേർക്കുന്നത് കൂടുതൽ കാര്യക്ഷമമായിരിക്കും.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. ഇമേജുകൾ മാത്രം പരിഭാഷപ്പെടുത്തൽ

നിങ്ങളുടെ പ്രോജക്റ്റിലെ ഇമേജ് ഫയലുകൾ മാത്രം പരിഭാഷപ്പെടുത്താൻ, `-img` ഓപ്ഷൻ ഉപയോഗിക്കുക:

```bash
translate -l "ko" -img
```

ഈ കമാൻഡ് മാർക്ക്ഡൗൺ ഫയലുകളെ ബാധിക്കാതെ ഇമേജുകൾ മാത്രം കൊറിയൻ ഭാഷയിലേക്ക് പരിഭാഷപ്പെടുത്തും.

### 6. മാർക്ക്ഡൗൺ ഫയലുകൾ മാത്രം പരിഭാഷപ്പെടുത്തൽ

നിങ്ങളുടെ പ്രോജക്റ്റിലെ മാർക്ക്ഡൗൺ ഫയലുകൾ മാത്രം പരിഭാഷപ്പെടുത്താൻ, `-md` ഓപ്ഷൻ ഉപയോഗിക്കുക:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook-ൽ ഉദാഹരണം

**Phi-3 CookBook**-ൽ, കൊറിയൻ ഫയലുകളിൽ പരിഭാഷാ പിഴവുകൾ പരിശോധിക്കാൻ, പിഴവുകൾ കണ്ടെത്തിയ ഫയലുകൾക്ക് സ്വയം വീണ്ടും പരിഭാഷ നൽകാൻ ഞാൻ താഴെ കാണുന്ന രീതിയാണ് ഉപയോഗിച്ചത്.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

ഈ ഓപ്ഷൻ പരിഭാഷാ പിഴവുകൾ പരിശോധിക്കുന്നു. നിലവിൽ, ഒറിജിനൽ ഫയലിനും പരിഭാഷപ്പെടുത്തിയ ഫയലിനും ഇടയിൽ വരികൾ തകർക്കുന്ന വ്യത്യാസം ആറിൽ കൂടുതൽ ആയാൽ, ഫയൽ പരിഭാഷാ പിഴവുള്ളതായി അടയാളപ്പെടുത്തുന്നു. ഭാവിയിൽ കൂടുതൽ സൗകര്യപ്രദമായ രീതിയിലേക്ക് ഈ മാനദണ്ഡം മെച്ചപ്പെടുത്താൻ ഞാൻ പദ്ധതിയിടുന്നു.

ഉദാഹരണത്തിന്, ഈ രീതി നഷ്ടമായ ഭാഗങ്ങൾ അല്ലെങ്കിൽ കേടായ പരിഭാഷകൾ കണ്ടെത്താൻ ഉപകാരപ്രദമാണ്, കൂടാതെ അവ സ്വയം വീണ്ടും പരിഭാഷ നൽകും.

എന്നാൽ, നിങ്ങൾക്ക് ഏത് ഫയലുകൾ പ്രശ്നകരമാണെന്ന് ഇതിനകം അറിയാമെങ്കിൽ, അവ ഫയലുകൾ കൈമാറി `-a` ഓപ്ഷൻ ഉപയോഗിച്ച് വീണ്ടും പരിഭാഷ നൽകുന്നത് കൂടുതൽ കാര്യക്ഷമമായിരിക്കും.

### 8. ഡീബഗ് മോഡ്

പ്രശ്നപരിഹാരത്തിനായി വിശദമായ ലോഗിംഗ് പ്രാപ്തമാക്കാൻ, `-d` ഓപ്ഷൻ ഉപയോഗിക്കുക:

```bash
translate -l "ko" -d
```

ഈ കമാൻഡ് പരിഭാഷാ പ്രക്രിയയിൽ പ്രശ്നങ്ങൾ തിരിച്ചറിയാൻ സഹായിക്കുന്ന അധിക ലോഗിംഗ് വിവരങ്ങൾ നൽകുന്ന ഡീബഗ് മോഡിൽ പരിഭാഷ നടത്തും.

#### Phi-3 CookBook-ൽ ഉദാഹരണം

**Phi-3 CookBook**-ൽ, മാർക്ക്ഡൗൺ ഫയലുകളിൽ നിരവധി ലിങ്കുകൾ ഉള്ള പരിഭാഷകൾ ഫോർമാറ്റിംഗ് പിഴവുകൾ, തകർന്ന പരിഭാഷകൾ, അവഗണിച്ച വരികൾ എന്നിവയ്ക്ക് കാരണമായ ഒരു പ്രശ്നം ഞാൻ നേരിട്ടു. ഈ പ്രശ്നം എങ്ങനെ പ്രവർത്തിക്കുന്നുവെന്ന് മനസിലാക്കാൻ, പരിഭാഷാ പ്രക്രിയ പരിശോധിക്കാൻ ഞാൻ `-d` ഓപ്ഷൻ ഉപയോഗിച്ചു.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. എല്ലാ ഭാഷകളിലും പരിഭാഷ നൽകൽ

പ്രോജക്റ്റ് എല്ലാ പിന്തുണയുള്ള ഭാഷകളിലും പരിഭാഷപ്പെടുത്താൻ, all എന്ന കീവാക്ക് ഉപയോഗിക്കുക.

> [!WARNING]
> എല്ലാ ഭാഷകളിലും ഒരേസമയം പരിഭാഷ നൽകുന്നത് പ്രോജക്റ്റിന്റെ വലിപ്പത്തെ ആശ്രയിച്ച് വളരെ സമയം എടുക്കും. ഉദാഹരണത്തിന്, **Phi-3 CookBook** സ്പാനിഷിലേക്ക് പരിഭാഷപ്പെടുത്താൻ ഏകദേശം 2 മണിക്കൂർ എടുത്തു. ഈ തോതിൽ, 20 ഭാഷകൾ കൈകാര്യം ചെയ്യാൻ ഒരു വ്യക്തിക്ക് പ്രായോഗികമല്ല. ഓരോ വ്യക്തിയും ഒരു അല്ലെങ്കിൽ രണ്ട് ഭാഷകൾ കൈകാര്യം ചെയ്യുന്നതും, പരിഭാഷകൾ ക്രമമായി അപ്ഡേറ്റ് ചെയ്യുന്നതും ശുപാർശ ചെയ്യുന്നു.

```bash
translate -l "all"
```

ഈ കമാൻഡ് പ്രോജക്റ്റ് എല്ലാ ലഭ്യമായ ഭാഷകളിലേക്ക് പരിഭാഷപ്പെടുത്തും. നിങ്ങൾ മുന്നോട്ട് പോകുകയാണെങ്കിൽ, പ്രോജക്റ്റിന്റെ വലിപ്പത്തെ ആശ്രയിച്ച് പരിഭാഷയ്ക്ക് വളരെ സമയം എടുക്കാം.

> [!TIP]
>
> ### പരിഭാഷപ്പെടുത്തിയ ഫയലുകൾ കൈമാറ്റം ചെയ്യൽ (ഓപ്ഷണൽ)
> ഒരു സോഴ്‌സ് ഫയൽ അപ്ഡേറ്റ് ചെയ്യുമ്പോൾ പരിഭാഷപ്പെടുത്തിയ ഫയലുകൾ ഇപ്പോൾ സ്വയം കണ്ടെത്തുകയും വൃത്തിയാക്കുകയും ചെയ്യുന്നു.
>
> എന്നാൽ, ഒരു പ്രത്യേക ഫയൽ വീണ്ടും ചെയ്യാൻ അല്ലെങ്കിൽ സിസ്റ്റം പെരുമാറ്റം മറികടക്കാൻ നിങ്ങൾക്ക് പരിഭാഷ അപ്ഡേറ്റ് ചെയ്യാൻ ആഗ്രഹമുണ്ടെങ്കിൽ, ഭാഷാ ഫോൾഡറുകളിലുടനീളം ഫയലിന്റെ എല്ലാ പതിപ്പുകളും ഇല്ലാതാക്കാൻ താഴെ കാണുന്ന കമാൻഡ് ഉപയോഗിക്കാം.
>
> ### Windows-ൽ:
> 1. **Command Prompt ഉപയോഗിച്ച്**:
>    - Command Prompt തുറക്കുക.
>    - `cd` കമാൻഡ് ഉപയോഗിച്ച് ഫയലുകൾ സ്ഥിതിചെയ്യുന്ന ഫോൾഡറിലേക്ക് പോകുക.
>    - ഫയലുകൾ ഇല്ലാതാക്കാൻ താഴെ കാണുന്ന കമാൻഡ് ഉപയോഗിക്കുക:
>      ```
>      del /s *filename*
>      ```
>      `filename` എന്നത് നിങ്ങൾ അന്വേഷിക്കുന്ന ഫയൽ നാമത്തിന്റെ പ്രത്യേക ഭാഗം കൊണ്ട് മാറ്റുക. `/s` ഓപ്ഷൻ സബ്‌ഡയറക്ടറികൾ തിരയുന്നു.
>
> 2. **PowerShell ഉപയോഗിച്ച്**:
>    - PowerShell തുറക്കുക.
>    - ഈ കമാൻഡ് പ്രവർത്തിപ്പിക്കുക:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` എന്നത് ഫോൾഡർ പാതയുമായി മാറ്റുക, `filename` എന്നത് പ്രത്യേക നാമവുമായി മാറ്റുക.
>
> ### macOS/Linux-ൽ:
> 1. **Terminal ഉപയോഗിച്ച്**:
>   - Terminal തുറക്കുക.
>   - `cd` ഉപയോഗിച്ച് ഡയറക്ടറിയിലേക്ക് പോകുക.
>   - `find` കമാൻഡ് ഉപയോഗിക്കുക:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` എന്നത് പ്രത്യേക നാമവുമായി മാറ്റുക.
>
> ഫയലുകൾ ഇല്ലാതാക്കുന്നതിന് മുമ്പ് അപകടകരമായ നഷ്ടം ഒഴിവാക്കാൻ ഫയലുകൾ രണ്ടുതവണ പരിശോധിക്കുക.
>
> നിങ്ങൾ മാറ്റേണ്ട ഫയലുകൾ ഇല്ലാതാക്കിയ ശേഷം, ഏറ്റവും പുതിയ ഫയൽ മാറ്റങ്ങൾ അപ്ഡേറ്റ് ചെയ്യാൻ നിങ്ങളുടെ `translate -l` കമാൻഡ് വീണ്ടും പ്രവർത്തിപ്പിക്കുക.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**അറിയിപ്പ്**:  
ഈ പ്രമാണം AI വിവർത്തന സേവനം [Co-op Translator](https://github.com/Azure/co-op-translator) ഉപയോഗിച്ച് വിവർത്തനം ചെയ്തതാണ്. ഞങ്ങൾ കൃത്യതയ്ക്കായി ശ്രമിക്കുന്നുവെങ്കിലും, ഓട്ടോമേറ്റഡ് വിവർത്തനങ്ങളിൽ പിഴവുകൾ അല്ലെങ്കിൽ തെറ്റായ വിവരങ്ങൾ ഉണ്ടാകാൻ സാധ്യതയുണ്ട്. പ്രമാണത്തിന്റെ മാതൃഭാഷയിലുള്ള യഥാർത്ഥ പതിപ്പ് പ്രാമാണികമായ ഉറവിടമായി പരിഗണിക്കണം. നിർണായകമായ വിവരങ്ങൾക്ക്, പ്രൊഫഷണൽ മനുഷ്യ വിവർത്തനം ശുപാർശ ചെയ്യുന്നു. ഈ വിവർത്തനം ഉപയോഗിച്ച് ഉണ്ടാകുന്ന തെറ്റിദ്ധാരണകൾ അല്ലെങ്കിൽ തെറ്റായ വ്യാഖ്യാനങ്ങൾക്കായി ഞങ്ങൾ ഉത്തരവാദികളല്ല.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->