<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T13:14:07+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "ml"
}
-->
# കോ-ഓപ്പ് ട്രാൻസ്ലേറ്ററിലേക്ക് സംഭാവന ചെയ്യൽ

ഈ പ്രോജക്റ്റ് സംഭാവനകളും നിർദ്ദേശങ്ങളും സ്വാഗതം ചെയ്യുന്നു. മിക്ക സംഭാവനകൾക്കും നിങ്ങൾക്ക് നിങ്ങളുടെ സംഭാവന ഉപയോഗിക്കാൻ അവകാശമുണ്ടെന്ന്, അതും യഥാർത്ഥത്തിൽ അവകാശം നൽകുന്നതായി പ്രഖ്യാപിക്കുന്ന Contributor License Agreement (CLA) ഒപ്പിടേണ്ടതുണ്ട്. വിശദാംശങ്ങൾക്ക് https://cla.opensource.microsoft.com സന്ദർശിക്കുക.

നിങ്ങൾ ഒരു പുൾ റിക്വസ്റ്റ് സമർപ്പിക്കുമ്പോൾ, CLA ബോട്ട് സ്വയം നിങ്ങൾക്ക് CLA നൽകേണ്ടതുണ്ടോ എന്ന് നിർണയിച്ച് PR യോജിച്ച രീതിയിൽ (ഉദാ: സ്റ്റാറ്റസ് ചെക്ക്, കമന്റ്) അലങ്കരിക്കും. ബോട്ടിന്റെ നിർദ്ദേശങ്ങൾ പാലിക്കുക. ഞങ്ങളുടെ CLA ഉപയോഗിക്കുന്ന എല്ലാ റിപോസിറ്ററികളിലും ഇത് ഒരിക്കൽ മാത്രം ചെയ്യേണ്ടതാണ്.

## ഡെവലപ്പ്മെന്റ് പരിസ്ഥിതി ക്രമീകരണം

ഈ പ്രോജക്റ്റിന്റെ ഡെവലപ്പ്മെന്റ് പരിസ്ഥിതി ക്രമീകരിക്കാൻ, ഡിപ്പൻഡൻസികൾ മാനേജ് ചെയ്യാൻ Poetry ഉപയോഗിക്കാൻ ഞങ്ങൾ ശുപാർശ ചെയ്യുന്നു. ഞങ്ങൾ `pyproject.toml` ഉപയോഗിച്ച് പ്രോജക്റ്റ് ഡിപ്പൻഡൻസികൾ നിയന്ത്രിക്കുന്നു, അതിനാൽ ഡിപ്പൻഡൻസികൾ ഇൻസ്റ്റാൾ ചെയ്യാൻ Poetry ഉപയോഗിക്കണം.

### ഒരു വെർച്വൽ എൻവയോൺമെന്റ് സൃഷ്ടിക്കുക

#### pip ഉപയോഗിച്ച്

```bash
python -m venv .venv
```

#### Poetry ഉപയോഗിച്ച്

```bash
poetry init
```

### വെർച്വൽ എൻവയോൺമെന്റ് സജീവമാക്കുക

#### pipക്കും Poetryക്കും

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry ഉപയോഗിച്ച്

```bash
poetry shell
```

### പാക്കേജ് കൂടാതെ ആവശ്യമായ പാക്കേജുകൾ ഇൻസ്റ്റാൾ ചെയ്യൽ

#### Poetry ഉപയോഗിച്ച് (pyproject.toml-ൽ നിന്നു)

```bash
poetry install
```

### മാനുവൽ ടെസ്റ്റിംഗ്

PR സമർപ്പിക്കുന്നതിന് മുമ്പ്, യഥാർത്ഥ ഡോക്യുമെന്റേഷനുമായി ട്രാൻസ്ലേഷൻ ഫംഗ്ഷണാലിറ്റി പരിശോധിക്കുന്നത് പ്രധാനമാണ്:

1. റൂട്ട് ഡയറക്ടറിയിൽ ഒരു ടെസ്റ്റ് ഡയറക്ടറി സൃഷ്ടിക്കുക:
    ```bash
    mkdir test_docs
    ```

2. നിങ്ങൾക്ക് വിവർത്തനം ചെയ്യേണ്ട ചില മാർക്ക്ഡൗൺ ഡോക്യുമെന്റേഷനും ചിത്രങ്ങളും ടെസ്റ്റ് ഡയറക്ടറിയിലേക്ക് പകർത്തുക. ഉദാഹരണത്തിന്:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. പാക്കേജ് ലോക്കലായി ഇൻസ്റ്റാൾ ചെയ്യുക:
    ```bash
    pip install -e .
    ```

4. നിങ്ങളുടെ ടെസ്റ്റ് ഡോക്യുമെന്റുകളിൽ Co-op Translator ഓടിക്കുക:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` ഉം `test_docs/translated_images` ഉം പരിശോധിച്ച് ഉറപ്പാക്കുക:
   - വിവർത്തന ഗുണമേന്മ
   - മെറ്റാഡേറ്റ കമന്റുകൾ ശരിയാണോ
   - ഒറിജിനൽ മാർക്ക്ഡൗൺ ഘടന നിലനിർത്തപ്പെട്ടിട്ടുണ്ടോ
   - ലിങ്കുകളും ചിത്രങ്ങളും ശരിയായി പ്രവർത്തിക്കുന്നുണ്ടോ

ഈ മാനുവൽ ടെസ്റ്റിംഗ് നിങ്ങളുടെ മാറ്റങ്ങൾ യഥാർത്ഥ സാഹചര്യങ്ങളിൽ നന്നായി പ്രവർത്തിക്കുന്നുവെന്ന് ഉറപ്പാക്കാൻ സഹായിക്കും.

### പരിസ്ഥിതി വേരിയബിളുകൾ

1. റൂട്ട് ഡയറക്ടറിയിൽ `.env.template` ഫയൽ കോപ്പി ചെയ്ത് `.env` ഫയൽ സൃഷ്ടിക്കുക.
2. നിർദ്ദേശിച്ച പ്രകാരം പരിസ്ഥിതി വേരിയബിളുകൾ പൂരിപ്പിക്കുക.

> [!TIP]
>
> ### അധിക ഡെവലപ്പ്മെന്റ് പരിസ്ഥിതി ഓപ്ഷനുകൾ
>
> പ്രോജക്റ്റ് ലോക്കലായി ഓടിക്കുന്നതിനു പുറമേ, GitHub Codespaces അല്ലെങ്കിൽ VS Code Dev Containers ഉപയോഗിച്ച് മറ്റൊരു ഡെവലപ്പ്മെന്റ് പരിസ്ഥിതി ക്രമീകരണം നടത്താം.
>
> #### GitHub Codespaces
>
> GitHub Codespaces ഉപയോഗിച്ച് ഈ സാമ്പിളുകൾ വെർച്വലായി ഓടിക്കാം, അധിക ക്രമീകരണങ്ങൾ ആവശ്യമില്ല.
>
> ബട്ടൺ നിങ്ങളുടെ ബ്രൗസറിൽ വെബ് അടിസ്ഥാനത്തിലുള്ള VS Code ഇൻസ്റ്റൻസ് തുറക്കും:
>
> 1. ടെംപ്ലേറ്റ് തുറക്കുക (ഇത് കുറച്ച് മിനിറ്റുകൾ എടുക്കാം):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers ഉപയോഗിച്ച് ലോക്കലായി ഓടിക്കൽ
>
> ⚠️ ഈ ഓപ്ഷൻ പ്രവർത്തിക്കാൻ നിങ്ങളുടെ Docker Desktop-ന് കുറഞ്ഞത് 16 GB RAM വേണം. 16 GB-ൽ കുറവുണ്ടെങ്കിൽ [GitHub Codespaces ഓപ്ഷൻ](../..) പരീക്ഷിക്കുക അല്ലെങ്കിൽ [ലോക്കലായി ക്രമീകരിക്കുക](../..).
>
> VS Code Dev Containers ഉപയോഗിച്ച് പ്രോജക്റ്റ് നിങ്ങളുടെ ലോക്കൽ VS Code-യിൽ തുറക്കും, ഇത് [Dev Containers എക്സ്റ്റൻഷൻ](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) ഉപയോഗിക്കുന്നു:
>
> 1. Docker Desktop ആരംഭിക്കുക (ഇൻസ്റ്റാൾ ചെയ്തിട്ടില്ലെങ്കിൽ ഇൻസ്റ്റാൾ ചെയ്യുക)
> 2. പ്രോജക്റ്റ് തുറക്കുക:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### കോഡ് സ്റ്റൈൽ

പ്രോജക്റ്റിൽ ഏകീകൃത കോഡ് സ്റ്റൈൽ നിലനിർത്താൻ Python കോഡ് ഫോർമാറ്ററായ [Black](https://github.com/psf/black) ഉപയോഗിക്കുന്നു. Black ഒരു നിർബന്ധിത കോഡ് ഫോർമാറ്ററാണ്, Python കോഡ് സ്വയം Black സ്റ്റൈലിൽ പുനഃരൂപീകരിക്കുന്നു.

#### കോൺഫിഗറേഷൻ

Black കോൺഫിഗറേഷൻ ഞങ്ങളുടെ `pyproject.toml`-ൽ വ്യക്തമാക്കിയിട്ടുണ്ട്:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black ഇൻസ്റ്റാൾ ചെയ്യൽ

Poetry (ശുപാർശ ചെയ്യുന്നു) അല്ലെങ്കിൽ pip ഉപയോഗിച്ച് Black ഇൻസ്റ്റാൾ ചെയ്യാം:

##### Poetry ഉപയോഗിച്ച്

ഡെവലപ്പ്മെന്റ് പരിസ്ഥിതി ക്രമീകരിക്കുമ്പോൾ Black സ്വയം ഇൻസ്റ്റാൾ ചെയ്യും:
```bash
poetry install
```

##### pip ഉപയോഗിച്ച്

pip ഉപയോഗിക്കുന്നുവെങ്കിൽ, Black നേരിട്ട് ഇൻസ്റ്റാൾ ചെയ്യാം:
```bash
pip install black
```

#### Black ഉപയോഗിക്കൽ

##### Poetry ഉപയോഗിച്ച്

1. പ്രോജക്റ്റിലെ എല്ലാ Python ഫയലുകളും ഫോർമാറ്റ് ചെയ്യുക:
    ```bash
    poetry run black .
    ```

2. ഒരു പ്രത്യേക ഫയൽ അല്ലെങ്കിൽ ഡയറക്ടറി ഫോർമാറ്റ് ചെയ്യുക:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip ഉപയോഗിച്ച്

1. പ്രോജക്റ്റിലെ എല്ലാ Python ഫയലുകളും ഫോർമാറ്റ് ചെയ്യുക:
    ```bash
    black .
    ```

2. ഒരു പ്രത്യേക ഫയൽ അല്ലെങ്കിൽ ഡയറക്ടറി ഫോർമാറ്റ് ചെയ്യുക:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> നിങ്ങളുടെ എഡിറ്റർ Black ഉപയോഗിച്ച് കോഡ് സേവ് ചെയ്യുമ്പോൾ സ്വയം ഫോർമാറ്റ് ചെയ്യാൻ ക്രമീകരിക്കാൻ ഞങ്ങൾ ശുപാർശ ചെയ്യുന്നു. മിക്ക ആധുനിക എഡിറ്ററുകളും ഇത് എക്സ്റ്റൻഷനുകൾ അല്ലെങ്കിൽ പ്ലഗിനുകൾ വഴി പിന്തുണയ്ക്കുന്നു.

## Co-op Translator ഓടിക്കൽ

നിങ്ങളുടെ പരിസ്ഥിതിയിൽ Poetry ഉപയോഗിച്ച് Co-op Translator ഓടിക്കാൻ, താഴെ പറയുന്ന ഘട്ടങ്ങൾ പാലിക്കുക:

1. നിങ്ങൾ ട്രാൻസ്ലേഷൻ ടെസ്റ്റുകൾ നടത്താൻ ആഗ്രഹിക്കുന്ന ഡയറക്ടറിയിലേക്ക് പോകുക അല്ലെങ്കിൽ ടെസ്റ്റിംഗിനായി താൽക്കാലിക ഫോൾഡർ സൃഷ്ടിക്കുക.

2. താഴെ കാണുന്ന കമാൻഡ് പ്രവർത്തിപ്പിക്കുക. `-l ko` എന്നത് നിങ്ങൾ വിവർത്തനം ചെയ്യാൻ ആഗ്രഹിക്കുന്ന ഭാഷാ കോഡിൽ മാറ്റുക. `-d` ഫ്ലാഗ് ഡീബഗ് മോഡ് സൂചിപ്പിക്കുന്നു.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> കമാൻഡ് ഓടിക്കുന്നതിന് മുമ്പ് Poetry പരിസ്ഥിതി സജീവമാക്കിയിട്ടുണ്ടെന്ന് ഉറപ്പാക്കുക (poetry shell).

## പുതിയ ഭാഷ സംഭാവന ചെയ്യുക

പുതിയ ഭാഷകൾക്ക് പിന്തുണ നൽകുന്ന സംഭാവനകൾ ഞങ്ങൾ സ്വാഗതം ചെയ്യുന്നു. PR തുറക്കുന്നതിന് മുമ്പ്, സ്മൂത്ത് റിവ്യൂക്കായി താഴെ പറയുന്ന ഘട്ടങ്ങൾ പൂർത്തിയാക്കുക.

1. ഫോണ്ട് മാപ്പിംഗിൽ ഭാഷ ചേർക്കുക
   - `src/co_op_translator/fonts/font_language_mappings.yml` എഡിറ്റ് ചെയ്യുക
   - താഴെ പറയുന്നവ ഉൾപ്പെടുന്ന എൻട്രി ചേർക്കുക:
     - `code`: ISO പോലുള്ള ഭാഷാ കോഡ് (ഉദാ: `vi`)
     - `name`: മനുഷ്യനു സുഗമമായ പ്രദർശന നാമം
     - `font`: `src/co_op_translator/fonts/`-ൽ ഉൾപ്പെടുത്തിയിട്ടുള്ള, ആ സ്ക്രിപ്റ്റ് പിന്തുണയ്ക്കുന്ന ഫോണ്ട്
     - `rtl`: വലത്തുനിന്ന് ഇടത്തേക്ക് (right-to-left) ആണെങ്കിൽ `true`, അല്ലെങ്കിൽ `false`

2. ആവശ്യമായ ഫോണ്ട് ഫയലുകൾ ഉൾപ്പെടുത്തുക (ആവശ്യമായെങ്കിൽ)
   - പുതിയ ഫോണ്ട് ആവശ്യമായാൽ, ഓപ്പൺ സോഴ്‌സ് വിതരണംക്കുള്ള ലൈസൻസ് അനുയോജ്യത പരിശോധിക്കുക
   - ഫോണ്ട് ഫയൽ `src/co_op_translator/fonts/`-ലേക്ക് ചേർക്കുക

3. ലോക്കൽ പരിശോധന
   - ചെറിയ സാമ്പിൾ (Markdown, ചിത്രങ്ങൾ, നോട്ട്‌ബുക്കുകൾ) വിവർത്തനം നടത്തുക
   - ഔട്ട്പുട്ട് ശരിയായി റെൻഡർ ചെയ്യുന്നതും ഫോണ്ടുകളും RTL ലേഔട്ടും ശരിയാണെന്ന് ഉറപ്പാക്കുക

4. ഡോക്യുമെന്റേഷൻ അപ്ഡേറ്റ് ചെയ്യുക
   - ഭാഷ `getting_started/supported-languages.md`-ൽ പ്രത്യക്ഷപ്പെടുന്നുണ്ടെന്ന് ഉറപ്പാക്കുക
   - `getting_started/README_languages_template.md`-ൽ മാറ്റം ആവശ്യമില്ല; അത് പിന്തുണയുള്ള ലിസ്റ്റിൽ നിന്നാണ് സൃഷ്ടിക്കുന്നത്

5. PR തുറക്കുക
   - ചേർത്ത ഭാഷയും ഫോണ്ട്/ലൈസൻസിംഗ് സംബന്ധിച്ച കാര്യങ്ങളും വിശദീകരിക്കുക
   - സാധ്യമായെങ്കിൽ റെൻഡർ ചെയ്ത ഔട്ട്പുട്ടുകളുടെ സ്ക്രീൻഷോട്ടുകൾ ചേർക്കുക

ഉദാഹരണ YAML എൻട്രി:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### പുതിയ ഭാഷ പരീക്ഷിക്കുക

പുതിയ ഭാഷ പരീക്ഷിക്കാൻ താഴെ കാണുന്ന കമാൻഡ് ഓടിക്കുക:

```bash
# ഒരു വെർച്വൽ എൻവയോൺമെന്റ് സൃഷ്ടിച്ച് സജീവമാക്കുക
python -m venv .venv
# വിൻഡോസ്
.venv\Scripts\activate
# മാക്‌ഓഎസ്/ലിനക്സ്
source .venv/bin/activate
# ഡെവലപ്പ്മെന്റ് പാക്കേജ് ഇൻസ്റ്റാൾ ചെയ്യുക
pip install -e .
# വിവർത്തനം നടത്തുക
translate -l "new_lang"
```

## പരിപാലകർ

### കമ്മിറ്റ് സന്ദേശവും മർജ് തന്ത്രവും

നമ്മുടെ പ്രോജക്റ്റിന്റെ കമ്മിറ്റ് ചരിത്രത്തിൽ ഏകീകൃതതയും വ്യക്തതയും ഉറപ്പാക്കാൻ, **Squash and Merge** തന്ത്രം ഉപയോഗിക്കുമ്പോൾ **അവസാന കമ്മിറ്റ് സന്ദേശം** ഒരു പ്രത്യേക ഫോർമാറ്റിൽ വേണം.

ഒരു പുൾ റിക്വസ്റ്റ് (PR) മർജ് ചെയ്യുമ്പോൾ, വ്യക്തിഗത കമ്മിറ്റുകൾ ഒറ്റ കമ്മിറ്റായി സ്ക്വാഷ് ചെയ്യും. അവസാന കമ്മിറ്റ് സന്ദേശം താഴെ പറയുന്ന ഫോർമാറ്റിൽ ആയിരിക്കണം, ഇതിലൂടെ ശുദ്ധവും ഏകീകൃതവുമായ ചരിത്രം നിലനിർത്താം.

#### കമ്മിറ്റ് സന്ദേശ ഫോർമാറ്റ് (squash and merge-ക്കായി)

നാം താഴെ പറയുന്ന ഫോർമാറ്റ് ഉപയോഗിക്കുന്നു:

```bash
<type>: <description> (#<PR നമ്പർ>)
```

- **type**: കമ്മിറ്റിന്റെ വിഭാഗം വ്യക്തമാക്കുന്നു. താഴെ പറയുന്ന തരം ഉപയോഗിക്കുന്നു:
  - `Docs`: ഡോക്യുമെന്റേഷൻ അപ്ഡേറ്റുകൾക്കായി.
  - `Build`: ബിൽഡ് സിസ്റ്റം അല്ലെങ്കിൽ ഡിപ്പൻഡൻസികളുമായി ബന്ധപ്പെട്ട മാറ്റങ്ങൾ, കോൺഫിഗറേഷൻ ഫയലുകൾ, CI വർക്ക്‌ഫ്ലോകൾ, Dockerfile ഉൾപ്പെടെ.
  - `Core`: പ്രോജക്റ്റിന്റെ കോർ ഫംഗ്ഷണാലിറ്റി അല്ലെങ്കിൽ ഫീച്ചറുകളിൽ മാറ്റങ്ങൾ, പ്രത്യേകിച്ച് `src/co_op_translator/core` ഡയറക്ടറിയിലെ ഫയലുകൾ.

- **description**: മാറ്റത്തിന്റെ സംക്ഷിപ്ത വിവരണം.
- **PR നമ്പർ**: കമ്മിറ്റുമായി ബന്ധപ്പെട്ട പുൾ റിക്വസ്റ്റ് നമ്പർ.

**ഉദാഹരണങ്ങൾ**:

- `Docs: Update installation instructions for clarity (#50)`
- `Core: Improve handling of image translation (#60)`

> [!NOTE]
> നിലവിൽ, **`Docs`**, **`Core`**, **`Build`** പ്രിഫിക്സുകൾ സ്വയം PR തലക്കെട്ടിൽ ചേർക്കപ്പെടുന്നു, മാറ്റിയ സോഴ്‌സ് കോഡിന്റെ ലേബലുകൾ അടിസ്ഥാനമാക്കി. ശരിയായ ലേബൽ ചേർത്താൽ, PR തലക്കെട്ട് കൈമാറേണ്ടതില്ല. നിങ്ങൾക്ക് ശരിയാണെന്ന് പരിശോധിക്കേണ്ടതാണ്.

#### മർജ് തന്ത്രം

നാം പുൾ റിക്വസ്റ്റുകൾക്കായി **Squash and Merge** ആണ് ഡിഫോൾട്ട് തന്ത്രം. ഇത് വ്യക്തിഗത കമ്മിറ്റുകൾ ഫോർമാറ്റ് പാലിക്കാത്ത പക്ഷത്തിലും, കമ്മിറ്റ് സന്ദേശങ്ങൾ ഫോർമാറ്റ് പാലിക്കുന്നതായി ഉറപ്പാക്കുന്നു.

**കാരണം**:

- ശുദ്ധവും ലീനുമായ പ്രോജക്റ്റ് ചരിത്രം.
- കമ്മിറ്റ് സന്ദേശങ്ങളിൽ ഏകീകൃതത.
- ചെറിയ കമ്മിറ്റുകളിൽ നിന്നുള്ള ശബ്ദം കുറയ്ക്കൽ (ഉദാ: "fix typo").

മർജ് ചെയ്യുമ്പോൾ, അവസാന കമ്മിറ്റ് സന്ദേശം മുകളിൽ പറഞ്ഞ ഫോർമാറ്റ് പാലിക്കുന്നതായി ഉറപ്പാക്കുക.

**Squash and Merge ഉദാഹരണം**  
ഒരു PR-ൽ താഴെ പറയുന്ന കമ്മിറ്റുകൾ ഉണ്ടെങ്കിൽ:

- `fix typo`
- `update README`
- `adjust formatting`

അവ സ്ക്വാഷ് ചെയ്ത് ഇങ്ങനെ ആകണം:  
`Docs: Improve documentation clarity and formatting (#65)`

### റിലീസ് പ്രക്രിയ

Co-op Translator-ന്റെ പുതിയ റിലീസ് പരിപാലകർ എളുപ്പത്തിൽ പ്രസിദ്ധീകരിക്കാൻ ഈ വിഭാഗം വിശദീകരിക്കുന്നു.

#### 1. `pyproject.toml`-ൽ വേർഷൻ അപ്ഡേറ്റ് ചെയ്യുക

1. അടുത്ത വേർഷൻ നമ്പർ തീരുമാനിക്കുക (നാം സെമാന്റിക് വേർഷനിംഗ് പിന്തുടരുന്നു: `MAJOR.MINOR.PATCH`).
2. `pyproject.toml` എഡിറ്റ് ചെയ്ത് `[tool.poetry]`-ലെ `version` ഫീൽഡ് അപ്ഡേറ്റ് ചെയ്യുക.
3. വെർഷൻ മാത്രം മാറ്റുന്ന പ്രത്യേക പുൾ റിക്വസ്റ്റ് തുറക്കുക (ഓട്ടോമാറ്റിക് അപ്ഡേറ്റ് ആയ ലോക്ക്/മെറ്റാഡേറ്റ ഫയലുകൾ ഉൾപ്പെടാം).
4. റിവ്യൂ കഴിഞ്ഞ്, **Squash and Merge** ഉപയോഗിച്ച് മർജ് ചെയ്യുക, അവസാന കമ്മിറ്റ് സന്ദേശം മുകളിൽ പറഞ്ഞ ഫോർമാറ്റ് പാലിക്കുന്നതായി ഉറപ്പാക്കുക.

#### 2. GitHub റിലീസ് സൃഷ്ടിക്കുക

1. GitHub റിപോസിറ്ററി പേജ് തുറന്ന് **Releases** → **Draft a new release** തുറക്കുക.
2. `main` ബ്രാഞ്ചിൽ നിന്നുള്ള പുതിയ ടാഗ് സൃഷ്ടിക്കുക (ഉദാ: `v0.13.0`).
3. റിലീസ് തലക്കെട്ട് അതേ വേർഷൻ ആയി സജ്ജമാക്കുക (ഉദാ: `v0.13.0`).
4. **Generate release notes** ക്ലിക്ക് ചെയ്ത് ചേഞ്ച്‌ലോഗ് സ്വയം പൂരിപ്പിക്കുക.
5. ആഗ്രഹമുണ്ടെങ്കിൽ ടെക്സ്റ്റ് എഡിറ്റ് ചെയ്യാം (പുതിയ പിന്തുണയുള്ള ഭാഷകൾ അല്ലെങ്കിൽ പ്രധാന മാറ്റങ്ങൾ ഹൈലൈറ്റ് ചെയ്യാൻ).
6. റിലീസ് പ്രസിദ്ധീകരിക്കുക.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**അസൂയാ**:  
ഈ രേഖ AI വിവർത്തന സേവനം [Co-op Translator](https://github.com/Azure/co-op-translator) ഉപയോഗിച്ച് വിവർത്തനം ചെയ്തതാണ്. നാം കൃത്യതയ്ക്ക് ശ്രമിച്ചെങ്കിലും, സ്വയം പ്രവർത്തിക്കുന്ന വിവർത്തനങ്ങളിൽ പിശകുകൾ അല്ലെങ്കിൽ തെറ്റുകൾ ഉണ്ടാകാമെന്ന് ദയവായി ശ്രദ്ധിക്കുക. അതിന്റെ മാതൃഭാഷയിലുള്ള യഥാർത്ഥ രേഖയാണ് പ്രാമാണികമായ ഉറവിടം എന്ന് പരിഗണിക്കേണ്ടതാണ്. നിർണായക വിവരങ്ങൾക്ക്, പ്രൊഫഷണൽ മനുഷ്യ വിവർത്തനം ശുപാർശ ചെയ്യപ്പെടുന്നു. ഈ വിവർത്തനം ഉപയോഗിക്കുന്നതിൽ നിന്നുണ്ടാകുന്ന ഏതെങ്കിലും തെറ്റിദ്ധാരണകൾക്കോ വ്യാഖ്യാനക്കേടുകൾക്കോ ഞങ്ങൾ ഉത്തരവാദികളല്ല.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->