<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "3fd2055f97f093b6fe102ea24df4458b",
  "translation_date": "2025-11-23T02:16:47+00:00",
  "source_file": "AGENTS.md",
  "language_code": "ml"
}
-->
# AGENTS.md

## പ്രോജക്റ്റ് അവലോകനം

Co‑op Translator ഒരു Python കമാൻഡ്‑ലൈൻ ടൂൾയും GitHub Actions പ്രവാഹവുമാണ്, ഇത് Markdown ഫയലുകൾ, Jupyter നോട്ട്ബുക്കുകൾ, ചിത്രങ്ങളിലെ ടെക്സ്റ്റ് എന്നിവ പല ഭാഷകളിലേക്ക് പരിഭാഷപ്പെടുത്തുന്നു. ഇത് ഔട്ട്പുട്ടുകൾ ഭാഷ‑നിർദ്ദിഷ്ട ഫോൾഡറുകളിൽ ക്രമീകരിക്കുകയും സോഴ്‌സ് ഉള്ളടക്കവുമായി പരിഭാഷകൾ സിങ്ക്രണൈസ് ചെയ്യുകയും ചെയ്യുന്നു. പ്രോജക്റ്റ് CLI എൻട്രി പോയിന്റുകളുള്ള Poetry‑നിർമ്മിത ലൈബ്രറിയായി ഘടനയുള്ളതാണ്.

### ആർക്കിടെക്ചർ അവലോകനം

- CLI എൻട്രി പോയിന്റുകൾ (`translate`, `migrate-links`, `evaluate`) ഒരു ഏകീകൃത CLI-നെ വിളിക്കുന്നു, ഇത് പരിഭാഷ, ലിങ്ക് മൈഗ്രേഷൻ, വിലയിരുത്തൽ പ്രവാഹങ്ങളിലേക്ക് ഡിസ്‌പാച്ച് ചെയ്യുന്നു.
- കോൺഫിഗറേഷൻ ലോഡർ `.env` വായിക്കുകയും LLM പ്രൊവൈഡറെ (Azure OpenAI അല്ലെങ്കിൽ OpenAI) സ്വയം‑ഡിറ്റക്റ്റ് ചെയ്യുകയും, ആവശ്യമായാൽ, ചിത്ര ടെക്സ്റ്റ് എക്സ്ട്രാക്ഷനിനായി വിഷൻ പ്രൊവൈഡറെ (Azure AI Service) ഡിറ്റക്റ്റ് ചെയ്യുകയും ചെയ്യുന്നു.
- പരിഭാഷയുടെ കോർ Markdown, നോട്ട്ബുക്കുകൾ കൈകാര്യം ചെയ്യുന്നു; `-img` ഉപയോഗിക്കുമ്പോൾ വിഷൻ പൈപ്പ്‌ലൈൻ ചിത്രങ്ങളിൽ നിന്ന് ടെക്സ്റ്റ് എക്സ്ട്രാക്റ്റ് ചെയ്യുന്നു.
- ഔട്ട്പുട്ടുകൾ `translations/<lang>/` എന്നതിൽ ടെക്സ്റ്റിനും `translated_images/` എന്നതിൽ ചിത്രങ്ങൾക്കും ക്രമീകരിച്ചിരിക്കുന്നു, ഒറിജിനൽ ഘടന സംരക്ഷിക്കുന്നു.

### പ്രധാന ടെക്നോളജികളും ഫ്രെയിംവർക്കുകളും

- Python 3.10–3.12, പാക്കേജിംഗിനായി Poetry
- CLI: `click`
- LLM/AI SDKs: Azure OpenAI, OpenAI
- Vision: Azure AI Service (Computer Vision)
- HTTP, ഡാറ്റ: `httpx`, `pydantic`
- Imaging: `pillow`, `opencv-python`, `matplotlib`
- Tooling: `pytest`, `black`, `ruff`

## സെറ്റപ്പ് കമാൻഡുകൾ

### മുൻ‌വശം ആവശ്യങ്ങൾ

- Python 3.10–3.12
- Azure സബ്സ്ക്രിപ്ഷൻ (ഓപ്ഷണൽ, Azure AI സേവനങ്ങൾക്കായി)
- LLM/Vision API-കൾക്കായി ഇന്റർനെറ്റ് ആക്സസ് (ഉദാ., Azure OpenAI/OpenAI, Azure AI Vision)

### ഓപ്ഷൻ A: Poetry (ശുപാർശ ചെയ്യുന്നു)

```bash
# റിപോസിറ്ററി റൂട്ടിൽ നിന്ന്
pip install poetry
poetry install

# പോയട്രി വഴി ഏതെങ്കിലും കമാൻഡ് പ്രവർത്തിപ്പിക്കുക
poetry run translate --help
```

### ഓപ്ഷൻ B: pip/venv

```bash
# വെർച്വൽ പരിസ്ഥിതി സൃഷ്ടിച്ച് സജീവമാക്കുക
python -m venv .venv
# വിൻഡോസ്
.venv\\Scripts\\activate
# ലിനക്സ്/മാക്‌ഒഎസ്
# source .venv/bin/activate

# ആശ്രിതങ്ങൾ ഇൻസ്റ്റാൾ ചെയ്യുക
pip install -r requirements.txt

# (ഐച്ഛികം) പ്രാദേശിക വികസനത്തിനായി എഡിറ്റബിൾ ഇൻസ്റ്റാൾ
pip install -e .
```

## എന്റർ യൂസർ ഉപയോഗം

### Docker (പ്രസിദ്ധീകരിച്ച ഇമേജ്)

```bash
# GHCR-ൽ നിന്ന് പൊതുവായ ഇമേജ് പുൾ ചെയ്യുക
docker pull ghcr.io/azure/co-op-translator:latest

# നിലവിലെ ഫോൾഡർ മൗണ്ട് ചെയ്ത് .env നൽകിക്കൊണ്ട് പ്രവർത്തിക്കുക (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "fr es" -md

# പവർഷെൽ
docker run --rm -it --env-file .env -v ${PWD}:/work ghcr.io/azure/co-op-translator:latest -l "fr es" -md
```

കുറിപ്പുകൾ:
- ഡിഫോൾട്ട് എൻട്രി പോയിന്റ് `translate` ആണ്. ലിങ്ക് മൈഗ്രേഷനായി `--entrypoint migrate-links` ഉപയോഗിച്ച് ഓവർറൈഡ് ചെയ്യുക.
- അനോണിമസ് പുൾസിനായി GHCR പാക്കേജ് ദൃശ്യത Public ആക്കുക.

### CLI (pip)

```bash
pip install co-op-translator
translate -l "fr es" -md
```

### പരിസ്ഥിതി കോൺഫിഗറേഷൻ

റിപ്പോസിറ്ററി റൂട്ടിൽ `.env` ഫയൽ സൃഷ്ടിച്ച് നിങ്ങളുടെ തിരഞ്ഞെടുക്കുന്ന ഭാഷ മോഡലിനും (ഓപ്ഷണൽ) വിഷൻ സേവനത്തിനും ക്രെഡൻഷ്യലുകൾ/എൻഡ്പോയിന്റുകൾ നൽകുക. പ്രൊവൈഡർ‑നിർദ്ദിഷ്ട സെറ്റപ്പിനായി, `getting_started/set-up-azure-ai.md` കാണുക.

### ആവശ്യമായ പരിസ്ഥിതി വേരിയബിളുകൾ

കുറഞ്ഞത് ഒരു LLM പ്രൊവൈഡർ കോൺഫിഗർ ചെയ്യണം. ചിത്ര പരിഭാഷയ്ക്കായി Azure AI Service കോൺഫിഗർ ചെയ്യണം.

- Azure OpenAI (ടെക്സ്റ്റ് പരിഭാഷ):
  - `AZURE_OPENAI_API_KEY`
  - `AZURE_OPENAI_ENDPOINT`
  - `AZURE_OPENAI_MODEL_NAME`
  - `AZURE_OPENAI_CHAT_DEPLOYMENT_NAME`
  - `AZURE_OPENAI_API_VERSION`

- OpenAI (ടെക്സ്റ്റ് പരിഭാഷയ്ക്ക് പകരം):
  - `OPENAI_API_KEY`
  - `OPENAI_ORG_ID` (ഓപ്ഷണൽ)
  - `OPENAI_CHAT_MODEL_ID` (OpenAI പ്രൊവൈഡർ ഉപയോഗിക്കുമ്പോൾ ആവശ്യമാണ്)
  - `OPENAI_BASE_URL` (ഓപ്ഷണൽ; ഡിഫോൾട്ട് `https://api.openai.com/v1`)

- Azure AI Service ചിത്ര ടെക്സ്റ്റ് എക്സ്ട്രാക്ഷനിനായി (ആവശ്യമായപ്പോൾ `-img` ഉപയോഗിക്കുക):
  - `AZURE_AI_SERVICE_API_KEY` (മുൻ‌ഗണന) അല്ലെങ്കിൽ പാരമ്പര്യ `AZURE_SUBSCRIPTION_KEY`
  - `AZURE_AI_SERVICE_ENDPOINT`

ഉദാഹരണ `.env` സ്നിപ്പറ്റ്:

```bash
# Azure AI സേവനം (ചിത്ര വിവർത്തനത്തിനായി)
AZURE_AI_SERVICE_API_KEY="..."
AZURE_AI_SERVICE_ENDPOINT="https://<your-ai-service>.cognitiveservices.azure.com/"

# Azure OpenAI (പ്രധാന ഓപ്ഷൻ)
AZURE_OPENAI_API_KEY="..."
AZURE_OPENAI_ENDPOINT="https://<your-azure-openai>.openai.azure.com/"
AZURE_OPENAI_MODEL_NAME="gpt-4o"
AZURE_OPENAI_CHAT_DEPLOYMENT_NAME="<your-deployment>"
AZURE_OPENAI_API_VERSION="2024-12-01-preview"

# OpenAI (പര്യായ ഓപ്ഷൻ)
OPENAI_API_KEY="..."
OPENAI_ORG_ID="..."            # ഐച്ഛികം
OPENAI_CHAT_MODEL_ID="gpt-4o"   # OpenAI ഉപയോഗിക്കുമ്പോൾ ആവശ്യമാണ്
OPENAI_BASE_URL="https://api.openai.com/v1" # ഐച്ഛികം
```

കുറിപ്പുകൾ:

- ടൂൾ ലഭ്യമായ LLM പ്രൊവൈഡറെ സ്വയം‑ഡിറ്റക്റ്റ് ചെയ്യുന്നു; Azure OpenAI അല്ലെങ്കിൽ OpenAI കോൺഫിഗർ ചെയ്യുക.
- ചിത്ര പരിഭാഷയ്ക്ക് `AZURE_AI_SERVICE_API_KEY`യും `AZURE_AI_SERVICE_ENDPOINT`ഉം ആവശ്യമാണ്.
- ആവശ്യമായ വേരിയബിളുകൾ ഇല്ലെങ്കിൽ CLI വ്യക്തമായ പിഴവുകൾ ഉയർത്തും.

## ഡെവലപ്മെന്റ് പ്രവാഹം

- സോഴ്‌സ് കോഡ് `src/co_op_translator` ൽ നിലനിൽക്കുന്നു; ടെസ്റ്റുകൾ `tests/` ൽ.
- പ്രാഥമിക CLI-കൾ (എൻട്രി പോയിന്റുകൾ വഴി ഇൻസ്റ്റാൾ ചെയ്യുന്നു):

```bash
# ഉള്ളടക്കം ഒരു അല്ലെങ്കിൽ കൂടുതൽ ഭാഷകളിലേക്ക് വിവർത്തനം ചെയ്യുക (സ്പേസ്-വേർപെടുത്തിയ കോഡുകൾ)
translate -l "fr es de"

# ഉള്ളടക്ക തരം പ്രകാരം പരിമിതപ്പെടുത്തുക
translate -l "ja" -md            # മാത്രം മാർക്ക്ഡൗൺ
translate -l "ko" -nb            # മാത്രം നോട്ട്‌ബുക്കുകൾ
translate -l "zh" -md -img       # മാർക്ക്ഡൗൺ + ചിത്രങ്ങൾ

# മുമ്പ് വിവർത്തനം ചെയ്ത നോട്ട്‌ബുക്കുകൾ/മാർക്ക്ഡൗൺ ലിങ്കുകൾ അപ്ഡേറ്റ് ചെയ്യുക
migrate-links -l "all" -y
```

കൂടുതൽ ഉപയോഗ ഡോകുകൾ `getting_started/` ൽ കാണുക.

## ടെസ്റ്റിംഗ് നിർദ്ദേശങ്ങൾ

റിപ്പോസിറ്ററി റൂട്ടിൽ നിന്ന് ടെസ്റ്റുകൾ പ്രവർത്തിപ്പിക്കുക. ചില ടെസ്റ്റുകൾ API ക്രെഡൻഷ്യലുകൾ ആവശ്യമായേക്കാം; ആവശ്യമെങ്കിൽ അവ ഒഴിവാക്കുക.

```bash
# മുഴുവൻ ടെസ്റ്റ് സ്യൂട്ട് പ്രവർത്തിപ്പിക്കുക
pytest

# തത്സമയ API കീകൾ ആവശ്യമായ ടെസ്റ്റുകൾ ഒഴിവാക്കുക
pytest -m "not api_key_required"

# ഒരു ഉപസമുച്ചയം പ്രവർത്തിപ്പിക്കുക
pytest tests/co_op_translator -k "name_substring"
```

ഓപ്ഷണൽ കവർേജ് (ആവശ്യമായ `coverage`):

```bash
coverage run -m pytest -m "not api_key_required"
coverage html  # ./htmlcov ലേക്ക് ഔട്ട്പുട്ട് നൽകുന്നു
```

## കോഡ് സ്റ്റൈൽ മാർഗനിർദ്ദേശങ്ങൾ

- Formatter: Black (`pyproject.toml` ൽ കോൺഫിഗർ ചെയ്തിരിക്കുന്നു, ലൈൻ നീളം 88)
- Linter: Ruff (`pyproject.toml` ൽ കോൺഫിഗർ ചെയ്തിരിക്കുന്നു, ലൈൻ നീളം 120)
- Type checks: mypy (കോൺഫിഗറേഷൻ നിലവിലുണ്ട്; ഇൻസ്റ്റാൾ ചെയ്താൽ പ്രവർത്തിപ്പിക്കുക)

കമാൻഡുകൾ:

```bash
# കവിതയിലൂടെ
poetry run black .
poetry run ruff check .
poetry run ruff check . --fix   # സുരക്ഷിതമായ സ്വയം‑ശുദ്ധീകരണങ്ങൾ

# അല്ലെങ്കിൽ ആഗോള ഉപകരണങ്ങളുമായി
black .
ruff check .
```

Python സോഴ്‌സുകൾ `src/` ൽ, ടെസ്റ്റുകൾ `tests/` ൽ ക്രമീകരിക്കുക, പാക്കേജ് namespace (`co_op_translator.*`) ഉള്ളിൽ വ്യക്തമായ ഇമ്പോർട്ടുകൾ മുൻ‌ഗണിക്കുക.

## ബിൽഡും ഡെപ്ലോയ്മെന്റും

ബിൽഡ് ആർട്ടിഫാക്ടുകൾ `dist/` ൽ പ്രസിദ്ധീകരിക്കുന്നു.

```bash
# നിർമ്മാണം (Poetry)
poetry build

# നിർമ്മിതമായ വീൽ പ്രാദേശികമായി ഇൻസ്റ്റാൾ ചെയ്യുക
pip install dist/*.whl
```

GitHub Actions വഴി ഓട്ടോമേഷൻ പിന്തുണയ്ക്കുന്നു; കാണുക:

- `getting_started/github-actions-guide/github-actions-guide-public.md`
- `getting_started/github-actions-guide/github-actions-guide-org.md`

### കണ്ടെയ്നർ ഇമേജ് (GHCR)

- ഔദ്യോഗിക ഇമേജ്: `ghcr.io/azure/co-op-translator:<tag>`
- ടാഗുകൾ: `latest` (main ൽ), സെമാന്റിക് ടാഗുകൾ പോലെ `vX.Y.Z`, ഒരു `sha` ടാഗ്
- മൾട്ടി-ആർക്ക്: `linux/amd64, linux/arm64` Buildx വഴി പിന്തുണയ്ക്കുന്നു
- Dockerfile പാറ്റേൺ: ബിൽഡ് ഡിപെൻഡൻസി വീലുകൾ ബിൽഡറിൽ (ഉപയോഗിച്ച് `build-essential` and `python3-dev`) നിർമ്മിച്ച് റൺടൈമിൽ ലോക്കൽ വീൽഹൗസിൽ നിന്ന് ഇൻസ്റ്റാൾ ചെയ്യുക (`pip install --no-index --find-links=/wheels`)
- പ്രവാഹം: `.github/workflows/docker-publish.yml` GHCR-ലേക്ക് ബിൽഡും പുഷും ചെയ്യുന്നു

## സുരക്ഷാ പരിഗണനകൾ

- API കീകളും എൻഡ്പോയിന്റുകളും `.env` അല്ലെങ്കിൽ നിങ്ങളുടെ CI സീക്രെറ്റ്സ് സ്റ്റോറിൽ സൂക്ഷിക്കുക; സീക്രെറ്റുകൾ ഒരിക്കലും കമ്മിറ്റ് ചെയ്യരുത്.
- ചിത്ര പരിഭാഷയ്ക്കായി Azure AI Vision കീകൾ/എൻഡ്പോയിന്റുകൾ ആവശ്യമാണ്; അല്ലെങ്കിൽ `-img` ഒഴിവാക്കുക.
- വലിയ പരിഭാഷ ബാച്ചുകൾ പ്രവർത്തിപ്പിക്കുമ്പോൾ പ്രൊവൈഡർ ക്വോട്ട/റേറ്റ് ലിമിറ്റുകൾ സാധൂകരിക്കുക.

## പുൾ റിക്വസ്റ്റ് മാർഗനിർദ്ദേശങ്ങൾ

### സമർപ്പിക്കുന്നതിന് മുമ്പ്

1. **നിങ്ങളുടെ മാറ്റങ്ങൾ ടെസ്റ്റ് ചെയ്യുക:**
   - ബാധിച്ച നോട്ട്ബുക്കുകൾ പൂർണ്ണമായും പ്രവർത്തിപ്പിക്കുക
   - എല്ലാ സെല്ലുകളും പിഴവുകൾ കൂടാതെ പ്രവർത്തിക്കുന്നുണ്ടെന്ന് ഉറപ്പാക്കുക
   - ഔട്ട്പുട്ടുകൾ അനുയോജ്യമായുണ്ടെന്ന് പരിശോധിക്കുക

2. **ഡോകുമെന്റേഷൻ അപ്ഡേറ്റുകൾ:**
   - പുതിയ ആശയങ്ങൾ ചേർക്കുമ്പോൾ `README.md` അപ്ഡേറ്റ് ചെയ്യുക
   - കോംപ്ലെക്സ് കോഡിനായി നോട്ട്ബുക്കുകളിൽ കുറിപ്പുകൾ ചേർക്കുക
   - Markdown സെല്ലുകൾ ഉദ്ദേശ്യം വിശദീകരിക്കുന്നുണ്ടെന്ന് ഉറപ്പാക്കുക

3. **ഫയൽ മാറ്റങ്ങൾ:**
   - `.env` ഫയലുകൾ കമ്മിറ്റ് ചെയ്യുന്നത് ഒഴിവാക്കുക (`.env.example` ഉപയോഗിക്കുക)
   - `venv/` അല്ലെങ്കിൽ `__pycache__/` ഡയറക്ടറികൾ കമ്മിറ്റ് ചെയ്യരുത്
   - ആശയങ്ങൾ വിശദീകരിക്കുന്ന നോട്ട്ബുക്ക് ഔട്ട്പുട്ടുകൾ സൂക്ഷിക്കുക
   - താൽക്കാലിക ഫയലുകളും ബാക്കപ്പ് നോട്ട്ബുക്കുകളും (`*-backup.ipynb`) നീക്കം ചെയ്യുക

4. **സ്റ്റൈൽ, ഫോർമാറ്റിംഗ്:**
   - സ്റ്റൈൽ, ഫോർമാറ്റിംഗ് മാർഗനിർദ്ദേശങ്ങൾ പാലിക്കുക
   - `poetry run black .` and `poetry run ruff check .` പ്രവർത്തിപ്പിച്ച് സ്റ്റൈൽ, ഫോർമാറ്റിംഗ് പ്രശ്നങ്ങൾ പരിശോധിക്കുക

5. **ടെസ്റ്റുകളും CLI സഹായവും ചേർക്കുക/അപ്ഡേറ്റ് ചെയ്യുക:**
   - പെരുമാറ്റം മാറ്റുമ്പോൾ ടെസ്റ്റുകൾ ചേർക്കുക അല്ലെങ്കിൽ അപ്ഡേറ്റ് ചെയ്യുക
   - മാറ്റങ്ങളുമായി CLI സഹായം സുസ്ഥിരമാക്കുക

### കമ്മിറ്റ് സന്ദേശവും മർജ് തന്ത്രവും

ഞങ്ങൾ ഡിഫോൾട്ടായി Squash and Merge ഉപയോഗിക്കുന്നു. അന്തിമ സ്ക്വാഷ് കമ്മിറ്റ് സന്ദേശം താഴെപോലെ ആയിരിക്കണം:

```bash
<type>: <description> (#<PR നമ്പർ>)
```

അനുവദിച്ച തരം:
- `Docs` — ഡോകുമെന്റേഷൻ അപ്ഡേറ്റുകൾ
- `Build` — ബിൽഡ് സിസ്റ്റം, ഡിപെൻഡൻസികൾ, കോൺഫിഗറേഷൻ/CI
- `Core` — കോർ പ്രവർത്തനക്ഷമതയും സവിശേഷതകളും (ഉദാ., `src/co_op_translator/core`)

ഉദാഹരണങ്ങൾ:
- `Docs: Update installation instructions for clarity (#50)`
- `Core: Improve handling of image translation (#60)`

കുറിപ്പുകൾ:
- PR തലക്കെട്ടുകൾ ലേബലുകൾ അടിസ്ഥാനമാക്കി സ്വയം‑പ്രിഫിക്സ് ചെയ്യപ്പെടുന്നു; സൃഷ്ടിച്ച പ്രിഫിക്സ് ശരിയാണെന്ന് സ്ഥിരീകരിക്കുക.

### PR തലക്കെട്ട് ഫോർമാറ്റ്

വ്യക്തമായ, സംക്ഷിപ്തമായ തലക്കെട്ടുകൾ ഉപയോഗിക്കുക. അന്തിമ സ്ക്വാഷ് കമ്മിറ്റിന്റെ സമാന ഘടന മുൻ‌ഗണിക്കുക:
- `Docs: Update installation instructions for clarity`
- `Core: Improve handling of image translation`

## ഡീബഗ്ഗിംഗ്, പ്രശ്ന പരിഹാരം

- സാധാരണ പ്രശ്നങ്ങളും പരിഹാരങ്ങളും: `getting_started/troubleshooting.md`
- പിന്തുണയുള്ള ഭാഷകളും കുറിപ്പുകളും (ഫോണ്ടുകൾ/അറിയപ്പെടുന്ന പ്രശ്നങ്ങൾ ഉൾപ്പെടെ): `getting_started/supported-languages.md`
- നോട്ട്ബുക്കുകളിൽ ലിങ്ക് പ്രശ്നങ്ങൾ ഉണ്ടെങ്കിൽ, വീണ്ടും പ്രവർത്തിപ്പിക്കുക: `migrate-links -l "all" -y`

## ഏജന്റുകൾക്കുള്ള കുറിപ്പുകൾ

- പുനരാവർത്തനശേഷിയുള്ള പരിസ്ഥിതികൾക്കായി Poetry മുൻ‌ഗണിക്കുക; അല്ലെങ്കിൽ `requirements.txt` ഉപയോഗിക്കുക.
- CI-യിൽ CLI-കൾ വിളിക്കുമ്പോൾ ആവശ്യമായ സീക്രെറ്റുകൾ പരിസ്ഥിതി വേരിയബിളുകൾ അല്ലെങ്കിൽ `.env` ഇൻജക്ഷൻ വഴി നൽകുക.
- Monorepo ഉപഭോക്താക്കൾക്കായി, ഈ റിപ്പോ സ്വതന്ത്ര പാക്കേജായി പ്രവർത്തിക്കുന്നു; ഉപ‑പാക്കേജ് കോർഡിനേഷൻ ആവശ്യമില്ല.

- മൾട്ടി-ആർക്ക് മാർഗനിർദ്ദേശം: ARM ഉപയോക്താക്കൾ (Apple Silicon/ARM സെർവറുകൾ) ലക്ഷ്യമാക്കുമ്പോൾ `linux/arm64` സൂക്ഷിക്കുക; അല്ലെങ്കിൽ ലളിതത്വത്തിനായി `linux/amd64` മാത്രം സ്വീകരിക്കുക.
- Docker Quick Start-ൽ Bash, PowerShell വകഭേദങ്ങൾ ഉൾപ്പെടുത്തുക, കാരണം ക്വോട്ടിംഗ് വ്യത്യാസങ്ങൾ.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**അറിയിപ്പ്**:  
ഈ രേഖ AI പരിഭാഷാ സേവനം [Co-op Translator](https://github.com/Azure/co-op-translator) ഉപയോഗിച്ച് പരിഭാഷപ്പെടുത്തിയതാണ്. ഞങ്ങൾ കൃത്യതയ്ക്കായി ശ്രമിക്കുന്നുവെങ്കിലും, ഓട്ടോമേറ്റഡ് പരിഭാഷകളിൽ പിഴവുകൾ അല്ലെങ്കിൽ തെറ്റായ വിവരങ്ങൾ ഉണ്ടാകാൻ സാധ്യതയുണ്ട്. അതിന്റെ സ്വാഭാവിക ഭാഷയിലുള്ള അസൽ രേഖയാണ് പ്രാമാണികമായ ഉറവിടമായി പരിഗണിക്കേണ്ടത്. നിർണായകമായ വിവരങ്ങൾക്ക്, പ്രൊഫഷണൽ മനുഷ്യ പരിഭാഷ ശുപാർശ ചെയ്യുന്നു. ഈ പരിഭാഷ ഉപയോഗിച്ച് ഉണ്ടാകുന്ന തെറ്റിദ്ധാരണകൾ അല്ലെങ്കിൽ തെറ്റായ വ്യാഖ്യാനങ്ങൾക്കായി ഞങ്ങൾ ഉത്തരവാദികളല്ല.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->