<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T13:18:31+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "kn"
}
-->
# ಕೋ-ಆಪ್ ಅನುವಾದಕಕ್ಕೆ ಕೊಡುಗೆ ನೀಡುವುದು

ಈ ಯೋಜನೆ ಕೊಡುಗೆಗಳು ಮತ್ತು ಸಲಹೆಗಳನ್ನು ಸ್ವಾಗತಿಸುತ್ತದೆ. ಬಹುತೇಕ ಕೊಡುಗೆಗಳಿಗೆ ನೀವು Contributor License Agreement (CLA) ಒಪ್ಪಿಕೊಳ್ಳಬೇಕಾಗುತ್ತದೆ, ಇದು ನೀವು ನಿಮ್ಮ ಕೊಡುಗೆಯನ್ನು ಬಳಸಲು ನಮಗೆ ಹಕ್ಕುಗಳನ್ನು ನೀಡುವ ಹಕ್ಕು ಹೊಂದಿದ್ದೀರಿ ಮತ್ತು ನಿಜವಾಗಿಯೂ ನೀಡುತ್ತಿದ್ದೀರಿ ಎಂದು ಘೋಷಿಸುತ್ತದೆ. ವಿವರಗಳಿಗೆ, https://cla.opensource.microsoft.com ಗೆ ಭೇಟಿ ನೀಡಿ.

ನೀವು ಪಲ್ಲ್ ರಿಕ್ವೆಸ್ಟ್ ಸಲ್ಲಿಸಿದಾಗ, CLA ಬಾಟ್ ಸ್ವಯಂಚಾಲಿತವಾಗಿ ನೀವು CLA ಒದಗಿಸಬೇಕೇ ಎಂದು ನಿರ್ಧರಿಸಿ PR ಅನ್ನು ಸೂಕ್ತವಾಗಿ ಅಲಂಕರಿಸುತ್ತದೆ (ಉದಾ: ಸ್ಥಿತಿ ಪರಿಶೀಲನೆ, ಕಾಮೆಂಟ್). ಬಾಟ್ ನೀಡುವ ಸೂಚನೆಗಳನ್ನು ಅನುಸರಿಸಿ. ನಮ್ಮ CLA ಬಳಸಿ ಎಲ್ಲಾ ರೆಪೋಗಳಲ್ಲಿಯೂ ನೀವು ಇದನ್ನು ಒಂದೇ ಬಾರಿ ಮಾಡಬೇಕಾಗುತ್ತದೆ.

## ಅಭಿವೃದ್ಧಿ ಪರಿಸರವನ್ನು ಹೊಂದಿಸುವುದು

ಈ ಯೋಜನೆಗಾಗಿ ಅಭಿವೃದ್ಧಿ ಪರಿಸರವನ್ನು ಹೊಂದಿಸಲು, ಅವಲಂಬನೆಗಳನ್ನು ನಿರ್ವಹಿಸಲು Poetry ಬಳಕೆ ಮಾಡುವುದು ಶಿಫಾರಸು ಮಾಡಲಾಗಿದೆ. ನಾವು `pyproject.toml` ಅನ್ನು ಯೋಜನೆಯ ಅವಲಂಬನೆಗಳನ್ನು ನಿರ್ವಹಿಸಲು ಬಳಸುತ್ತೇವೆ, ಆದ್ದರಿಂದ ಅವಲಂಬನೆಗಳನ್ನು ಸ್ಥಾಪಿಸಲು ನೀವು Poetry ಬಳಸಿ.

### ವರ್ಚುವಲ್ ಪರಿಸರವನ್ನು ರಚಿಸುವುದು

#### pip ಬಳಸಿ

```bash
python -m venv .venv
```

#### Poetry ಬಳಸಿ

```bash
poetry init
```

### ವರ್ಚುವಲ್ ಪರಿಸರವನ್ನು ಸಕ್ರಿಯಗೊಳಿಸುವುದು

#### pip ಮತ್ತು Poetry ಎರಡಕ್ಕೂ

- ವಿಂಡೋಸ್:

    ```bash
    .venv\Scripts\activate.bat
    ```

- ಮ್ಯಾಕ್/ಲಿನಕ್ಸ್:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry ಬಳಸಿ

```bash
poetry shell
```

### ಪ್ಯಾಕೇಜ್ ಮತ್ತು ಅಗತ್ಯವಿರುವ ಪ್ಯಾಕೇಜ್‌ಗಳನ್ನು ಸ್ಥಾಪಿಸುವುದು

#### Poetry ಬಳಸಿ (pyproject.toml ನಿಂದ)

```bash
poetry install
```

### ಕೈಯಿಂದ ಪರೀಕ್ಷೆ

PR ಸಲ್ಲಿಸುವ ಮೊದಲು, ನಿಜವಾದ ಡಾಕ್ಯುಮೆಂಟೇಶನ್ ಬಳಸಿ ಅನುವಾದ ಕಾರ್ಯಕ್ಷಮತೆಯನ್ನು ಪರೀಕ್ಷಿಸುವುದು ಮುಖ್ಯ:

1. ರೂಟ್ ಡೈರೆಕ್ಟರಿಯಲ್ಲಿ ಒಂದು ಟೆಸ್ಟ್ ಡೈರೆಕ್ಟರಿ ರಚಿಸಿ:
    ```bash
    mkdir test_docs
    ```

2. ನೀವು ಅನುವಾದಿಸಲು ಬಯಸುವ ಕೆಲವು ಮಾರ್ಕ್‌ಡೌನ್ ಡಾಕ್ಯುಮೆಂಟೇಶನ್ ಮತ್ತು ಚಿತ್ರಗಳನ್ನು ಟೆಸ್ಟ್ ಡೈರೆಕ್ಟರಿಯಲ್ಲಿ ನಕಲಿಸಿ. ಉದಾಹರಣೆಗೆ:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. ಪ್ಯಾಕೇಜ್ ಅನ್ನು ಸ್ಥಳೀಯವಾಗಿ ಸ್ಥಾಪಿಸಿ:
    ```bash
    pip install -e .
    ```

4. ನಿಮ್ಮ ಟೆಸ್ಟ್ ಡಾಕ್ಯುಮೆಂಟ್‌ಗಳ ಮೇಲೆ ಕೋ-ಆಪ್ ಅನುವಾದಕವನ್ನು ಚಾಲನೆ ಮಾಡಿ:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` ಮತ್ತು `test_docs/translated_images` ನಲ್ಲಿ ಅನುವಾದಿತ ಫೈಲ್‌ಗಳನ್ನು ಪರಿಶೀಲಿಸಿ:
   - ಅನುವಾದ ಗುಣಮಟ್ಟ
   - ಮೆಟಾಡೇಟಾ ಕಾಮೆಂಟ್‌ಗಳು ಸರಿಯಾಗಿವೆ
   - ಮೂಲ ಮಾರ್ಕ್‌ಡೌನ್ ರಚನೆ ಉಳಿದಿದೆ
   - ಲಿಂಕ್‌ಗಳು ಮತ್ತು ಚಿತ್ರಗಳು ಸರಿಯಾಗಿ ಕಾರ್ಯನಿರ್ವಹಿಸುತ್ತಿವೆ

ಈ ಕೈಯಿಂದ ಪರೀಕ್ಷೆ ನಿಮ್ಮ ಬದಲಾವಣೆಗಳು ನಿಜವಾದ ಪರಿಸರಗಳಲ್ಲಿ ಚೆನ್ನಾಗಿ ಕೆಲಸ ಮಾಡುತ್ತವೆ ಎಂದು ಖಚಿತಪಡಿಸುತ್ತದೆ.

### ಪರಿಸರ ಚರಗಳು

1. ರೂಟ್ ಡೈರೆಕ್ಟರಿಯಲ್ಲಿ `.env.template` ಫೈಲ್ ನಕಲಿಸಿ `.env` ಫೈಲ್ ರಚಿಸಿ.
1. ಮಾರ್ಗದರ್ಶನದಂತೆ ಪರಿಸರ ಚರಗಳನ್ನು ಭರ್ತಿ ಮಾಡಿ.

> [!TIP]
>
> ### ಹೆಚ್ಚುವರಿ ಅಭಿವೃದ್ಧಿ ಪರಿಸರ ಆಯ್ಕೆಗಳು
>
> ಯೋಜನೆಯನ್ನು ಸ್ಥಳೀಯವಾಗಿ ಚಾಲನೆ ಮಾಡುವುದರ ಜೊತೆಗೆ, GitHub Codespaces ಅಥವಾ VS Code Dev Containers ಬಳಸಿ ಪರ್ಯಾಯ ಅಭಿವೃದ್ಧಿ ಪರಿಸರವನ್ನು ಹೊಂದಿಸಬಹುದು.
>
> #### GitHub Codespaces
>
> GitHub Codespaces ಬಳಸಿ ಈ ಮಾದರಿಗಳನ್ನು ವಾಸ್ತವಿಕವಾಗಿ ಚಾಲನೆ ಮಾಡಬಹುದು ಮತ್ತು ಯಾವುದೇ ಹೆಚ್ಚುವರಿ ಸೆಟ್ಟಿಂಗ್ ಅಥವಾ ಹೊಂದಾಣಿಕೆ ಅಗತ್ಯವಿಲ್ಲ.
>
> ಈ ಬಟನ್ ನಿಮ್ಮ ಬ್ರೌಸರ್‌ನಲ್ಲಿ ವೆಬ್ ಆಧಾರಿತ VS Code ಇನ್ಸ್ಟಾನ್ಸ್ ತೆರೆಯುತ್ತದೆ:
>
> 1. ಟೆಂಪ್ಲೇಟನ್ನು ತೆರೆಯಿರಿ (ಇದು ಕೆಲವು ನಿಮಿಷಗಳು ತೆಗೆದುಕೊಳ್ಳಬಹುದು):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### ಸ್ಥಳೀಯವಾಗಿ VS Code Dev Containers ಬಳಸಿ ಚಾಲನೆ
>
> ⚠️ ಈ ಆಯ್ಕೆ ನಿಮ್ಮ ಡೋಕರ್ ಡೆಸ್ಕ್‌ಟಾಪ್ ಕನಿಷ್ಠ 16 GB RAM ಹೊಂದಿದ್ದಾಗ ಮಾತ್ರ ಕಾರ್ಯನಿರ್ವಹಿಸುತ್ತದೆ. 16 GB ಕಿಂತ ಕಡಿಮೆ RAM ಇದ್ದರೆ, [GitHub Codespaces ಆಯ್ಕೆ](../..) ಅಥವಾ [ಸ್ಥಳೀಯವಾಗಿ ಹೊಂದಿಸಿಕೊಳ್ಳಿ](../..) ಪ್ರಯತ್ನಿಸಿ.
>
> ಸಂಬಂಧಿತ ಆಯ್ಕೆ VS Code Dev Containers ಆಗಿದ್ದು, ಇದು [Dev Containers ವಿಸ್ತರಣೆ](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) ಬಳಸಿ ನಿಮ್ಮ ಸ್ಥಳೀಯ VS Code ನಲ್ಲಿ ಯೋಜನೆಯನ್ನು ತೆರೆಯುತ್ತದೆ:
>
> 1. ಡೋಕರ್ ಡೆಸ್ಕ್‌ಟಾಪ್ ಪ್ರಾರಂಭಿಸಿ (ಇದನ್ನು ಸ್ಥಾಪಿಸಿಲ್ಲದಿದ್ದರೆ ಸ್ಥಾಪಿಸಿ)
> 2. ಯೋಜನೆಯನ್ನು ತೆರೆಯಿರಿ:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### ಕೋಡ್ ಶೈಲಿ

ನಾವು ಯೋಜನೆಯಾದ್ಯಂತ ಸुसಂಗತ ಕೋಡ್ ಶೈಲಿಯನ್ನು ಕಾಯ್ದುಕೊಳ್ಳಲು Python ಕೋಡ್ ಫಾರ್ಮ್ಯಾಟರ್ ಆಗಿ [Black](https://github.com/psf/black) ಅನ್ನು ಬಳಸುತ್ತೇವೆ. Black ಒಂದು ಅಚಲಿತ ಕೋಡ್ ಫಾರ್ಮ್ಯಾಟರ್ ಆಗಿದ್ದು, Python ಕೋಡ್ ಅನ್ನು ಸ್ವಯಂಚಾಲಿತವಾಗಿ Black ಕೋಡ್ ಶೈಲಿಗೆ ಹೊಂದಿಸುವಂತೆ ಮರುರೂಪಗೊಳಿಸುತ್ತದೆ.

#### ಸಂರಚನೆ

Black ಸಂರಚನೆ ನಮ್ಮ `pyproject.toml` ನಲ್ಲಿ ನಿರ್ದಿಷ್ಟಪಡಿಸಲಾಗಿದೆ:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black ಅನ್ನು ಸ್ಥಾಪಿಸುವುದು

ನೀವು Black ಅನ್ನು Poetry (ಶಿಫಾರಸು ಮಾಡಲಾಗಿದೆ) ಅಥವಾ pip ಬಳಸಿ ಸ್ಥಾಪಿಸಬಹುದು:

##### Poetry ಬಳಸಿ

ಅಭಿವೃದ್ಧಿ ಪರಿಸರವನ್ನು ಹೊಂದಿಸುವಾಗ Black ಸ್ವಯಂಚಾಲಿತವಾಗಿ ಸ್ಥಾಪಿತವಾಗುತ್ತದೆ:
```bash
poetry install
```

##### pip ಬಳಸಿ

ನೀವು pip ಬಳಸುತ್ತಿದ್ದರೆ, ನೇರವಾಗಿ Black ಅನ್ನು ಸ್ಥಾಪಿಸಬಹುದು:
```bash
pip install black
```

#### Black ಬಳಸಿ

##### Poetry ಜೊತೆಗೆ

1. ಯೋಜನೆಯ ಎಲ್ಲಾ Python ಫೈಲ್‌ಗಳನ್ನು ಫಾರ್ಮ್ಯಾಟ್ ಮಾಡಿ:
    ```bash
    poetry run black .
    ```

2. ನಿರ್ದಿಷ್ಟ ಫೈಲ್ ಅಥವಾ ಡೈರೆಕ್ಟರಿಯನ್ನು ಫಾರ್ಮ್ಯಾಟ್ ಮಾಡಿ:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip ಜೊತೆಗೆ

1. ಯೋಜನೆಯ ಎಲ್ಲಾ Python ಫೈಲ್‌ಗಳನ್ನು ಫಾರ್ಮ್ಯಾಟ್ ಮಾಡಿ:
    ```bash
    black .
    ```

2. ನಿರ್ದಿಷ್ಟ ಫೈಲ್ ಅಥವಾ ಡೈರೆಕ್ಟರಿಯನ್ನು ಫಾರ್ಮ್ಯಾಟ್ ಮಾಡಿ:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> ನಿಮ್ಮ ಸಂಪಾದಕವನ್ನು Black ಬಳಸಿ ಕೋಡ್ ಅನ್ನು ಉಳಿಸುವಾಗ ಸ್ವಯಂಚಾಲಿತವಾಗಿ ಫಾರ್ಮ್ಯಾಟ್ ಮಾಡಲು ಹೊಂದಿಸುವುದನ್ನು ನಾವು ಶಿಫಾರಸು ಮಾಡುತ್ತೇವೆ. ಬಹುತೇಕ ಆಧುನಿಕ ಸಂಪಾದಕರು ವಿಸ್ತರಣೆಗಳು ಅಥವಾ ಪ್ಲಗಿನ್‌ಗಳ ಮೂಲಕ ಇದನ್ನು ಬೆಂಬಲಿಸುತ್ತವೆ.

## ಕೋ-ಆಪ್ ಅನುವಾದಕವನ್ನು ಚಾಲನೆ ಮಾಡುವುದು

ನಿಮ್ಮ ಪರಿಸರದಲ್ಲಿ Poetry ಬಳಸಿ ಕೋ-ಆಪ್ ಅನುವಾದಕವನ್ನು ಚಾಲನೆ ಮಾಡಲು, ಈ ಹಂತಗಳನ್ನು ಅನುಸರಿಸಿ:

1. ನೀವು ಅನುವಾದ ಪರೀಕ್ಷೆಗಳನ್ನು ನಡೆಸಲು ಬಯಸುವ ಡೈರೆಕ್ಟರಿಗೆ ಹೋಗಿ ಅಥವಾ ಪರೀಕ್ಷೆಗಾಗಿ ತಾತ್ಕಾಲಿಕ ಫೋಲ್ಡರ್ ರಚಿಸಿ.

2. ಕೆಳಗಿನ ಆಜ್ಞೆಯನ್ನು ನಿರ್ವಹಿಸಿ. `-l ko` ಅನ್ನು ನೀವು ಅನುವಾದಿಸಲು ಬಯಸುವ ಭಾಷಾ ಕೋಡ್‌ನೊಂದಿಗೆ ಬದಲಾಯಿಸಿ. `-d` ಧ್ವಜವು ಡಿಬಗ್ ಮೋಡ್ ಸೂಚಿಸುತ್ತದೆ.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> ಆಜ್ಞೆಯನ್ನು ಚಾಲನೆ ಮಾಡುವ ಮೊದಲು ನಿಮ್ಮ Poetry ಪರಿಸರ ಸಕ್ರಿಯಗೊಂಡಿರುವುದನ್ನು ಖಚಿತಪಡಿಸಿಕೊಳ್ಳಿ (poetry shell).

## ಹೊಸ ಭಾಷೆಯನ್ನು ಕೊಡುಗೆ ನೀಡುವುದು

ಹೊಸ ಭಾಷೆಗಳ ಬೆಂಬಲವನ್ನು ಸೇರಿಸುವ ಕೊಡುಗೆಗಳನ್ನು ನಾವು ಸ್ವಾಗತಿಸುತ್ತೇವೆ. PR ತೆರೆಯುವ ಮೊದಲು, ಸಮೀಕ್ಷೆ ಸುಗಮವಾಗಲು ಕೆಳಗಿನ ಹಂತಗಳನ್ನು ಪೂರ್ಣಗೊಳಿಸಿ.

1. ಭಾಷೆಯನ್ನು ಫಾಂಟ್ ಮ್ಯಾಪಿಂಗ್‌ಗೆ ಸೇರಿಸಿ
   - `src/co_op_translator/fonts/font_language_mappings.yml` ಅನ್ನು ಸಂಪಾದಿಸಿ
   - ಕೆಳಗಿನ ಅಂಶಗಳೊಂದಿಗೆ ಎಂಟ್ರಿಯನ್ನು ಸೇರಿಸಿ:
     - `code`: ISO-ಹೋಲುವ ಭಾಷಾ ಕೋಡ್ (ಉದಾ: `vi`)
     - `name`: ಮಾನವ ಸ್ನೇಹಿ ಪ್ರದರ್ಶನ ಹೆಸರು
     - `font`: `src/co_op_translator/fonts/` ನಲ್ಲಿ ಪ್ಯಾಕೇಜ್ ಆಗಿರುವ, ಆ ಲಿಪಿಯನ್ನು ಬೆಂಬಲಿಸುವ ಫಾಂಟ್
     - `rtl`: ಬಲದಿಂದ ಎಡಕ್ಕೆ ಓದುವ ಭಾಷೆ ಆಗಿದ್ದರೆ `true`, ಇಲ್ಲದಿದ್ದರೆ `false`

2. ಅಗತ್ಯವಿದ್ದರೆ ಫಾಂಟ್ ಫೈಲ್‌ಗಳನ್ನು ಸೇರಿಸಿ
   - ಹೊಸ ಫಾಂಟ್ ಬೇಕಾದರೆ, ಮುಕ್ತ ಮೂಲ ವಿತರಣೆಗಾಗಿ ಪರವಾನಗಿ ಹೊಂದಾಣಿಕೆಯನ್ನು ಪರಿಶೀಲಿಸಿ
   - ಫಾಂಟ್ ಫೈಲ್ ಅನ್ನು `src/co_op_translator/fonts/` ಗೆ ಸೇರಿಸಿ

3. ಸ್ಥಳೀಯ ಪರಿಶೀಲನೆ
   - ಸಣ್ಣ ಮಾದರಿಗಾಗಿ ಅನುವಾದಗಳನ್ನು ನಡೆಸಿ (ಮಾರ್ಕ್‌ಡೌನ್, ಚಿತ್ರಗಳು ಮತ್ತು ನೋಟ್‌ಬುಕ್‌ಗಳು ಅಗತ್ಯವಿದ್ದರೆ)
   - ಔಟ್‌ಪುಟ್ ಸರಿಯಾಗಿ ಪ್ರದರ್ಶಿಸುತ್ತಿದೆಯೇ, ಫಾಂಟ್‌ಗಳು ಮತ್ತು RTL ವಿನ್ಯಾಸ ಸಹಿತ ಪರಿಶೀಲಿಸಿ

4. ಡಾಕ್ಯುಮೆಂಟೇಶನ್ ನವೀಕರಿಸಿ
   - ಭಾಷೆ `getting_started/supported-languages.md` ನಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳುವಂತೆ ಮಾಡಿ
   - `getting_started/README_languages_template.md` ಗೆ ಬದಲಾವಣೆ ಅಗತ್ಯವಿಲ್ಲ; ಇದು ಬೆಂಬಲಿತ ಪಟ್ಟಿಯಿಂದ ಸ್ವಯಂಚಾಲಿತವಾಗಿ ರಚಿಸಲಾಗುತ್ತದೆ

5. PR ತೆರೆಯಿರಿ
   - ಸೇರಿಸಿದ ಭಾಷೆ ಮತ್ತು ಯಾವುದೇ ಫಾಂಟ್/ಪರವಾನಗಿ ವಿಚಾರಗಳನ್ನು ವಿವರಿಸಿ
   - ಸಾಧ್ಯವಾದರೆ ಔಟ್‌ಪುಟ್‌ನ ಸ್ಕ್ರೀನ್‌ಶಾಟ್‌ಗಳನ್ನು ಲಗತ್ತಿಸಿ

ಉದಾಹರಣೆಯ YAML ಎಂಟ್ರಿ:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### ಹೊಸ ಭಾಷೆಯನ್ನು ಪರೀಕ್ಷಿಸುವುದು

ನೀವು ಕೆಳಗಿನ ಆಜ್ಞೆಯನ್ನು ಚಾಲನೆ ಮಾಡಿ ಹೊಸ ಭಾಷೆಯನ್ನು ಪರೀಕ್ಷಿಸಬಹುದು:

```bash
# ವರ್ಚುವಲ್ ಪರಿಸರವನ್ನು ರಚಿಸಿ ಮತ್ತು ಸಕ್ರಿಯಗೊಳಿಸಿ
python -m venv .venv
# ವಿಂಡೋಸ್
.venv\Scripts\activate
# ಮ್ಯಾಕ್‌ಒಎಸ್/ಲಿನಕ್ಸ
source .venv/bin/activate
# ಅಭಿವೃದ್ಧಿ ಪ್ಯಾಕೇಜ್ ಅನ್ನು ಸ್ಥಾಪಿಸಿ
pip install -e .
# ಅನುವಾದವನ್ನು ಚಾಲನೆ ಮಾಡಿ
translate -l "new_lang"
```

## ನಿರ್ವಹಕರು

### ಕಮಿಟ್ ಸಂದೇಶ ಮತ್ತು ಮರ್ಜ್ ತಂತ್ರ

ನಮ್ಮ ಯೋಜನೆಯ ಕಮಿಟ್ ಇತಿಹಾಸದಲ್ಲಿ ಸुसಂಗತತೆ ಮತ್ತು ಸ್ಪಷ್ಟತೆಯನ್ನು ಖಚಿತಪಡಿಸಲು, ನಾವು **Squash and Merge** ತಂತ್ರವನ್ನು ಬಳಸುವಾಗ **ಅಂತಿಮ ಕಮಿಟ್ ಸಂದೇಶ**ಗಾಗಿ ನಿರ್ದಿಷ್ಟ ಕಮಿಟ್ ಸಂದೇಶ ಸ್ವರೂಪವನ್ನು ಅನುಸರಿಸುತ್ತೇವೆ.

ಒಂದು ಪಲ್ಲ್ ರಿಕ್ವೆಸ್ಟ್ (PR) ಮರ್ಜ್ ಆಗುವಾಗ, ವೈಯಕ್ತಿಕ ಕಮಿಟ್‌ಗಳನ್ನು ಒಟ್ಟುಗೂಡಿಸಿ ಒಂದು ಕಮಿಟ್ ಆಗಿ ಮಾಡಲಾಗುತ್ತದೆ. ಅಂತಿಮ ಕಮಿಟ್ ಸಂದೇಶವು ಕೆಳಗಿನ ಸ್ವರೂಪವನ್ನು ಅನುಸರಿಸಬೇಕು, ಇದರಿಂದ ಇತಿಹಾಸವು ಸ್ವಚ್ಛ ಮತ್ತು ಸुसಂಗತವಾಗಿರುತ್ತದೆ.

#### ಕಮಿಟ್ ಸಂದೇಶ ಸ್ವರೂಪ (squash and merge ಗಾಗಿ)

ನಾವು ಕೆಳಗಿನ ಸ್ವರೂಪವನ್ನು ಕಮಿಟ್ ಸಂದೇಶಗಳಿಗೆ ಬಳಸುತ್ತೇವೆ:

```bash
<type>: <description> (#<PR ಸಂಖ್ಯೆ>)
```

- **type**: ಕಮಿಟ್ ವರ್ಗವನ್ನು ಸೂಚಿಸುತ್ತದೆ. ನಾವು ಈ ಕೆಳಗಿನ ಪ್ರಕಾರಗಳನ್ನು ಬಳಸುತ್ತೇವೆ:
  - `Docs`: ಡಾಕ್ಯುಮೆಂಟೇಶನ್ ನವೀಕರಣಗಳಿಗೆ.
  - `Build`: ನಿರ್ಮಾಣ ವ್ಯವಸ್ಥೆ ಅಥವಾ ಅವಲಂಬನೆಗಳಿಗೆ ಸಂಬಂಧಿಸಿದ ಬದಲಾವಣೆಗಳಿಗೆ, ಸಂರಚನಾ ಫೈಲ್‌ಗಳು, CI ವರ್ಕ್‌ಫ್ಲೋಗಳು ಅಥವಾ ಡೋಕರ್‌ಫೈಲ್ ನವೀಕರಣಗಳು ಸೇರಿ.
  - `Core`: ಯೋಜನೆಯ ಮೂಲ ಕಾರ್ಯಕ್ಷಮತೆ ಅಥವಾ ವೈಶಿಷ್ಟ್ಯಗಳಿಗೆ ಬದಲಾವಣೆಗಳಿಗೆ, ವಿಶೇಷವಾಗಿ `src/co_op_translator/core` ಡೈರೆಕ್ಟರಿಯಲ್ಲಿನ ಫೈಲ್‌ಗಳಿಗೆ.

- **description**: ಬದಲಾವಣೆಯ ಸಂಕ್ಷಿಪ್ತ ಸಾರಾಂಶ.
- **PR ಸಂಖ್ಯೆ**: ಕಮಿಟ್‌ಗೆ ಸಂಬಂಧಿಸಿದ ಪಲ್ಲ್ ರಿಕ್ವೆಸ್ಟ್ ಸಂಖ್ಯೆ.

**ಉದಾಹರಣೆಗಳು**:

- `Docs: ಸ್ಪಷ್ಟತೆಗಾಗಿ ಸ್ಥಾಪನೆ ಸೂಚನೆಗಳನ್ನು ನವೀಕರಿಸಲಾಗಿದೆ (#50)`
- `Core: ಚಿತ್ರ ಅನುವಾದದ ನಿರ್ವಹಣೆಯನ್ನು ಸುಧಾರಿಸಲಾಗಿದೆ (#60)`

> [!NOTE]
> ಪ್ರಸ್ತುತ, **`Docs`**, **`Core`**, ಮತ್ತು **`Build`** ಪೂರ್ವಪ್ರತ್ಯಯಗಳು ಸ್ವಯಂಚಾಲಿತವಾಗಿ PR ಶೀರ್ಷಿಕೆಗಳಿಗೆ ಸೇರಿಸಲಾಗುತ್ತದೆ, ಬದಲಾಯಿಸಿದ ಮೂಲ ಕೋಡ್‌ಗೆ ಅನ್ವಯಿಸುವ ಲೇಬಲ್‌ಗಳ ಆಧಾರದ ಮೇಲೆ. ಸರಿಯಾದ ಲೇಬಲ್ ಅನ್ವಯಿಸಿದರೆ, ನೀವು ಸಾಮಾನ್ಯವಾಗಿ PR ಶೀರ್ಷಿಕೆಯನ್ನು ಕೈಯಿಂದ ನವೀಕರಿಸುವ ಅಗತ್ಯವಿಲ್ಲ. ನೀವು ಎಲ್ಲವೂ ಸರಿಯಾಗಿದೆಯೇ ಮತ್ತು ಪೂರ್ವಪ್ರತ್ಯಯ ಸರಿಯಾಗಿ ರಚಿಸಲಾಗಿದೆ ಎಂದು ಪರಿಶೀಲಿಸುವುದೇ ಸಾಕು.

#### ಮರ್ಜ್ ತಂತ್ರ

ನಾವು ಪಲ್ಲ್ ರಿಕ್ವೆಸ್ಟ್‌ಗಳಿಗೆ ಡೀಫಾಲ್ಟ್ ಆಗಿ **Squash and Merge** ತಂತ್ರವನ್ನು ಬಳಸುತ್ತೇವೆ. ಈ ತಂತ್ರವು ಕಮಿಟ್ ಸಂದೇಶಗಳು ನಮ್ಮ ಸ್ವರೂಪವನ್ನು ಅನುಸರಿಸುವಂತೆ ಖಚಿತಪಡಿಸುತ್ತದೆ, ವೈಯಕ್ತಿಕ ಕಮಿಟ್‌ಗಳು ಇಲ್ಲದಿದ್ದರೂ ಸಹ.

**ಕಾರಣಗಳು**:

- ಸ್ವಚ್ಛ, ರೇಖೀಯ ಯೋಜನೆ ಇತಿಹಾಸ.
- ಕಮಿಟ್ ಸಂದೇಶಗಳಲ್ಲಿ ಸुसಂಗತತೆ.
- ಸಣ್ಣ ಕಮಿಟ್‌ಗಳಿಂದ (ಉದಾ: "ಟೈಪೋ ಸರಿಪಡಿಸಿ") ಉಂಟಾಗುವ ಶಬ್ದವನ್ನು ಕಡಿಮೆ ಮಾಡುವುದು.

ಮರ್ಜ್ ಮಾಡುವಾಗ, ಅಂತಿಮ ಕಮಿಟ್ ಸಂದೇಶವು ಮೇಲ್ಕಂಡ ಸ್ವರೂಪವನ್ನು ಅನುಸರಿಸಬೇಕು.

**Squash and Merge ಉದಾಹರಣೆ**
ಒಂದು PR ಈ ಕೆಳಗಿನ ಕಮಿಟ್‌ಗಳನ್ನು ಹೊಂದಿದ್ದರೆ:

- `ಟೈಪೋ ಸರಿಪಡಿಸಿ`
- `README ನವೀಕರಿಸಿ`
- `ಫಾರ್ಮ್ಯಾಟಿಂಗ್ ಸರಿಪಡಿಸಿ`

ಅವುಗಳನ್ನು ಒಟ್ಟುಗೂಡಿಸಿ:
`Docs: ಡಾಕ್ಯುಮೆಂಟೇಶನ್ ಸ್ಪಷ್ಟತೆ ಮತ್ತು ಫಾರ್ಮ್ಯಾಟಿಂಗ್ ಸುಧಾರಣೆ (#65)`

### ಬಿಡುಗಡೆ ಪ್ರಕ್ರಿಯೆ

ಈ ವಿಭಾಗವು ನಿರ್ವಹಕರಿಗೆ ಕೋ-ಆಪ್ ಅನುವಾದಕದ ಹೊಸ ಬಿಡುಗಡೆ ಪ್ರಕಟಿಸುವ ಸರಳ ವಿಧಾನವನ್ನು ವಿವರಿಸುತ್ತದೆ.

#### 1. `pyproject.toml` ನಲ್ಲಿ ಆವೃತ್ತಿಯನ್ನು ಹೆಚ್ಚಿಸುವುದು

1. ಮುಂದಿನ ಆವೃತ್ತಿ ಸಂಖ್ಯೆಯನ್ನು ನಿರ್ಧರಿಸಿ (ನಾವು ಸೆಮ್ಯಾಂಟಿಕ್ ವರ್ಸನಿಂಗ್ ಅನುಸರಿಸುತ್ತೇವೆ: `MAJOR.MINOR.PATCH`).
2. `pyproject.toml` ಅನ್ನು ಸಂಪಾದಿಸಿ ಮತ್ತು `[tool.poetry]` ಅಡಿಯಲ್ಲಿ `version` ಕ್ಷೇತ್ರವನ್ನು ನವೀಕರಿಸಿ.
3. ಕೇವಲ ಆವೃತ್ತಿಯನ್ನು ಬದಲಾಯಿಸುವ (ಮತ್ತು ಸ್ವಯಂಚಾಲಿತವಾಗಿ ನವೀಕರಿಸಲಾದ ಲಾಕ್/ಮೆಟಾಡೇಟಾ ಫೈಲ್‌ಗಳು ಇದ್ದರೆ ಅವುಗಳನ್ನೂ) ಸಮರ್ಪಿತ ಪಲ್ಲ್ ರಿಕ್ವೆಸ್ಟ್ ತೆರೆಯಿರಿ.
4. ಪರಿಶೀಲನೆಯ ನಂತರ, **Squash and Merge** ಬಳಸಿ ಮತ್ತು ಅಂತಿಮ ಕಮಿಟ್ ಸಂದೇಶವು ಮೇಲ್ಕಂಡ ಸ್ವರೂಪವನ್ನು ಅನುಸರಿಸುವಂತೆ ಖಚಿತಪಡಿಸಿ.

#### 2. GitHub ಬಿಡುಗಡೆ ರಚನೆ

1. GitHub ರೆಪೊಸಿಟರಿ ಪುಟಕ್ಕೆ ಹೋಗಿ **Releases** → **Draft a new release** ತೆರೆಯಿರಿ.
2. `main` ಶಾಖೆಯಿಂದ ಹೊಸ ಟ್ಯಾಗ್ (ಉದಾ: `v0.13.0`) ರಚಿಸಿ.
3. ಬಿಡುಗಡೆ ಶೀರ್ಷಿಕೆಯನ್ನು ಅದೇ ಆವೃತ್ತಿಗೆ (ಉದಾ: `v0.13.0`) ಹೊಂದಿಸಿ.
4. **Generate release notes** ಕ್ಲಿಕ್ ಮಾಡಿ ಚೇಂಜ್‌ಲಾಗ್ ಸ್ವಯಂಚಾಲಿತವಾಗಿ ತುಂಬಿಸಿ.
5. ಐಚ್ಛಿಕವಾಗಿ ಪಠ್ಯವನ್ನು ಸಂಪಾದಿಸಿ (ಉದಾ: ಹೊಸ ಬೆಂಬಲಿತ ಭಾಷೆಗಳು ಅಥವಾ ಪ್ರಮುಖ ಬದಲಾವಣೆಗಳನ್ನು ಹೈಲೈಟ್ ಮಾಡಲು).
6. ಬಿಡುಗಡೆ ಪ್ರಕಟಿಸಿ.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**ಅಸ್ವೀಕರಣ**:  
ಈ ದಸ್ತಾವೇಜು [Co-op Translator](https://github.com/Azure/co-op-translator) ಎಂಬ AI ಅನುವಾದ ಸೇವೆಯನ್ನು ಬಳಸಿ ಅನುವಾದಿಸಲಾಗಿದೆ. ನಾವು ಶುದ್ಧತೆಯತ್ತ ಪ್ರಯತ್ನಿಸುತ್ತಿದ್ದರೂ, ಸ್ವಯಂಚಾಲಿತ ಅನುವಾದಗಳಲ್ಲಿ ತಪ್ಪುಗಳು ಅಥವಾ ಅಸತ್ಯತೆಗಳು ಇರಬಹುದು ಎಂಬುದನ್ನು ದಯವಿಟ್ಟು ಗಮನಿಸಿ. ಮೂಲ ಭಾಷೆಯಲ್ಲಿರುವ ಮೂಲ ದಸ್ತಾವೇಜನ್ನು ಅಧಿಕೃತ ಮೂಲವೆಂದು ಪರಿಗಣಿಸಬೇಕು. ಮಹತ್ವದ ಮಾಹಿತಿಗಾಗಿ, ವೃತ್ತಿಪರ ಮಾನವ ಅನುವಾದವನ್ನು ಶಿಫಾರಸು ಮಾಡಲಾಗುತ್ತದೆ. ಈ ಅನುವಾದ ಬಳಕೆಯಿಂದ ಉಂಟಾಗುವ ಯಾವುದೇ ತಪ್ಪು ಅರ್ಥಮಾಡಿಕೊಳ್ಳುವಿಕೆ ಅಥವಾ ತಪ್ಪು ವಿವರಣೆಗಳಿಗೆ ನಾವು ಹೊಣೆಗಾರರಾಗುವುದಿಲ್ಲ.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->