<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "cc205495d4eace1fabcdee963024069f",
  "translation_date": "2025-07-04T08:11:19+00:00",
  "source_file": "SECURITY.md",
  "language_code": "ja"
}
-->
## セキュリティ

Microsoftは、ソフトウェア製品とサービスのセキュリティを重視しており、これにはGitHub組織を通じて管理されるすべてのソースコードリポジトリが含まれます。これには、[Microsoft](https://github.com/Microsoft)、[Azure](https://github.com/Azure)、[DotNet](https://github.com/dotnet)、[AspNet](https://github.com/aspnet)、[Xamarin](https://github.com/xamarin)が含まれます。

もし、[Microsoftのセキュリティ脆弱性の定義](https://aka.ms/security.md/definition)に該当するMicrosoft所有のリポジトリにセキュリティ脆弱性を発見したと思われる場合は、以下の手順に従って報告してください。

## セキュリティ問題の報告

**セキュリティ脆弱性を公開GitHubの問題として報告しないでください。**

代わりに、Microsoft Security Response Center (MSRC) に[https://msrc.microsoft.com/create-report](https://aka.ms/security.md/msrc/create-report)で報告してください。

ログインせずに提出したい場合は、[secure@microsoft.com](mailto:secure@microsoft.com)にメールを送信してください。可能であれば、メッセージを当社のPGPキーで暗号化してください。PGPキーは[Microsoft Security Response Center PGP Key page](https://aka.ms/security.md/msrc/pgp)からダウンロードできます。

24時間以内に返信を受け取るはずです。何らかの理由で返信がない場合は、元のメッセージが届いているか確認するためにメールでフォローアップしてください。追加情報は[microsoft.com/msrc](https://www.microsoft.com/msrc)で確認できます。

可能な限り以下の情報を含めてください。これにより、問題の性質と範囲をよりよく理解するのに役立ちます：

  * 問題の種類（例：バッファオーバーフロー、SQLインジェクション、クロスサイトスクリプティングなど）
  * 問題の発生に関連するソースファイルのフルパス
  * 影響を受けるソースコードの場所（タグ/ブランチ/コミットまたは直接URL）
  * 問題を再現するために必要な特別な設定
  * 問題を再現するためのステップバイステップの手順
  * 概念実証またはエクスプロイトコード（可能であれば）
  * 問題の影響、攻撃者がどのように問題を悪用する可能性があるか

この情報は、報告を迅速に処理するのに役立ちます。

バグバウンティのために報告する場合、より詳細な報告はより高い報奨金に貢献する可能性があります。アクティブなプログラムの詳細については、[Microsoft Bug Bounty Program](https://aka.ms/security.md/msrc/bounty)ページをご覧ください。

## 優先言語

すべてのコミュニケーションは英語で行うことを推奨します。

## ポリシー

Microsoftは[Coordinated Vulnerability Disclosure](https://aka.ms/security.md/cvd)の原則に従っています。

**免責事項**:
この文書はAI翻訳サービス[Co-op Translator](https://github.com/Azure/co-op-translator)を使用して翻訳されています。正確性を追求していますが、自動翻訳には誤りや不正確さが含まれる可能性があることをご了承ください。元の言語での文書が権威ある情報源と見なされるべきです。重要な情報については、専門の人間による翻訳をお勧めします。この翻訳の使用に起因する誤解や誤解について、当社は責任を負いません。