<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T03:05:41+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "it"
}
-->
# Installa il pacchetto Co-op Translator

Il **Co-op Translator** è uno strumento da riga di comando (CLI) progettato per aiutarti a tradurre tutti i file markdown e le immagini del tuo progetto in più lingue. Questa guida ti accompagnerà nella configurazione del traduttore e nel suo utilizzo per diversi casi d'uso.

### Crea un ambiente virtuale

Puoi creare un ambiente virtuale utilizzando sia `pip` che `Poetry`. Digita uno dei seguenti comandi nel tuo terminale.

#### Usando pip

```bash
python -m venv .venv
```

#### Usando Poetry

```bash
poetry init
```

### Attiva l'ambiente virtuale

Dopo aver creato l'ambiente virtuale, dovrai attivarlo. I passaggi variano a seconda del sistema operativo. Digita il seguente comando nel tuo terminale.

#### Per entrambi pip e Poetry

- Windows:

    ```bash
    .venv\Scripts\activate
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Usando Poetry

1. Se hai creato l'ambiente con Poetry, digita il seguente comando nel tuo terminale per attivarlo.

    ```bash
    poetry shell
    ```

### Installazione del pacchetto e dei pacchetti necessari

Una volta che il tuo ambiente virtuale è stato configurato e attivato, il prossimo passo è installare le dipendenze necessarie.

### Installazione rapida

Installa Co-Op Translator tramite pip

```
pip install co-op-translator
```
Oppure

Installa tramite poetry
```
poetry add co-op-translator
```

#### Usando pip (da requirements.txt) se hai clonato questo repository

> [!NOTE]
> Non eseguire questa operazione se hai installato co-op translator tramite l'installazione rapida.

1. Se stai usando pip, digita il seguente comando nel tuo terminale. Installerà automaticamente i pacchetti richiesti specificati nel file `requirements.txt`:

    ```bash
    pip install -r requirements.txt
    ```

#### Usando Poetry (da pyproject.toml)

1. Se stai usando Poetry, digita il seguente comando nel tuo terminale. Installerà automaticamente i pacchetti richiesti specificati nel file `pyproject.toml`:

    ```bash
    poetry install
    ```

---

**Disclaimer**:
Questo documento è stato tradotto utilizzando il servizio di traduzione AI [Co-op Translator](https://github.com/Azure/co-op-translator). Pur impegnandoci per garantire l’accuratezza, si prega di notare che le traduzioni automatiche possono contenere errori o imprecisioni. Il documento originale nella sua lingua nativa deve essere considerato la fonte autorevole. Per informazioni critiche, si raccomanda una traduzione professionale umana. Non siamo responsabili per eventuali fraintendimenti o interpretazioni errate derivanti dall’uso di questa traduzione.