<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T02:43:59+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "hi"
}
-->
# Microsoft Co-op Translator समस्या निवारण गाइड

## अवलोकन
Microsoft Co-Op Translator एक शक्तिशाली टूल है जो Markdown दस्तावेज़ों का अनुवाद आसानी से करता है। यह गाइड आपको टूल का उपयोग करते समय आने वाली सामान्य समस्याओं को हल करने में मदद करेगी।

## सामान्य समस्याएँ और समाधान

### 1. Markdown टैग समस्या
**समस्या:** अनुवादित Markdown दस्तावेज़ के ऊपर `markdown` टैग आ जाता है, जिससे रेंडरिंग में समस्या होती है।

**समाधान:** इसे ठीक करने के लिए, फाइल के ऊपर से `markdown` टैग को हटा दें। इससे Markdown फाइल सही से रेंडर होगी।

**स्टेप्स:**
1. अनुवादित Markdown (`.md`) फाइल खोलें।
2. दस्तावेज़ के ऊपर `markdown` टैग ढूंढें।
3. `markdown` टैग को डिलीट करें।
4. फाइल को सेव करें।
5. फाइल को फिर से खोलें और देखें कि वह सही से रेंडर हो रही है या नहीं।

### 2. एम्बेडेड इमेज URL समस्या
**समस्या:** एम्बेडेड इमेज के URL भाषा लोकल से मेल नहीं खाते, जिससे गलत या गायब इमेज दिखती हैं।

**समाधान:** एम्बेडेड इमेज के URL चेक करें और सुनिश्चित करें कि वे भाषा लोकल से मेल खाते हैं। सभी इमेज `translated_images` फोल्डर में होती हैं और हर इमेज के फाइल नाम में भाषा लोकल टैग होता है।

**स्टेप्स:**
1. अनुवादित Markdown दस्तावेज़ खोलें।
2. एम्बेडेड इमेज और उनके URL पहचानें।
3. जांचें कि इमेज फाइल नाम में भाषा लोकल दस्तावेज़ की भाषा से मेल खाता है या नहीं।
4. जरूरत हो तो URL अपडेट करें।
5. बदलाव सेव करें और दस्तावेज़ को फिर से खोलें ताकि इमेज सही से दिखें।

### 3. अनुवाद की सटीकता
**समस्या:** अनुवादित सामग्री सटीक नहीं है या उसमें और संपादन की जरूरत है।

**समाधान:** अनुवादित दस्तावेज़ की समीक्षा करें और सटीकता व पठनीयता बढ़ाने के लिए जरूरी संपादन करें।

**स्टेप्स:**
1. अनुवादित दस्तावेज़ खोलें।
2. सामग्री को ध्यान से पढ़ें।
3. अनुवाद की सटीकता बढ़ाने के लिए जरूरी संपादन करें।
4. बदलाव सेव करें।

## 4. अनुमति त्रुटि Redacted या 404

अगर इमेज या टेक्स्ट सही भाषा में अनुवादित नहीं हो रहे हैं और -d डिबग मोड में 401 त्रुटि आ रही है, तो यह क्लासिक ऑथेंटिकेशन फेलियर है—या तो कुंजी अमान्य है, समाप्त हो गई है, या एंडपॉइंट के क्षेत्र से लिंक नहीं है।

मूल कारण जानने के लिए co-op translator को [-d debug switch](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md) के साथ चलाएँ।

- **त्रुटि संदेश:** `Access denied due to invalid subscription key or wrong API endpoint.`
- **संभावित कारण:**
  - अनुरोध में सब्सक्रिप्शन कुंजी हटा दी गई या गलत थी।
  - AI Services Key या Subscription Key किसी अन्य Azure संसाधन (जैसे Translator या OpenAI) की हो सकती है, जबकि चाहिए **Azure AI Vision** संसाधन की।

 **Resource Type**
  - [Azure Portal](https://portal.azure.com) या [Azure AI Foundry](https://ai.azure.com) पर जाएँ और सुनिश्चित करें कि संसाधन का प्रकार `Azure AI services` → `Vision` है।
  - कुंजियों को सत्यापित करें और सही कुंजी का उपयोग हो रहा है, यह सुनिश्चित करें।

## 5. कॉन्फ़िगरेशन त्रुटियाँ (नई त्रुटि हैंडलिंग)

नई चयनात्मक अनुवाद प्रणाली के साथ, Co-op Translator अब स्पष्ट त्रुटि संदेश देता है जब आवश्यक सेवाएँ कॉन्फ़िगर नहीं होतीं।

### 5.1. इमेज अनुवाद के लिए Azure AI Service कॉन्फ़िगर नहीं

**समस्या:** आपने इमेज अनुवाद (`-img` फ्लैग) का अनुरोध किया है, लेकिन Azure AI Service सही से कॉन्फ़िगर नहीं है।

**त्रुटि संदेश:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**समाधान:**
1. **विकल्प 1:** Azure AI Service कॉन्फ़िगर करें
   - अपनी `.env` फाइल में `AZURE_AI_SERVICE_API_KEY` जोड़ें
   - अपनी `.env` फाइल में `AZURE_AI_SERVICE_ENDPOINT` जोड़ें
   - सेवा सुलभ है, यह सत्यापित करें

2. **विकल्प 2:** इमेज अनुवाद अनुरोध हटा दें
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. आवश्यक कॉन्फ़िगरेशन गायब

**समस्या:** आवश्यक LLM कॉन्फ़िगरेशन गायब है।

**त्रुटि संदेश:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**समाधान:**
1. अपनी `.env` फाइल में कम से कम निम्नलिखित LLM कॉन्फ़िगरेशन में से एक होना चाहिए:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` और `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   आपको या तो Azure OpenAI या OpenAI कॉन्फ़िगर करना है, दोनों नहीं।

### 5.3. चयनात्मक अनुवाद भ्रम

**समस्या:** कमांड सफल होने के बावजूद कोई फाइल अनुवादित नहीं हुई।

**संभावित कारण:**
- गलत फाइल टाइप फ्लैग (`-md`, `-img`, `-nb`)
- प्रोजेक्ट में कोई मेल खाती फाइल नहीं
- गलत डायरेक्टरी संरचना

**समाधान:**
1. **डिबग मोड का उपयोग करें** यह देखने के लिए कि क्या हो रहा है:
   ```bash
   translate -l "ko" -md -d
   ```

2. **अपने प्रोजेक्ट में फाइल टाइप्स चेक करें:**
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **फ्लैग संयोजन सत्यापित करें:**
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. पुराने सिस्टम से माइग्रेशन

### 6.1. केवल Markdown मोड अब बंद

**समस्या:** वे कमांड जो अपने आप markdown-only मोड पर निर्भर थे, अब उम्मीद के मुताबिक काम नहीं करते।

**पुराना व्यवहार:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**नया व्यवहार:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**समाधान:**
- **स्पष्ट रूप से बताएं** कि आप क्या अनुवाद करना चाहते हैं:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. अप्रत्याशित लिंक व्यवहार

**समस्या:** अनुवादित फाइलों में लिंक अप्रत्याशित स्थानों पर जा रहे हैं।

**कारण:** चुने गए फाइल टाइप्स के आधार पर डायनामिक लिंक प्रोसेसिंग बदलती है।

**समाधान:**
1. **नए लिंक व्यवहार को समझें:**
   - `-nb` शामिल: नोटबुक लिंक अनुवादित वर्शन की ओर जाते हैं
   - `-nb` बाहर: नोटबुक लिंक मूल फाइलों की ओर जाते हैं
   - `-img` शामिल: इमेज लिंक अनुवादित वर्शन की ओर जाते हैं
   - `-img` बाहर: इमेज लिंक मूल फाइलों की ओर जाते हैं

2. **अपने उपयोग के अनुसार सही संयोजन चुनें:**
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. GitHub Action चला लेकिन कोई Pull Request (PR) नहीं बना

**लक्षण:** `peter-evans/create-pull-request` के लिए वर्कफ़्लो लॉग में दिखता है:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**संभावित कारण:**
- **कोई बदलाव नहीं मिला:** अनुवाद स्टेप ने कोई डिफ नहीं बनाया (repo पहले से अपडेटेड है)।
- **आउटपुट्स को अनदेखा किया गया:** `.gitignore` उन फाइलों को इग्नोर कर रहा है जिन्हें आप कमिट करना चाहते हैं (जैसे, `*.ipynb`, `translations/`, `translated_images/`)।
- **add-paths मेल नहीं खाते:** एक्शन को दिए गए पाथ्स असली आउटपुट लोकेशन से मेल नहीं खाते।
- **वर्कफ़्लो लॉजिक/शर्तें:** अनुवाद स्टेप जल्दी बंद हो गया या अनपेक्षित डायरेक्टरी में लिखा गया।

**कैसे ठीक करें / सत्यापित करें:**
1. **आउटपुट्स मौजूद हैं, यह सुनिश्चित करें:** अनुवाद के बाद, वर्कस्पेस में `translations/` और/या `translated_images/` में नई/बदली हुई फाइलें देखें।
   - अगर नोटबुक का अनुवाद कर रहे हैं, तो सुनिश्चित करें कि `.ipynb` फाइलें वास्तव में `translations/<lang>/...` के तहत लिखी गई हैं।
2. **`.gitignore` की समीक्षा करें:** जनरेटेड आउटपुट्स को इग्नोर न करें। सुनिश्चित करें कि आप इन्हें इग्नोर नहीं कर रहे:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (अगर नोटबुक का अनुवाद कर रहे हैं)
3. **add-paths आउटपुट्स से मेल खाते हैं, यह सुनिश्चित करें:** मल्टीलाइन वैल्यू का उपयोग करें और दोनों फोल्डर शामिल करें अगर लागू हो:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **डिबगिंग के लिए PR को फोर्स करें:** अस्थायी रूप से खाली कमिट्स की अनुमति दें ताकि वायरिंग सही है या नहीं, यह पता चल सके:
   ```yaml
   with:
     commit-empty: true
   ```
5. **डिबग मोड में चलाएँ:** ट्रांसलेट कमांड में `-d` जोड़ें ताकि पता चले कौन सी फाइलें मिलीं और लिखी गईं।
6. **अनुमतियाँ (GITHUB_TOKEN):** सुनिश्चित करें कि वर्कफ़्लो के पास कमिट और PR बनाने के लिए write परमिशन है:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```


## त्वरित डिबगिंग चेकलिस्ट

जब अनुवाद संबंधी समस्याओं का निवारण करें:

1. **डिबग मोड का उपयोग करें:** डिटेल्ड लॉग्स देखने के लिए `-d` फ्लैग जोड़ें
2. **अपने फ्लैग्स चेक करें:** सुनिश्चित करें कि `-md`, `-img`, `-nb` आपकी मंशा के अनुसार हैं
3. **कॉन्फ़िगरेशन सत्यापित करें:** अपनी `.env` फाइल में आवश्यक कुंजियाँ हैं, यह देखें
4. **क्रमशः परीक्षण करें:** केवल `-md` से शुरू करें, फिर अन्य टाइप्स जोड़ें
5. **फाइल संरचना देखें:** सुनिश्चित करें कि स्रोत फाइलें मौजूद हैं और सुलभ हैं

उपलब्ध कमांड्स और फ्लैग्स के बारे में अधिक जानकारी के लिए [Command Reference](./command-reference.md) देखें।

---

**अस्वीकरण**:
इस दस्तावेज़ का अनुवाद AI अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) का उपयोग करके किया गया है। जबकि हम सटीकता के लिए प्रयास करते हैं, कृपया ध्यान दें कि स्वचालित अनुवादों में त्रुटियाँ या गलतियाँ हो सकती हैं। मूल दस्तावेज़ को उसकी मूल भाषा में ही प्रामाणिक स्रोत माना जाना चाहिए। महत्वपूर्ण जानकारी के लिए, पेशेवर मानव अनुवाद की सिफारिश की जाती है। इस अनुवाद के उपयोग से उत्पन्न किसी भी गलतफहमी या गलत व्याख्या के लिए हम उत्तरदायी नहीं हैं।