<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:44:36+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "hi"
}
-->
# अपने प्रोजेक्ट का अनुवाद Co-op Translator से करें

**Co-op Translator** एक कमांड-लाइन इंटरफेस (CLI) टूल है, जो आपके प्रोजेक्ट की मार्कडाउन और इमेज फाइल्स को कई भाषाओं में अनुवाद करने में मदद करता है। इस सेक्शन में टूल का उपयोग कैसे करें, CLI के विभिन्न विकल्पों की जानकारी और अलग-अलग उपयोग के उदाहरण दिए गए हैं।

---

## उदाहरण और कमांड्स

यहाँ **Co-op Translator** के कुछ आम उपयोग के तरीके और उनके लिए सही कमांड्स दिए गए हैं।

### 1. बेसिक अनुवाद (एक भाषा में)

अगर आप अपने पूरे प्रोजेक्ट (मार्कडाउन फाइल्स और इमेजेज) को एक भाषा, जैसे कोरियन में अनुवाद करना चाहते हैं, तो यह कमांड चलाएँ:

```bash
translate -l "ko"
```

यह कमांड सभी मार्कडाउन और इमेज फाइल्स को कोरियन में अनुवाद कर देगा, और नए अनुवाद जोड़ देगा, बिना किसी मौजूदा अनुवाद को हटाए।

#### Phi-3 CookBook पर उदाहरण

**Phi-3 CookBook** में, मैंने मौजूदा मार्कडाउन फाइल्स और इमेजेज के लिए कोरियन अनुवाद जोड़ने के लिए यह तरीका अपनाया।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. कई भाषाओं में अनुवाद

अगर आप अपने प्रोजेक्ट को कई भाषाओं (जैसे स्पैनिश, फ्रेंच, और जर्मन) में अनुवाद करना चाहते हैं, तो यह कमांड इस्तेमाल करें:

```bash
translate -l "es fr de"
```

यह कमांड प्रोजेक्ट को स्पैनिश, फ्रेंच और जर्मन में अनुवाद करेगा, और नए अनुवाद जोड़ देगा, बिना मौजूदा अनुवाद को ओवरराइट किए।

#### Phi-3 CookBook पर उदाहरण

**Phi-3 CookBook** में, लेटेस्ट बदलावों को अपडेट करने के बाद, मैंने नए मार्कडाउन फाइल्स और इमेजेज को अनुवाद करने के लिए यह तरीका अपनाया।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### 3. अनुवाद अपडेट करना (मौजूदा अनुवाद हटाता है)

अगर आप मौजूदा अनुवादों को हटाकर नए अनुवाद जोड़ना चाहते हैं, तो `-u` विकल्प का उपयोग करें। इससे चुनी गई भाषाओं के सभी मौजूदा अनुवाद हट जाएंगे और फिर से अनुवाद हो जाएंगे।

```bash
translate -l "ko" -u
```

सावधान: यह कमांड मौजूदा अनुवादों को हटाने से पहले पुष्टि के लिए पूछेगा।

#### Phi-3 CookBook पर उदाहरण

**Phi-3 CookBook** में, मैंने स्पैनिश में सभी अनुवादित फाइल्स को अपडेट करने के लिए यह तरीका अपनाया। अगर आपके पास कई मार्कडाउन डॉक्युमेंट्स में बड़े बदलाव हैं, तो यह तरीका बेहतर है। अगर सिर्फ कुछ फाइल्स अपडेट करनी हैं, तो उन्हें मैन्युअली डिलीट करके `-a` विकल्प से अनुवाद करना ज्यादा आसान है।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. सिर्फ इमेजेज का अनुवाद

अगर आप सिर्फ इमेज फाइल्स का अनुवाद करना चाहते हैं, तो `-img` विकल्प का उपयोग करें:

```bash
translate -l "ko" -img
```

यह कमांड सिर्फ इमेजेज को कोरियन में अनुवाद करेगा, मार्कडाउन फाइल्स पर कोई असर नहीं होगा।

### 6. सिर्फ मार्कडाउन फाइल्स का अनुवाद

अगर आप सिर्फ मार्कडाउन फाइल्स का अनुवाद करना चाहते हैं, तो `-md` विकल्प का उपयोग करें:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook पर उदाहरण

**Phi-3 CookBook** में, मैंने कोरियन फाइल्स में अनुवाद की गलतियों को चेक करने और जिन फाइल्स में दिक्कत मिली, उनका अनुवाद ऑटोमेटिकली फिर से करने के लिए यह तरीका अपनाया।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

यह विकल्प अनुवाद की गलतियों को चेक करता है। अभी, अगर ओरिजिनल और अनुवादित फाइल्स में लाइन ब्रेक का फर्क छह से ज्यादा है, तो फाइल को अनुवाद में गलती मान लिया जाता है। भविष्य में इसे और लचीला बनाने की योजना है।

यह तरीका मिसिंग हिस्सों या खराब अनुवाद को पकड़ने में मदद करता है, और उन फाइल्स का अनुवाद ऑटोमेटिकली फिर से करता है।

अगर आपको पहले से पता है कि कौन सी फाइल्स में दिक्कत है, तो उन्हें मैन्युअली डिलीट करके `-a` विकल्प से फिर से अनुवाद करना ज्यादा आसान है।

### 8. डिबग मोड

अगर आप ट्रबलशूटिंग के लिए डिटेल्ड लॉगिंग चाहते हैं, तो `-d` विकल्प का उपयोग करें:

```bash
translate -l "ko" -d
```

यह कमांड अनुवाद को डिबग मोड में चलाएगा, जिससे आपको अनुवाद प्रक्रिया के दौरान ज्यादा जानकारी मिलेगी और समस्याएँ पहचानने में मदद मिलेगी।

#### Phi-3 CookBook पर उदाहरण

**Phi-3 CookBook** में, मुझे एक समस्या आई जहाँ मार्कडाउन फाइल्स में बहुत सारे लिंक होने से फॉर्मेटिंग में गड़बड़ी आ रही थी, जैसे अनुवाद टूटना या लाइन ब्रेक गायब होना। इस समस्या को समझने के लिए मैंने `-d` विकल्प का उपयोग किया।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. सभी भाषाओं में अनुवाद

अगर आप प्रोजेक्ट को सभी सपोर्टेड भाषाओं में अनुवाद करना चाहते हैं, तो all कीवर्ड का उपयोग करें।

```bash
translate -l "all"
```

यह कमांड प्रोजेक्ट को सभी उपलब्ध भाषाओं में अनुवाद करेगा। अगर आप आगे बढ़ते हैं, तो प्रोजेक्ट के साइज के हिसाब से अनुवाद में काफी समय लग सकता है।

> ### अनुवादित फाइल्स को मैन्युअली डिलीट करना (ऑप्शनल)
> अब अनुवादित फाइल्स ऑटोमेटिकली डिटेक्ट और क्लीन हो जाती हैं जब सोर्स फाइल अपडेट होती है।
>
> लेकिन अगर आप किसी अनुवाद को मैन्युअली अपडेट करना चाहते हैं - जैसे किसी खास फाइल को फिर से अनुवाद करना या सिस्टम के व्यवहार को ओवरराइड करना - तो आप नीचे दिए गए कमांड से सभी भाषाओं के फोल्डर में उस फाइल के वर्शन डिलीट कर सकते हैं।
>
> ### Windows पर:
> 1. **Command Prompt से**:
>    - Command Prompt खोलें।
>    - `cd` कमांड से उस फोल्डर में जाएँ जहाँ फाइल्स हैं।
>    - फाइल्स डिलीट करने के लिए यह कमांड चलाएँ:
>      ```
>      del /s *filename*
>      ```
>      `filename` को उस फाइल के नाम से बदलें जिसे आप ढूँढ रहे हैं। `/s` विकल्प सबडायरेक्टरी में भी सर्च करता है।
>
> 2. **PowerShell से**:
>    - PowerShell खोलें।
>    - यह कमांड चलाएँ:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` को फोल्डर के पाथ से और `filename` को फाइल के नाम से बदलें।
>
> ### macOS/Linux पर:
> 1. **Terminal से**:
>   - Terminal खोलें।
>   - `cd` से डायरेक्टरी में जाएँ।
>   - `find` कमांड का उपयोग करें:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` को फाइल के नाम से बदलें।
>
> डिलीट करने से पहले फाइल्स को अच्छी तरह चेक कर लें ताकि गलती से कोई जरूरी फाइल न हट जाए।
>
> जब आप फाइल्स डिलीट कर लें जिन्हें रिप्लेस करना है, तो बस अपना `translate -l` कमांड फिर से चलाएँ ताकि लेटेस्ट फाइल्स अपडेट हो जाएँ।

---

**अस्वीकरण**:
इस दस्तावेज़ का अनुवाद एआई अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) का उपयोग करके किया गया है। जबकि हम सटीकता के लिए प्रयास करते हैं, कृपया ध्यान दें कि स्वचालित अनुवादों में त्रुटियाँ या गलतियाँ हो सकती हैं। मूल दस्तावेज़ को उसकी मूल भाषा में ही प्रामाणिक स्रोत माना जाना चाहिए। महत्वपूर्ण जानकारी के लिए, पेशेवर मानव अनुवाद की सिफारिश की जाती है। इस अनुवाद के उपयोग से उत्पन्न किसी भी गलतफहमी या गलत व्याख्या के लिए हम उत्तरदायी नहीं हैं।