<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T10:30:44+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "hi"
}
-->
# Co-op Translator में योगदान करना

यह प्रोजेक्ट योगदान और सुझावों का स्वागत करता है। अधिकांश योगदानों के लिए आपको एक Contributor License Agreement (CLA) से सहमति देनी होती है, जिसमें आप यह घोषणा करते हैं कि आपके पास अपने योगदान का उपयोग करने के अधिकार हैं और आप हमें ये अधिकार प्रदान करते हैं। विवरण के लिए, https://cla.opensource.microsoft.com पर जाएं।

जब आप एक पुल रिक्वेस्ट सबमिट करते हैं, तो एक CLA बॉट स्वचालित रूप से यह निर्धारित करेगा कि आपको CLA प्रदान करने की आवश्यकता है या नहीं और PR को उपयुक्त रूप से सजाएगा (जैसे, स्टेटस चेक, टिप्पणी)। बस बॉट द्वारा दिए गए निर्देशों का पालन करें। आपको यह केवल एक बार सभी रिपोज में करना होगा जो हमारे CLA का उपयोग करते हैं।

## विकास पर्यावरण सेटअप

इस प्रोजेक्ट के लिए विकास पर्यावरण सेटअप करने के लिए, हम डिपेंडेंसी प्रबंधन के लिए Poetry का उपयोग करने की सलाह देते हैं। हम प्रोजेक्ट डिपेंडेंसीज़ को प्रबंधित करने के लिए `pyproject.toml` का उपयोग करते हैं, इसलिए डिपेंडेंसीज़ इंस्टॉल करने के लिए आपको Poetry का उपयोग करना चाहिए।

### वर्चुअल एनवायरनमेंट बनाएं

#### pip का उपयोग करते हुए

```bash
python -m venv .venv
```

#### Poetry का उपयोग करते हुए

```bash
poetry init
```

### वर्चुअल एनवायरनमेंट सक्रिय करें

#### pip और Poetry दोनों के लिए

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry का उपयोग करते हुए

```bash
poetry shell
```

### पैकेज और आवश्यक पैकेज इंस्टॉल करना

#### Poetry का उपयोग करते हुए (pyproject.toml से)

```bash
poetry install
```

### मैनुअल परीक्षण

PR सबमिट करने से पहले, वास्तविक दस्तावेज़ के साथ अनुवाद कार्यक्षमता का परीक्षण करना महत्वपूर्ण है:

1. रूट डायरेक्टरी में एक टेस्ट डायरेक्टरी बनाएं:
    ```bash
    mkdir test_docs
    ```

2. कुछ मार्कडाउन दस्तावेज़ और इमेजेज़ जिन्हें आप अनुवाद करना चाहते हैं, उन्हें टेस्ट डायरेक्टरी में कॉपी करें। उदाहरण के लिए:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. पैकेज को लोकली इंस्टॉल करें:
    ```bash
    pip install -e .
    ```

4. अपने टेस्ट दस्तावेज़ों पर Co-op Translator चलाएं:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` और `test_docs/translated_images` में अनुवादित फाइलों की जांच करें ताकि सुनिश्चित हो सके कि:
   - अनुवाद की गुणवत्ता अच्छी है
   - मेटाडेटा टिप्पणियाँ सही हैं
   - मूल मार्कडाउन संरचना बनी हुई है
   - लिंक और इमेजेज़ सही ढंग से काम कर रहे हैं

यह मैनुअल परीक्षण यह सुनिश्चित करने में मदद करता है कि आपके बदलाव वास्तविक दुनिया के परिदृश्यों में अच्छी तरह काम करते हैं।

### पर्यावरण चर (Environment Variables)

1. रूट डायरेक्टरी में `.env.template` फाइल की कॉपी बनाकर `.env` फाइल बनाएं।
2. पर्यावरण चर को निर्देशानुसार भरें।

> [!TIP]
>
> ### अतिरिक्त विकास पर्यावरण विकल्प
>
> प्रोजेक्ट को लोकली चलाने के अलावा, आप GitHub Codespaces या VS Code Dev Containers का उपयोग भी कर सकते हैं, जो एक वैकल्पिक विकास पर्यावरण सेटअप प्रदान करते हैं।
>
> #### GitHub Codespaces
>
> आप GitHub Codespaces का उपयोग करके इस सैंपल को वर्चुअली चला सकते हैं, इसके लिए कोई अतिरिक्त सेटिंग या सेटअप आवश्यक नहीं है।
>
> यह बटन आपके ब्राउज़र में वेब-आधारित VS Code इंस्टेंस खोलेगा:
>
> 1. टेम्पलेट खोलें (यह कुछ मिनट ले सकता है):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers का उपयोग करके लोकली चलाना
>
> ⚠️ यह विकल्प तभी काम करेगा जब आपके Docker Desktop को कम से कम 16 GB RAM आवंटित हो। यदि आपके पास 16 GB से कम RAM है, तो आप [GitHub Codespaces विकल्प](../..) या [लोकली सेटअप](../..) आज़मा सकते हैं।
>
> एक संबंधित विकल्प VS Code Dev Containers है, जो प्रोजेक्ट को आपके लोकल VS Code में [Dev Containers एक्सटेंशन](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) का उपयोग करके खोलेगा:
>
> 1. Docker Desktop शुरू करें (यदि पहले से इंस्टॉल नहीं है तो इंस्टॉल करें)
> 2. प्रोजेक्ट खोलें:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### कोड स्टाइल

हम प्रोजेक्ट में एक समान कोड स्टाइल बनाए रखने के लिए [Black](https://github.com/psf/black) का उपयोग करते हैं। Black एक सख्त कोड फॉर्मेटर है जो स्वचालित रूप से Python कोड को Black कोड स्टाइल के अनुरूप पुनः स्वरूपित करता है।

#### कॉन्फ़िगरेशन

Black कॉन्फ़िगरेशन हमारे `pyproject.toml` में निर्दिष्ट है:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black इंस्टॉल करना

आप Black को Poetry (सिफारिश की गई) या pip के माध्यम से इंस्टॉल कर सकते हैं:

##### Poetry का उपयोग करते हुए

जब आप विकास पर्यावरण सेटअप करते हैं, तो Black स्वचालित रूप से इंस्टॉल हो जाता है:
```bash
poetry install
```

##### pip का उपयोग करते हुए

यदि आप pip का उपयोग कर रहे हैं, तो आप सीधे Black इंस्टॉल कर सकते हैं:
```bash
pip install black
```

#### Black का उपयोग करना

##### Poetry के साथ

1. प्रोजेक्ट में सभी Python फाइलों को फॉर्मेट करें:
    ```bash
    poetry run black .
    ```

2. किसी विशेष फाइल या डायरेक्टरी को फॉर्मेट करें:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip के साथ

1. प्रोजेक्ट में सभी Python फाइलों को फॉर्मेट करें:
    ```bash
    black .
    ```

2. किसी विशेष फाइल या डायरेक्टरी को फॉर्मेट करें:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> हम सुझाव देते हैं कि आप अपने एडिटर को सेट करें ताकि वह Black के साथ कोड को सेव करते समय ऑटोमैटिकली फॉर्मेट करे। अधिकांश आधुनिक एडिटर एक्सटेंशन्स या प्लगइन्स के माध्यम से इसे सपोर्ट करते हैं।

## Co-op Translator चलाना

अपने पर्यावरण में Poetry का उपयोग करके Co-op Translator चलाने के लिए, निम्न चरणों का पालन करें:

1. उस डायरेक्टरी में जाएं जहां आप अनुवाद परीक्षण करना चाहते हैं या परीक्षण के लिए एक अस्थायी फ़ोल्डर बनाएं।

2. निम्न कमांड चलाएं। `-l ko` को उस भाषा कोड से बदलें जिसमें आप अनुवाद करना चाहते हैं। `-d` फ्लैग डिबग मोड के लिए है।

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> कमांड चलाने से पहले सुनिश्चित करें कि आपका Poetry पर्यावरण सक्रिय है (poetry shell)।

## नई भाषा में योगदान करें

हम नई भाषाओं के समर्थन को जोड़ने वाले योगदानों का स्वागत करते हैं। PR खोलने से पहले, कृपया नीचे दिए गए चरणों को पूरा करें ताकि समीक्षा सुचारू हो सके।

1. भाषा को फ़ॉन्ट मैपिंग में जोड़ें
   - `src/co_op_translator/fonts/font_language_mappings.yml` संपादित करें
   - एक एंट्री जोड़ें जिसमें:
     - `code`: ISO जैसी भाषा कोड (जैसे, `vi`)
     - `name`: मानव-पठनीय डिस्प्ले नाम
     - `font`: `src/co_op_translator/fonts/` में उपलब्ध कोई ऐसा फ़ॉन्ट जो उस स्क्रिप्ट का समर्थन करता हो
     - `rtl`: यदि दाएं से बाएं है तो `true`, अन्यथा `false`

2. आवश्यक फ़ॉन्ट फाइलें शामिल करें (यदि आवश्यक हो)
   - यदि नया फ़ॉन्ट चाहिए, तो ओपन सोर्स वितरण के लिए लाइसेंस संगतता जांचें
   - फ़ॉन्ट फाइल को `src/co_op_translator/fonts/` में जोड़ें

3. लोकल सत्यापन
   - एक छोटे नमूने (Markdown, इमेजेज़, और नोटबुक्स जहां उपयुक्त हों) के लिए अनुवाद चलाएं
   - आउटपुट सही ढंग से रेंडर हो रहा है, फ़ॉन्ट्स और किसी भी RTL लेआउट सहित, इसकी पुष्टि करें

4. दस्तावेज़ अपडेट करें
   - सुनिश्चित करें कि भाषा `getting_started/supported-languages.md` में दिखाई दे रही है
   - `getting_started/README_languages_template.md` में कोई बदलाव आवश्यक नहीं है; यह समर्थित सूची से जेनरेट होता है

5. PR खोलें
   - जोड़ी गई भाषा और किसी भी फ़ॉन्ट/लाइसेंसिंग विचारों का वर्णन करें
   - संभव हो तो रेंडर किए गए आउटपुट के स्क्रीनशॉट संलग्न करें

उदाहरण YAML एंट्री:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### नई भाषा का परीक्षण करें

आप निम्न कमांड चलाकर नई भाषा का परीक्षण कर सकते हैं:

```bash
# एक वर्चुअल वातावरण बनाएं और सक्रिय करें
python -m venv .venv
# विंडोज
.venv\Scripts\activate
# मैकओएस/लिनक्स
source .venv/bin/activate
# विकास पैकेज स्थापित करें
pip install -e .
# अनुवाद चलाएं
translate -l "new_lang"
```

## मेंटेनर्स

### कमिट संदेश और मर्ज रणनीति

हमारे प्रोजेक्ट के कमिट इतिहास में स्थिरता और स्पष्टता सुनिश्चित करने के लिए, हम **Squash and Merge** रणनीति का उपयोग करते समय **अंतिम कमिट संदेश** के लिए एक विशिष्ट कमिट संदेश प्रारूप का पालन करते हैं।

जब एक पुल रिक्वेस्ट (PR) मर्ज होती है, तो व्यक्तिगत कमिट्स को एकल कमिट में स्क्वैश किया जाता है। अंतिम कमिट संदेश को नीचे दिए गए प्रारूप के अनुसार होना चाहिए ताकि इतिहास साफ और सुसंगत रहे।

#### कमिट संदेश प्रारूप (squash and merge के लिए)

हम कमिट संदेशों के लिए निम्न प्रारूप का उपयोग करते हैं:

```bash
<type>: <description> (#<पीआर संख्या>)
```

- **type**: कमिट की श्रेणी निर्दिष्ट करता है। हम निम्न प्रकारों का उपयोग करते हैं:
  - `Docs`: दस्तावेज़ अपडेट के लिए।
  - `Build`: बिल्ड सिस्टम या डिपेंडेंसीज़ से संबंधित बदलावों के लिए, जिसमें कॉन्फ़िगरेशन फाइलें, CI वर्कफ़्लोज़, या Dockerfile अपडेट शामिल हैं।
  - `Core`: प्रोजेक्ट के मुख्य कार्यक्षमता या फीचर्स में बदलाव के लिए, विशेष रूप से `src/co_op_translator/core` डायरेक्टरी की फाइलों में।

- **description**: बदलाव का संक्षिप्त सारांश।
- **PR नंबर**: संबंधित पुल रिक्वेस्ट नंबर।

**उदाहरण**:

- `Docs: स्पष्टता के लिए इंस्टॉलेशन निर्देश अपडेट करें (#50)`
- `Core: इमेज अनुवाद हैंडलिंग में सुधार करें (#60)`

> [!NOTE]
> वर्तमान में, **`Docs`**, **`Core`**, और **`Build`** उपसर्ग स्वचालित रूप से PR शीर्षकों में जोड़े जाते हैं, जो संशोधित स्रोत कोड पर लगाए गए लेबल्स पर आधारित होते हैं। जब तक सही लेबल लागू है, आपको आमतौर पर PR शीर्षक मैन्युअली अपडेट करने की आवश्यकता नहीं होती। बस सुनिश्चित करें कि सब कुछ सही है और उपसर्ग सही ढंग से उत्पन्न हुआ है।

#### मर्ज रणनीति

हम पुल रिक्वेस्ट के लिए डिफ़ॉल्ट रूप से **Squash and Merge** रणनीति का उपयोग करते हैं। यह रणनीति सुनिश्चित करती है कि कमिट संदेश हमारे प्रारूप का पालन करें, भले ही व्यक्तिगत कमिट्स न करें।

**कारण**:

- साफ, रैखिक प्रोजेक्ट इतिहास।
- कमिट संदेशों में स्थिरता।
- छोटे कमिट्स (जैसे, "टाइपो ठीक करें") से होने वाले शोर में कमी।

मर्ज करते समय, सुनिश्चित करें कि अंतिम कमिट संदेश ऊपर वर्णित प्रारूप का पालन करता है।

**Squash and Merge का उदाहरण**  
यदि किसी PR में निम्न कमिट्स हैं:

- `fix typo`
- `update README`
- `adjust formatting`

तो इन्हें स्क्वैश करके बनाया जाना चाहिए:  
`Docs: Improve documentation clarity and formatting (#65)`

### रिलीज प्रक्रिया

यह अनुभाग मेंटेनर्स के लिए Co-op Translator का नया रिलीज प्रकाशित करने का सबसे सरल तरीका बताता है।

#### 1. `pyproject.toml` में संस्करण बढ़ाएं

1. अगला संस्करण संख्या तय करें (हम semantic versioning का पालन करते हैं: `MAJOR.MINOR.PATCH`)।
2. `pyproject.toml` संपादित करें और `[tool.poetry]` के अंतर्गत `version` फ़ील्ड अपडेट करें।
3. केवल संस्करण (और यदि मौजूद हो तो स्वचालित रूप से अपडेट होने वाली लॉक/मेटाडेटा फाइलें) बदलने वाला एक समर्पित पुल रिक्वेस्ट खोलें।
4. समीक्षा के बाद, **Squash and Merge** का उपयोग करें और सुनिश्चित करें कि अंतिम कमिट संदेश ऊपर वर्णित प्रारूप का पालन करता है।

#### 2. GitHub रिलीज बनाएं

1. GitHub रिपोजिटरी पेज पर जाएं और **Releases** → **Draft a new release** खोलें।
2. `main` ब्रांच से एक नया टैग बनाएं (उदाहरण के लिए, `v0.13.0`)।
3. रिलीज़ शीर्षक को उसी संस्करण पर सेट करें (उदाहरण के लिए, `v0.13.0`)।
4. **Generate release notes** पर क्लिक करें ताकि चेंजलॉग ऑटो-पॉप्युलेट हो जाए।
5. वैकल्पिक रूप से टेक्स्ट संपादित करें (जैसे, नई समर्थित भाषाओं या महत्वपूर्ण परिवर्तनों को हाइलाइट करने के लिए)।
6. रिलीज़ प्रकाशित करें।

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**अस्वीकरण**:  
इस दस्तावेज़ का अनुवाद AI अनुवाद सेवा [Co-op Translator](https://github.com/Azure/co-op-translator) का उपयोग करके किया गया है। जबकि हम सटीकता के लिए प्रयासरत हैं, कृपया ध्यान दें कि स्वचालित अनुवादों में त्रुटियाँ या अशुद्धियाँ हो सकती हैं। मूल दस्तावेज़ अपनी मूल भाषा में प्रामाणिक स्रोत माना जाना चाहिए। महत्वपूर्ण जानकारी के लिए, पेशेवर मानव अनुवाद की सलाह दी जाती है। इस अनुवाद के उपयोग से उत्पन्न किसी भी गलतफहमी या गलत व्याख्या के लिए हम जिम्मेदार नहीं हैं।
<!-- CO-OP TRANSLATOR DISCLAIMER END -->