<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T03:33:15+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "he"
}
-->
# תרגום הפרויקט שלך עם Co-op Translator

**Co-op Translator** הוא כלי שורת פקודה (CLI) שמסייע לך לתרגם קבצי Markdown ותמונות בפרויקט שלך לשפות שונות. החלק הזה מסביר איך להשתמש בכלי, מפרט את אפשרויות ה-CLI השונות, ומביא דוגמאות לשימושים מגוונים.

---

## תרחישים ודוגמאות לפקודות

להלן כמה שימושים נפוצים ב-**Co-op Translator**, יחד עם הפקודות המתאימות.

### 1. תרגום בסיסי (שפה אחת)

כדי לתרגם את כל הפרויקט שלך (קבצי Markdown ותמונות) לשפה אחת, למשל קוריאנית, השתמש בפקודה הבאה:

```bash
translate -l "ko"
```

הפקודה הזו תתרגם את כל קבצי ה-Markdown והתמונות לקוריאנית, ותוסיף תרגומים חדשים מבלי למחוק תרגומים קיימים.

#### דוגמה ב-Phi-3 CookBook

ב-**Phi-3 CookBook**, השתמשתי בשיטה הבאה כדי להוסיף תרגום לקוריאנית לקבצי ה-Markdown והתמונות הקיימים.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. תרגום למספר שפות

כדי לתרגם את הפרויקט שלך למספר שפות (למשל ספרדית, צרפתית וגרמנית), השתמש בפקודה הזו:

```bash
translate -l "es fr de"
```

הפקודה הזו תתרגם את הפרויקט לספרדית, צרפתית וגרמנית, ותוסיף תרגומים חדשים מבלי לדרוס תרגומים קיימים.

#### דוגמה ב-Phi-3 CookBook

ב-**Phi-3 CookBook**, לאחר משיכת העדכונים האחרונים כדי לשקף את הקומיטים החדשים, השתמשתי בשיטה הזו כדי לתרגם קבצי Markdown ותמונות שנוספו לאחרונה.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

בדרך כלל מומלץ לתרגם שפה אחת בכל פעם, אבל במקרים שבהם צריך להוסיף שינויים מסוימים, תרגום למספר שפות יחד יכול להיות יעיל.

### 3. עדכון תרגומים (מוחק תרגומים קיימים)

כדי לעדכן תרגומים קיימים (כלומר, למחוק את התרגומים הנוכחיים ולהחליף אותם בחדשים), השתמש באופציה `-u`. זה ימחק את כל התרגומים הקיימים לשפות שציינת ויתרגם מחדש.

```bash
translate -l "ko" -u
```

אזהרה: הפקודה הזו תבקש ממך אישור לפני שתמחק את התרגומים הקיימים.

#### דוגמה ב-Phi-3 CookBook

ב-**Phi-3 CookBook**, השתמשתי בשיטה הזו כדי לעדכן את כל הקבצים המתורגמים לספרדית. אני ממליץ להשתמש בשיטה הזו כשיש שינויים משמעותיים בתוכן המקורי במספר קבצי Markdown. אם יש רק כמה קבצים מתורגמים שצריך לעדכן, עדיף למחוק אותם ידנית ואז להשתמש בשיטה `-a` כדי להוסיף את התרגומים המעודכנים.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. תרגום תמונות בלבד

כדי לתרגם רק את קבצי התמונות בפרויקט שלך, השתמש באופציה `-img`:

```bash
translate -l "ko" -img
```

הפקודה הזו תתרגם רק את התמונות לקוריאנית, בלי להשפיע על קבצי ה-Markdown.

### 6. תרגום קבצי Markdown בלבד

כדי לתרגם רק את קבצי ה-Markdown בפרויקט שלך, השתמש באופציה `-md`:

```bash
translate -l "ko" -md
```

#### דוגמה ב-Phi-3 CookBook

ב-**Phi-3 CookBook**, השתמשתי בשיטה הזו כדי לבדוק שגיאות תרגום בקבצים הקוריאניים ולבצע ניסיון תרגום חוזר אוטומטי לקבצים שבהם התגלו בעיות.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

האופציה הזו בודקת שגיאות תרגום. כרגע, אם יש הבדל של יותר משש שורות בין הקובץ המקורי למתורגם, הקובץ מסומן כבעייתי. אני מתכנן לשפר את הקריטריון הזה בעתיד כדי שיהיה גמיש יותר.

למשל, השיטה הזו שימושית לזיהוי קטעים חסרים או תרגומים פגומים, והיא תנסה לתרגם מחדש את אותם קבצים אוטומטית.

אם אתה כבר יודע אילו קבצים בעייתיים, עדיף למחוק אותם ידנית ולהשתמש באופציה `-a` כדי לתרגם אותם מחדש.

### 8. מצב דיבאג

כדי להפעיל לוגים מפורטים לצורך פתרון בעיות, השתמש באופציה `-d`:

```bash
translate -l "ko" -d
```

הפקודה הזו תריץ את התרגום במצב דיבאג, ותספק מידע נוסף בלוגים שיכול לעזור לך לזהות בעיות בתהליך התרגום.

#### דוגמה ב-Phi-3 CookBook

ב-**Phi-3 CookBook**, נתקלתי בבעיה שבה תרגומים עם הרבה קישורים בקבצי Markdown גרמו לשגיאות עיצוב, כמו תרגומים שבורים ודילוג על שורות. כדי לאבחן את הבעיה, השתמשתי באופציה `-d` כדי לראות איך תהליך התרגום מתבצע.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. תרגום לכל השפות

אם אתה רוצה לתרגם את הפרויקט לכל השפות הנתמכות, השתמש במילת המפתח all.

```bash
translate -l "all"
```

הפקודה הזו תתרגם את הפרויקט לכל השפות הזמינות. אם תמשיך, התרגום עשוי לקחת הרבה זמן בהתאם לגודל הפרויקט.

> ### מחיקת קבצים מתורגמים ידנית (אופציונלי)
> קבצים מתורגמים מזוהים ומנוקים אוטומטית כאשר קובץ מקור מתעדכן.
>
> עם זאת, אם אתה רוצה לעדכן תרגום ידנית – למשל, כדי לתרגם מחדש קובץ מסוים או לעקוף את ההתנהגות האוטומטית – תוכל להשתמש בפקודה הבאה כדי למחוק את כל הגרסאות של הקובץ בתיקיות השפה.
>
> ### ב-Windows:
> 1. **באמצעות Command Prompt**:
>    - פתח את Command Prompt.
>    - עבור לתיקיה שבה נמצאים הקבצים עם הפקודה `cd`.
>    - השתמש בפקודה הבאה למחיקת קבצים:
>      ```
>      del /s *filename*
>      ```
>      החלף את `filename` בשם הקובץ שאתה מחפש. האופציה `/s` מחפשת גם בתיקיות משנה.
>
> 2. **באמצעות PowerShell**:
>    - פתח את PowerShell.
>    - הרץ את הפקודה הזו:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      החלף את `"C:\YourPath"` בנתיב התיקיה ואת `filename` בשם הספציפי.
>
> ### ב-macOS/Linux:
> 1. **באמצעות Terminal**:
>   - פתח את Terminal.
>   - עבור לתיקיה עם `cd`.
>   - השתמש בפקודת `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     החלף את `filename` בשם הספציפי.
>
> תמיד בדוק היטב את הקבצים לפני מחיקה כדי להימנע מאובדן לא מכוון.
>
> לאחר שמחקת את הקבצים שצריך להחליף, פשוט הרץ שוב את פקודת `translate -l` כדי לעדכן את השינויים האחרונים בקובץ.

---

**הצהרת אחריות**:
מסמך זה תורגם באמצעות שירות תרגום מבוסס בינה מלאכותית [Co-op Translator](https://github.com/Azure/co-op-translator). למרות שאנו שואפים לדיוק, יש לקחת בחשבון כי תרגומים אוטומטיים עשויים להכיל טעויות או אי-דיוקים. יש להתייחס למסמך המקורי בשפתו המקורית כמקור הסמכותי. למידע קריטי, מומלץ לפנות לתרגום מקצועי על ידי אדם. איננו אחראים לכל אי-הבנה או פירוש שגוי הנובעים מהשימוש בתרגום זה.