<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T03:33:07+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "he"
}
-->
# התקנת חבילת Co-op Translator

**Co-op Translator** הוא כלי שורת פקודה (CLI) שנועד לעזור לך לתרגם את כל קבצי ה-Markdown והתמונות בפרויקט שלך לשפות שונות. מדריך זה יסביר איך להגדיר את המתרגם ולהריץ אותו במגוון תרחישים.

### יצירת סביבת עבודה וירטואלית

אפשר ליצור סביבת עבודה וירטואלית בעזרת `pip` או `Poetry`. הקלד אחת מהפקודות הבאות במסוף שלך.

#### שימוש ב-pip

```bash
python -m venv .venv
```

#### שימוש ב-Poetry

```bash
poetry init
```

### הפעלת סביבת העבודה הווירטואלית

לאחר שיצרת את סביבת העבודה הווירטואלית, תצטרך להפעיל אותה. השלבים משתנים לפי מערכת ההפעלה שלך. הקלד את הפקודה הבאה במסוף שלך.

#### עבור pip ו-Poetry

- Windows:

    ```bash
    .venv\Scripts\activate
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### שימוש ב-Poetry

1. אם יצרת את הסביבה עם Poetry, הקלד את הפקודה הבאה במסוף שלך כדי להפעיל אותה.

    ```bash
    poetry shell
    ```

### התקנת החבילה והחבילות הנדרשות

לאחר שסביבת העבודה הווירטואלית מוכנה ומופעלת, השלב הבא הוא התקנת התלויות הנדרשות.

### התקנה מהירה

התקן את Co-Op Translator דרך pip

```
pip install co-op-translator
```
או 

התקן דרך poetry
```
poetry add co-op-translator
```

#### שימוש ב-pip (דרך requirements.txt) אם שיבטת את המאגר הזה

> [!NOTE]
> אל תעשה זאת אם התקנת את co-op translator דרך ההתקנה המהירה.

1. אם אתה משתמש ב-pip, הקלד את הפקודה הבאה במסוף שלך. היא תתקין אוטומטית את החבילות הנדרשות שמצוינות בקובץ `requirements.txt`:

    ```bash
    pip install -r requirements.txt
    ```

#### שימוש ב-Poetry (דרך pyproject.toml)

1. אם אתה משתמש ב-Poetry, הקלד את הפקודה הבאה במסוף שלך. היא תתקין אוטומטית את החבילות הנדרשות שמצוינות בקובץ `pyproject.toml`:

    ```bash
    poetry install
    ```

---

**הצהרת אחריות**:  
מסמך זה תורגם באמצעות שירות תרגום מבוסס בינה מלאכותית [Co-op Translator](https://github.com/Azure/co-op-translator). למרות שאנו שואפים לדיוק, יש לקחת בחשבון כי תרגומים אוטומטיים עשויים להכיל טעויות או אי-דיוקים. יש לראות במסמך המקורי בשפתו המקורית כמקור הסמכותי. למידע קריטי, מומלץ לפנות לתרגום מקצועי על ידי אדם. איננו אחראים לכל אי-הבנות או פירושים שגויים הנובעים מהשימוש בתרגום זה.