<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T11:40:29+00:00",
  "source_file": "README.md",
  "language_code": "he"
}
-->
# מתרגם Co-op

_אוטומציה קלה של תרגום התוכן החינוכי שלך ב-GitHub לשפות רבות כדי להגיע לקהל עולמי._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 תמיכה בריבוי שפות

#### נתמך על ידי [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[ערבית](../ar/README.md) | [בנגלית](../bn/README.md) | [בולגרית](../bg/README.md) | [בורמזית (מיאנמר)](../my/README.md) | [סינית (מפושטת)](../zh/README.md) | [סינית (מסורתית, הונג קונג)](../hk/README.md) | [סינית (מסורתית, מקאו)](../mo/README.md) | [סינית (מסורתית, טייוואן)](../tw/README.md) | [קרואטית](../hr/README.md) | [צ'כית](../cs/README.md) | [דנית](../da/README.md) | [הולנדית](../nl/README.md) | [אסטונית](../et/README.md) | [פינית](../fi/README.md) | [צרפתית](../fr/README.md) | [גרמנית](../de/README.md) | [יוונית](../el/README.md) | [עברית](./README.md) | [הינדי](../hi/README.md) | [הונגרית](../hu/README.md) | [אינדונזית](../id/README.md) | [איטלקית](../it/README.md) | [יפנית](../ja/README.md) | [קנדה](../kn/README.md) | [קוריאנית](../ko/README.md) | [ליטאית](../lt/README.md) | [מלאית](../ms/README.md) | [מלאיאלאם](../ml/README.md) | [מרטהי](../mr/README.md) | [נפאלית](../ne/README.md) | [פידג'ין ניגרי](../pcm/README.md) | [נורווגית](../no/README.md) | [פרסית (פרסי)](../fa/README.md) | [פולנית](../pl/README.md) | [פורטוגזית (ברזיל)](../br/README.md) | [פורטוגזית (פורטוגל)](../pt/README.md) | [פונג'אבית (גורמוכי)](../pa/README.md) | [רומנית](../ro/README.md) | [רוסית](../ru/README.md) | [סרבית (קירילית)](../sr/README.md) | [סלובקית](../sk/README.md) | [סלובנית](../sl/README.md) | [ספרדית](../es/README.md) | [סווהילית](../sw/README.md) | [שוודית](../sv/README.md) | [טגלוג (פיליפינית)](../tl/README.md) | [טמילית](../ta/README.md) | [טלוגו](../te/README.md) | [תאית](../th/README.md) | [טורקית](../tr/README.md) | [אוקראינית](../uk/README.md) | [אורדו](../ur/README.md) | [וייטנאמית](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## סקירה כללית

**Co-op Translator** עוזר לך לתרגם את התוכן החינוכי שלך ב-GitHub לשפות רבות בקלות.
כשאתה מעדכן את קבצי Markdown, תמונות או מחברות, התרגומים מתעדכנים אוטומטית, ומבטיחים שהתוכן שלך נשאר מדויק ועדכני ללומדים ברחבי העולם.

דוגמה לאופן ארגון התוכן המתורגם:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.he.png)

## התחלה מהירה

```bash
# צור והפעל סביבה וירטואלית (מומלץ)
python -m venv .venv
# חלונות
.venv\Scripts\activate
# מק או לינוקס
source .venv/bin/activate
# התקן את החבילה
pip install co-op-translator
# תרגם
translate -l "ko ja fr" -md
```

Docker:

```bash
# משוך את התמונה הציבורית מ-GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# הרץ עם התיקייה הנוכחית מותקנת ו-.env מסופק (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## הגדרה מינימלית

1. צור קובץ `.env` באמצעות התבנית: [.env.template](../../.env.template)
2. הגדר ספק LLM אחד (Azure OpenAI או OpenAI)
3. (אופציונלי) לתרגום תמונות (`-img`), הגדר Azure AI Vision
4. (מומלץ) נקה תרגומים קודמים כדי למנוע התנגשויות (למשל, `translations/`)
5. (מומלץ) הוסף קטע תרגום ל-README שלך באמצעות [תבנית שפות ל-README](./getting_started/README_languages_template.md)
6. ראה: [הגדרת Azure AI](./getting_started/set-up-azure-ai.md)

## שימוש

תרגם את כל סוגי הקבצים הנתמכים:

```bash
translate -l "ko ja"
```

רק Markdown:

```bash
translate -l "de" -md
```

Markdown + תמונות:

```bash
translate -l "pt" -md -img
```

רק מחברות:

```bash
translate -l "zh" -nb
```

עוד דגלים: [הפניה לפקודות](./getting_started/command-reference.md)

## תכונות

- תרגום אוטומטי ל-Markdown, מחברות ותמונות
- שומר על סינכרון התרגומים עם שינויים במקור
- פועל מקומית (CLI) או ב-CI (GitHub Actions)
- משתמש ב-Azure OpenAI או OpenAI; אופציונלי Azure AI Vision לתמונות
- שומר על פורמט ומבנה Markdown

## תיעוד

- [מדריך שורת פקודה](./getting_started/command-line-guide/command-line-guide.md)
- [מדריך GitHub Actions (מאגרי ציבור וסודות סטנדרטיים)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [מדריך GitHub Actions (מאגרי ארגון Microsoft והגדרות ארגוניות)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [תבנית שפות ל-README](./getting_started/README_languages_template.md)
- [שפות נתמכות](./getting_started/supported-languages.md)
- [תרומה לפרויקט](./CONTRIBUTING.md)
- [פתרון תקלות](./getting_started/troubleshooting.md)

### מדריך ספציפי ל-Microsoft
> [!NOTE]
> מיועד למתחזקים של מאגרי "למתחילים" של Microsoft בלבד.

- [עדכון רשימת "קורסים אחרים" (רק למאגרי MS Beginners)](./getting_started/update-other-courses.md)

## תמכו בנו וקידמו למידה עולמית

הצטרפו אלינו במהפכה של שיתוף תוכן חינוכי ברחבי העולם! תנו ל-[Co-op Translator](https://github.com/azure/co-op-translator) ⭐ ב-GitHub ותמכו במשימה שלנו לפרוץ מחסומי שפה בלמידה וטכנולוגיה. ההתעניינות והתרומות שלכם משפיעות משמעותית! תרומות קוד והצעות לתכונות תמיד מתקבלות בברכה.

### גלו תוכן חינוכי של Microsoft בשפתכם

- [AZD למתחילים](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI למתחילים](https://github.com/microsoft/edgeai-for-beginners)
- [פרוטוקול הקשר מודל (MCP) למתחילים](https://github.com/microsoft/mcp-for-beginners)
- [סוכני AI למתחילים](https://github.com/microsoft/ai-agents-for-beginners)
- [AI גנרטיבי למתחילים עם .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [AI גנרטיבי למתחילים](https://github.com/microsoft/generative-ai-for-beginners)
- [AI גנרטיבי למתחילים עם Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [למידת מכונה למתחילים](https://aka.ms/ml-beginners)
- [מדעי הנתונים למתחילים](https://aka.ms/datascience-beginners)
- [AI למתחילים](https://aka.ms/ai-beginners)
- [סייברסקיוריטי למתחילים](https://github.com/microsoft/Security-101)
- [פיתוח ווב למתחילים](https://aka.ms/webdev-beginners)
- [IoT למתחילים](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## מצגות וידאו

👉 לחצו על התמונה למטה לצפייה ב-YouTube.

- **Open at Microsoft**: מבוא קצר של 18 דקות ומדריך מהיר לשימוש ב-Co-op Translator.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.he.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## תרומה לפרויקט

הפרויקט מקבל בברכה תרומות והצעות. מעוניינים לתרום ל-Azure Co-op Translator? אנא עיינו ב-[CONTRIBUTING.md](./CONTRIBUTING.md) לקבלת הנחיות כיצד תוכלו לעזור להפוך את Co-op Translator לנגיש יותר.

## תורמים

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## קוד התנהגות

הפרויקט אימץ את [קוד ההתנהגות של Microsoft בקוד פתוח](https://opensource.microsoft.com/codeofconduct/).
למידע נוסף ראו את [שאלות נפוצות על קוד ההתנהגות](https://opensource.microsoft.com/codeofconduct/faq/) או
צרו קשר ב-[opencode@microsoft.com](mailto:opencode@microsoft.com) עם שאלות או הערות נוספות.

## בינה מלאכותית אחראית

Microsoft מחויבת לסייע ללקוחותיה להשתמש במוצרי ה-AI שלנו באחריות, לשתף את הידע שצברנו ולבנות שותפויות מבוססות אמון באמצעות כלים כמו Transparency Notes ו-Impact Assessments. משאבים רבים זמינים ב-[https://aka.ms/RAI](https://aka.ms/RAI).
הגישה של Microsoft לבינה מלאכותית אחראית מבוססת על עקרונות ה-AI שלנו: הוגנות, אמינות ובטיחות, פרטיות ואבטחה, הכללה, שקיפות ואחריות.

מודלים רחבי היקף של שפה טבעית, תמונות ודיבור - כמו אלה שבדוגמה זו - עלולים להתנהג באופן לא הוגן, לא אמין או פוגעני, ולגרום לנזקים. אנא עיינו ב-[הערת השקיפות של שירות Azure OpenAI](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) כדי להתעדכן בסיכונים ובמגבלות.
הגישה המומלצת להפחתת סיכונים אלה היא לכלול במבנה שלך מערכת בטיחות שיכולה לזהות ולמנוע התנהגות מזיקה. <a href="https://learn.microsoft.com/azure/ai-services/content-safety/overview">Azure AI Content Safety</a> מספק שכבת הגנה עצמאית, המסוגלת לזהות תוכן מזיק שנוצר על ידי משתמשים או על ידי AI באפליקציות ובשירותים. Azure AI Content Safety כוללת ממשקי API לטקסט ולתמונות שמאפשרים לך לזהות חומר מזיק. בנוסף, יש לנו סטודיו אינטראקטיבי ל-Content Safety שמאפשר לך לצפות, לחקור ולנסות קוד לדוגמה לזיהוי תוכן מזיק במגוון מודאליות. <a href="https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest">תיעוד ההתחלה המהירה הבא</a> ינחה אותך כיצד לבצע בקשות לשירות.

היבט נוסף שיש לקחת בחשבון הוא ביצועי האפליקציה הכוללים. באפליקציות רב-מודאליות ורב-מודליות, אנו מתייחסים לביצועים כאל כך שהמערכת פועלת כפי שאתה והמשתמשים שלך מצפים, כולל אי יצירת פלטים מזיקים. חשוב להעריך את ביצועי האפליקציה הכוללים שלך באמצעות <a href="https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in">מדדי איכות יצירה וסיכון ובטיחות</a>.

אתה יכול להעריך את אפליקציית ה-AI שלך בסביבת הפיתוח שלך באמצעות <a href="https://microsoft.github.io/promptflow/index.html">prompt flow SDK</a>. בהתבסס על מערך נתונים לבחינה או מטרה, יצירות ה-AI הגנרטיביות שלך נמדדות כמותית עם מעריכים מובנים או מעריכים מותאמים אישית לפי בחירתך. כדי להתחיל עם ה-prompt flow sdk להערכת המערכת שלך, תוכל לעקוב אחרי <a href="https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk">מדריך ההתחלה המהירה</a>. לאחר ביצוע ריצת הערכה, תוכל <a href="https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results">להציג את התוצאות ב-Azure AI Studio</a>.

## סימני מסחר

פרויקט זה עשוי להכיל סימני מסחר או לוגואים של פרויקטים, מוצרים או שירותים. שימוש מורשה בסימני המסחר או בלוגואים של Microsoft כפוף וצריך לעמוד ב-[הנחיות סימני המסחר והמותג של Microsoft](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general). שימוש בסימני המסחר או בלוגואים של Microsoft בגרסאות מותאמות של פרויקט זה לא יגרום לבלבול או ייצור רושם של חסות מצד Microsoft. כל שימוש בסימני מסחר או לוגואים של צדדים שלישיים כפוף למדיניות של אותם צדדים שלישיים.

## קבלת עזרה

אם נתקעת או יש לך שאלות לגבי בניית אפליקציות AI, הצטרף ל:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

אם יש לך משוב על המוצר או שגיאות במהלך הבנייה, בקר ב:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**כתב ויתור**:  
מסמך זה תורגם באמצעות שירות תרגום מבוסס בינה מלאכותית [Co-op Translator](https://github.com/Azure/co-op-translator). למרות שאנו שואפים לדיוק, יש לקחת בחשבון כי תרגומים אוטומטיים עלולים להכיל שגיאות או אי-דיוקים. המסמך המקורי בשפתו המקורית נחשב למקור הסמכותי. למידע קריטי מומלץ להשתמש בתרגום מקצועי על ידי אדם. אנו לא נושאים באחריות לכל אי-הבנה או פרשנות שגויה הנובעת משימוש בתרגום זה.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->