<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T02:21:05+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "fa"
}
-->
# راهنمای رفع اشکال Microsoft Co-op Translator

## مرور کلی
Microsoft Co-Op Translator ابزاری قدرتمند برای ترجمه بی‌دردسر اسناد Markdown است. این راهنما به شما کمک می‌کند تا مشکلات رایج هنگام استفاده از این ابزار را رفع کنید.

## مشکلات رایج و راه‌حل‌ها

### ۱. مشکل تگ Markdown
**مشکل:** سند ترجمه‌شده Markdown شامل یک تگ `markdown` در بالای فایل است که باعث اختلال در نمایش می‌شود.

**راه‌حل:** برای رفع این مشکل، کافیست تگ `markdown` را از بالای فایل حذف کنید. با این کار فایل Markdown به‌درستی نمایش داده می‌شود.

**مراحل:**
۱. فایل ترجمه‌شده Markdown (`.md`) را باز کنید.
۲. تگ `markdown` را در بالای سند پیدا کنید.
۳. تگ `markdown` را حذف کنید.
۴. تغییرات را ذخیره کنید.
۵. فایل را دوباره باز کنید تا مطمئن شوید به‌درستی نمایش داده می‌شود.

### ۲. مشکل URL تصاویر جاسازی‌شده
**مشکل:** آدرس تصاویر جاسازی‌شده با زبان سند مطابقت ندارد و باعث نمایش اشتباه یا عدم نمایش تصاویر می‌شود.

**راه‌حل:** آدرس تصاویر جاسازی‌شده را بررسی کنید و مطمئن شوید با زبان سند هماهنگ است. همه تصاویر در پوشه `translated_images` قرار دارند و هر تصویر یک تگ زبان در نام فایل دارد.

**مراحل:**
۱. سند ترجمه‌شده Markdown را باز کنید.
۲. تصاویر جاسازی‌شده و آدرس‌های آن‌ها را پیدا کنید.
۳. مطمئن شوید تگ زبان در نام فایل تصویر با زبان سند مطابقت دارد.
۴. در صورت نیاز آدرس‌ها را اصلاح کنید.
۵. تغییرات را ذخیره کنید و سند را دوباره باز کنید تا مطمئن شوید تصاویر به‌درستی نمایش داده می‌شوند.

### ۳. دقت ترجمه
**مشکل:** محتوای ترجمه‌شده دقیق نیست یا نیاز به ویرایش بیشتر دارد.

**راه‌حل:** سند ترجمه‌شده را مرور کنید و ویرایش‌های لازم را برای بهبود دقت و خوانایی انجام دهید.

**مراحل:**
۱. سند ترجمه‌شده را باز کنید.
۲. محتوا را با دقت مرور کنید.
۳. ویرایش‌های لازم را برای بهبود دقت ترجمه انجام دهید.
۴. تغییرات را ذخیره کنید.

## ۴. خطای دسترسی یا ۴۰۴

اگر تصاویر یا متن به زبان درست ترجمه نمی‌شوند و هنگام اجرای حالت -d debug با خطای ۴۰۱ مواجه می‌شوید، این یک خطای احراز هویت کلاسیک است—یا کلید نامعتبر، منقضی شده یا به منطقه endpoint مرتبط نیست.

Co-op Translator را با [سویچ -d debug](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md) اجرا کنید تا علت اصلی را بهتر متوجه شوید.

- **پیام خطا:** `Access denied due to invalid subscription key or wrong API endpoint.`
- **دلایل احتمالی:**
  - کلید اشتراک در درخواست حذف یا اشتباه وارد شده است.
  - کلید AI Services یا Subscription Key متعلق به منبع Azure دیگری (مانند Translator یا OpenAI) است و نه منبع **Azure AI Vision**.

 **نوع منبع**
  - به [پرتال Azure](https://portal.azure.com) یا [Azure AI Foundry](https://ai.azure.com) بروید و مطمئن شوید منبع از نوع `Azure AI services` → `Vision` است.
  - کلیدها را اعتبارسنجی کنید و مطمئن شوید کلید درست استفاده می‌شود.

## ۵. خطاهای پیکربندی (مدیریت خطای جدید)

با شروع سیستم ترجمه انتخابی جدید، Co-op Translator اکنون پیام‌های خطای واضحی ارائه می‌دهد اگر سرویس‌های مورد نیاز پیکربندی نشده باشند.

### ۵.۱. سرویس Azure AI برای ترجمه تصویر پیکربندی نشده

**مشکل:** شما ترجمه تصویر را درخواست داده‌اید (`-img` flag) اما سرویس Azure AI به‌درستی پیکربندی نشده است.

**پیام خطا:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**راه‌حل:**
۱. **گزینه ۱:** پیکربندی سرویس Azure AI
   - `AZURE_AI_SERVICE_API_KEY` را به فایل `.env` خود اضافه کنید
   - `AZURE_AI_SERVICE_ENDPOINT` را به فایل `.env` خود اضافه کنید
   - مطمئن شوید سرویس قابل دسترسی است

۲. **گزینه ۲:** درخواست ترجمه تصویر را حذف کنید
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### ۵.۲. پیکربندی ضروری وجود ندارد

**مشکل:** پیکربندی ضروری LLM وجود ندارد.

**پیام خطا:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**راه‌حل:**
۱. مطمئن شوید فایل `.env` شما حداقل یکی از پیکربندی‌های LLM زیر را دارد:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` و `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   فقط یکی از Azure OpenAI یا OpenAI باید پیکربندی شود، نه هر دو.

### ۵.۳. سردرگمی در ترجمه انتخابی

**مشکل:** هیچ فایلی ترجمه نشده با اینکه فرمان با موفقیت اجرا شده است.

**دلایل احتمالی:**
- پرچم‌های نوع فایل اشتباه (`-md`, `-img`, `-nb`)
- هیچ فایل منطبق در پروژه وجود ندارد
- ساختار پوشه اشتباه است

**راه‌حل:**
۱. **حالت debug را فعال کنید** تا ببینید چه اتفاقی می‌افتد:
   ```bash
   translate -l "ko" -md -d
   ```

۲. **نوع فایل‌ها** را در پروژه خود بررسی کنید:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

۳. **ترکیب پرچم‌ها** را اعتبارسنجی کنید:
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## ۶. مهاجرت از سیستم قدیمی

### ۶.۱. حالت فقط Markdown منسوخ شده است

**مشکل:** فرمان‌هایی که به حالت fallback خودکار فقط Markdown متکی بودند دیگر به‌درستی کار نمی‌کنند.

**رفتار قدیمی:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**رفتار جدید:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**راه‌حل:**
- **دقیقاً مشخص کنید** چه چیزی را می‌خواهید ترجمه کنید:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### ۶.۲. رفتار غیرمنتظره لینک‌ها

**مشکل:** لینک‌ها در فایل‌های ترجمه‌شده به مکان‌های غیرمنتظره اشاره می‌کنند.

**دلیل:** پردازش پویا لینک‌ها بر اساس نوع فایل انتخاب‌شده تغییر می‌کند.

**راه‌حل:**
۱. **رفتار جدید لینک‌ها را بشناسید:**
   - اگر `-nb` فعال باشد: لینک‌های نوت‌بوک به نسخه ترجمه‌شده اشاره می‌کنند
   - اگر `-nb` غیرفعال باشد: لینک‌های نوت‌بوک به فایل اصلی اشاره می‌کنند
   - اگر `-img` فعال باشد: لینک‌های تصویر به نسخه ترجمه‌شده اشاره می‌کنند
   - اگر `-img` غیرفعال باشد: لینک‌های تصویر به فایل اصلی اشاره می‌کنند

۲. **ترکیب مناسب را برای نیاز خود انتخاب کنید:**
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## ۷. GitHub Action اجرا شد اما Pull Request (PR) ساخته نشد

**نشانه:** لاگ‌های workflow برای `peter-evans/create-pull-request` نشان می‌دهد:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**دلایل احتمالی:**
- **تغییری شناسایی نشد:** مرحله ترجمه هیچ تفاوتی ایجاد نکرده (مخزن قبلاً به‌روز است).
- **خروجی‌های نادیده گرفته‌شده:** فایل‌هایی که انتظار دارید commit شوند توسط `.gitignore` حذف شده‌اند (مثلاً `*.ipynb`, `translations/`, `translated_images/`).
- **عدم تطابق add-paths:** مسیرهای داده‌شده به اکشن با محل واقعی خروجی‌ها مطابقت ندارد.
- **منطق/شرایط workflow:** مرحله ترجمه زودتر متوقف شده یا به پوشه‌های غیرمنتظره نوشته شده است.

**چگونه رفع/بررسی کنیم:**
۱. **مطمئن شوید خروجی‌ها وجود دارند:** بعد از ترجمه، بررسی کنید که فایل‌های جدید/تغییر یافته در `translations/` و/یا `translated_images/` وجود داشته باشند.
   - اگر نوت‌بوک ترجمه می‌کنید، مطمئن شوید فایل‌های `.ipynb` واقعاً زیر `translations/<lang>/...` نوشته شده‌اند.
۲. **بررسی `.gitignore`:** خروجی‌های تولیدشده را نادیده نگیرید. مطمئن شوید موارد زیر را نادیده نمی‌گیرید:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (اگر نوت‌بوک ترجمه می‌کنید)
۳. **مطمئن شوید add-paths با خروجی‌ها مطابقت دارد:** مقدار چندخطی استفاده کنید و هر دو پوشه را در صورت نیاز وارد کنید:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
۴. **برای رفع اشکال PR را مجبوراً بسازید:** موقتاً اجازه commit خالی بدهید تا مطمئن شوید اتصال درست است:
   ```yaml
   with:
     commit-empty: true
   ```
۵. **با debug اجرا کنید:** `-d` را به فرمان translate اضافه کنید تا ببینید چه فایل‌هایی کشف و نوشته شده‌اند.
۶. **دسترسی‌ها (GITHUB_TOKEN):** مطمئن شوید workflow اجازه نوشتن برای ساخت commit و PR را دارد:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```

## چک‌لیست سریع رفع اشکال

هنگام رفع اشکال ترجمه:

۱. **حالت debug را فعال کنید:** پرچم `-d` را اضافه کنید تا لاگ‌های دقیق ببینید
۲. **پرچم‌های خود را بررسی کنید:** مطمئن شوید `-md`, `-img`, `-nb` با هدف شما مطابقت دارد
۳. **پیکربندی را اعتبارسنجی کنید:** مطمئن شوید فایل `.env` کلیدهای لازم را دارد
۴. **تست تدریجی انجام دهید:** ابتدا فقط با `-md` شروع کنید، سپس انواع دیگر را اضافه کنید
۵. **ساختار فایل را بررسی کنید:** مطمئن شوید فایل‌های منبع وجود دارند و قابل دسترسی هستند

برای اطلاعات بیشتر درباره فرمان‌ها و پرچم‌های موجود، به [راهنمای فرمان‌ها](./command-reference.md) مراجعه کنید.

---

**سلب مسئولیت**:
این سند با استفاده از سرویس ترجمه هوش مصنوعی [Co-op Translator](https://github.com/Azure/co-op-translator) ترجمه شده است. اگرچه ما برای دقت تلاش می‌کنیم، لطفاً توجه داشته باشید که ترجمه‌های خودکار ممکن است شامل خطا یا نادقتی باشند. نسخه اصلی سند به زبان مادری آن باید به عنوان منبع معتبر در نظر گرفته شود. برای اطلاعات حساس، ترجمه انسانی حرفه‌ای توصیه می‌شود. ما هیچ مسئولیتی در قبال سوءتفاهم یا تفسیر نادرست ناشی از استفاده از این ترجمه نداریم.